/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqebifw.management;

import com.cognos.xqe.config.ServiceEnumeration;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.trace.XQELog;
import com.cognos.xqe.trace.XQELogger;
import com.cognos.xqe.util.CollectionCast;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.DynamicMBean;
import javax.management.InvalidAttributeValueException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;
import javax.management.OperationsException;
import javax.management.ReflectionException;

public class XqeJMXURLHolder
implements DynamicMBean {
    XQELogger errorLogger = XQELog.getLogger(ServiceEnumeration.XQE, "XQE", "Exception", LogLevel.ERROR);
    public static final String BOOLEAN = "java.lang.Boolean";
    public static final String CHECKURL_AND_PWD = "checkUrlAndPassword";
    private static final String GETALL_INSTANCES_JMXURL = "getAllQSInstancesJMXURL";
    private static final String GETCRED_METHOD = "getCredentials";
    private static final String GETURL_METHOD = "getXqeJMXURL";
    private static final String ADD_METHOD = "addXqeJMXURL";
    private static final String REMOVE_METHOD = "removeXqeJMXURL";
    private static final String VOID = "void";
    private static final String STRING = "java.lang.String";
    private static final String STRING_ARRAY = "java.lang.String[]";
    public static final String URL = "Url";
    public static final String URL_LOWERCASE = "Url".toLowerCase();
    public static final String CREDENTIALS = "Credentials";
    public static final String CREDENTIALS_LOWERCASE = "Credentials".toLowerCase();
    public static final String NULL = "null";
    private volatile String jmxUrl = null;
    private volatile String credentials = null;
    private MBeanInfo mbeanInfo = null;

    public Boolean addXqeJMXURL(String url, String pwd) {
        this.jmxUrl = url;
        this.credentials = pwd;
        return this.validUrlPassword();
    }

    private Boolean validUrlPassword() {
        return this.jmxUrl != null && this.jmxUrl.length() > 0 && this.credentials != null && this.credentials.length() > 0;
    }

    public Boolean checkUrlAndPassword(String url, String pwd) {
        return this.validUrlPassword() != false && this.jmxUrl.equals(url) && this.credentials.equals(pwd);
    }

    public String[] getAllQSInstancesJMXURL() {
        if (this.jmxUrl == null || this.jmxUrl.length() == 0) {
            return new String[0];
        }
        return new String[]{this.jmxUrl};
    }

    public String getXqeJMXURL() {
        return this.jmxUrl;
    }

    public String getCredentials() {
        return this.credentials;
    }

    public void removeXqeJMXURL() {
        this.jmxUrl = null;
    }

    @Override
    public Object getAttribute(String attribute) throws AttributeNotFoundException, MBeanException, ReflectionException {
        if (attribute == null) {
            throw new AttributeNotFoundException(NULL);
        }
        if (URL_LOWERCASE.equals(attribute.toLowerCase())) {
            return this.getAllQSInstancesJMXURL();
        }
        if (CREDENTIALS_LOWERCASE.equals(attribute.toLowerCase())) {
            return this.getCredentials();
        }
        throw new AttributeNotFoundException(attribute);
    }

    @Override
    public AttributeList getAttributes(String[] attributes) {
        AttributeList attribs = new AttributeList();
        if (attributes == null) {
            return attribs;
        }
        for (String attrib : attributes) {
            try {
                attribs.add(new Attribute(attrib, this.getAttribute(attrib)));
            }
            catch (Exception e) {
                this.errorLogger.log(LogLevel.INFO, (Throwable)e);
            }
        }
        return attribs;
    }

    @Override
    public Object invoke(String actionName, Object[] params, String[] signature) throws MBeanException, ReflectionException {
        if (ADD_METHOD.equals(actionName)) {
            this.check(params, 2);
            return this.addXqeJMXURL((String)params[0], (String)params[1]);
        }
        if (REMOVE_METHOD.equals(actionName)) {
            this.removeXqeJMXURL();
            return null;
        }
        if (GETURL_METHOD.equals(actionName)) {
            return this.getXqeJMXURL();
        }
        if (GETCRED_METHOD.equals(actionName)) {
            return this.getCredentials();
        }
        if (GETALL_INSTANCES_JMXURL.equals(actionName)) {
            return this.getAllQSInstancesJMXURL();
        }
        if (CHECKURL_AND_PWD.equals(actionName)) {
            this.check(params, 2);
            return this.checkUrlAndPassword((String)params[0], (String)params[1]);
        }
        throw new ReflectionException(new OperationsException(actionName));
    }

    private void check(Object[] params, int expectedLength) throws MBeanException {
        if (params == null || params.length < expectedLength) {
            throw new MBeanException(new IllegalArgumentException());
        }
    }

    @Override
    public void setAttribute(Attribute attribute) throws InvalidAttributeValueException, MBeanException, AttributeNotFoundException, ReflectionException {
        block5: {
            if (attribute == null) {
                throw new AttributeNotFoundException(NULL);
            }
            try {
                if (URL_LOWERCASE.equals(attribute.getName().toLowerCase())) {
                    this.jmxUrl = (String)attribute.getValue();
                    break block5;
                }
                if (CREDENTIALS_LOWERCASE.equals(attribute.getName().toLowerCase())) {
                    this.credentials = (String)attribute.getValue();
                    break block5;
                }
                throw new AttributeNotFoundException(attribute.getName());
            }
            catch (Exception ex) {
                throw new MBeanException(ex);
            }
        }
    }

    @Override
    public AttributeList setAttributes(AttributeList attributes) {
        AttributeList resultList = new AttributeList();
        if (attributes == null) {
            return resultList;
        }
        for (Attribute attrib : CollectionCast.downcast(attributes, Object.class, Attribute.class)) {
            try {
                this.setAttribute(attrib);
                resultList.add(attrib);
            }
            catch (Exception ex) {
                this.errorLogger.log(ex);
            }
        }
        return resultList;
    }

    private MBeanInfo buildMBeanInfo() {
        MBeanAttributeInfo[] attrs = new MBeanAttributeInfo[]{new MBeanAttributeInfo(URL, STRING_ARRAY, "XQE JMX RMI URL", true, true, false), new MBeanAttributeInfo(CREDENTIALS, STRING, "Credentials for XQE JMX RMI Connection", true, true, false)};
        MBeanOperationInfo[] operationInfo = new MBeanOperationInfo[]{new MBeanOperationInfo(ADD_METHOD, "add jmx url and details to mbean", new MBeanParameterInfo[]{new MBeanParameterInfo(URL, STRING, URL), new MBeanParameterInfo(CREDENTIALS, STRING, CREDENTIALS)}, BOOLEAN, 1), new MBeanOperationInfo(CHECKURL_AND_PWD, "checks if jmx url and password are already present", new MBeanParameterInfo[]{new MBeanParameterInfo(URL, STRING, URL), new MBeanParameterInfo(CREDENTIALS, STRING, CREDENTIALS)}, BOOLEAN, 1), new MBeanOperationInfo(REMOVE_METHOD, "removes jmx url and details from mbean", new MBeanParameterInfo[]{new MBeanParameterInfo(URL, STRING, URL)}, VOID, 1), new MBeanOperationInfo(GETURL_METHOD, "gets xqe jmx url", new MBeanParameterInfo[0], STRING, 1), new MBeanOperationInfo(GETALL_INSTANCES_JMXURL, "gets all instances xqe jmx url", new MBeanParameterInfo[0], STRING_ARRAY, 1), new MBeanOperationInfo(GETCRED_METHOD, "gets xqe jmx credentials", new MBeanParameterInfo[]{new MBeanParameterInfo(URL, STRING, URL)}, STRING, 1)};
        return new MBeanInfo(this.getClass().getName(), "XqeJMXURLHolder Bean", attrs, null, operationInfo, null);
    }

    @Override
    public MBeanInfo getMBeanInfo() {
        if (this.mbeanInfo == null) {
            this.mbeanInfo = this.buildMBeanInfo();
        }
        return this.mbeanInfo;
    }
}

