/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqebifw.management;

import com.cognos.accman.jcam.crypto.CAMCryptoException;
import com.cognos.pogo.bibus.CryptoFacility;
import com.cognos.xqe.config.ServiceEnumeration;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.trace.XQELog;
import com.cognos.xqe.trace.XQELogger;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.NameValuePair;
import org.apache.commons.httpclient.methods.GetMethod;

public final class XqeRESTAdminOperations {
    private static final String HTTPS_PROTOCOL = "https";
    private static final String CAM_PASSPORT = "cam_passport";
    private static final String QUERY_SERVICE_PATH = "/bi/v1/datasets/";
    private static final String STR_EQUAL = "=";
    private static final String XSRF_TOKEN = "XSRF-TOKEN";
    private static final String X_XSRF_TOKEN = "X-XSRF-TOKEN";
    private static final String SEMICOLON = ";";
    private static final String COOKIE = "Cookie";
    public static final String ADMIN = "admin/";
    public static final String DUMP_CACHE = "dumpCache";
    public static final String DUMP_DMR_CACHE = "dumpDMRCache";
    public static final String FLUSH_CACHE = "flushCache";
    public static final String FLUSH_DMR_CACHE = "flushDMRCache";
    private static final String CATALOGNAME = "catalogName";
    private static final String CUBENAME = "cubeName";
    private static final String DATASOURCENAME = "dataSourceName";
    private static final String PACKAGENAME = "packageName";
    private static XQELogger LOGGER = XQELog.getLogger(ServiceEnumeration.XQE, "XQE", "HTTPClient", LogLevel.ERROR);

    private XqeRESTAdminOperations() {
    }

    public static boolean flush(String dispatcherName, String camPassport) {
        return XqeRESTAdminOperations.executeAdminOperation(dispatcherName, camPassport, FLUSH_CACHE, null);
    }

    public static boolean flush(String dispatcherName, String camPassport, String dataSourceName, String catalogName, String cubeName) {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put(DATASOURCENAME, dataSourceName);
        parameters.put(CATALOGNAME, catalogName);
        parameters.put(CUBENAME, cubeName);
        return XqeRESTAdminOperations.executeAdminOperation(dispatcherName, camPassport, FLUSH_CACHE, parameters);
    }

    public static boolean dump(String dispatcherName, String camPassport) {
        return XqeRESTAdminOperations.executeAdminOperationWithResponse(dispatcherName, camPassport, DUMP_CACHE, null);
    }

    public static boolean dump(String dispatcherName, String camPassport, String dataSourceName, String catalogName, String cubeName) {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put(DATASOURCENAME, dataSourceName);
        parameters.put(CATALOGNAME, catalogName);
        parameters.put(CUBENAME, cubeName);
        return XqeRESTAdminOperations.executeAdminOperationWithResponse(dispatcherName, camPassport, DUMP_CACHE, parameters);
    }

    public static boolean flushDMRCache(String dispatcherName, String camPassport, String dataSourceName, String packageName) {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put(DATASOURCENAME, dataSourceName);
        parameters.put(PACKAGENAME, packageName);
        return XqeRESTAdminOperations.executeAdminOperation(dispatcherName, camPassport, FLUSH_DMR_CACHE, parameters);
    }

    public static boolean dumpDMRCache(String dispatcherName, String camPassport, String dataSourceName, String packageName) {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put(DATASOURCENAME, dataSourceName);
        parameters.put(PACKAGENAME, packageName);
        return XqeRESTAdminOperations.executeAdminOperationWithResponse(dispatcherName, camPassport, DUMP_DMR_CACHE, parameters);
    }

    public static boolean flushDMRCache(String dispatcherName, String camPassport) {
        return XqeRESTAdminOperations.executeAdminOperation(dispatcherName, camPassport, FLUSH_DMR_CACHE, null);
    }

    public static boolean dumpDMRCache(String dispatcherName, String camPassport) {
        return XqeRESTAdminOperations.executeAdminOperationWithResponse(dispatcherName, camPassport, FLUSH_DMR_CACHE, null);
    }

    private static boolean executeAdminOperation(String dispatcherName, String camPassport, String operation, Map<String, String> parameters) {
        GetMethod getMethod = XqeRESTAdminOperations.executeAdminRequest(dispatcherName, camPassport, operation, parameters);
        return getMethod.getStatusCode() == 204;
    }

    private static boolean executeAdminOperationWithResponse(String dispatcherName, String camPassport, String operation, Map<String, String> parameters) {
        GetMethod getMethod = XqeRESTAdminOperations.executeAdminRequest(dispatcherName, camPassport, operation, parameters);
        return getMethod.getStatusCode() == 200;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static GetMethod executeAdminRequest(String dispatcherName, String camPassport, String operation, Map<String, String> parameters) {
        HttpClient httpClient;
        if (LOGGER.isOn(LogLevel.INFO)) {
            StringBuilder message = new StringBuilder();
            message.append("Executing Admin Request, dispatcherName=").append(dispatcherName);
            message.append(", operation=").append(operation);
            if (parameters != null) {
                message.append(", parameters=" + parameters.toString());
            }
            LOGGER.log(LogLevel.INFO, message.toString());
        }
        if ((httpClient = XqeRESTAdminOperations.createHttpClient(dispatcherName)) == null) {
            return null;
        }
        GetMethod getMethod = XqeRESTAdminOperations.createGetMethod(camPassport, operation, parameters);
        if (getMethod == null) {
            return null;
        }
        String response = null;
        try {
            httpClient.executeMethod((HttpMethod)getMethod);
            if (LOGGER.isOn(LogLevel.INFO) && getMethod.getStatusCode() == 200) {
                response = getMethod.getResponseBodyAsString(2000);
            }
        }
        catch (HttpException e) {
            LOGGER.log("HttpClient executeMethod HttpException: " + e.getMessage());
            GetMethod getMethod2 = null;
            return getMethod2;
        }
        catch (IOException e) {
            LOGGER.log("HttpClient executeMethod IOException: " + e.getMessage());
            GetMethod getMethod3 = null;
            return getMethod3;
        }
        finally {
            getMethod.releaseConnection();
        }
        if (LOGGER.isOn(LogLevel.INFO)) {
            StringBuilder message = new StringBuilder();
            message.append("Completed Admin Request, statusCode=").append(getMethod.getStatusCode());
            if (response != null) {
                message.append(", response=").append(response);
            }
            LOGGER.log(LogLevel.INFO, message.toString());
        }
        return getMethod;
    }

    private static HttpClient createHttpClient(String dispatcherName) {
        int port;
        String host;
        String protocol;
        try {
            URL dispatcherURL = new URL(dispatcherName);
            protocol = dispatcherURL.getProtocol();
            host = dispatcherURL.getHost();
            port = dispatcherURL.getPort();
        }
        catch (MalformedURLException e) {
            LOGGER.log("Parsing dispatcherName as URL: " + e.getMessage());
            return null;
        }
        boolean secured = protocol.equals(HTTPS_PROTOCOL);
        try {
            return CryptoFacility.getCAMFactory().createHttpClient(host, port, secured);
        }
        catch (CAMCryptoException e) {
            LOGGER.log("Attempting to create HttpClient: " + e.getMessage());
            return null;
        }
    }

    private static GetMethod createGetMethod(String camPassport, String operation, Map<String, String> parameters) {
        if (camPassport == null || camPassport.isEmpty()) {
            LOGGER.log("No CAM passport found for admin operation " + operation);
            return null;
        }
        GetMethod getMethod = new GetMethod();
        getMethod.setPath("/bi/v1/datasets/admin/" + operation);
        if (parameters != null) {
            Set<Map.Entry<String, String>> entries = parameters.entrySet();
            NameValuePair[] nvPairs = new NameValuePair[entries.size()];
            int idx = 0;
            for (Map.Entry<String, String> entry : entries) {
                nvPairs[idx] = new NameValuePair(entry.getKey(), entry.getValue());
                ++idx;
            }
            getMethod.setQueryString(nvPairs);
        }
        StringBuilder sbCookies = new StringBuilder();
        sbCookies.append(CAM_PASSPORT);
        sbCookies.append(STR_EQUAL);
        sbCookies.append(camPassport);
        sbCookies.append(SEMICOLON);
        String xsrfToken = XqeRESTAdminOperations.createXSRFToken();
        sbCookies.append(XSRF_TOKEN);
        sbCookies.append(STR_EQUAL);
        sbCookies.append(xsrfToken);
        getMethod.setRequestHeader(X_XSRF_TOKEN, xsrfToken);
        getMethod.setRequestHeader(COOKIE, sbCookies.toString());
        return getMethod;
    }

    private static String createXSRFToken() {
        return "XQE_" + System.currentTimeMillis();
    }
}

