/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqebifw.metrics;

import com.cognos.pogo.monitoring.jmx.PogoMBeanServer;
import com.cognos.xqe.config.ServiceEnumeration;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.management.XqeRMIConnector;
import com.cognos.xqe.metrics.IMetricsMBean;
import com.cognos.xqe.metrics.MetricsManager;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.trace.XQELog;
import com.cognos.xqe.trace.XQELogger;
import com.cognos.xqebifw.management.XqeSystemMetricsMBean;
import com.cognos.xqebifw.management.XqeSystemMetricsProxyCreator;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;

public final class XqeSystemMetricsManager {
    public static final String XQE_METRICS_MBEAN_NAME = "com.cognos.xqe:type=serviceMetrics,service=xqeService";
    private static XqeSystemMetricsManager manager = null;
    private MBeanServer mbeanServer = null;
    private IMetricsMBean mbean = null;
    private ObjectName objName = null;
    private static final XqeSystemMetricsProxyCreator PROXY_CREATOR = new XqeSystemMetricsProxyCreator();
    private static XQELogger mLogger = XQELog.getLogger(ServiceEnumeration.XQE, "XQE", "MIB", LogLevel.ERROR);

    public ObjectName getObjName() {
        return this.objName;
    }

    public static XqeSystemMetricsManager getManager() {
        if (manager == null) {
            throw new XQERuntimeException();
        }
        return manager;
    }

    private XqeSystemMetricsManager(MBeanServer server) {
        this.mbeanServer = server;
        this.mbean = new XqeSystemMetricsMBean();
        MetricsManager.start(server, this.mbean);
        ObjectName adminConsoleName = null;
        try {
            adminConsoleName = new ObjectName(XqeSystemMetricsManager.getMBeanName());
        }
        catch (MalformedObjectNameException e) {
            throw new XQERuntimeException(XQEMessageKeys.GEN_UnexpectedException, (Throwable)e);
        }
        try {
            this.mbeanServer.registerMBean(this.mbean, adminConsoleName);
        }
        catch (InstanceAlreadyExistsException e) {
            throw new XQERuntimeException(e);
        }
        catch (MBeanRegistrationException e) {
            throw new XQERuntimeException(e);
        }
        catch (NotCompliantMBeanException e) {
            throw new XQERuntimeException(e);
        }
    }

    public static void start(MBeanServer server) {
        if (manager == null) {
            manager = new XqeSystemMetricsManager(server);
        }
    }

    public static void stop() {
        if (manager != null) {
            ObjectName adminConsoleName = null;
            try {
                adminConsoleName = new ObjectName(XqeSystemMetricsManager.getMBeanName());
                XqeSystemMetricsManager.manager.mbeanServer.unregisterMBean(adminConsoleName);
            }
            catch (MalformedObjectNameException e) {
                throw new XQERuntimeException(XQEMessageKeys.GEN_UnexpectedException, (Throwable)e);
            }
            catch (MBeanRegistrationException e) {
                mLogger.log(e);
            }
            catch (InstanceNotFoundException e) {
                mLogger.log(e);
            }
            manager = null;
            MetricsManager.stop();
        }
    }

    public static String getMBeanName() {
        return MetricsManager.getMBeanName(XqeRMIConnector.getConnectionString());
    }

    public static void createProxyMBean() {
        ObjectName obName = null;
        try {
            obName = new ObjectName(XqeSystemMetricsProxyCreator.getMBeanName());
            PogoMBeanServer.getInstance().getServer().registerMBean(PROXY_CREATOR, obName);
        }
        catch (MalformedObjectNameException e) {
            throw new XQERuntimeException(e);
        }
        catch (InstanceAlreadyExistsException e) {
            mLogger.log(LogLevel.INFO, "Replacing existing XqeSystemMetricsProxyCreator MBean.");
            try {
                PogoMBeanServer.getInstance().getServer().unregisterMBean(obName);
                PogoMBeanServer.getInstance().getServer().registerMBean(PROXY_CREATOR, obName);
            }
            catch (Exception e1) {
                mLogger.log(e1);
            }
        }
        catch (MBeanRegistrationException e) {
            throw new XQERuntimeException(e);
        }
        catch (NotCompliantMBeanException e) {
            throw new XQERuntimeException(e);
        }
    }
}

