/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqebifw.runtree.olap.mdx.rolapprovider.admin.tool;

import com.cognos.xqe.exception.XQEAxisFaultException;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.admin.IROLAPCommandResult;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.admin.ROLAPCubeCommandResult;
import com.cognos.xqebifw.runtree.olap.mdx.rolapprovider.admin.tool.BiBusCommandPlugin;
import com.cognos.xqebifw.runtree.olap.mdx.rolapprovider.admin.tool.ROLAPAdminTestTool;
import java.io.BufferedOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.axis.AxisFault;

public final class DynamicCubesAdminTool {
    private static final String NL = "\n";
    private static final String DS = "  ";
    private static final String COMMA = ",";
    private static final long CREDENTIAL_NO = 3L;
    public static final String INTERNALLY_INVOKES = " (internally invokes SDK call \"";
    public static final String CMD_GET_CUBE_STATE = "getCubeState";
    public static final String CMD_GET_CUBE_METRICS = "getCubeMetrics";
    public static final String CMD_START_CUBES = "startCubes";
    public static final String CMD_STOP_CUBES = "stopCubes";
    public static final String CMD_FORCE_START_CUBES = "forceStartCubes";
    public static final String CMD_FORCE_STOP_CUBES = "forceStopCubes";
    public static final String CMD_RESTART_CUBES = "restartCubes";
    public static final String CMD_REFRESH_CUBE_MEMBER_CACHE = "refreshCubeMemberCache";
    public static final String CMD_REFRESH_CUBE_DATA_CACHE = "refreshCubeDataCache";
    public static final String CMD_REFRESH_CUBE_SECURITY = "refreshCubeSecurity";
    public static final String CMD_CLEAR_CUBE_WORKLOAD_LOG = "clearCubeWorkloadLog";
    public static final String CMD_PAUSE_CUBES = "pauseCubes";
    public static final String CMD_INCREMENTALLY_LOAD_CUBES = "incrementallyLoadCubes";
    private static int portOverride = -1;
    private static String serverOverride = null;
    private static int waitOverride = -1;
    private static int commandIdx = -1;
    private static String[] biLoginCredentials = new String[]{"", null, null};
    private static ArrayList<String> cubes = new ArrayList();
    private static PrintWriter xmlWriter = null;
    private static final HashSet<String> ALLOWED_ARGS = new HashSet<String>(Arrays.asList("transactionID"));
    private static HashMap<String, String> arguments = new HashMap();
    private static final String[] COMMANDS = new String[]{"getCubeState", "getCubeMetrics", "startCubes", "forceStartCubes", "stopCubes", "forceStopCubes", "restartCubes", "refreshCubeMemberCache", "refreshCubeDataCache", "refreshCubeSecurity", "clearCubeWorkloadLog", "pauseCubes", "incrementallyLoadCubes"};

    private static void usage() {
        ROLAPAdminTestTool.println("Usage:\n\n dcadmin[.bat|.sh] [-p port] [-s server] [-x output_file] [-l \"namespace,userid,password\"] [-arg argName argValue] command [cube0 cube1 ...]\n\n -p port - Specify the port to use. Default is 9300.\n -s server - Specify the server name to use. Default is \"localhost.\"\n -x output_file - Specify the name of the output file to write the structured\n      command result to\n -v - Enable verbose output\n -l \"namespace,userid,password\" - Specify the BI login parameters\n      For example: -l \"LDAP,admin,secret123\"\n -arg argName argValue - Specifies command arguments.\n        Currently supported arguments:\n          transactionID - Optional argument to command incrementallyLoadCubes\n\nNote that any parameter containing a comma or a space must be included in double quotes, e.g. \"param1,param2\"\n\nAvailable commands: \n  getCubeState\n  getCubeMetrics\n  startCubes\n  forceStartCubes (internally invokes SDK call \"startCubes\" with parameter \"startROLAPCubesAndSourceCubes\")\n  stopCubes\n  forceStopCubes (internally invokes SDK call \"stopCubes\" with parameter \"stopROLAPCubesImmediately\")\n  restartCubes\n  pauseCubes\n  incrementallyLoadCubes\n  refreshCubeDataCache\n  refreshCubeMemberCache\n  refreshCubeSecurity\n  clearCubeWorkloadLog\n\nScript returns exit code 0 when command was successful, and code 1 in case of an error");
        System.exit(0);
    }

    private static void parseArguments(String[] args) {
        if (args.length == 0) {
            DynamicCubesAdminTool.usage();
        }
        boolean moreCommands = true;
        for (int i = 0; i < args.length && moreCommands; ++i) {
            if (args[i].equals("-p")) {
                if (++i >= args.length) {
                    ROLAPAdminTestTool.error("Invalid port argument");
                }
                try {
                    portOverride = Integer.parseInt(args[i]);
                }
                catch (NumberFormatException e) {
                    ROLAPAdminTestTool.error("Invalid port number - " + args[i]);
                }
                continue;
            }
            if (args[i].equals("-s")) {
                if (++i >= args.length) {
                    ROLAPAdminTestTool.error("Invalid server name");
                }
                serverOverride = args[i];
                continue;
            }
            if (args[i].equals("-x")) {
                if (++i >= args.length) {
                    ROLAPAdminTestTool.error("Invalid output file name");
                }
                try {
                    xmlWriter = new PrintWriter((Writer)new OutputStreamWriter((OutputStream)new BufferedOutputStream(new FileOutputStream(args[i])), "UTF8"), true);
                    xmlWriter.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
                }
                catch (IOException e) {
                    ROLAPAdminTestTool.error(e.getMessage());
                }
                continue;
            }
            if (args[i].equals("-l")) {
                if (++i >= args.length) {
                    ROLAPAdminTestTool.error("Invalid credentials argument");
                    continue;
                }
                biLoginCredentials = args[i].split(COMMA);
                if ((long)biLoginCredentials.length == 3L) continue;
                ROLAPAdminTestTool.error("Missing credential arguments. Requires \"<namespace>,<userid>,<password>\"");
                continue;
            }
            if (args[i].equals("-arg")) {
                if (++i >= args.length) {
                    ROLAPAdminTestTool.error("Invalid command argument");
                    continue;
                }
                String argName = args[i];
                if (!ALLOWED_ARGS.contains(argName)) {
                    ROLAPAdminTestTool.error("Unknown argument: " + argName);
                }
                if (++i >= args.length) {
                    ROLAPAdminTestTool.error("Missing value for argument: " + argName);
                }
                String argValue = args[i];
                arguments.put(argName, argValue);
                continue;
            }
            if (args[i].equals("-v")) {
                ROLAPAdminTestTool.setVerbose(true);
                continue;
            }
            for (int c = 0; c < COMMANDS.length; ++c) {
                if (!args[i].equals(COMMANDS[c])) continue;
                commandIdx = c;
                break;
            }
            if (commandIdx == -1) {
                ROLAPAdminTestTool.error("Unknown command: " + args[i]);
            }
            moreCommands = false;
        }
        for (int cubeIdx = i; cubeIdx < args.length; ++cubeIdx) {
            cubes.add(args[cubeIdx]);
        }
    }

    public static void main(String[] args) {
        DynamicCubesAdminTool.parseArguments(args);
        try {
            BiBusCommandPlugin plugin = new BiBusCommandPlugin(serverOverride, portOverride, waitOverride, null, null, biLoginCredentials);
            IROLAPCommandResult result = plugin.executeCommand(COMMANDS[commandIdx], cubes, arguments, false);
            if (xmlWriter != null) {
                xmlWriter.println("<dcAdminCommandResult>");
            }
            if (result != null) {
                result.renderPlain(System.out);
                if (xmlWriter != null) {
                    result.renderSimpleXML(xmlWriter);
                }
            } else {
                ROLAPAdminTestTool.println("Found no cubes to manage");
            }
            if (xmlWriter != null) {
                xmlWriter.println("</dcAdminCommandResult>");
            }
            int errorLevel = 0;
            if (result instanceof ROLAPCubeCommandResult) {
                Map<String, ROLAPCubeCommandResult.ResultDetails> results = ((ROLAPCubeCommandResult)result).getResultMap();
                for (Map.Entry<String, ROLAPCubeCommandResult.ResultDetails> entry : results.entrySet()) {
                    if (entry.getValue().isSuccess()) continue;
                    errorLevel = 1;
                    break;
                }
            }
            System.exit(errorLevel);
        }
        catch (AxisFault af) {
            XQEAxisFaultException xaf = new XQEAxisFaultException(af);
            List<String> messages = xaf.getAxisFaultMessageStrings();
            if (messages.size() == 0) {
                ROLAPAdminTestTool.error(af.getMessage(), af);
            } else {
                ROLAPAdminTestTool.error(messages.get(0), af);
            }
        }
        catch (Exception e) {
            ROLAPAdminTestTool.error("Exception occurred", e);
        }
        System.exit(1);
    }
}

