/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqemfw4j;

import com.cognos.xqe.data.model.IDataSource;
import com.cognos.xqe.data.providers.DataSourceTypeEnum;
import com.cognos.xqe.data.providers.IDataProvider;
import com.cognos.xqe.data.providers.ProviderManager;
import com.cognos.xqe.data.providers.olap.IOLAPDataProvider;
import com.cognos.xqe.data.providers.olap.IOLAPMetadataProvider;
import com.cognos.xqe.data.providers.olap.MetadataQueryArguments;
import com.cognos.xqe.data.providers.olap.MetadataRestriction;
import com.cognos.xqe.data.providers.olap.RestrictionType;
import com.cognos.xqe.data.values.DateTimeValue;
import com.cognos.xqe.metadata.DimensionTypeEnum;
import com.cognos.xqe.metadata.ICatalog;
import com.cognos.xqe.metadata.ICube;
import com.cognos.xqe.metadata.IDimension;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.metadata.IMeasure;
import com.cognos.xqe.metadata.IMetadata;
import com.cognos.xqe.metadata.IModelDataSource;
import com.cognos.xqe.metadata.INamespace;
import com.cognos.xqe.metadata.IVariable;
import com.cognos.xqe.metadata.MetadataType;
import com.cognos.xqe.metadata.record.DimensionRecord;
import com.cognos.xqe.metadata.virtual.VirtualLevel;
import com.cognos.xqe.query.engine.ExecutionEnvironment;
import com.cognos.xqe.util.CollectionCast;
import com.cognos.xqe.util.UniqueNameGenerator;
import com.cognos.xqe.util.bean.BeanPropertySupport;
import com.cognos.xqe.util.context.ExecutionEnvironmentContext;
import com.cognos.xqe.util.xml.XMLUtils;
import com.cognos.xqemfw4j.MFWDataSource;
import com.cognos.xqemfw4j.MFWDimension;
import com.cognos.xqemfw4j.MFWMetadata;
import com.cognos.xqemfw4j.MFWMetadataConnection;
import com.cognos.xqemfw4j.MFWMultiRequestHandle;
import com.cognos.xqemfw4j.MFWNamespace;
import com.cognos.xqemfw4j.MFWVirtualDimension;
import com.cognos.xqemfw4j.MFWVirtualHierarchy;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;

class MFWCube
extends MFWMetadata
implements ICube {
    private static final BeanPropertySupport BEAN_PROPERTY_SUPPORT = new BeanPropertySupport(MFWCube.class);
    static final long serialVersionUID = 7647274105530911872L;
    protected String name = null;
    protected MFWDataSource datasource = null;
    protected MFWNamespace namespace = null;
    protected List<IDimension> dimensions = null;
    protected DateTimeValue createdDate = null;
    protected IMeasure defaultMeasure = null;
    protected String uniqueName = null;
    private static final String CLOSING_SQ_BRACKET = "]";

    MFWCube(MFWMetadataConnection mfwConnection, MFWMultiRequestHandle[] mfwHandle) {
        super(mfwConnection, mfwHandle);
    }

    @Override
    public DateTimeValue getCreatedDate() {
        if (this.createdDate == null) {
            this.createdDate = this.getMfwDatasource().getCubeCreatedOn();
        }
        return this.createdDate;
    }

    @Override
    public INamespace getNamespace() {
        return this.namespace;
    }

    protected void setNamespace(MFWNamespace mfwNamespace) {
        this.namespace = mfwNamespace;
    }

    @Override
    public DateTimeValue getUpdatedDate() {
        return this.getMfwDatasource().getCubeDataUpdatedOn();
    }

    @Override
    public List<IDimension> getDimensions() {
        if (this.dimensions == null) {
            List<IDimension> dims = null;
            ExecutionEnvironment executionEnvironment = (ExecutionEnvironment)ExecutionEnvironmentContext.getExecutionEnvironment();
            IModelDataSource modelDS = this.getModelDataSource();
            IDataSource ds = executionEnvironment.getOrAddDataSource(modelDS);
            IDataProvider provider = ProviderManager.getInstance().getProvider(ds.getType());
            if (!modelDS.isDummy()) {
                Locale locale = modelDS.getConnection().getContentLocale();
                provider.resolveDataSourceCapabilities(executionEnvironment, ds, locale);
            }
            MFWDimension virtual = null;
            MFWDimension virtual2 = null;
            if (ds.getType().equals("BW") || ds.getType().equals("EB") || ds.getType().equals("RO") || (ds.getType().equals("TM") || ds.getType().equals("TMR")) && ds.getCapabilities().isSupported("v5.useLocalOLAP")) {
                virtual = this.buildVirtualDimension("XQE_VD1", ds);
                virtual2 = this.buildVirtualDimension("XQE_VD2", ds);
            }
            if (this.getModelDataSource().isRelational()) {
                String query = "//dimension";
                dims = Collections.unmodifiableList(CollectionCast.downcast(this.getConnection().queryMetadata(this.namespace.getHandle(), query), IMetadata.class, IDimension.class));
            } else {
                String datasourceID = this.getMfwDatasource().getID();
                String query = "/project//dimension[dataSourceRef=" + XMLUtils.xPathLiteral(datasourceID) + CLOSING_SQ_BRACKET;
                List<IMetadata> dimMeta = this.getConnection().queryMetadata(query);
                if (virtual != null) {
                    dimMeta.add(virtual);
                    dimMeta.add(virtual2);
                }
                dims = Collections.unmodifiableList(CollectionCast.downcast(dimMeta, IMetadata.class, IDimension.class));
            }
            this.dimensions = dims;
        }
        return this.dimensions;
    }

    private MFWDimension buildVirtualDimension(String dimName, IDataSource ds) {
        DimensionRecord record = new DimensionRecord();
        record.setUniqueName("[" + dimName + CLOSING_SQ_BRACKET);
        record.setName(dimName);
        MFWVirtualDimension virtualDimension = new MFWVirtualDimension(this, record);
        virtualDimension.dimensionType = DimensionTypeEnum.INTERNAL;
        virtualDimension.defaultHierarchyExistInModel = false;
        MFWVirtualHierarchy virtualHierarchy = new MFWVirtualHierarchy(virtualDimension, dimName);
        if (ds.getType().equals("RO")) {
            virtualHierarchy.uniqueName = virtualHierarchy.uniqueName + "." + virtualHierarchy.uniqueName;
        }
        virtualDimension.defaultHierarchy = virtualHierarchy;
        virtualDimension.hierarchies = new ArrayList();
        virtualDimension.hierarchies.add(virtualHierarchy);
        VirtualLevel virtualLevel = new VirtualLevel("VL", virtualHierarchy);
        virtualHierarchy.levels = new ArrayList();
        virtualHierarchy.levels.add(virtualLevel);
        return virtualDimension;
    }

    @Override
    public int getDimensionCount() {
        int dimensionCount = 0;
        if (this.getDimensions() != null) {
            dimensionCount = this.getDimensions().size();
        }
        return dimensionCount;
    }

    @Override
    public IDimension getDimension(String dimensionUniqueName) {
        IDimension dimension = null;
        if (this.getDimensions() != null) {
            for (IDimension dim : this.getDimensions()) {
                if (!dimensionUniqueName.equals(dim.getUniqueName())) continue;
                dimension = dim;
                break;
            }
        }
        return dimension;
    }

    @Override
    public IHierarchy getHierarchy(String hierarchyUniqueName) {
        for (IDimension dimension : this.getDimensions()) {
            for (IHierarchy hierarchy : dimension.getHierarchies()) {
                if (!hierarchyUniqueName.equals(hierarchy.getUniqueName())) continue;
                return hierarchy;
            }
        }
        return null;
    }

    @Override
    public IHierarchy getMeasuresHierarchy() {
        IHierarchy hierarchy = null;
        for (IDimension dimension : this.getDimensions()) {
            if (!dimension.isMeasuresDimension() || ((MFWDimension)dimension).isAccessedViaShortcut()) continue;
            hierarchy = dimension.getDefaultHierarchy();
            break;
        }
        return hierarchy;
    }

    @Override
    public int getDimensionIndex(IDimension dimension) {
        return this.getDimensions().indexOf(dimension);
    }

    @Override
    public IDimension getDimension(int index) {
        if (index < 0 || index >= this.getDimensionCount()) {
            return null;
        }
        return this.dimensions.get(index);
    }

    @Override
    public boolean getPropagateNulls() {
        return false;
    }

    public void initialize() {
    }

    @Override
    public ICatalog getCatalog() {
        return this.getModelDataSource().getCatalog();
    }

    @Override
    public DateTimeValue getSchemaUpdatedDate() {
        return this.getMfwDatasource().getCubeSchemaUpdatedOn();
    }

    @Override
    public String getCubeCurrentPeriod() {
        return this.getMfwDatasource().getCubeCurrentPeriod();
    }

    @Override
    public IMeasure getDefaultMeasure() {
        IHierarchy measuresHierarchy;
        if (null == this.defaultMeasure && (measuresHierarchy = this.getMeasuresHierarchy()) != null) {
            this.defaultMeasure = (IMeasure)measuresHierarchy.getDefaultMember();
        }
        return this.defaultMeasure;
    }

    @Override
    public ICube.CubeSuppressionTypeEnum getSuppressionType() {
        return this.getMfwDatasource().getSuppression();
    }

    @Override
    public final MetadataType getObjectType() {
        return MetadataType.CUBE;
    }

    @Override
    public BeanPropertySupport getBeanPropertySupport() {
        return BEAN_PROPERTY_SUPPORT;
    }

    @Override
    public IModelDataSource getModelDataSource() {
        return this.getMfwDatasource();
    }

    protected void setDatasource(MFWDataSource mfwDatasource) {
        this.datasource = mfwDatasource;
    }

    public MFWDataSource getMfwDatasource() {
        if (this.datasource == null) {
            this.datasource = (MFWDataSource)this.getConnection().mfwObjectToMetadataObject(this.getHandle().getParent());
        }
        return this.datasource;
    }

    @Override
    public List<IVariable> getVariables() {
        return this.getMfwDatasource().getVariables();
    }

    @Override
    public String getName() {
        if (this.name == null) {
            this.name = this.getModelDataSource().isRelational() ? this.getNamespace().getName() : this.queryValue();
        }
        return this.name;
    }

    @Override
    public String getCaption() {
        if (this.caption == null) {
            this.caption = this.getName();
        }
        return this.caption;
    }

    @Override
    public String getUniqueID() {
        return null;
    }

    @Override
    public String getUniqueName() {
        if (null == this.uniqueName) {
            this.uniqueName = this.getModelDataSource().isRelational() ? UniqueNameGenerator.createUniqueName(this.getName()) : this.queryValue();
        }
        return this.uniqueName;
    }

    @Override
    public String toString() {
        return this.getModelDataSource().toString() + "/" + this.getUniqueName();
    }

    @Override
    public IDimension getMeasureDimension() {
        List<IDimension> dimension = this.getDimensions();
        if (dimension == null) {
            return null;
        }
        int dimCnt = dimension.size();
        for (int i = 0; i < dimCnt; ++i) {
            IDimension dim = dimension.get(i);
            if (!dim.isMeasuresDimension()) continue;
            return dim;
        }
        return null;
    }

    @Override
    public boolean hasSAPReplacementVariable() {
        IModelDataSource modelDS = this.getModelDataSource();
        IOLAPDataProvider dataProvider = ProviderManager.getInstance().getOLAPProvider(modelDS.getInterface());
        ExecutionEnvironment executionEnvironment = (ExecutionEnvironment)ExecutionEnvironmentContext.getExecutionEnvironment();
        MetadataQueryArguments mdQueryArgs = MetadataQueryArguments.buildArguments(executionEnvironment.getOrAddDataSource(modelDS), executionEnvironment, this.getConnection().getExpressionLocale());
        IOLAPMetadataProvider metadataProvider = dataProvider.getMetadataProvider(mdQueryArgs);
        return metadataProvider.isReplacementVariableSpecified();
    }

    @Override
    public boolean isReplacementVariableUsed(IDimension dimension) {
        IModelDataSource modelDS = this.getModelDataSource();
        IOLAPDataProvider dataProvider = ProviderManager.getInstance().getOLAPProvider(modelDS.getInterface());
        ExecutionEnvironment executionEnvironment = (ExecutionEnvironment)ExecutionEnvironmentContext.getExecutionEnvironment();
        MetadataQueryArguments mdQueryArgs = MetadataQueryArguments.buildArguments(executionEnvironment.getOrAddDataSource(modelDS), executionEnvironment, this.getConnection().getExpressionLocale());
        IOLAPMetadataProvider metadataProvider = dataProvider.getMetadataProvider(mdQueryArgs);
        MetadataRestriction restrictions = new MetadataRestriction();
        restrictions.add(RestrictionType.CUBE_OBJECT, this);
        restrictions.add(RestrictionType.DIMENSION_UNIQUE_NAME, dimension.getUniqueName());
        return metadataProvider.isReplacementVariableUsedFor(restrictions);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IDimension queryDimension(String dimensionUName) {
        IModelDataSource modelDS = this.getModelDataSource();
        IOLAPDataProvider dataProvider = ProviderManager.getInstance().getOLAPProvider(modelDS.getInterface());
        ExecutionEnvironment executionEnvironment = (ExecutionEnvironment)ExecutionEnvironmentContext.getExecutionEnvironment();
        IDataSource ds = executionEnvironment.getOrAddDataSource(modelDS);
        MetadataQueryArguments mdQueryArgs = MetadataQueryArguments.buildArguments(ds, executionEnvironment, modelDS.getConnection().getExpressionLocale());
        IOLAPMetadataProvider metadataProvider = dataProvider.getMetadataProvider(mdQueryArgs);
        MetadataRestriction restrictions = new MetadataRestriction();
        if (this.getModelDataSource().getCatalog() != null) {
            restrictions.add(RestrictionType.CATALOG, modelDS.getCatalog().getUniqueName());
        }
        restrictions.add(RestrictionType.CUBE, this.getUniqueName());
        restrictions.add(RestrictionType.DIMENSION_UNIQUE_NAME, dimensionUName);
        List<DimensionRecord> records = null;
        try {
            records = metadataProvider.getDimensions(restrictions);
            if (records == null || records.size() != 1) {
                this.getConnection().throwInternalError("Querying a dimension of a cube" + this.getUniqueName() + " returned empty result.");
            }
            MFWVirtualDimension vDim = new MFWVirtualDimension(this, records.get(0));
            if (this.dimensions != null && ds.getType().equals("BW") && !this.dimensions.contains(vDim)) {
                ArrayList<IDimension> dims = new ArrayList<IDimension>();
                dims.addAll(this.dimensions);
                dims.add(vDim);
                this.dimensions = Collections.unmodifiableList(dims);
            }
            MFWVirtualDimension mFWVirtualDimension = vDim;
            return mFWVirtualDimension;
        }
        finally {
            metadataProvider.release();
        }
    }

    @Override
    public ICube.CubeTypeEnum getType() {
        MFWDataSource dataSource = this.getMfwDatasource();
        if (dataSource.isDMR()) {
            return ICube.CubeTypeEnum.DMR;
        }
        String dsInterface = this.getModelDataSource().getInterface();
        if (DataSourceTypeEnum.isEssbase(dsInterface)) {
            return ICube.CubeTypeEnum.ESSBASE;
        }
        if (DataSourceTypeEnum.isMicrosoft(dsInterface)) {
            return ICube.CubeTypeEnum.MICROSOFT;
        }
        if (DataSourceTypeEnum.isPowerCube(dsInterface)) {
            return ICube.CubeTypeEnum.POWERCUBE;
        }
        if (DataSourceTypeEnum.isSAPBW(dsInterface)) {
            return ICube.CubeTypeEnum.SAP;
        }
        if (DataSourceTypeEnum.isROLAP(dsInterface)) {
            return ICube.CubeTypeEnum.ROLAP;
        }
        if (DataSourceTypeEnum.isTM1(dsInterface)) {
            return ICube.CubeTypeEnum.TM1;
        }
        if (DataSourceTypeEnum.isTMR(dsInterface)) {
            return ICube.CubeTypeEnum.TMR;
        }
        throw new UnsupportedOperationException();
    }
}

