/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqemfw4j;

import com.cognos.mfw4j.framework.MFWModelRes;
import com.cognos.xqe.metadata.DimensionTypeEnum;
import com.cognos.xqemfw4j.MFWAlias;
import com.cognos.xqemfw4j.MFWAliasEntry;
import com.cognos.xqemfw4j.MFWCalculatedMember;
import com.cognos.xqemfw4j.MFWCalculation;
import com.cognos.xqemfw4j.MFWCalculationMacros;
import com.cognos.xqemfw4j.MFWCalculationNamedSet;
import com.cognos.xqemfw4j.MFWCalculationUnknown;
import com.cognos.xqemfw4j.MFWColumnDependency;
import com.cognos.xqemfw4j.MFWCube;
import com.cognos.xqemfw4j.MFWDataSource;
import com.cognos.xqemfw4j.MFWDbDimension;
import com.cognos.xqemfw4j.MFWDbMeasureDimension;
import com.cognos.xqemfw4j.MFWDeterminant;
import com.cognos.xqemfw4j.MFWDimension;
import com.cognos.xqemfw4j.MFWEmbeddedFilter;
import com.cognos.xqemfw4j.MFWFilter;
import com.cognos.xqemfw4j.MFWFolder;
import com.cognos.xqemfw4j.MFWFunction;
import com.cognos.xqemfw4j.MFWHierarchy;
import com.cognos.xqemfw4j.MFWHierarchyNamedSet;
import com.cognos.xqemfw4j.MFWIndex;
import com.cognos.xqemfw4j.MFWLevel;
import com.cognos.xqemfw4j.MFWMeasure;
import com.cognos.xqemfw4j.MFWMeasureDimension;
import com.cognos.xqemfw4j.MFWMember;
import com.cognos.xqemfw4j.MFWMetadata;
import com.cognos.xqemfw4j.MFWMetadataConnection;
import com.cognos.xqemfw4j.MFWModelDataSecurityObject;
import com.cognos.xqemfw4j.MFWModelDataSecurityViewrefObject;
import com.cognos.xqemfw4j.MFWMultiRequestHandle;
import com.cognos.xqemfw4j.MFWNamespace;
import com.cognos.xqemfw4j.MFWParentChildHierarchy;
import com.cognos.xqemfw4j.MFWPhysicalColumn;
import com.cognos.xqemfw4j.MFWPhysicalProcArgument;
import com.cognos.xqemfw4j.MFWPhysicalProcResult;
import com.cognos.xqemfw4j.MFWPhysicalSource;
import com.cognos.xqemfw4j.MFWPhysicalSubroutine;
import com.cognos.xqemfw4j.MFWPhysicalTable;
import com.cognos.xqemfw4j.MFWProcParameter;
import com.cognos.xqemfw4j.MFWProcResult;
import com.cognos.xqemfw4j.MFWProject;
import com.cognos.xqemfw4j.MFWQueryItem;
import com.cognos.xqemfw4j.MFWQueryItemFolder;
import com.cognos.xqemfw4j.MFWQueryItemOfDimension;
import com.cognos.xqemfw4j.MFWQueryItemOfHierarchy;
import com.cognos.xqemfw4j.MFWQueryItemOfLevel;
import com.cognos.xqemfw4j.MFWQueryItemOfQuerySubject;
import com.cognos.xqemfw4j.MFWQuerySubject;
import com.cognos.xqemfw4j.MFWRelationship;
import com.cognos.xqemfw4j.MFWRelationshipShortcut;
import com.cognos.xqemfw4j.MFWScopeRelationship;
import com.cognos.xqemfw4j.MFWSecurityFilterBasedOn;
import com.cognos.xqemfw4j.MFWSecurityObject;
import com.cognos.xqemfw4j.MFWShortcut;
import com.cognos.xqemfw4j.MFWVariable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public abstract class MFWMetadataFactory {
    private static String dbQuery = "dbQuery";
    private static final Map<Short, MFWMetadataFactory> FACTORY = Collections.unmodifiableMap(new HashMap<Short, MFWMetadataFactory>(){
        MFWModelRes modelRes = MFWModelRes.getInstance();
        {
            this.put(this.modelRes.RID_project, new MFWMetadataFactory(){

                @Override
                protected MFWMetadata newMfwInstance(MFWMetadataConnection connection, MFWMultiRequestHandle[] handles) {
                    return new MFWProject(connection, handles);
                }
            });
            this.put(this.modelRes.RID_folder, new MFWMetadataFactory(){

                @Override
                protected MFWMetadata newMfwInstance(MFWMetadataConnection connection, MFWMultiRequestHandle[] handles) {
                    return new MFWFolder(connection, handles);
                }
            });
            this.put(this.modelRes.RID_namespace, new MFWMetadataFactory(){

                @Override
                protected MFWMetadata newMfwInstance(MFWMetadataConnection connection, MFWMultiRequestHandle[] handles) {
                    return new MFWNamespace(connection, handles);
                }
            });
            this.put(this.modelRes.RID_dataSource, new MFWMetadataFactory(){

                @Override
                protected MFWMetadata newMfwInstance(MFWMetadataConnection connection, MFWMultiRequestHandle[] handles) {
                    return new MFWDataSource(connection, handles);
                }
            });
            this.put(this.modelRes.RID_dimension, new MFWMetadataFactory(){

                @Override
                protected MFWMetadata newMfwInstance(MFWMetadataConnection connection, MFWMultiRequestHandle[] handles) {
                    MFWDimension dimension = null;
                    String type = connection.queryValue(handles[handles.length - 1], MFWModelRes.getInstance().RID_type, new short[0]);
                    DimensionTypeEnum dimensionType = DimensionTypeEnum.fromFMDimensionTypeString(type);
                    String queryType = connection.queryValue(handles[handles.length - 1], MFWModelRes.getInstance().RID_definitionType, new short[0]);
                    dimension = dimensionType == DimensionTypeEnum.MEASURE ? (dbQuery.equals(queryType) ? new MFWDbMeasureDimension(connection, handles) : new MFWMeasureDimension(connection, handles)) : (dbQuery.equals(queryType) ? new MFWDbDimension(connection, handles) : new MFWDimension(connection, handles));
                    return dimension;
                }
            });
            this.put(this.modelRes.RID_hierarchy, new MFWMetadataFactory(){

                @Override
                protected MFWMetadata newMfwInstance(MFWMetadataConnection connection, MFWMultiRequestHandle[] handles) {
                    MFWHierarchy hierarchy = null;
                    boolean parentChild = "true".equals(connection.queryValue(handles[handles.length - 1], MFWModelRes.getInstance().RID_parentChild, new short[0]));
                    hierarchy = parentChild ? new MFWParentChildHierarchy(connection, handles) : new MFWHierarchy(connection, handles);
                    return hierarchy;
                }
            });
            this.put(this.modelRes.RID_level, new MFWMetadataFactory(){

                @Override
                protected MFWMetadata newMfwInstance(MFWMetadataConnection connection, MFWMultiRequestHandle[] handles) {
                    return new MFWLevel(connection, handles);
                }
            });
            this.put(this.modelRes.RID_member, new MFWMetadataFactory(){

                @Override
                protected MFWMetadata newMfwInstance(MFWMetadataConnection connection, MFWMultiRequestHandle[] handles) {
                    return new MFWMember(connection, handles);
                }
            });
            this.put(this.modelRes.RID_calculatedMember, new MFWMetadataFactory(){

                @Override
                protected MFWMetadata newMfwInstance(MFWMetadataConnection connection, MFWMultiRequestHandle[] handles) {
                    return new MFWCalculatedMember(connection, handles);
                }
            });
            this.put(this.modelRes.RID_measure, new MFWMetadataFactory(){

                @Override
                protected MFWMetadata newMfwInstance(MFWMetadataConnection connection, MFWMultiRequestHandle[] handles) {
                    return new MFWMeasure(connection, handles);
                }
            });
            this.put(this.modelRes.RID_relationship, new MFWMetadataFactory(){

                @Override
                protected MFWMetadata newMfwInstance(MFWMetadataConnection connection, MFWMultiRequestHandle[] handles) {
                    return new MFWRelationship(connection, handles);
                }
            });
            this.put(this.modelRes.RID_scopeRelationship, new MFWMetadataFactory(){

                @Override
                protected MFWMetadata newMfwInstance(MFWMetadataConnection connection, MFWMultiRequestHandle[] handles) {
                    return new MFWScopeRelationship(connection, handles);
                }
            });
            this.put(this.modelRes.RID_querySubject, new MFWMetadataFactory(){

                @Override
                protected MFWMetadata newMfwInstance(MFWMetadataConnection connection, MFWMultiRequestHandle[] handles) {
                    return new MFWQuerySubject(connection, handles);
                }
            });
            this.put(this.modelRes.RID_updateSubject, new MFWMetadataFactory(){

                @Override
                protected MFWMetadata newMfwInstance(MFWMetadataConnection connection, MFWMultiRequestHandle[] handles) {
                    return new MFWQuerySubject(connection, handles);
                }
            });
            this.put(this.modelRes.RID_queryItem, new MFWMetadataFactory(){

                @Override
                protected MFWMetadata newMfwInstance(MFWMetadataConnection connection, MFWMultiRequestHandle[] handles) {
                    MFWQueryItem queryItem = null;
                    MFWMultiRequestHandle parent = null;
                    for (parent = handles[handles.length - 1].getParent(); parent != null && parent.getNameRID() == modelRes.RID_queryItemFolder; parent = parent.getParent()) {
                    }
                    if (parent != null) {
                        short parentRID = parent.getNameRID();
                        if (modelRes.RID_dimension == parentRID) {
                            queryItem = new MFWQueryItemOfDimension(connection, handles);
                        } else if (modelRes.RID_hierarchy == parentRID) {
                            queryItem = new MFWQueryItemOfHierarchy(connection, handles);
                        } else if (modelRes.RID_level == parentRID) {
                            queryItem = new MFWQueryItemOfLevel(connection, handles);
                        } else if (modelRes.RID_querySubject == parentRID) {
                            queryItem = new MFWQueryItemOfQuerySubject(connection, handles);
                        }
                    }
                    return queryItem;
                }
            });
            this.put(this.modelRes.RID_shortcut, new MFWMetadataFactory(){

                @Override
                protected MFWMetadata newMfwInstance(MFWMetadataConnection connection, MFWMultiRequestHandle[] handles) {
                    return new MFWShortcut(connection, handles);
                }
            });
            this.put(this.modelRes.getResourceID("dimensionFolder"), new MFWMetadataFactory(){

                @Override
                protected MFWMetadata newMfwInstance(MFWMetadataConnection connection, MFWMultiRequestHandle[] handles) {
                    return new MFWProject(connection, handles);
                }
            });
            this.put(this.modelRes.RID_hierarchyFolder, new MFWMetadataFactory(){

                @Override
                protected MFWMetadata newMfwInstance(MFWMetadataConnection connection, MFWMultiRequestHandle[] handles) {
                    return new MFWFolder(connection, handles);
                }
            });
            this.put(this.modelRes.RID_measureFolder, new MFWMetadataFactory(){

                @Override
                protected MFWMetadata newMfwInstance(MFWMetadataConnection connection, MFWMultiRequestHandle[] handles) {
                    return new MFWFolder(connection, handles);
                }
            });
            this.put(this.modelRes.RID_queryItemFolder, new MFWMetadataFactory(){

                @Override
                protected MFWMetadata newMfwInstance(MFWMetadataConnection connection, MFWMultiRequestHandle[] handles) {
                    return new MFWQueryItemFolder(connection, handles);
                }
            });
            this.put(this.modelRes.RID_calculation, new MFWMetadataFactory(){

                @Override
                protected MFWMetadata newMfwInstance(MFWMetadataConnection connection, MFWMultiRequestHandle[] handles) {
                    MFWCalculation calculation = null;
                    String calcType = connection.queryValue(handles[handles.length - 1], MFWModelRes.getInstance().RID_calcType, new short[0]);
                    if ("unknown".equals(calcType)) {
                        calculation = new MFWCalculationUnknown(connection, handles);
                    } else if ("namedSet".equals(calcType)) {
                        calculation = new MFWCalculationNamedSet(connection, handles);
                    } else if ("macros".equals(calcType)) {
                        calculation = new MFWCalculationMacros(connection, handles);
                    }
                    return calculation;
                }
            });
            this.put(this.modelRes.RID_hierarchyNamedSet, new MFWMetadataFactory(){

                @Override
                protected MFWMetadata newMfwInstance(MFWMetadataConnection connection, MFWMultiRequestHandle[] handles) {
                    return new MFWHierarchyNamedSet(connection, handles);
                }
            });
            this.put(this.modelRes.RID_parameterMap, new MFWMetadataFactory(){

                @Override
                protected MFWMetadata newMfwInstance(MFWMetadataConnection connection, MFWMultiRequestHandle[] handles) {
                    return new MFWAlias(connection, handles);
                }
            });
            this.put(this.modelRes.RID_parameterMapEntry, new MFWMetadataFactory(){

                @Override
                protected MFWMetadata newMfwInstance(MFWMetadataConnection connection, MFWMultiRequestHandle[] handles) {
                    return new MFWAliasEntry(connection, handles);
                }
            });
            this.put(this.modelRes.RID_filterDefinition, new MFWMetadataFactory(){

                @Override
                protected MFWMetadata newMfwInstance(MFWMetadataConnection connection, MFWMultiRequestHandle[] handles) {
                    return new MFWEmbeddedFilter(connection, handles);
                }
            });
            this.put(this.modelRes.RID_previewFilter, new MFWMetadataFactory(){

                @Override
                protected MFWMetadata newMfwInstance(MFWMetadataConnection connection, MFWMultiRequestHandle[] handles) {
                    return new MFWEmbeddedFilter(connection, handles);
                }
            });
            this.put(this.modelRes.RID_securityFilterDefinition, new MFWMetadataFactory(){

                @Override
                protected MFWMetadata newMfwInstance(MFWMetadataConnection connection, MFWMultiRequestHandle[] handles) {
                    return new MFWEmbeddedFilter(connection, handles);
                }
            });
            this.put(this.modelRes.RID_securityObject, new MFWMetadataFactory(){

                @Override
                protected MFWMetadata newMfwInstance(MFWMetadataConnection connection, MFWMultiRequestHandle[] handles) {
                    return new MFWSecurityObject(connection, handles);
                }
            });
            this.put(this.modelRes.RID_basedOn, new MFWMetadataFactory(){

                @Override
                protected MFWMetadata newMfwInstance(MFWMetadataConnection connection, MFWMultiRequestHandle[] handles) {
                    return new MFWSecurityFilterBasedOn(connection, handles);
                }
            });
            this.put(this.modelRes.RID_modelDataSecurityObjects, new MFWMetadataFactory(){

                @Override
                protected MFWMetadata newMfwInstance(MFWMetadataConnection connection, MFWMultiRequestHandle[] handles) {
                    return new MFWModelDataSecurityObject(connection, handles);
                }
            });
            this.put(this.modelRes.RID_modelDataViewrefObjects, new MFWMetadataFactory(){

                @Override
                protected MFWMetadata newMfwInstance(MFWMetadataConnection connection, MFWMultiRequestHandle[] handles) {
                    return new MFWModelDataSecurityViewrefObject(connection, handles);
                }
            });
            this.put(this.modelRes.RID_filter, new MFWMetadataFactory(){

                @Override
                protected MFWMetadata newMfwInstance(MFWMetadataConnection connection, MFWMultiRequestHandle[] handles) {
                    return new MFWFilter(connection, handles);
                }
            });
            this.put(this.modelRes.RID_cube, new MFWMetadataFactory(){

                @Override
                protected MFWMetadata newMfwInstance(MFWMetadataConnection connection, MFWMultiRequestHandle[] handles) {
                    return new MFWCube(connection, handles);
                }
            });
            this.put(this.modelRes.RID_property, new MFWMetadataFactory(){

                @Override
                protected MFWMetadata newMfwInstance(MFWMetadataConnection connection, MFWMultiRequestHandle[] handles) {
                    boolean isVariable;
                    MFWMultiRequestHandle parent = handles[handles.length - 1].getParent();
                    boolean bl = isVariable = parent != null && parent.getNameRID() == MFWModelRes.getInstance().RID_property && "SAP BW Variables".equals(connection.queryValue(parent, MFWModelRes.getInstance().RID_name, new short[0]));
                    if (isVariable) {
                        return new MFWVariable(connection, handles);
                    }
                    return null;
                }
            });
            this.put(this.modelRes.RID_relationshipShortcut, new MFWMetadataFactory(){

                @Override
                protected MFWMetadata newMfwInstance(MFWMetadataConnection connection, MFWMultiRequestHandle[] handles) {
                    return new MFWRelationshipShortcut(connection, handles);
                }
            });
            this.put(this.modelRes.RID_determinant, new MFWMetadataFactory(){

                @Override
                protected MFWMetadata newMfwInstance(MFWMetadataConnection connection, MFWMultiRequestHandle[] handles) {
                    return new MFWDeterminant(connection, handles);
                }
            });
            this.put(this.modelRes.RID_columnDependency, new MFWMetadataFactory(){

                @Override
                protected MFWMetadata newMfwInstance(MFWMetadataConnection connection, MFWMultiRequestHandle[] handles) {
                    return new MFWColumnDependency(connection, handles);
                }
            });
            this.put(this.modelRes.RID_index, new MFWMetadataFactory(){

                @Override
                protected MFWMetadata newMfwInstance(MFWMetadataConnection connection, MFWMultiRequestHandle[] handles) {
                    return new MFWIndex(connection, handles);
                }
            });
            this.put(this.modelRes.RID_physicalSource, new MFWMetadataFactory(){

                @Override
                protected MFWMetadata newMfwInstance(MFWMetadataConnection connection, MFWMultiRequestHandle[] handles) {
                    return new MFWPhysicalSource(connection, handles);
                }
            });
            this.put(this.modelRes.RID_table, new MFWMetadataFactory(){

                @Override
                protected MFWMetadata newMfwInstance(MFWMetadataConnection connection, MFWMultiRequestHandle[] handles) {
                    return new MFWPhysicalTable(connection, handles);
                }
            });
            this.put(this.modelRes.RID_column, new MFWMetadataFactory(){

                @Override
                protected MFWMetadata newMfwInstance(MFWMetadataConnection connection, MFWMultiRequestHandle[] handles) {
                    return new MFWPhysicalColumn(connection, handles);
                }
            });
            this.put(this.modelRes.RID_subroutine, new MFWMetadataFactory(){

                @Override
                protected MFWMetadata newMfwInstance(MFWMetadataConnection connection, MFWMultiRequestHandle[] handles) {
                    return new MFWPhysicalSubroutine(connection, handles);
                }
            });
            this.put(this.modelRes.RID_procArgument, new MFWMetadataFactory(){

                @Override
                protected MFWMetadata newMfwInstance(MFWMetadataConnection connection, MFWMultiRequestHandle[] handles) {
                    return new MFWPhysicalProcArgument(connection, handles);
                }
            });
            this.put(this.modelRes.RID_procResult, new MFWMetadataFactory(){

                @Override
                protected MFWMetadata newMfwInstance(MFWMetadataConnection connection, MFWMultiRequestHandle[] handles) {
                    return new MFWPhysicalProcResult(connection, handles);
                }
            });
            this.put(this.modelRes.RID_procParameter, new MFWMetadataFactory(){

                @Override
                protected MFWMetadata newMfwInstance(MFWMetadataConnection connection, MFWMultiRequestHandle[] handles) {
                    return new MFWProcParameter(connection, handles);
                }
            });
            this.put(this.modelRes.RID_result, new MFWMetadataFactory(){

                @Override
                protected MFWMetadata newMfwInstance(MFWMetadataConnection connection, MFWMultiRequestHandle[] handles) {
                    return new MFWProcResult(connection, handles);
                }
            });
            this.put(this.modelRes.RID_function, new MFWMetadataFactory(){

                @Override
                protected MFWMetadata newMfwInstance(MFWMetadataConnection connection, MFWMultiRequestHandle[] handles) {
                    return new MFWFunction(connection, handles);
                }
            });
        }

        @Override
        public MFWMetadataFactory get(Object key) {
            MFWMetadataFactory factory = (MFWMetadataFactory)super.get(key);
            if (factory == null) {
                factory = DEFAULT;
            }
            return factory;
        }
    });
    private static final MFWMetadataFactory DEFAULT = new MFWMetadataFactory(){

        @Override
        protected MFWMetadata newMfwInstance(MFWMetadataConnection connection, MFWMultiRequestHandle[] handles) {
            return null;
        }
    };

    public static MFWMetadata newInstance(MFWMetadataConnection connection, MFWMultiRequestHandle[] handles) {
        return FACTORY.get(handles[handles.length - 1].getNameRID()).newMfwInstance(connection, handles);
    }

    public static void initialize() {
        MFWModelRes modelRes = MFWModelRes.getInstance();
        FACTORY.get(modelRes.RID_project);
    }

    protected abstract MFWMetadata newMfwInstance(MFWMetadataConnection var1, MFWMultiRequestHandle[] var2);
}

