/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqemfw4j;

import com.cognos.mfw4j.framework.MFWGateway;
import com.cognos.mfw4j.framework.MFWGatewayReuseIndicator;
import com.cognos.mfw4j.framework.MFWMetadataSource;
import com.cognos.mfw4j.framework.MFWNodeHandle;
import com.cognos.mfw4j.framework.MFWQuerySpec;
import com.cognos.mfw4j.framework.MFWRequestContext;
import com.cognos.mfw4j.framework.nodeKey.MFWNodeKey;
import com.cognos.mfw4j.utilities.IMFWUsageIndicator;
import com.cognos.xqe.bibushandler.RequestEnvironment;
import com.cognos.xqe.metadata.IMultiRequestGateway;
import com.cognos.xqe.metadata.IMultiRequestHandle;
import com.cognos.xqe.query.engine.ExecutionEnvironment;
import com.cognos.xqe.query.engine.IContextable;
import com.cognos.xqe.query.engine.MultiRequestReference;
import com.cognos.xqe.util.context.ExecutionEnvironmentContext;
import com.cognos.xqemfw4j.MFWMultiRequestHandle;
import com.cognos.xqemfw4j.MFWUsageIndicator;
import java.util.HashMap;
import java.util.Map;
import org.dom4j.Element;

class MFWMultiRequestGateway
implements IMultiRequestGateway {
    private final String gatewayId;
    private final MFWMetadataSource metadataSource;
    private final Parameters parameters;
    private final MultiRequestReference<Map<MFWNodeKey, MFWMultiRequestHandle>> multiReqHandleCacheRef = new MultiRequestReference();
    private final MultiRequestReference<MFWGateway> gatewayImplRef = new MultiRequestReference();

    MFWMultiRequestGateway(ExecutionEnvironment theExecEnv, String theGatewayId, MFWMetadataSource theMetadataSource, Parameters theParameters, MFWGateway theGatewayImpl) {
        if (null == theExecEnv) {
            throw new NullPointerException("theExecEnv was null");
        }
        if (null == theMetadataSource) {
            throw new NullPointerException("theMetadataSource was null");
        }
        if (null == theParameters) {
            throw new NullPointerException("theParameters was null");
        }
        if (null == theGatewayImpl) {
            throw new NullPointerException("theGatewayImpl was null");
        }
        this.gatewayId = theGatewayId;
        this.metadataSource = theMetadataSource;
        this.parameters = theParameters;
        this.gatewayImplRef.set(theExecEnv, theGatewayImpl);
        theExecEnv.registerResource(new MFWGatewayContextableAdapter(theGatewayImpl));
    }

    @Override
    public MFWGateway getGatewayImpl() {
        ExecutionEnvironment execEnv = (ExecutionEnvironment)ExecutionEnvironmentContext.getExecutionEnvironment();
        RequestEnvironment reqEnv = (RequestEnvironment)execEnv.getRequestEnvironment();
        MFWGateway impl = this.gatewayImplRef.get(execEnv);
        if (null == impl) {
            MFWRequestContext newReqCtx = MFWRequestContext.create((String)this.parameters.getProductLocale(), (String)this.parameters.getContentLocale(), (String)this.parameters.getUserPassport());
            newReqCtx.setAdvancedIDResolution(this.parameters.getAdvancedIDResolution());
            reqEnv.setUpMFWContextHeader(newReqCtx);
            newReqCtx.setXQEUsageIndicatorService((IMFWUsageIndicator)new MFWUsageIndicator());
            if (null != execEnv.getConnectionElement()) {
                Element connectionSpec = (Element)execEnv.getConnectionElement().clone();
                newReqCtx.setConnectionSpec(connectionSpec);
            }
            newReqCtx.setXQEExecutionEnvironment((Object)execEnv);
            impl = MFWGateway.open((String)this.gatewayId, (MFWRequestContext)newReqCtx, (MFWMetadataSource)this.metadataSource);
            execEnv.registerResource(new MFWGatewayContextableAdapter(impl));
            this.gatewayImplRef.set(execEnv, impl);
        }
        impl.getContext().setXQEExecutionEnvironment((Object)execEnv);
        reqEnv.setUpMFWContextHeader(impl.getContext());
        impl.getContext().setXQEUsageIndicatorService((IMFWUsageIndicator)new MFWUsageIndicator());
        impl.getContext().setConnectionSpec(execEnv.getConnectionElement());
        return impl;
    }

    MFWMultiRequestHandle createMultiRequestHandle(MFWNodeHandle nodeHandle) {
        MFWNodeKey nodeKey;
        if (null == nodeHandle) {
            throw new NullPointerException("nodeHandle was null");
        }
        if (nodeHandle.isProperty()) {
            return new MFWMultiRequestHandle(this, nodeHandle);
        }
        Map<MFWNodeKey, MFWMultiRequestHandle> multiReqHandleCache = this.getOrCreateMultiRequestHandleCache();
        MFWMultiRequestHandle multiReqHandle = multiReqHandleCache.get(nodeKey = this.getGatewayImpl().getNodeKey(nodeHandle));
        if (null == multiReqHandle) {
            multiReqHandle = new MFWMultiRequestHandle(this, nodeHandle);
            multiReqHandleCache.put(nodeKey, multiReqHandle);
        }
        return multiReqHandle;
    }

    MFWMultiRequestHandle[] createMultiRequestHandles(MFWNodeHandle[] handles) {
        if (null == handles) {
            throw new NullPointerException("handles was null");
        }
        MFWMultiRequestHandle[] result = new MFWMultiRequestHandle[handles.length];
        for (int i = 0; i < handles.length; ++i) {
            result[i] = this.createMultiRequestHandle(handles[i]);
        }
        return result;
    }

    private Map<MFWNodeKey, MFWMultiRequestHandle> getOrCreateMultiRequestHandleCache() {
        Map<MFWNodeKey, MFWMultiRequestHandle> multiRequestHandleCache = this.multiReqHandleCacheRef.get();
        if (null == multiRequestHandleCache) {
            multiRequestHandleCache = new HashMap<MFWNodeKey, MFWMultiRequestHandle>();
            this.multiReqHandleCacheRef.set(multiRequestHandleCache);
        }
        return multiRequestHandleCache;
    }

    public void close() {
    }

    public MFWMultiRequestHandle[] getAllObjectChildren(IMultiRequestHandle arg0) {
        MFWNodeHandle[] result = this.getGatewayImpl().getAllObjectChildren(arg0.getNodeHandle());
        return this.createMultiRequestHandles(result);
    }

    public MFWMetadataSource getAssociatedMetadataSource(MFWMultiRequestHandle arg0) {
        return this.getGatewayImpl().getAssociatedMetadataSource(arg0.getNodeHandle());
    }

    public boolean getBooleanPropertyValue(MFWMultiRequestHandle arg0) {
        return this.getGatewayImpl().getBooleanPropertyValue(arg0.getNodeHandle());
    }

    public int getEnumPropertyValue(MFWMultiRequestHandle arg0) {
        return this.getGatewayImpl().getEnumPropertyValue(arg0.getNodeHandle());
    }

    public String getID() {
        return this.gatewayId;
    }

    public boolean getObjectBooleanPropertyValue(MFWMultiRequestHandle arg0, short arg1) {
        return this.getGatewayImpl().getObjectBooleanPropertyValue(arg0.getNodeHandle(), arg1);
    }

    public MFWMultiRequestHandle[] getObjectChildren(MFWMultiRequestHandle arg0, short arg1) {
        MFWNodeHandle[] result = this.getGatewayImpl().getObjectChildren(arg0.getNodeHandle(), arg1);
        return this.createMultiRequestHandles(result);
    }

    public int getObjectEnumPropertyValue(MFWMultiRequestHandle arg0, short arg1) {
        return this.getGatewayImpl().getObjectEnumPropertyValue(arg0.getNodeHandle(), arg1);
    }

    public String getObjectPropertyValue(MFWMultiRequestHandle arg0, short arg1) {
        return this.getGatewayImpl().getObjectPropertyValue(arg0.getNodeHandle(), arg1);
    }

    public MFWMultiRequestHandle getObjectReferencePropertyValue(MFWMultiRequestHandle arg0, short arg1) {
        MFWNodeHandle result = this.getGatewayImpl().getObjectReferencePropertyValue(arg0.getNodeHandle(), arg1);
        return this.createMultiRequestHandle(result);
    }

    @Override
    public String getPropertyValue(IMultiRequestHandle arg0) {
        return this.getGatewayImpl().getPropertyValue(arg0.getNodeHandle());
    }

    public MFWMultiRequestHandle getReferencePropertyValue(MFWMultiRequestHandle arg0) {
        MFWNodeHandle result = this.getGatewayImpl().getReferencePropertyValue(arg0.getNodeHandle());
        return this.createMultiRequestHandle(result);
    }

    public MFWMultiRequestHandle[] query(MFWQuerySpec arg0) {
        MFWNodeHandle[] result = this.getGatewayImpl().query(arg0);
        return this.createMultiRequestHandles(result);
    }

    public MFWMultiRequestHandle[] queryObject(IMultiRequestHandle arg0, MFWQuerySpec arg1) {
        MFWNodeHandle[] result = this.getGatewayImpl().queryObject(arg0.getNodeHandle(), arg1);
        return this.createMultiRequestHandles(result);
    }

    public MFWMultiRequestHandle[] resolveCrnID(String arg0) {
        MFWNodeHandle[] result = this.getGatewayImpl().resolveCrnID(arg0);
        return this.createMultiRequestHandles(result);
    }

    public MFWNodeKey getNodeKey(MFWMultiRequestHandle handle) {
        handle.persist();
        return handle.getNodeKey();
    }

    public MFWMultiRequestHandle getNodeByKey(MFWNodeKey nodeKey) {
        MFWNodeHandle nodeHandle = this.getGatewayImpl().getNodeByKey(nodeKey);
        return this.createMultiRequestHandle(nodeHandle);
    }

    public MFWGatewayReuseIndicator getReuseIndicator() {
        return this.getGatewayImpl().getReuseIndicator();
    }

    public MFWMultiRequestHandle[] lookupObjectsByType(short classType) {
        MFWNodeHandle[] handles = this.getGatewayImpl().lookupObjectsByType(classType);
        return this.createMultiRequestHandles(handles);
    }

    public String toString() {
        return this.gatewayImplRef.toString();
    }

    public boolean isStale(boolean ignoreRetainPeriod, boolean isMetadataRequest) {
        return this.getGatewayImpl().isStale(ignoreRetainPeriod, this.metadataSource, isMetadataRequest);
    }

    private static final class MFWGatewayContextableAdapter
    implements IContextable {
        private final MFWGateway gateway;

        private MFWGatewayContextableAdapter(MFWGateway theGateway) {
            this.gateway = theGateway;
        }

        @Override
        public void release() {
            this.gateway.close();
        }

        @Override
        public boolean isSessionScope() {
            return true;
        }
    }

    public static final class Parameters {
        private String productLocale;
        private String contentLocale;
        private String userPassport;
        private boolean advancedIDResolution;

        public static Parameters fromRequestContext(MFWRequestContext requestContext) {
            Parameters params = new Parameters();
            params.setProductLocale(requestContext.getProductLocale());
            params.setContentLocale(requestContext.getContentLocale());
            params.setUserPassport(requestContext.getUserPassport());
            params.setAdvancedIDResolution(requestContext.getAdvancedIDResolution());
            return params;
        }

        Parameters() {
        }

        public String getProductLocale() {
            return this.productLocale;
        }

        public void setProductLocale(String theProductLocale) {
            this.productLocale = theProductLocale;
        }

        public String getContentLocale() {
            return this.contentLocale;
        }

        public void setContentLocale(String theContentLocale) {
            this.contentLocale = theContentLocale;
        }

        public String getUserPassport() {
            return this.userPassport;
        }

        public void setUserPassport(String theUserPassport) {
            this.userPassport = theUserPassport;
        }

        public boolean getAdvancedIDResolution() {
            return this.advancedIDResolution;
        }

        public void setAdvancedIDResolution(boolean useAdvancedIDResolution) {
            this.advancedIDResolution = useAdvancedIDResolution;
        }
    }
}

