/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqemfw4j;

import com.cognos.mfw4j.framework.MFWGateway;
import com.cognos.mfw4j.framework.MFWInfo;
import com.cognos.mfw4j.framework.MFWNodeHandle;
import com.cognos.mfw4j.framework.nodeKey.MFWNodeKey;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.metadata.IMultiRequestHandle;
import com.cognos.xqe.query.engine.ExecutionEnvironment;
import com.cognos.xqe.query.engine.MultiRequestReference;
import com.cognos.xqe.util.context.ExecutionEnvironmentContext;
import com.cognos.xqemfw4j.MFWMultiRequestGateway;

final class MFWMultiRequestHandle
implements IMultiRequestHandle {
    private final MFWMultiRequestGateway gateway;
    private final MultiRequestReference<MFWNodeHandle> nodeHandleRef = new MultiRequestReference();
    private MFWNodeKey nodeKey = null;
    private Boolean cachedIsObject = null;
    private Boolean cachedIsProperty = null;
    private String cachedName = null;
    private Short cachedNameRID = null;
    private int cachedHashCode = -1;

    MFWMultiRequestHandle(MFWMultiRequestGateway theGateway, MFWNodeHandle theNodeHandle) {
        this.gateway = theGateway;
        if (null != theNodeHandle) {
            this.nodeHandleRef.set(theNodeHandle);
        }
    }

    public MFWMultiRequestGateway getGateway() {
        return this.gateway;
    }

    MFWNodeKey getNodeKey() {
        return this.nodeKey;
    }

    public void persist() {
        if (null == this.nodeKey) {
            MFWNodeHandle nodeHandle = this.nodeHandleRef.get();
            if (null == nodeHandle) {
                throw new XQERuntimeException(XQEMessageKeys.GEN_FoundInternalErrorParam_INTERNAL, "MFWNodeHandle was not found in current context.");
            }
            this.nodeKey = this.getGateway().getGatewayImpl().getNodeKey(nodeHandle);
        }
    }

    @Override
    public MFWNodeHandle getNodeHandle() {
        if (null == this.gateway) {
            return null;
        }
        ExecutionEnvironment execEnv = (ExecutionEnvironment)ExecutionEnvironmentContext.getExecutionEnvironment();
        if (null == execEnv) {
            throw new XQERuntimeException(XQEMessageKeys.GEN_ExecutionEnvironmentMissing_INTERNAL);
        }
        MFWNodeHandle nodeHandle = this.nodeHandleRef.get(execEnv);
        if (null == nodeHandle) {
            if (null == this.nodeKey) {
                throw new XQERuntimeException(XQEMessageKeys.GEN_FoundInternalErrorParam_INTERNAL, "Cannot resolve MFWNodeHandle without a node key.");
            }
            MFWGateway gatewayImpl = this.gateway.getGatewayImpl();
            nodeHandle = gatewayImpl.getNodeByKey(this.nodeKey);
            if (null == nodeHandle) {
                throw new XQERuntimeException(XQEMessageKeys.GEN_FoundInternalErrorParam_INTERNAL, "Failed to resolve MFWNodeHandle from node key: " + this.nodeKey.toString());
            }
            this.nodeHandleRef.set(execEnv, nodeHandle);
        }
        return nodeHandle;
    }

    public MFWInfo getInfo() {
        return this.getNodeHandle().getInfo();
    }

    @Override
    public String getName() {
        if (null == this.cachedName) {
            this.cachedName = this.getNodeHandle().getName();
        }
        return this.cachedName;
    }

    @Override
    public short getNameRID() {
        if (null == this.cachedNameRID) {
            this.cachedNameRID = this.getNodeHandle().getNameRID();
        }
        return this.cachedNameRID;
    }

    @Override
    public boolean isObject() {
        if (null == this.cachedIsObject) {
            this.cachedIsObject = this.getNodeHandle().isObject();
        }
        return this.cachedIsObject;
    }

    @Override
    public boolean isProperty() {
        if (null == this.cachedIsProperty) {
            this.cachedIsProperty = this.getNodeHandle().isProperty();
        }
        return this.cachedIsProperty;
    }

    public MFWMultiRequestHandle getParent() {
        MFWNodeHandle parentNode = this.getNodeHandle().getParent();
        return this.getGateway().createMultiRequestHandle(parentNode);
    }

    public String getPath() {
        return this.getNodeHandle().getPath();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MFWMultiRequestHandle)) {
            return false;
        }
        MFWMultiRequestHandle handle = (MFWMultiRequestHandle)o;
        if (this.gateway != handle.gateway) {
            return false;
        }
        return this.nodeKey == handle.nodeKey || this.nodeKey.equals(handle.nodeKey);
    }

    public int hashCode() {
        if (-1 == this.cachedHashCode) {
            if (null == this.nodeKey) {
                this.cachedHashCode = 0;
            } else {
                this.cachedHashCode = this.nodeKey.hashCode();
                if (-1 == this.cachedHashCode) {
                    this.cachedHashCode = 0;
                }
            }
        }
        return this.cachedHashCode;
    }

    public String toString() {
        return this.getNodeHandle().toString();
    }
}

