/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqemfw4j;

import com.cognos.mfw4j.framework.MFWModelRes;
import com.cognos.xqe.data.types.IDataType;
import com.cognos.xqe.data.types.MultisetType;
import com.cognos.xqe.data.types.StructType;
import com.cognos.xqe.metadata.IMetadata;
import com.cognos.xqe.metadata.IQueryItemFolder;
import com.cognos.xqe.metadata.IQuerySubject;
import com.cognos.xqe.metadata.IRelationship;
import com.cognos.xqemfw4j.MFWFolder;
import com.cognos.xqemfw4j.MFWMetadataConnection;
import com.cognos.xqemfw4j.MFWMultiRequestHandle;

class MFWQueryItemFolder
extends MFWFolder
implements IQueryItemFolder {
    private volatile boolean dtLoaded = false;
    private volatile IDataType dt = null;
    private volatile boolean cardLoaded = false;
    private volatile IRelationship.Cardinality parentCard = null;
    private volatile IRelationship.Cardinality card = null;

    MFWQueryItemFolder(MFWMetadataConnection mfwConnection, MFWMultiRequestHandle[] mfwHandle) {
        super(mfwConnection, mfwHandle);
    }

    @Override
    public IDataType getDataType() {
        this.loadDataType();
        return this.dt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadDataType() {
        if (this.dtLoaded) {
            return;
        }
        MFWQueryItemFolder mFWQueryItemFolder = this;
        synchronized (mFWQueryItemFolder) {
            if (!this.dtLoaded) {
                String dtName = this.queryValue(MFWModelRes.getInstance().RID_datatype, new short[0]);
                if ("struct".equals(dtName)) {
                    this.dt = StructType.STRUCTTYPE;
                } else if ("multiset".equals(dtName)) {
                    this.dt = MultisetType.MULTISETTYPE;
                }
                this.dtLoaded = true;
            }
        }
    }

    @Override
    public IRelationship.Cardinality getParentCardinality() {
        this.loadCardinality();
        return this.parentCard;
    }

    @Override
    public IRelationship.Cardinality getCardinality() {
        this.loadCardinality();
        return this.card;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadCardinality() {
        if (this.cardLoaded) {
            return;
        }
        MFWQueryItemFolder mFWQueryItemFolder = this;
        synchronized (mFWQueryItemFolder) {
            if (!this.cardLoaded) {
                this.parentCard = this.convertStringToCardinality(this.queryValue(MFWModelRes.getInstance().RID_leftmaxcard, new short[0]));
                this.card = this.convertStringToCardinality(this.queryValue(MFWModelRes.getInstance().RID_rightmaxcard, new short[0]));
                this.cardLoaded = true;
            }
        }
    }

    private IRelationship.Cardinality convertStringToCardinality(String minPart) {
        if ("zero".equals(minPart)) {
            return IRelationship.Cardinality.ZERO_ONE;
        }
        if ("one".equals(minPart)) {
            return IRelationship.Cardinality.ONE_ONE;
        }
        if ("many".equals(minPart)) {
            return IRelationship.Cardinality.ONE_MANY;
        }
        return null;
    }

    @Override
    public IQuerySubject getQuerySubject() {
        for (IMetadata parent = this.getParentObject(); parent != null; parent = parent.getParentObject()) {
            if (!(parent instanceof IQuerySubject)) continue;
            return (IQuerySubject)parent;
        }
        return null;
    }

    @Override
    public String getV5UniqueName() {
        return this.getID();
    }

    @Override
    public boolean isHidden() {
        return super.isHidden();
    }
}

