/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqemfw4j;

import com.cognos.mfw4j.utilities.IMFWUsageIndicator;
import com.cognos.xqe.config.ServiceEnumeration;
import com.cognos.xqe.config.XQEConfiguration;
import com.cognos.xqe.config.XQEConfigurationManager;
import com.cognos.xqe.util.usage.UsageTrackingService;
import com.cognos.xqe.util.usage.indicators.IUsageIndicator;
import com.cognos.xqe.util.usage.indicators.UsageIndicatorCategory;
import com.cognos.xqe.util.usage.indicators.UsageIndicatorType;

public class MFWUsageIndicator
implements IMFWUsageIndicator {
    private static final String TAG_NUMBER_OF_CALLS = "numberOfCalls/";
    private static Boolean isUsageTrackingEnabled = null;

    public MFWUsageIndicator() {
        if (isUsageTrackingEnabled == null) {
            Boolean configValue;
            XQEConfiguration configuration = XQEConfigurationManager.getInstance().getConfiguration(ServiceEnumeration.XQE);
            isUsageTrackingEnabled = configValue = Boolean.valueOf(configuration.getBooleanProperty("usageTracking.mfwUsageTrackingsService[@enabled]", false));
        }
    }

    public void logMeasurements(String name, long time) {
        if (!isUsageTrackingEnabled.booleanValue()) {
            return;
        }
        IUsageIndicator elapsedTime = UsageTrackingService.getIndicator(UsageIndicatorType.SIMPLE_INDICATOR, UsageIndicatorCategory.COMPONENT_EXECUTION_TIME, name);
        elapsedTime.add(time);
        IUsageIndicator numCalls = UsageTrackingService.getIndicator(UsageIndicatorType.SIMPLE_INDICATOR, UsageIndicatorCategory.COMPONENT_METHODS, TAG_NUMBER_OF_CALLS.concat(name));
        numCalls.increment();
    }
}

