/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqemfw4j;

import com.cognos.mfw4j.framework.MFWModelRes;
import com.cognos.xqe.data.DataType;
import com.cognos.xqe.data.providers.DataSourceTypeEnum;
import com.cognos.xqe.data.types.DataTypeFactory;
import com.cognos.xqe.data.types.IDataType;
import com.cognos.xqe.data.values.DataValueFactory;
import com.cognos.xqe.data.values.IValue;
import com.cognos.xqe.data.values.StringValue;
import com.cognos.xqe.metadata.ICube;
import com.cognos.xqe.metadata.IDimension;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.metadata.IVariable;
import com.cognos.xqe.metadata.MetadataType;
import com.cognos.xqe.metadata.VariableEntryTypeEnum;
import com.cognos.xqe.metadata.VariablePromptTypeEnum;
import com.cognos.xqe.metadata.VariableSelectionTypeEnum;
import com.cognos.xqe.metadata.VariableTypeEnum;
import com.cognos.xqe.util.bean.BeanPropertySupport;
import com.cognos.xqemfw4j.MFWDataSource;
import com.cognos.xqemfw4j.MFWMetadata;
import com.cognos.xqemfw4j.MFWMetadataConnection;
import com.cognos.xqemfw4j.MFWMultiRequestHandle;
import com.cognos.xqemfw4j.MFWVirtualDimension;

class MFWVariable
extends MFWMetadata
implements IVariable {
    private static final String QUOTE_CLOSEBRACKET = "']";
    private static final String EQUAL_QUOTE = "='";
    private static final String OPENBRACKET = "[";
    private static final String CLOSEBRACKET_PERIOD = "].";
    private static final BeanPropertySupport BEAN_PROPERTY_SUPPORT = new BeanPropertySupport(MFWVariable.class);
    static final String SEPARATOR = ":";
    static final String EOL = "\n";
    private static final String QUERY_DEFAULTHIGH = "/property[name='defaultHigh']/__Value";
    private static final String QUERY_DEFAULTLOW = "/property[name='defaultLow']/__Value";
    private static final String QUERY_ENTRYTYPE = "/property[name='entryType']/__Value";
    private static final String QUERY_HIERARCHY = "/property[name='hierarchy']/__Value";
    private static final String QUERY_LOWCAPTION = "/property[name='lowCaption']/__Value";
    private static final String QUERY_HIGHCAPTION = "/property[name='highCaption']/__Value";
    private static final String QUERY_ISKEYDATE = "/property[name='isKeyDate']/__Value";
    private static final String QUERY_FIXEDVALUE = "/property[name='fixedValue']/__Value";
    private static final String QUERY_SELECTIONTYPE = "/property[name='selectionType']/__Value";
    private static final String QUERY_PROMPTTYPE = "/property[name='promptType']/__Value";
    private static final String QUERY_SHOWKEYANDCAPTION = "/property[name='showKeyAndCaption']/__Value";
    private static final String QUERY_DIMENSION = "/property[name='dimension']/__Value";
    private static final String QUERY_DATATYPE = "/property[name='dataType']/__Value";
    private static final String QUERY_TYPE = "/property[name='type']/__Value";
    private static final String QUERY_UNIQUENAME = "/property[name='name']/__Value";
    protected String name = null;
    protected String caption = null;
    protected String uniqueName = null;
    protected String disambiguatedUniqueName = null;
    protected boolean fullyQualifiedVariableUniqueNameExists = false;
    final MFWDataSource mfwDatasource = (MFWDataSource)this.getConnection().mfwObjectToMetadataObject(this.getHandle().getParent().getParent());
    protected VariableTypeEnum type = null;
    protected IDataType datatype = null;
    protected VariableSelectionTypeEnum selectionType = null;
    protected VariablePromptTypeEnum promptType = null;
    protected Boolean showKeyAndCaption = null;
    protected VariableEntryTypeEnum entryType = null;
    protected IDimension dimension = null;
    protected String dimensionUniqueName = null;
    protected IHierarchy hierarchy = null;
    protected String hierarchyUniqueName = null;
    protected IValue defaultLow = null;
    protected String lowCaption = null;
    protected IValue defaultHigh = null;
    protected String highCaption = null;
    protected Boolean isFixedValue = null;
    protected Boolean isKeyDate = null;
    private String id = null;

    MFWVariable(MFWMetadataConnection mfwConnection, MFWMultiRequestHandle[] mfwHandle) {
        super(mfwConnection, mfwHandle);
    }

    private MFWDataSource getDatasource() {
        return this.mfwDatasource;
    }

    @Override
    public String getDisambiguatedUniqueName(ICube[] cubes, ICube variableCube) {
        if (this.disambiguatedUniqueName == null) {
            int variableNameCount = 0;
            int cubeNameCount = 0;
            String varDisambiguatedUniqueName = this.getUniqueName();
            for (ICube cube : cubes) {
                for (IVariable variable : cube.getVariables()) {
                    if (!variable.getUniqueName().equals(varDisambiguatedUniqueName)) continue;
                    ++variableNameCount;
                    if (cube.getName() != variableCube.getName()) continue;
                    ++cubeNameCount;
                }
            }
            if (variableNameCount > 1) {
                this.fullyQualifiedVariableUniqueNameExists = true;
                varDisambiguatedUniqueName = variableCube.getName() + "." + varDisambiguatedUniqueName;
                if (cubeNameCount > 1) {
                    varDisambiguatedUniqueName = OPENBRACKET + variableCube.getModelDataSource().getName() + CLOSEBRACKET_PERIOD + varDisambiguatedUniqueName;
                }
            }
            this.disambiguatedUniqueName = varDisambiguatedUniqueName;
        }
        return this.disambiguatedUniqueName;
    }

    @Override
    public IValue getDefaultHigh() {
        String defaultHighString;
        if (this.defaultHigh == null && this.getHandle() != null && (defaultHighString = this.queryValue(QUERY_DEFAULTHIGH)) != null) {
            StringValue value = DataValueFactory.createStringValue();
            value.set(defaultHighString);
            this.defaultHigh = value;
        }
        return this.defaultHigh;
    }

    @Override
    public IValue getDefaultLow() {
        String defaultLowString;
        if (this.defaultLow == null && this.getHandle() != null && (defaultLowString = this.queryValue(QUERY_DEFAULTLOW)) != null) {
            StringValue value = DataValueFactory.createStringValue();
            value.set(defaultLowString);
            this.defaultLow = value;
        }
        return this.defaultLow;
    }

    @Override
    public VariableEntryTypeEnum getEntryType() {
        if (this.entryType == null && this.getHandle() != null) {
            this.entryType = VariableEntryTypeEnum.get(this.queryValue(QUERY_ENTRYTYPE));
        }
        return this.entryType;
    }

    @Override
    public IHierarchy getHierarchy() {
        if (this.hierarchy == null && this.getHierarchyUniqueName() != null && this.getHandle() != null) {
            this.dimension = this.getDimension();
            if (this.dimension != null) {
                this.hierarchy = this.dimension.getHierarchy(this.getHierarchyUniqueName());
            }
        }
        return this.hierarchy;
    }

    @Override
    public String getHierarchyUniqueName() {
        if (this.hierarchyUniqueName == null && this.getHandle() != null) {
            this.hierarchyUniqueName = this.queryValue(QUERY_HIERARCHY);
        }
        return this.hierarchyUniqueName;
    }

    @Override
    public String getHighCaption() {
        if (this.highCaption == null && this.getHandle() != null) {
            this.highCaption = this.queryValue(QUERY_HIGHCAPTION);
        }
        return this.highCaption;
    }

    @Override
    public String getLowCaption() {
        if (this.lowCaption == null && this.getHandle() != null) {
            this.lowCaption = this.queryValue(QUERY_LOWCAPTION);
        }
        return this.lowCaption;
    }

    @Override
    public boolean isFixedValue() {
        if (this.isFixedValue == null && this.getHandle() != null) {
            this.isFixedValue = Boolean.valueOf(this.queryValue(QUERY_FIXEDVALUE));
        }
        return this.isFixedValue;
    }

    @Override
    public boolean isKeyDate() {
        if (this.isKeyDate == null && this.getHandle() != null) {
            this.isKeyDate = Boolean.valueOf(this.queryValue(QUERY_ISKEYDATE));
        }
        return this.isKeyDate;
    }

    @Override
    public VariableSelectionTypeEnum getSelectionType() {
        if (this.selectionType == null && this.getHandle() != null) {
            this.selectionType = VariableSelectionTypeEnum.get(this.queryValue(QUERY_SELECTIONTYPE));
        }
        return this.selectionType;
    }

    @Override
    public VariablePromptTypeEnum getPromptType() {
        if (this.promptType == null && this.getHandle() != null) {
            this.promptType = VariablePromptTypeEnum.get(this.queryValue(QUERY_PROMPTTYPE));
        }
        return this.promptType;
    }

    @Override
    public boolean showKeyAndCaption() {
        if (this.showKeyAndCaption == null && this.getHandle() != null) {
            this.showKeyAndCaption = Boolean.valueOf(this.queryValue(QUERY_SHOWKEYANDCAPTION));
        }
        return this.showKeyAndCaption;
    }

    @Override
    public VariableTypeEnum getType() {
        if (this.type == null && this.getHandle() != null) {
            this.type = VariableTypeEnum.get(this.queryValue(QUERY_TYPE));
        }
        return this.type;
    }

    @Override
    public IDimension getDimension() {
        if (this.dimension == null && this.getHandle() != null) {
            this.dimension = this.getCube().getDimension(this.getDimensionUniqueName());
        }
        return this.dimension;
    }

    @Override
    public String getDimensionUniqueName() {
        if (this.dimensionUniqueName == null && this.getHandle() != null) {
            this.dimensionUniqueName = this.queryValue(QUERY_DIMENSION);
        }
        return this.dimensionUniqueName;
    }

    public ICube getCube() {
        return this.getDatasource().getCube();
    }

    @Override
    public String getName() {
        if (this.name == null && this.getHandle() != null) {
            this.name = this.queryValue(MFWModelRes.getInstance().RID_name, new short[0]);
        }
        return this.name;
    }

    @Override
    public String getCaption() {
        if (this.caption == null && this.getHandle() != null) {
            String locale = this.getConnection().getContentLocaleString();
            this.caption = this.queryValue("/property[name='caption']/property[name='" + locale + "']/__Value");
        }
        return this.caption;
    }

    @Override
    public String toString() {
        StringBuilder toString = new StringBuilder();
        toString.append("VARIABLE:").append(this.getName()).append(EOL);
        toString.append("name").append(SEPARATOR).append(this.getUniqueName()).append(EOL);
        toString.append("type").append(SEPARATOR).append((Object)this.getType()).append(EOL);
        toString.append("datatype").append(SEPARATOR).append(this.getDataType()).append(EOL);
        if (this.getDefaultHigh() != null) {
            toString.append("defaultHigh").append(SEPARATOR).append(this.getDefaultHigh()).append(EOL);
        }
        if (this.getDefaultLow() != null) {
            toString.append("defaultLow").append(SEPARATOR).append(this.getDefaultLow()).append(EOL);
        }
        toString.append("dimension").append(SEPARATOR).append(this.getDimension().getV5UniqueName()).append(EOL);
        toString.append("hierarchy").append(SEPARATOR).append(this.getHierarchy().getV5UniqueName()).append(EOL);
        toString.append("entryType").append(SEPARATOR).append((Object)this.getEntryType()).append(EOL);
        if (this.getHighCaption() != null) {
            toString.append("highCaption").append(SEPARATOR).append(this.getHighCaption()).append(EOL);
        }
        if (this.getLowCaption() != null) {
            toString.append("lowCaption").append(SEPARATOR).append(this.getLowCaption()).append(EOL);
        }
        toString.append("fixedValue").append(SEPARATOR).append(this.isFixedValue()).append(EOL);
        toString.append("isKeyDate").append(SEPARATOR).append(this.isKeyDate()).append(EOL);
        return toString.toString();
    }

    @Override
    public String getUniqueName() {
        if (this.uniqueName == null && this.getHandle() != null) {
            this.uniqueName = this.queryValue(QUERY_UNIQUENAME);
        }
        return this.uniqueName;
    }

    @Override
    public MetadataType getObjectType() {
        return MetadataType.VARIABLE;
    }

    @Override
    public BeanPropertySupport getBeanPropertySupport() {
        return BEAN_PROPERTY_SUPPORT;
    }

    @Override
    public IDataType getDataType() {
        if (this.datatype == null && this.getHandle() != null) {
            String nodeValue = this.queryValue(QUERY_DATATYPE);
            DataType varDataType = null;
            if (nodeValue == null) {
                varDataType = DataTypeFactory.getStringType();
            } else if (nodeValue.equals("xsdDate")) {
                varDataType = this.getType() == VariableTypeEnum.MEMBER && this.getPromptType() == VariablePromptTypeEnum.TYPEIN ? DataTypeFactory.getMemberUniqueNameType() : DataTypeFactory.getDateType();
            } else if (nodeValue.equals("xsdDatetime")) {
                varDataType = DataTypeFactory.getTimestampType();
            } else if (nodeValue.equals("xsdInt")) {
                varDataType = DataTypeFactory.getIntegerType();
            } else if (nodeValue.equals("xsdFloat")) {
                varDataType = DataTypeFactory.getFloatType();
            } else if (nodeValue.equals("xsdLong")) {
                varDataType = DataTypeFactory.getLongType();
            } else if (nodeValue.equals("memberUniqueName")) {
                IDimension dim = this.getDimension();
                varDataType = DataSourceTypeEnum.isSAPBW(this.mfwDatasource.getInterface()) && (dim == null || dim instanceof MFWVirtualDimension) && this.getType().equals((Object)VariableTypeEnum.LEAF_MEMBER) ? DataTypeFactory.getStringType() : DataTypeFactory.getMemberUniqueNameType();
            } else {
                varDataType = nodeValue.equals("hierarchyUniqueName") ? DataTypeFactory.getDimensionUniqueNameType() : DataTypeFactory.getStringType();
            }
            this.datatype = varDataType;
        }
        return this.datatype;
    }

    @Override
    public String getID() {
        if (this.id == null) {
            this.id = this.queryValue(MFWModelRes.getInstance().RID_ID, new short[0]);
        }
        return this.id;
    }

    @Override
    public boolean getFullyQualifiedVariableUniqueNameExists() {
        return this.fullyQualifiedVariableUniqueNameExists;
    }
}

