/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqemfw4j;

import com.cognos.xqe.data.model.IDataSource;
import com.cognos.xqe.data.providers.ProviderManager;
import com.cognos.xqe.data.providers.olap.IOLAPDataProvider;
import com.cognos.xqe.data.providers.olap.IOLAPMetadataProvider;
import com.cognos.xqe.data.providers.olap.MetadataQueryArguments;
import com.cognos.xqe.data.providers.olap.MetadataRestriction;
import com.cognos.xqe.data.providers.olap.RestrictionType;
import com.cognos.xqe.metadata.ICube;
import com.cognos.xqe.metadata.ILevel;
import com.cognos.xqe.metadata.IMember;
import com.cognos.xqe.metadata.IModelDataSource;
import com.cognos.xqe.metadata.record.HierarchyRecord;
import com.cognos.xqe.metadata.record.LevelRecord;
import com.cognos.xqe.metadata.record.MemberRecord;
import com.cognos.xqe.query.engine.ExecutionEnvironment;
import com.cognos.xqe.util.context.ExecutionEnvironmentContext;
import com.cognos.xqemfw4j.MFWDimension;
import com.cognos.xqemfw4j.MFWHierarchy;
import com.cognos.xqemfw4j.MFWLevel;
import com.cognos.xqemfw4j.MFWMember;
import com.cognos.xqemfw4j.MFWVirtualLevel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

class MFWVirtualDefaultHierarchy
extends MFWHierarchy {
    private String validFrom = null;
    private String validTo = null;

    MFWVirtualDefaultHierarchy(MFWDimension mfwDimension, HierarchyRecord hierarchyRecord) {
        super(mfwDimension.getConnection(), null);
        this.uniqueName = hierarchyRecord.getUniqueName();
        this.name = hierarchyRecord.getName();
        this.uniqueID = hierarchyRecord.getUniqueId();
        this.dimension = mfwDimension;
        this.cardinality = new Integer(hierarchyRecord.getCardinality());
        this.balanced = new Boolean(hierarchyRecord.isBalanced());
        this.ragged = new Boolean(hierarchyRecord.isRagged());
        this.parentChild = new Boolean(false);
        this.validFrom = hierarchyRecord.getValidFrom();
        this.validTo = hierarchyRecord.getValidTo();
    }

    @Override
    public String getID() {
        return ((MFWDimension)this.getDimension()).getID() + "/" + this.getName();
    }

    @Override
    public List<ILevel> getLevels() {
        if (this.levels == null) {
            this.queryLevels();
        }
        return this.levels;
    }

    private void queryLevels() {
        List<ILevel> queryLevels;
        List<LevelRecord> levelRecords = this.queryLevelRecords();
        if (levelRecords == null) {
            queryLevels = Collections.emptyList();
        } else {
            queryLevels = new ArrayList<ILevel>(levelRecords.size());
            for (LevelRecord levelRecord : levelRecords) {
                MFWVirtualLevel level = new MFWVirtualLevel(this, levelRecord);
                queryLevels.add(level);
            }
            queryLevels = Collections.unmodifiableList(queryLevels);
        }
        this.setLevels(queryLevels);
    }

    private synchronized void setLevels(List<ILevel> queryLevels) {
        if (this.levels == null) {
            this.levels = queryLevels;
        }
    }

    @Override
    public String getValidFrom() {
        return this.validFrom;
    }

    @Override
    public String getValidTo() {
        return this.validTo;
    }

    @Override
    public IMember getRootMember() {
        if (this.rootMember == null) {
            MFWMember rootMemberOfHierarchy = null;
            List<MemberRecord> rootMemberRecords = this.queryRootMemberRecords();
            if (rootMemberRecords.size() == 1) {
                MemberRecord memberRecord = rootMemberRecords.get(0);
                String memberUniqueName = memberRecord.getUniqueName();
                MFWLevel level = (MFWLevel)this.getLevel(memberRecord.getLevelNumber());
                rootMemberOfHierarchy = new MFWMember(memberUniqueName, level);
                this.rootMember = rootMemberOfHierarchy;
            }
        }
        return this.rootMember;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<MemberRecord> queryRootMemberRecords() {
        ICube cube = this.getDimension().getCube();
        IModelDataSource modelDS = cube.getModelDataSource();
        ExecutionEnvironment executionEnvironment = (ExecutionEnvironment)ExecutionEnvironmentContext.getExecutionEnvironment();
        IDataSource ds = executionEnvironment.getOrAddDataSource(modelDS);
        IOLAPDataProvider dataProvider = ProviderManager.getInstance().getOLAPProvider(ds.getType());
        MetadataQueryArguments mdQueryArgs = MetadataQueryArguments.buildArguments(ds, executionEnvironment, modelDS.getConnection().getExpressionLocale());
        IOLAPMetadataProvider metadataProvider = dataProvider.getMetadataProvider(mdQueryArgs);
        MetadataRestriction restrictions = new MetadataRestriction();
        if (modelDS.getCatalog() != null) {
            restrictions.add(RestrictionType.CATALOG, modelDS.getCatalog().getUniqueName());
        }
        restrictions.add(RestrictionType.CUBE, cube.getUniqueName());
        restrictions.add(RestrictionType.DIMENSION_UNIQUE_NAME, this.getDimension().getUniqueName());
        restrictions.add(RestrictionType.HIERARCHY_UNIQUE_NAME, this.getUniqueName());
        List<MemberRecord> records = null;
        try {
            records = metadataProvider.getHierarchyRootMembers(restrictions);
        }
        finally {
            metadataProvider.release();
        }
        return records;
    }

    @Override
    public IMember getDefaultMember() {
        if (this.defaultMember == null) {
            HierarchyRecord hierarchyRecord = this.queryHierarchyRecord();
            String defaultMUN = hierarchyRecord.getDefaultMemberUniqueName();
            MemberRecord memberRecord = this.queryMemberRecord(defaultMUN);
            MFWLevel level = (MFWLevel)this.getLevel(memberRecord.getLevelNumber());
            MFWMember defaultMemberOfHierarchy = new MFWMember(defaultMUN, level);
            this.defaultMember = defaultMemberOfHierarchy;
        }
        return this.defaultMember;
    }

    @Override
    public boolean isMultiRoot() {
        if (this.multiRoot == null) {
            boolean hasMultiRoot = this.queryRootMemberRecords().size() > 1;
            this.multiRoot = new Boolean(hasMultiRoot);
        }
        return this.multiRoot;
    }
}

