/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqemoser;

import com.cognos.xqe.ast.macro.MacroExpander;
import com.cognos.xqe.data.types.IDataType;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.metadata.IAlias;
import com.cognos.xqe.metadata.ICatalog;
import com.cognos.xqe.metadata.ICube;
import com.cognos.xqe.metadata.IMetadata;
import com.cognos.xqe.metadata.IModelDataSource;
import com.cognos.xqe.metadata.IMultiRequestHandle;
import com.cognos.xqe.metadata.IVariable;
import com.cognos.xqe.metadata.MetadataType;
import com.cognos.xqe.metadata.provider.MetadataConnection;
import com.cognos.xqe.query.engine.IPlanningEnvironment;
import com.cognos.xqe.util.bean.BeanPropertySupport;
import com.cognos.xqemoser.MoserBaseMetadata;
import com.cognos.xqemoser.MoserCatalog;
import com.cognos.xqemoser.MoserPhysicalTable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

public class MoserDataSource
extends MoserBaseMetadata
implements IModelDataSource {
    protected String cmDataSource;
    protected String databaseType;
    protected MoserCatalog catalog;
    protected String schema;
    protected Map<String, Object> metadataProperties;
    protected TreeMap<String, MoserPhysicalTable> physicalTables = new TreeMap();
    protected boolean isCM = true;
    protected String parquetFilePath;
    protected XQERuntimeException error = null;

    public MoserDataSource(long id, String n) {
        super(id, n, -1);
        this.objectType = MetadataType.DATASOURCE;
    }

    @Override
    public String getUniqueName() {
        return null;
    }

    @Override
    public Set<String> getAvailableProperties() {
        return null;
    }

    @Override
    public Object getProperty(String propertyName) {
        return null;
    }

    @Override
    public IDataType getDataType() {
        return null;
    }

    @Override
    public MetadataConnection getConnection() {
        return null;
    }

    @Override
    public IMetadata getParentObject() {
        return null;
    }

    @Override
    public List<IMetadata> getDescendantMetadataObjectsSkipFolders() {
        return null;
    }

    @Override
    public List<IMetadata> getChildMetadataObjects() {
        return null;
    }

    @Override
    public String getV5UniqueName() {
        return null;
    }

    @Override
    public String getID() {
        return null;
    }

    @Override
    public boolean hasChildMetadataObjects() {
        return false;
    }

    @Override
    public String getDescription() {
        return null;
    }

    @Override
    public String getUniqueID() {
        return null;
    }

    @Override
    public BeanPropertySupport getBeanPropertySupport() {
        return null;
    }

    @Override
    public boolean isDMR() {
        return false;
    }

    @Override
    public boolean isMFW() {
        return false;
    }

    @Override
    public IMetadata getParentObjectSkipFolders() {
        return null;
    }

    @Override
    public boolean isAccessible() {
        return false;
    }

    @Override
    public void setParentMetadataObject(IMetadata parent) {
    }

    @Override
    public IMultiRequestHandle[] getHandles() {
        return null;
    }

    @Override
    public int compareTo(Object o) {
        return this.doCompareTo(o);
    }

    @Override
    public List<ICube> getCubes() {
        return null;
    }

    @Override
    public ICube getCube() {
        return null;
    }

    @Override
    public ICatalog getCatalog() {
        return this.catalog;
    }

    public void setCatalog(MoserCatalog c) {
        this.catalog = c;
    }

    @Override
    public String getInterface() {
        if (this.databaseType != null) {
            return this.databaseType;
        }
        return "JDBC";
    }

    public void setInterface(String dbType) {
        this.databaseType = dbType;
    }

    @Override
    public String getCMDataSourceName() {
        return this.cmDataSource;
    }

    @Override
    public void setCMDataSource(String dataSourceVal) {
        this.cmDataSource = dataSourceVal;
    }

    @Override
    public String getQueryType() {
        return null;
    }

    @Override
    public String getSchema() {
        return this.schema;
    }

    public void setSchema(String s) {
        this.schema = s;
    }

    @Override
    public IAlias getAlias() {
        return null;
    }

    @Override
    public Map<String, Object> getMetadataProperties() {
        this.throwIfError();
        return this.metadataProperties;
    }

    public void setMetadataProperties(Map<String, Object> p) {
        if (p != null && !p.isEmpty()) {
            HashMap<String, Object> pCopy = new HashMap<String, Object>(p);
            this.metadataProperties = Collections.unmodifiableMap(pCopy);
        }
    }

    @Override
    public boolean isMultidimensional() {
        return false;
    }

    @Override
    public boolean isRelational() {
        return true;
    }

    @Override
    public boolean isDummy() {
        return false;
    }

    @Override
    public boolean isROLAP() {
        return false;
    }

    @Override
    public List<IVariable> getVariables() {
        return null;
    }

    @Override
    public boolean isContentManager() {
        return this.isCM;
    }

    protected void setIsContentManager(boolean b) {
        this.isCM = b;
    }

    public void addTable(String n, MoserPhysicalTable tb) {
        this.physicalTables.put(n, tb);
    }

    public boolean matchCMNameCatalogSchema(String ds, String cat, String s, IPlanningEnvironment planEnv) {
        if (!this.cmDataSource.equals(ds)) {
            return false;
        }
        boolean b = this.checkCatalog(cat, planEnv);
        if (!b) {
            return false;
        }
        return this.checkSchema(s, planEnv);
    }

    private boolean checkSchema(String s, IPlanningEnvironment planEnv) {
        if (this.schema != null && s != null) {
            String sName = this.schema;
            if (planEnv != null && MacroExpander.isMacro(sName)) {
                MacroExpander expander = new MacroExpander();
                sName = expander.expand(null, planEnv, sName);
            }
            return s.equals(sName);
        }
        return this.schema == null && s == null;
    }

    private boolean checkCatalog(String cat, IPlanningEnvironment planEnv) {
        if (this.catalog != null && cat != null) {
            String catName = this.catalog.getName();
            if (planEnv != null && MacroExpander.isMacro(catName)) {
                MacroExpander expander = new MacroExpander();
                catName = expander.expand(null, planEnv, catName);
            }
            return cat.equals(catName);
        }
        return this.catalog == null && cat == null;
    }

    public IMetadata getTableByName(String n) {
        return this.physicalTables.get(n);
    }

    public List<MoserPhysicalTable> getTables() {
        return new ArrayList<MoserPhysicalTable>(this.physicalTables.values());
    }

    protected void throwIfError() {
        if (this.error != null) {
            throw this.error;
        }
    }
}

