/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqemoser;

import com.cognos.xqe.metadata.IEmbeddedFilter;
import com.cognos.xqe.metadata.IFacet;
import com.cognos.xqe.metadata.IMetadata;
import com.cognos.xqe.metadata.NoMetadataReuseContext;
import com.cognos.xqe.metadata.provider.MetadataService;
import com.cognos.xqe.query.engine.IExecutionEnvironment;
import com.cognos.xqe.util.Pair;
import com.cognos.xqemoser.MoserCalculation;
import com.cognos.xqemoser.MoserEmbeddedFilter;
import com.cognos.xqemoser.MoserEnv;
import com.cognos.xqemoser.MoserFilter;
import com.cognos.xqemoser.MoserMetadataConnection;
import com.cognos.xqemoser.MoserModule;
import com.cognos.xqemoser.MoserModuleUtil;
import com.cognos.xqemoser.MoserQueryItem;
import com.cognos.xqemoser.MoserQuerySubject;
import com.ibm.json.java.JSONObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public final class MoserEmbeddedModuleWrapper
extends MoserModule {
    private static final String SOURCE_MODULE_EMBEDDED_MODULE = "source module of embedded module";
    private static final Set<String> EMBEDDED_MODULE_SOURCE = new HashSet<String>();
    protected MoserModule embeddedModule;
    protected MoserMetadataConnection srcMetadataConnection;
    protected HashMap<MoserQuerySubject, Pair> extraQueryItemsEmbeddedFilters = new HashMap();
    protected HashMap<MoserQueryItem, MoserQueryItem> queryItemsOverride = new HashMap();
    protected HashMap<String, Integer> srcQuerySubjectPos = new HashMap();

    public MoserEmbeddedModuleWrapper(MoserMetadataConnection mdConn) {
        super(mdConn);
    }

    public MoserMetadataConnection getSourceMetadataConnection() {
        return this.srcMetadataConnection;
    }

    public void detachSourceMetadataConnection(IExecutionEnvironment execEnv) {
        this.srcMetadataConnection.module.clearRefWrappedMetadataConnection(execEnv, this.srcMetadataConnection.theConnectionPassport, this.srcMetadataConnection.cookies);
    }

    public void attachSourceMetadataConnection(MoserMetadataConnection mc, IExecutionEnvironment execEnv) {
        this.srcMetadataConnection.module.setRefWrappedMetadataConnection(mc, execEnv, this.srcMetadataConnection.theConnectionPassport, this.srcMetadataConnection.cookies);
    }

    protected void attachSourceMetadataConnectionIfRequired(MoserMetadataConnection mc, IExecutionEnvironment execEnv) {
        if (this.srcMetadataConnection.module.refWrappedMetadataConnection.get() == null) {
            this.attachSourceMetadataConnection(mc, execEnv);
        }
    }

    public static boolean isSourceModule(Set<String> objNames) {
        return objNames != null && objNames.contains(SOURCE_MODULE_EMBEDDED_MODULE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MoserEmbeddedModuleWrapper createEmbeddedModuleWrapper(MoserMetadataConnection mc, IExecutionEnvironment execEnv) {
        String srcModuleId = MoserEmbeddedModuleWrapper.getSourceModuleIdForUnResolvedEmbeddedModule(mc.module);
        if (srcModuleId == null) {
            return null;
        }
        boolean bExit = false;
        MoserMetadataConnection srcMC = null;
        try {
            if (!NoMetadataReuseContext.canReuse()) {
                bExit = true;
                NoMetadataReuseContext.exit();
            }
            srcMC = (MoserMetadataConnection)MetadataService.getInstance().getConnectionForObjects("MOSER", srcModuleId, execEnv, true, EMBEDDED_MODULE_SOURCE);
        }
        finally {
            if (bExit) {
                NoMetadataReuseContext.enter();
            }
        }
        if (srcMC == null || !srcMC.isConnected()) {
            return null;
        }
        MoserEmbeddedModuleWrapper wrapper = new MoserEmbeddedModuleWrapper(mc);
        wrapper.embeddedModule = mc.module;
        wrapper.srcMetadataConnection = srcMC;
        wrapper.prepareOverride(srcMC.module);
        wrapper.attachSourceMetadataConnection(mc, execEnv);
        return wrapper;
    }

    protected static String getSourceModuleIdForUnResolvedEmbeddedModule(MoserModule module) {
        if (module == null) {
            return null;
        }
        Object o = module.properties.get("_XQE_embedded_Module");
        if (!Boolean.TRUE.equals(o) && !"true".equals(o)) {
            return null;
        }
        List<JSONObject> useSpec = module.mUseSpecs;
        if (useSpec == null || useSpec.size() != 1) {
            return null;
        }
        JSONObject jObj = useSpec.get(0);
        if (!"ES".equals(jObj.get((Object)"identifier"))) {
            return null;
        }
        if (!"*".equals(jObj.get((Object)"imports"))) {
            return null;
        }
        String tp = (String)jObj.get((Object)"type");
        if (!("database".equals(tp) || "file".equals(tp) || "module".equals(tp) || "dataset".equals(tp))) {
            return null;
        }
        return (String)jObj.get((Object)"storeID");
    }

    protected void prepareOverride(MoserModule srcModule) {
        MoserQuerySubject srcQS;
        HashSet<String> allQSOverride = new HashSet<String>();
        for (MoserQuerySubject q : this.embeddedModule.querySubjects) {
            allQSOverride.add(q.getName());
        }
        if (allQSOverride.isEmpty()) {
            return;
        }
        HashMap<String, Pair> mapSrcQSs = new HashMap<String, Pair>();
        int pos = 0;
        for (MoserQuerySubject srcQS2 : srcModule.querySubjects) {
            String qID = srcQS2.getName();
            ++pos;
            if (!allQSOverride.contains(qID)) continue;
            this.srcQuerySubjectPos.put(qID, pos);
            HashMap<String, MoserQueryItem> mapSrcQIs = new HashMap<String, MoserQueryItem>();
            for (MoserQueryItem srcQI : srcQS2.queryItems) {
                mapSrcQIs.put(srcQI.getName(), srcQI);
            }
            mapSrcQSs.put(qID, new Pair(srcQS2, mapSrcQIs));
        }
        HashMap<MoserQuerySubject, MoserQuerySubject> mapQSToSrcQS = new HashMap<MoserQuerySubject, MoserQuerySubject>();
        for (MoserQuerySubject qs : this.embeddedModule.querySubjects) {
            Pair srcQSInfo = (Pair)mapSrcQSs.get(qs.getName());
            if (srcQSInfo == null) continue;
            MoserQuerySubject srcQS3 = (MoserQuerySubject)srcQSInfo.getFirst();
            mapQSToSrcQS.put(qs, srcQS3);
            HashMap mapSrcQIs = (HashMap)srcQSInfo.getSecond();
            Pair newObjects = new Pair();
            if (!qs.embeddedFilters.isEmpty()) {
                ArrayList<IEmbeddedFilter> toSrcFilters = new ArrayList<IEmbeddedFilter>(qs.embeddedFilters);
                for (IEmbeddedFilter aFlt : toSrcFilters) {
                    MoserEmbeddedFilter newFlt = (MoserEmbeddedFilter)aFlt;
                    newFlt.parentQS = srcQS3;
                    newFlt.bFromEmbeddedModule = true;
                }
                newObjects.setSecond(toSrcFilters);
            }
            if (!qs.queryItems.isEmpty()) {
                ArrayList<MoserQueryItem> toSrcQueryItems = new ArrayList<MoserQueryItem>();
                for (MoserQueryItem qi : qs.queryItems) {
                    String qiId = qi.getName();
                    MoserQueryItem srcQI = (MoserQueryItem)mapSrcQIs.get(qiId);
                    if (srcQI == null) {
                        toSrcQueryItems.add(qi);
                        qi.bFromEmbeddedModule = true;
                        continue;
                    }
                    this.queryItemsOverride.put(srcQI, qi);
                }
                if (!toSrcQueryItems.isEmpty()) {
                    for (MoserQueryItem theQI : toSrcQueryItems) {
                        theQI.parentQS = srcQS3;
                    }
                    newObjects.setFirst(toSrcQueryItems);
                }
            }
            if (newObjects.getFirst() == null && newObjects.getSecond() == null) continue;
            this.extraQueryItemsEmbeddedFilters.put(srcQS3, newObjects);
            this.querySubjects.add(srcQS3);
        }
        for (MoserCalculation calc : this.embeddedModule.calculations) {
            srcQS = (MoserQuerySubject)mapQSToSrcQS.get(calc.getParentObject());
            if (srcQS == null) continue;
            calc.setParent(srcQS);
        }
        for (MoserFilter flt : this.embeddedModule.filters) {
            srcQS = (MoserQuerySubject)mapQSToSrcQS.get(flt.getParentObject());
            if (srcQS == null) continue;
            flt.setParent(srcQS);
        }
    }

    protected void appendEmbeddedFilter(MoserQuerySubject qs, List<IEmbeddedFilter> rt) {
        Pair p = this.extraQueryItemsEmbeddedFilters.get(qs);
        if (p == null || p.getSecond() == null) {
            return;
        }
        rt.addAll((List)p.getSecond());
    }

    protected void appendQueryItem(MoserQuerySubject qs, List<IMetadata> rt) {
        Pair p = this.extraQueryItemsEmbeddedFilters.get(qs);
        if (p == null || p.getFirst() == null) {
            return;
        }
        rt.addAll((List)p.getFirst());
    }

    @Override
    public String getIdentifier() {
        return this.embeddedModule.getIdentifier();
    }

    @Override
    public String getCacheKey() {
        return this.embeddedModule.getCacheKey();
    }

    @Override
    public Locale getExpressionLocale() {
        return this.embeddedModule.getExpressionLocale();
    }

    @Override
    public IMetadata getExpressionObjectByUName(String uName, String userPassport, Map<String, String> cookiesToMoser, boolean bTryShortName, MoserEnv env) {
        return this.embeddedModule.getExpressionObjectByUName(uName, userPassport, cookiesToMoser, bTryShortName, env);
    }

    @Override
    public List<MoserCalculation> getCalculations() {
        return this.embeddedModule.getCalculations();
    }

    @Override
    public List<MoserFilter> getFilters() {
        return this.embeddedModule.getFilters();
    }

    protected String getPropertyOverride(String defaultV, MoserQueryItem qi, String propName) {
        MoserQueryItem qiOverride = this.queryItemsOverride.get(qi);
        if (qiOverride == null) {
            return defaultV;
        }
        String overrideV = null;
        switch (propName) {
            case "regularAggregate": {
                overrideV = qiOverride.regularAggrType;
                break;
            }
            case "format": {
                overrideV = qiOverride.format;
                break;
            }
            case "usage": {
                overrideV = qiOverride.usage;
                break;
            }
        }
        if (overrideV != null && !overrideV.equals(defaultV)) {
            return overrideV;
        }
        return defaultV;
    }

    protected IFacet getFacetOverride(IFacet defaultFacet, MoserQueryItem qi) {
        MoserQueryItem qiOverride = this.queryItemsOverride.get(qi);
        if (qiOverride == null || qiOverride.facetDefinition == null) {
            return defaultFacet;
        }
        if (qiOverride.facet == null) {
            String usage = qiOverride.usage;
            if (usage == null) {
                usage = qi.usage;
            }
            MoserModuleUtil.resolveFacet(usage, qi.datatype, qiOverride, qiOverride.facetDefinition, null, null, null);
        }
        return qiOverride.facet;
    }

    public int getQuerySubjectPosition(MoserQuerySubject qs, int qsPos) {
        Integer pos = this.srcQuerySubjectPos.get(qs.getName());
        if (pos != null) {
            return pos;
        }
        return qsPos;
    }

    static {
        EMBEDDED_MODULE_SOURCE.add(SOURCE_MODULE_EMBEDDED_MODULE);
    }
}

