/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqemoser;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.v5Exp.V5BoundModelIdentifier;
import com.cognos.xqe.metadata.IMetadata;
import com.cognos.xqe.metadata.IQuerySubject;
import com.cognos.xqe.metadata.IRelationship;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.transformation.v5tocogsql.util.RQPUtilities;
import com.cognos.xqe.util.Pair;
import com.cognos.xqemoser.MoserItemNormalizationGroup;
import com.cognos.xqemoser.MoserModule;
import com.cognos.xqemoser.MoserQueryItem;
import com.cognos.xqemoser.MoserQuerySubject;
import com.cognos.xqemoser.MoserQuerySubjectWrapper;
import com.cognos.xqemoser.MoserRelationshipWrapper;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.collections.CollectionUtils;

public class MoserItemNormalization {
    public static final String JOIN_NAME_SEP = "_to_";
    private List<List<MoserQueryItem>> uniKeys = new ArrayList<List<MoserQueryItem>>();
    private ArrayList<MoserItemNormalizationGroup> itemGroups = new ArrayList();
    protected HashMap<IRelationship, IRelationship> relToDummyJoin = new HashMap();
    protected HashMap<Set<IMetadata>, MoserQuerySubjectWrapper> joinedQIsToDummyQS = new HashMap();
    protected List<Set<MoserItemNormalizationGroup>> uniqueGroups = new ArrayList<Set<MoserItemNormalizationGroup>>();
    protected HashMap<Set<String>, IRelationship> internalJoins = new HashMap();
    protected HashSet<IMetadata> queryItemsNotInGroups = new HashSet();
    protected Boolean isGeneratedForPrimaryKey = null;

    public MoserItemNormalization(List<MoserItemNormalizationGroup> groups, List<IMetadata> allQIs) {
        this.itemGroups.addAll(groups);
        HashSet<MoserQueryItem> queryItemsInGrps = new HashSet<MoserQueryItem>();
        for (MoserItemNormalizationGroup g : groups) {
            boolean bPK = false;
            String grpName = g.getName();
            if (grpName != null) {
                bPK = grpName.startsWith("grp_4_PK_");
            }
            if (this.isGeneratedForPrimaryKey == null) {
                this.isGeneratedForPrimaryKey = bPK;
            } else if (Boolean.TRUE.equals(this.isGeneratedForPrimaryKey) && !bPK) {
                this.isGeneratedForPrimaryKey = Boolean.FALSE;
            }
            queryItemsInGrps.addAll(g.itemRef);
            if (!g.isUniqueKey() || g.keyRef == null) continue;
            ArrayList<List<MoserItemNormalizationGroup>> allPaths = new ArrayList<List<MoserItemNormalizationGroup>>();
            LinkedList<MoserItemNormalizationGroup> stack = new LinkedList<MoserItemNormalizationGroup>();
            MoserItemNormalization.generatePaths(g, stack, allPaths, true);
            for (List<MoserItemNormalizationGroup> path : allPaths) {
                this.uniqueGroups.add(new HashSet<MoserItemNormalizationGroup>(path));
                ArrayList<MoserQueryItem> aPK = new ArrayList<MoserQueryItem>();
                for (MoserItemNormalizationGroup k : path) {
                    aPK.add(k.keyRef);
                }
                Collections.reverse(aPK);
                this.uniKeys.add(aPK);
            }
        }
        if (allQIs.size() > queryItemsInGrps.size()) {
            allQIs.removeAll(queryItemsInGrps);
            this.queryItemsNotInGroups.addAll(allQIs);
        }
    }

    public boolean isGeneratedFromPrimaryKey() {
        return Boolean.TRUE.equals(this.isGeneratedForPrimaryKey);
    }

    public List<MoserItemNormalizationGroup> getMoserItemNormalizationGroups() {
        return new ArrayList<MoserItemNormalizationGroup>(this.itemGroups);
    }

    public Boolean hasDenormalizedValues(MoserQueryItem qi) {
        boolean bIsPartial = false;
        for (List<MoserQueryItem> keys : this.uniKeys) {
            if (!keys.contains(qi)) continue;
            if (keys.size() == 1) {
                return Boolean.FALSE;
            }
            bIsPartial = true;
        }
        if (bIsPartial) {
            return Boolean.TRUE;
        }
        MoserItemNormalizationGroup grp = null;
        for (MoserItemNormalizationGroup group : this.itemGroups) {
            if (!group.containsQueryItem(qi)) continue;
            grp = group;
            break;
        }
        if (grp == null) {
            return null;
        }
        return !grp.isUniqueKey();
    }

    protected boolean isUniqueGroupSet(Set<MoserItemNormalizationGroup> grps) {
        for (Set<MoserItemNormalizationGroup> s : this.uniqueGroups) {
            if (!s.equals(grps)) continue;
            return true;
        }
        return false;
    }

    public List<List<MoserQueryItem>> getUniqueKeys() {
        return this.uniKeys;
    }

    public Set<IMetadata> getKeys(MoserQueryItem qi, Set<IMetadata> prefer) {
        for (MoserItemNormalizationGroup group : this.itemGroups) {
            if (!group.containsQueryItem(qi)) continue;
            return this.getKeysGroup(group, qi, prefer);
        }
        TreeSet<IMetadata> rt = new TreeSet<IMetadata>();
        rt.add(qi);
        return rt;
    }

    protected Set<IMetadata> getKeysGroup(MoserItemNormalizationGroup group, MoserQueryItem qi, Set<IMetadata> prefer) {
        List<MoserItemNormalizationGroup> parents = group.getParentGroups();
        if (group.isMeasureScope()) {
            TreeSet<IMetadata> keys = new TreeSet<IMetadata>();
            for (MoserItemNormalizationGroup grp : parents) {
                this.fillKeys(grp, prefer, keys);
            }
            return keys;
        }
        if (!group.useParent() || parents.isEmpty()) {
            TreeSet<IMetadata> rt = new TreeSet<IMetadata>();
            rt.add(group.getKeyItem());
            return rt;
        }
        TreeSet<IMetadata> keys = new TreeSet<IMetadata>();
        this.fillKeys(group, prefer, keys);
        return keys;
    }

    protected void fillKeys(MoserItemNormalizationGroup grp, Set<IMetadata> prefer, TreeSet<IMetadata> keys) {
        List<MoserItemNormalizationGroup> minGroups = this.getMinParentGroups(grp, prefer);
        for (MoserItemNormalizationGroup pgrp : minGroups) {
            keys.add(pgrp.getKeyItem());
        }
    }

    protected List<MoserItemNormalizationGroup> getMinParentGroups(MoserItemNormalizationGroup grp, Set<IMetadata> prefer) {
        ArrayList<List<MoserItemNormalizationGroup>> allPaths = new ArrayList<List<MoserItemNormalizationGroup>>();
        LinkedList<MoserItemNormalizationGroup> stack = new LinkedList<MoserItemNormalizationGroup>();
        MoserItemNormalization.generatePaths(grp, stack, allPaths, true);
        if (allPaths.size() == 1) {
            return allPaths.get(0);
        }
        int minPos = 0;
        int minDepth = this.getDepth(allPaths.get(0), prefer);
        for (int i = 1; i < allPaths.size(); ++i) {
            int d = this.getDepth(allPaths.get(i), prefer);
            if (d >= minDepth) continue;
            minDepth = d;
            minPos = i;
        }
        return allPaths.get(minPos);
    }

    protected static void generatePaths(MoserItemNormalizationGroup grp, LinkedList<MoserItemNormalizationGroup> stack, ArrayList<List<MoserItemNormalizationGroup>> allPaths, boolean b) {
        if (b && !grp.useParent() || grp.getParentGroups().isEmpty()) {
            ArrayList<MoserItemNormalizationGroup> p = new ArrayList<MoserItemNormalizationGroup>(stack);
            p.add(grp);
            allPaths.add(p);
        } else {
            stack.addLast(grp);
            for (MoserItemNormalizationGroup pgrp : grp.getParentGroups()) {
                MoserItemNormalization.generatePaths(pgrp, stack, allPaths, b);
            }
            stack.removeLast();
        }
    }

    protected int getDepth(List<MoserItemNormalizationGroup> path, Set<IMetadata> prefer) {
        int r = path.size();
        for (MoserItemNormalizationGroup g : path) {
            if (!prefer.contains(g.getKeyItem())) continue;
            --r;
        }
        return r;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Pair getDummyJoinForItemNormalization(MoserQuerySubject qs, IRelationship jn, PlanningEnvironment environment) {
        IMetadata left = jn.getLeftRefObject();
        Enum<IRelationship.Cardinality> card = qs.equals(left) ? jn.getLeftCardinality() : jn.getRightCardinality();
        if (IRelationship.Cardinality.getMaxCard(card).equals("many")) {
            return null;
        }
        Set<IMetadata> usedInJoin = this.getQueryItemInOneJoin(environment, qs, jn);
        Set<MoserItemNormalizationGroup> grpsInJoin = this.getGroups(usedInJoin);
        HashSet<MoserItemNormalizationGroup> uniqueGrpsInJoin = new HashSet<MoserItemNormalizationGroup>();
        HashSet<MoserItemNormalizationGroup> coveredGrpsInJoin = new HashSet<MoserItemNormalizationGroup>();
        for (MoserItemNormalizationGroup g : grpsInJoin) {
            ArrayList<List<MoserItemNormalizationGroup>> allPaths = new ArrayList<List<MoserItemNormalizationGroup>>();
            LinkedList<MoserItemNormalizationGroup> stack = new LinkedList<MoserItemNormalizationGroup>();
            MoserItemNormalization.generatePaths(g, stack, allPaths, true);
            for (List<MoserItemNormalizationGroup> path : allPaths) {
                uniqueGrpsInJoin.addAll(path);
            }
            allPaths.clear();
            stack.clear();
            MoserItemNormalization.generatePaths(g, stack, allPaths, false);
            for (List<MoserItemNormalizationGroup> path : allPaths) {
                coveredGrpsInJoin.addAll(path);
            }
        }
        if (this.isUniqueGroupSet(uniqueGrpsInJoin)) {
            return null;
        }
        MoserItemNormalization moserItemNormalization = this;
        synchronized (moserItemNormalization) {
            IRelationship dummyJoin = this.relToDummyJoin.get(jn);
            if (dummyJoin == null) {
                this.addDummyJoinsForQSItemNormalization(qs, usedInJoin, uniqueGrpsInJoin, jn, coveredGrpsInJoin);
            }
            dummyJoin = this.relToDummyJoin.get(jn);
            MoserQuerySubjectWrapper dummyQS = this.joinedQIsToDummyQS.get(usedInJoin);
            return new Pair(dummyJoin, dummyQS);
        }
    }

    protected void addDummyJoinsForQSItemNormalization(MoserQuerySubject qs, Set<IMetadata> usedInJoin, Set<MoserItemNormalizationGroup> uniqueGrpsInJoin, IRelationship jn, Set<MoserItemNormalizationGroup> coveredGrpsInJoin) {
        MoserQuerySubjectWrapper qsWrapper = this.joinedQIsToDummyQS.get(usedInJoin);
        if (qsWrapper == null) {
            qsWrapper = this.createDummyQS(coveredGrpsInJoin, qs, usedInJoin, uniqueGrpsInJoin);
            this.joinedQIsToDummyQS.put(usedInJoin, qsWrapper);
        }
        IMetadata left = jn.getLeftRefObject();
        IMetadata right = jn.getRightRefObject();
        IMetadata leftObj = null;
        IMetadata rightObj = null;
        if (qs.equals(left)) {
            leftObj = qsWrapper;
            rightObj = right;
        } else {
            leftObj = left;
            rightObj = qsWrapper;
        }
        String dummyName = leftObj.getName() + JOIN_NAME_SEP + rightObj.getName();
        MoserRelationshipWrapper dummyJoin = new MoserRelationshipWrapper(qs.getParentModule().getMetadataConnection().getNextId(), dummyName);
        dummyJoin.uniqueId = qs.getParentModule().getUniqueName() + "." + dummyName;
        dummyJoin.srcRelationship = jn;
        dummyJoin.leftRefObj = new WeakReference<IMetadata>(leftObj);
        dummyJoin.leftID = leftObj.getID();
        dummyJoin.leftCard = jn.getLeftCardinality();
        dummyJoin.rightRefObj = new WeakReference<IMetadata>(rightObj);
        dummyJoin.rightID = rightObj.getID();
        dummyJoin.rightCard = jn.getRightCardinality();
        this.relToDummyJoin.put(jn, dummyJoin);
    }

    protected MoserQuerySubjectWrapper createDummyQS(Set<MoserItemNormalizationGroup> coveredGrpsInJoin, MoserQuerySubject qs, Set<IMetadata> usedInJoin, Set<MoserItemNormalizationGroup> uniqueGrpsInJoin) {
        TreeSet<String> names = new TreeSet<String>();
        for (IMetadata iMetadata : usedInJoin) {
            names.add(iMetadata.getName());
        }
        StringBuilder sb = new StringBuilder();
        sb.append(qs.getName());
        sb.append("_itemNormalGenerated");
        for (String s : names) {
            sb.append("_");
            sb.append(s);
        }
        MoserQuerySubjectWrapper moserQuerySubjectWrapper = new MoserQuerySubjectWrapper(qs, qs.getParentModule().getMetadataConnection().getNextId(), sb.toString());
        HashSet<IMetadata> wrappedItems = new HashSet<IMetadata>();
        for (MoserItemNormalizationGroup g : coveredGrpsInJoin) {
            wrappedItems.addAll(g.getQueryItems());
        }
        moserQuerySubjectWrapper.setWrappedQueryItems(wrappedItems);
        moserQuerySubjectWrapper.uniqueGroups.addAll(uniqueGrpsInJoin);
        moserQuerySubjectWrapper.coveredGroups.addAll(coveredGrpsInJoin);
        return moserQuerySubjectWrapper;
    }

    protected boolean isNGroup(MoserItemNormalizationGroup src, MoserItemNormalizationGroup target, LinkedList<MoserItemNormalizationGroup> stack) {
        if (src.equals(target)) {
            return false;
        }
        stack.addLast(src);
        List<MoserItemNormalizationGroup> parents = src.getParentGroups();
        if (src.isMeasureScope()) {
            if (parents.size() == 1 && parents.get(0).equals(target)) {
                stack.removeLast();
                return false;
            }
            for (MoserItemNormalizationGroup g : parents) {
                if (g.equals(target)) {
                    stack.removeLast();
                    return true;
                }
                if (stack.contains(g) || !this.isNGroup(g, target, stack)) continue;
                stack.removeLast();
                return true;
            }
            stack.removeLast();
            return false;
        }
        if (!src.useParent() || parents.isEmpty()) {
            stack.removeLast();
            return false;
        }
        for (MoserItemNormalizationGroup p : parents) {
            if (p.equals(target)) {
                stack.removeLast();
                return true;
            }
            if (stack.contains(p) || !this.isNGroup(p, target, stack)) continue;
            stack.removeLast();
            return true;
        }
        stack.removeLast();
        return false;
    }

    protected Set<IMetadata> getQueryItemInOneJoin(PlanningEnvironment environment, IMetadata qsItemNorm, IRelationship jn) {
        HashSet<IMetadata> usedInJoin = new HashSet<IMetadata>();
        IXQEQueryNode expression = RQPUtilities.getV5BoundRelationshipExpression(jn, environment);
        List<IXQEQueryNode> v5Identifiers = expression.getDescendantsOfTypeOrdered(201116, true);
        for (IXQEQueryNode v5Id : v5Identifiers) {
            IMetadata qi = ((V5BoundModelIdentifier)v5Id).getMetadata();
            IQuerySubject qs = ((V5BoundModelIdentifier)v5Id).getQuerySubject();
            if (!qsItemNorm.equals(qs)) continue;
            usedInJoin.add(qi);
        }
        return usedInJoin;
    }

    protected Set<MoserItemNormalizationGroup> getGroups(Set<IMetadata> usedQIs) {
        HashSet<MoserItemNormalizationGroup> grps = new HashSet<MoserItemNormalizationGroup>();
        for (MoserItemNormalizationGroup grp : this.itemGroups) {
            if (!grp.containsQueryItemSet(usedQIs)) continue;
            grps.add(grp);
        }
        return grps;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean checkSupport(Set<String> names, Set<IMetadata> queryItems) {
        MoserItemNormalization moserItemNormalization = this;
        synchronized (moserItemNormalization) {
            for (MoserQuerySubjectWrapper dummyQS : this.joinedQIsToDummyQS.values()) {
                if (!names.contains(dummyQS.getName()) || CollectionUtils.intersection(dummyQS.getQueryItemsAndMeasures(), queryItems).size() != queryItems.size()) continue;
                return true;
            }
        }
        return false;
    }

    public String getSQLOperator(IMetadata queryItem) {
        for (MoserItemNormalizationGroup grp : this.itemGroups) {
            if (grp.keyRef == null) continue;
            if (grp.keyRef.equals(queryItem)) {
                return null;
            }
            String sqlOp = grp.sqlOperator.get(queryItem);
            if (sqlOp == null) continue;
            return sqlOp;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<IRelationship> getInternalDummyJoins(MoserQuerySubject qs, Set<IMetadata> wrappers, Set<IMetadata> usedQIs) {
        HashSet<IRelationship> rt = new HashSet<IRelationship>();
        if (wrappers == null || wrappers.isEmpty() || this.isGeneratedFromPrimaryKey()) {
            return rt;
        }
        Set<MoserItemNormalizationGroup> grpsInQuery = this.getGroups(usedQIs);
        HashSet<MoserItemNormalizationGroup> grpsInWrappers = new HashSet<MoserItemNormalizationGroup>();
        for (IMetadata w : wrappers) {
            MoserQuerySubjectWrapper wrap = (MoserQuerySubjectWrapper)w;
            grpsInWrappers.addAll(wrap.coveredGroups);
        }
        HashSet<MoserItemNormalizationGroup> temp = new HashSet<MoserItemNormalizationGroup>(grpsInQuery);
        temp.removeAll(grpsInWrappers);
        boolean bTop = !temp.isEmpty();
        MoserModule md = qs.getParentModule();
        MoserItemNormalization moserItemNormalization = this;
        synchronized (moserItemNormalization) {
            if (wrappers.size() == 1) {
                if (bTop) {
                    IMetadata right = wrappers.iterator().next();
                    rt.add(this.addInternalJoin(md, qs, right));
                }
            } else {
                HashSet<IMetadata> tmpWrappers = new HashSet<IMetadata>(wrappers);
                IMetadata right = null;
                IMetadata left = null;
                while (!tmpWrappers.isEmpty()) {
                    right = this.getMinWrapper(tmpWrappers);
                    left = this.getMinNSideWrapper(tmpWrappers, right);
                    if (left != null) {
                        rt.add(this.addInternalJoin(md, left, right));
                        continue;
                    }
                    if (!bTop) continue;
                    rt.add(this.addInternalJoin(md, qs, right));
                }
            }
        }
        return rt;
    }

    protected IMetadata getMinWrapper(Set<IMetadata> wrappers) {
        MoserQuerySubjectWrapper minWrapper = null;
        for (IMetadata m : wrappers) {
            MoserQuerySubjectWrapper qsWrap = (MoserQuerySubjectWrapper)m;
            if (minWrapper != null && qsWrap.coveredGroups.size() >= minWrapper.coveredGroups.size()) continue;
            minWrapper = qsWrap;
        }
        if (minWrapper != null) {
            wrappers.remove(minWrapper);
        }
        return minWrapper;
    }

    protected IMetadata getMinNSideWrapper(Set<IMetadata> wrappers, IMetadata right) {
        MoserQuerySubjectWrapper minWrapper = null;
        MoserQuerySubjectWrapper rightWrapper = (MoserQuerySubjectWrapper)right;
        for (IMetadata m : wrappers) {
            MoserQuerySubjectWrapper qsWrap = (MoserQuerySubjectWrapper)m;
            HashSet<MoserItemNormalizationGroup> tmp = new HashSet<MoserItemNormalizationGroup>(qsWrap.coveredGroups);
            tmp.retainAll(rightWrapper.coveredGroups);
            if (tmp.size() != rightWrapper.coveredGroups.size() || minWrapper != null && qsWrap.coveredGroups.size() >= minWrapper.coveredGroups.size()) continue;
            minWrapper = qsWrap;
        }
        return minWrapper;
    }

    protected IRelationship addInternalJoin(MoserModule md, IMetadata left, IMetadata right) {
        HashSet<String> key = new HashSet<String>();
        key.add(left.getName());
        key.add(right.getName());
        IRelationship j = this.internalJoins.get(key);
        if (j != null) {
            return j;
        }
        String name = left.getName() + JOIN_NAME_SEP + right.getName();
        MoserRelationshipWrapper internal = new MoserRelationshipWrapper(md.getMetadataConnection().getNextId(), name);
        internal.isDummy = true;
        internal.uniqueId = md.getUniqueName() + "." + name;
        internal.leftRefObj = new WeakReference<IMetadata>(left);
        internal.leftID = left.getID();
        internal.leftCard = IRelationship.Cardinality.ONE_MANY;
        internal.rightRefObj = new WeakReference<IMetadata>(right);
        internal.rightID = right.getID();
        internal.rightCard = IRelationship.Cardinality.ONE_ONE;
        this.internalJoins.put(key, internal);
        return internal;
    }

    public boolean queryItemsInGroups(Set<IMetadata> usedQueryItems) {
        HashSet<IMetadata> tmp = new HashSet<IMetadata>(usedQueryItems);
        tmp.retainAll(this.queryItemsNotInGroups);
        return tmp.isEmpty();
    }

    public String getGroupName(String qiName) {
        for (MoserItemNormalizationGroup g : this.itemGroups) {
            for (MoserQueryItem qi : g.itemRef) {
                if (!qi.getName().equals(qiName)) continue;
                return g.getName();
            }
        }
        return null;
    }
}

