/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqemoser;

import com.cognos.mfw4j.framework.MFWRequestContext;
import com.cognos.pogo.pdk.BIBusEnvelope;
import com.cognos.xqe.bibushandler.IRequestEnvironment;
import com.cognos.xqe.bibushandler.RequestEnvironment;
import com.cognos.xqe.config.ServiceEnumeration;
import com.cognos.xqe.config.XQEConfiguration;
import com.cognos.xqe.config.XQEConfigurationManager;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.metadata.ICube;
import com.cognos.xqe.metadata.IEmbeddedFilter;
import com.cognos.xqe.metadata.IFacet;
import com.cognos.xqe.metadata.IMetadata;
import com.cognos.xqe.metadata.IModelDataSource;
import com.cognos.xqe.metadata.IMultiRequestGateway;
import com.cognos.xqe.metadata.INamespace;
import com.cognos.xqe.metadata.IPhysicalTable;
import com.cognos.xqe.metadata.IQuerySubject;
import com.cognos.xqe.metadata.IRelationship;
import com.cognos.xqe.metadata.IScopeRelationship;
import com.cognos.xqe.metadata.IShortcut;
import com.cognos.xqe.metadata.MetadataBindingException;
import com.cognos.xqe.metadata.MetadataUtil;
import com.cognos.xqe.metadata.dynamic.DMRelationship;
import com.cognos.xqe.metadata.provider.MetadataConnection;
import com.cognos.xqe.metadata.provider.MetadataService;
import com.cognos.xqe.query.engine.IExecutionEnvironment;
import com.cognos.xqe.query.engine.IPlanningEnvironment;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.transformation.v5tocogsql.util.aggregateAwareness.AggregateAwareness;
import com.cognos.xqe.transformation.v5tocogsql.util.aggregateAwareness.IAggregateAwareness;
import com.cognos.xqe.transformation.v5tocogsql.util.joinRefinement.RQPJoinPathFinder;
import com.cognos.xqe.transformation.v5tocogsql.util.metadataContext.IMetadataContextManager;
import com.cognos.xqe.transformation.v5tocogsql.util.undirectedgraph.IUndirectedGraph;
import com.cognos.xqe.transformation.v5tocogsql.util.undirectedgraph.UndirectedGraph;
import com.cognos.xqe.util.Governors;
import com.cognos.xqe.util.IParameterMaps;
import com.cognos.xqe.util.Pair;
import com.cognos.xqe.util.UniqueNameGenerator;
import com.cognos.xqe.util.io.TempFileUtil;
import com.cognos.xqemfw4j.MFWMetadataConnection;
import com.cognos.xqemoser.BaseHTTPClient;
import com.cognos.xqemoser.IMoserModule;
import com.cognos.xqemoser.IMoserModuleReader;
import com.cognos.xqemoser.ModuleIdPair;
import com.cognos.xqemoser.MoserBaseMetadata;
import com.cognos.xqemoser.MoserCalculation;
import com.cognos.xqemoser.MoserCube;
import com.cognos.xqemoser.MoserDataSource;
import com.cognos.xqemoser.MoserEmbeddedModuleWrapper;
import com.cognos.xqemoser.MoserEnv;
import com.cognos.xqemoser.MoserModule;
import com.cognos.xqemoser.MoserModuleIsStaleChecker;
import com.cognos.xqemoser.MoserModuleManager;
import com.cognos.xqemoser.MoserModuleUtil;
import com.cognos.xqemoser.MoserOlapPackageGenerator;
import com.cognos.xqemoser.MoserQueryItem;
import com.cognos.xqemoser.MoserQuerySubject;
import com.cognos.xqemoser.QsClassifierType;
import com.ibm.bi.platform.moser.common.generated.metadata.UseSpecType;
import com.ibm.json.java.JSONObject;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class MoserMetadataConnection
implements MetadataConnection {
    public static final String MOSER_SKIP = "/metadata";
    private static final String OPEN_SQUARE_BRACKET = "[";
    private static final String CLOSE_SQUARE_BRACKET = "]";
    protected volatile MoserModule module = null;
    protected volatile String theConnectionPassport = null;
    protected volatile String modulePath = null;
    protected volatile Locale defaultLocale = null;
    protected final Map<String, String> cookies = new TreeMap<String, String>();
    protected volatile Locale theContentLocale = null;
    private volatile MoserModuleManager moduleManager = null;
    protected volatile Locale theProductLocale = null;
    private final List<String> nagMessages = new ArrayList<String>();
    private final long periodCheckStale;
    private final AtomicBoolean staleStatus = new AtomicBoolean(false);
    private final AtomicBoolean connectStatus = new AtomicBoolean(false);
    private final Lock readLock;
    private final Lock writeLock;
    String mContentLocale;
    String mProductLocale;
    String mExpressionLocale;
    boolean mForceCMTrusted;
    private Map<String, Pair> mPackages = new HashMap<String, Pair>();
    private final IAggregateAwareness aggrAwareNess = new AggregateAwareness();
    protected MoserCube cube;
    String mExpressionToValidate = null;
    String mContextIdentifier = null;
    private long lastTimeIsStaleChecked = 0L;
    private String mJoinGraph;
    private IMoserModuleReader moduleReader;
    private long lifetime = -1L;

    public MoserMetadataConnection() {
        this.moduleManager = new MoserModuleManager(this);
        this.periodCheckStale = MetadataService.getInstance().getMoserConnectionCheckStalePeriod();
        if (MoserModuleManager.loggingEnabled()) {
            MoserModuleManager.log(LogLevel.TRACE, "create new MoserMetadataConnection and new MoserModuleManager.");
        }
        ReentrantReadWriteLock lock = new ReentrantReadWriteLock(true);
        this.readLock = lock.readLock();
        this.writeLock = lock.writeLock();
        this.moduleReader = MoserModuleManager.getMoserModuleReader();
    }

    public MoserMetadataConnection(String moduleId) {
        this.modulePath = moduleId;
        this.moduleManager = new MoserModuleManager(this);
        this.periodCheckStale = -1L;
        ReentrantReadWriteLock lock = new ReentrantReadWriteLock(true);
        this.readLock = lock.readLock();
        this.writeLock = lock.writeLock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void connect(String connectionString, String expressionLocale, IExecutionEnvironment execEnv, MFWRequestContext requestContext) {
        boolean bEmbeddedModule = this.module instanceof MoserEmbeddedModuleWrapper;
        if (!bEmbeddedModule) {
            this.readLock.lock();
        } else {
            this.writeLock.lock();
        }
        try {
            boolean bIsConnected = this.connectStatus.get();
            if (bIsConnected || this.staleStatus.get()) {
                if (bEmbeddedModule && bIsConnected) {
                    ((MoserEmbeddedModuleWrapper)this.module).attachSourceMetadataConnectionIfRequired(this, execEnv);
                }
                return;
            }
        }
        finally {
            if (!bEmbeddedModule) {
                this.readLock.unlock();
            } else {
                this.writeLock.unlock();
            }
        }
        this.writeLock.lock();
        try {
            Object reqEnv;
            Map<String, String> ck;
            if (this.connectStatus.get() || this.staleStatus.get()) {
                return;
            }
            this.mContentLocale = requestContext.getContentLocale();
            this.mProductLocale = requestContext.getProductLocale();
            this.mExpressionLocale = expressionLocale;
            this.mForceCMTrusted = requestContext.getForceCMTrusted();
            this.theConnectionPassport = requestContext.getUserPassport();
            this.modulePath = connectionString.startsWith(MetadataService.getInstance().getMoserBasePath()) ? connectionString.substring(MetadataService.getInstance().getMoserBasePath().length()) : connectionString;
            if (this.modulePath.endsWith(MOSER_SKIP)) {
                int end = this.modulePath.length() - MOSER_SKIP.length();
                this.modulePath = this.modulePath.substring(0, end);
            }
            if ((ck = (reqEnv = execEnv.getRequestEnvironment()).getCookies()) != null) {
                this.cookies.putAll(ck);
            }
            if (expressionLocale != null) {
                this.defaultLocale = new Locale(expressionLocale);
            }
            if (this.mContentLocale != null) {
                this.theContentLocale = new Locale(this.mContentLocale);
            }
            if (this.mProductLocale != null) {
                this.theProductLocale = new Locale(this.mProductLocale);
            }
            this.modulePath = MoserModuleUtil.extractStoreIDPrefix(this.modulePath);
            ModuleIdPair idPair = new ModuleIdPair(this.modulePath, this.modulePath, null);
            this.module = (MoserModule)this.moduleManager.buildTopModule(idPair, this.theConnectionPassport, this.cookies, new MoserEnv(execEnv, this.moduleReader));
            if (this.module != null) {
                this.connectStatus.set(true);
                this.staleStatus.set(false);
                if (this.module.getModuleType() == IMoserModule.ModuleType.EMBEDDED) {
                    MoserEmbeddedModuleWrapper wrapper = MoserEmbeddedModuleWrapper.createEmbeddedModuleWrapper(this, execEnv);
                    if (wrapper == null) {
                        this.connectStatus.set(false);
                        this.staleStatus.set(true);
                    } else {
                        this.module = wrapper;
                    }
                }
                if (this.connectStatus.get() && !MoserModuleUtil.isSessionTempID(this.modulePath) && this.moduleReader.is304Capable()) {
                    MoserModuleIsStaleChecker.getInstance().registerConnection(this, this.modulePath, this.module.getCacheKey());
                }
            } else {
                this.connectStatus.set(false);
                this.staleStatus.set(true);
            }
            this.lifetime = !this.connectStatus.get() ? 0L : this.moduleManager.lifetime;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public List<IMetadata> getPhysicalMetadata(String dataSource, String catalog, String schema, String name, boolean isTable, boolean metadataCallbackEnabled) {
        return this.getPhysicalMetadataExpandMacro(dataSource, catalog, schema, name, isTable, metadataCallbackEnabled, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<IMetadata> getPhysicalMetadataExpandMacro(String dataSource, String catalog, String schema, String name, boolean isTable, boolean metadataCallbackEnabled, IPlanningEnvironment env) {
        if (this.module instanceof MoserEmbeddedModuleWrapper) {
            return ((MoserEmbeddedModuleWrapper)this.module).srcMetadataConnection.getPhysicalMetadataExpandMacro(dataSource, catalog, schema, name, isTable, metadataCallbackEnabled, env);
        }
        this.readLock.lock();
        List<IMetadata> physMetadata = null;
        try {
            if (this.module != null && (physMetadata = this.module.getPhysicalMetadata(dataSource, catalog, schema, name, this.theConnectionPassport, this.cookies, env)) != null && physMetadata.size() > 1) {
                IMetadata keepOne = physMetadata.get(0);
                physMetadata.clear();
                physMetadata.add(keepOne);
            }
            if ((physMetadata == null || physMetadata.isEmpty()) && env == null) {
                physMetadata = this.getPhysicalMetadataPackage(dataSource, catalog, schema, name, isTable, metadataCallbackEnabled);
            }
            List<IMetadata> list = physMetadata;
            return list;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public List<IMetadata> getPhysicalMetadaFromCM(String cmDataSource, String cmConnection, String catalog, String schema, String name, IPlanningEnvironment env) {
        if (this.module instanceof MoserEmbeddedModuleWrapper) {
            return ((MoserEmbeddedModuleWrapper)this.module).srcMetadataConnection.getPhysicalMetadaFromCM(cmDataSource, cmConnection, catalog, schema, name, env);
        }
        List<IMetadata> physMetadata = this.getPhysicalMetadataExpandMacro(cmDataSource, catalog, schema, name, true, true, env);
        if (physMetadata != null && !physMetadata.isEmpty()) {
            return physMetadata;
        }
        this.writeLock.lock();
        try {
            Object sp;
            if (this.module != null) {
                sp = ":";
                if (MoserModuleManager.getDefaultDataFilePath() != null) {
                    sp = "_";
                }
                StringBuilder sb = new StringBuilder();
                sb.append(cmDataSource);
                sb.append((String)sp);
                sb.append(cmConnection);
                sb.append((String)sp);
                if (catalog == null) {
                    sb.append("null");
                } else {
                    sb.append(catalog);
                }
                sb.append((String)sp);
                if (schema == null) {
                    sb.append("null");
                } else {
                    sb.append(schema);
                }
                sb.append(".physicalmodule");
                String moduleId = sb.toString();
                sb.setLength(0);
                sb.append("xqemoser=true&type=database&qs=");
                if (MoserModuleManager.getDefaultDataFilePath() != null) {
                    sb.append(name);
                } else {
                    sb.append(BaseHTTPClient.encodeURIComponent(name));
                }
                String[] k = new String[]{null, null, null};
                k[0] = cmDataSource;
                k[1] = catalog;
                k[2] = schema;
                physMetadata = this.moduleManager.getPhysicalMetadaFromCM(this.module, moduleId, sb.toString(), this.theConnectionPassport, this.cookies, k, new MoserEnv((IExecutionEnvironment)env.getExecutionEnvironment(), null), env);
            }
            sp = physMetadata;
            return sp;
        }
        catch (Exception e) {
            throw new XQERuntimeException(XQEMessageKeys.MSR_TableNotFound, name, (Object)this.generateSchemaName(catalog, schema), (Object)cmConnection, (Object)cmDataSource);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    private String generateSchemaName(String catalog, String schema) {
        String sp = "/";
        if (catalog == null && schema == null) {
            return "null" + sp + "null";
        }
        if (catalog != null && schema != null) {
            return catalog + sp + schema;
        }
        if (catalog != null) {
            return catalog;
        }
        return schema;
    }

    private List<IMetadata> getPhysicalMetadataPackage(String dataSource, String catalog, String schema, String name, boolean isTable, boolean metadataCallbackEnabled) {
        for (Pair p : this.mPackages.values()) {
            MetadataConnection mdc = (MetadataConnection)p.getFirst();
            List<IMetadata> physMD = mdc.getPhysicalMetadata(dataSource, catalog, schema, name, isTable, metadataCallbackEnabled);
            if (physMD == null || physMD.isEmpty()) continue;
            return physMD;
        }
        return Collections.emptyList();
    }

    @Override
    public List<String> getModelDataSecurityObjects(IRequestEnvironment reqEnv) {
        return Collections.emptyList();
    }

    @Override
    public void release() {
    }

    @Override
    public boolean isConnected() {
        this.readLock.lock();
        try {
            boolean bl = this.connectStatus.get();
            return bl;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public boolean isStaleForObject(Set<String> objNames) {
        return this.checkIsStale(objNames);
    }

    @Override
    public boolean isStale(boolean isMetadataRefreshRequest, boolean isMetadataRequest) {
        return this.checkIsStale(null);
    }

    protected MetadataConnection getFMMetadataConnectionByStoreId(String fmId) {
        for (Pair p : this.mPackages.values()) {
            Map useSpec = (Map)p.getSecond();
            if (!fmId.equals(useSpec.get("storeID"))) continue;
            return (MetadataConnection)p.getFirst();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean checkIsStale(Set<String> objNames) {
        if (!MoserModuleUtil.isSessionTempID(this.modulePath) && XQEConfigurationManager.getInstance().getConfiguration(ServiceEnumeration.XQE).inStandaloneMode()) {
            long currentTime = System.currentTimeMillis();
            long period = currentTime - this.lastTimeIsStaleChecked;
            if (this.lastTimeIsStaleChecked != 0L && period <= this.periodCheckStale) {
                return false;
            }
        }
        if (this.module instanceof MoserEmbeddedModuleWrapper && ((MoserEmbeddedModuleWrapper)this.module).srcMetadataConnection.checkIsStale(objNames)) {
            this.staleStatus.set(true);
            return true;
        }
        MoserEnv env = new MoserEnv();
        this.writeLock.lock();
        try {
            boolean b;
            if (this.module == null) {
                boolean bl = true;
                return bl;
            }
            boolean bl = b = this.moduleManager.isStale(this.modulePath, this.theConnectionPassport, this.cookies, this.module.getCacheKey(), env) || this.isMissingParquetFile();
            if (b) {
                this.staleStatus.set(true);
            } else {
                this.staleStatus.set(false);
            }
            boolean bl2 = b;
            return bl2;
        }
        finally {
            this.lastTimeIsStaleChecked = System.currentTimeMillis();
            this.writeLock.unlock();
        }
    }

    private boolean isMissingParquetFile() {
        XQEConfiguration config = XQEConfigurationManager.getInstance().getConfiguration(ServiceEnumeration.XQE);
        if (!Boolean.parseBoolean(config.getStringProperty("queryExecution.flintServer.lazyConversion[@enabled]", "false"))) {
            return false;
        }
        HashSet<ModuleIdPair> physicals = new HashSet<ModuleIdPair>();
        for (Map.Entry<Pair, IMoserModule> e : this.moduleManager.allModules.entrySet()) {
            IMoserModule m = e.getValue();
            if (IMoserModule.ModuleType.REPORT == m.getModuleType()) continue;
            MoserModule baseModule = (MoserModule)m;
            if (!UseSpecType.FILE.value().equals(baseModule.getType()) && !UseSpecType.DATASET.value().equals(baseModule.getType())) continue;
            physicals.addAll(baseModule.importModules);
        }
        HashSet<String> moduleFiles = new HashSet<String>();
        for (Map.Entry<Pair, IMoserModule> e1 : this.moduleManager.allModules.entrySet()) {
            String id;
            ModuleIdPair mId = (ModuleIdPair)e1.getKey().getFirst();
            if (!physicals.contains(mId) || moduleFiles.contains(id = mId.getModuleId())) continue;
            moduleFiles.add(id);
            MoserModule aModule = (MoserModule)e1.getValue();
            List<MoserDataSource> ds = aModule.getDataSources();
            for (MoserDataSource d : ds) {
                File f;
                if (d.parquetFilePath == null || (f = new File(d.parquetFilePath)).exists()) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public String getModelName() {
        this.readLock.lock();
        try {
            String string = this.getModelPath();
            return string;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public String getModelPath() {
        this.readLock.lock();
        try {
            String string = this.modulePath;
            return string;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public List<IMetadata> queryMetadata(String queryString) {
        return null;
    }

    @Override
    public IMetadata getParentObject(IMetadata child) {
        return null;
    }

    @Override
    public IMetadata initialiseObjectProperties(IMetadata object) {
        return object;
    }

    @Override
    public IMetadata initialiseObjectChildren(IMetadata object) {
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<IModelDataSource> getModelDataSources() {
        if (this.module instanceof MoserEmbeddedModuleWrapper) {
            return ((MoserEmbeddedModuleWrapper)this.module).srcMetadataConnection.getModelDataSources();
        }
        this.readLock.lock();
        try {
            List<IModelDataSource> moduleDS;
            ArrayList<IModelDataSource> dataSources = new ArrayList<IModelDataSource>();
            if (this.module != null && (moduleDS = this.module.getModelDataSources(this.theConnectionPassport, this.cookies)) != null && !moduleDS.isEmpty()) {
                dataSources.addAll(moduleDS);
            }
            for (Pair p : this.mPackages.values()) {
                MetadataConnection mdc = (MetadataConnection)p.getFirst();
                List<IModelDataSource> packageDS = mdc.getModelDataSources();
                if (packageDS == null || packageDS.isEmpty()) continue;
                dataSources.addAll(packageDS);
            }
            ArrayList<IModelDataSource> arrayList = dataSources;
            return arrayList;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public List<String> getModelFunctionSetVendorIDs() {
        ArrayList<String> rt = new ArrayList<String>();
        rt.add("none");
        return rt;
    }

    @Override
    public IModelDataSource getModelDataSource(String dataSourceName) {
        return null;
    }

    @Override
    public INamespace getRootNamespace() {
        return null;
    }

    @Override
    public ICube getCube() {
        throw new XQERuntimeException(XQEMessageKeys.GEN_FoundInternalErrorParam_INTERNAL, "not supported");
    }

    @Override
    public ICube getCube(String name) {
        if (this.module instanceof MoserEmbeddedModuleWrapper) {
            return ((MoserEmbeddedModuleWrapper)this.module).srcMetadataConnection.getCube(name);
        }
        if (this.cube != null) {
            return this.cube;
        }
        for (ICube modelCube : this.getCubes()) {
            if (!modelCube.getUniqueName().equals(name)) continue;
            return modelCube;
        }
        return null;
    }

    @Override
    public ICube[] getCubes() {
        if (this.module instanceof MoserEmbeddedModuleWrapper) {
            return ((MoserEmbeddedModuleWrapper)this.module).srcMetadataConnection.getCubes();
        }
        if (this.cube == null) {
            ArrayList<ICube> cubes = new ArrayList<ICube>();
            for (Pair p : this.mPackages.values()) {
                MetadataConnection mdc = (MetadataConnection)p.getFirst();
                ICube[] fmCubes = mdc.getCubes();
                if (fmCubes == null) continue;
                cubes.addAll(Arrays.asList(fmCubes));
            }
            return cubes.toArray(new ICube[cubes.size()]);
        }
        return new ICube[]{this.cube};
    }

    @Override
    public Map<String, String> getDataSourceProperties() {
        return null;
    }

    @Override
    public IParameterMaps getParameterMapsModel() {
        if (this.module instanceof MoserEmbeddedModuleWrapper) {
            return ((MoserEmbeddedModuleWrapper)this.module).srcMetadataConnection.getParameterMapsModel();
        }
        if (this.mPackages != null) {
            for (Pair p : this.mPackages.values()) {
                MetadataConnection mdc = (MetadataConnection)p.getFirst();
                IParameterMaps pm = mdc.getParameterMapsModel();
                if (pm == null) continue;
                return pm;
            }
        }
        return this.module.getParameterMaps();
    }

    @Override
    public IParameterMaps getQIParameterMapsModel() {
        if (this.module instanceof MoserEmbeddedModuleWrapper) {
            return ((MoserEmbeddedModuleWrapper)this.module).srcMetadataConnection.getQIParameterMapsModel();
        }
        if (this.mPackages != null) {
            for (Pair p : this.mPackages.values()) {
                MetadataConnection mdc = (MetadataConnection)p.getFirst();
                IParameterMaps pm = mdc.getQIParameterMapsModel();
                if (pm == null) continue;
                return pm;
            }
        }
        return null;
    }

    @Override
    public IMetadata getFunction(String name) {
        if (this.module instanceof MoserEmbeddedModuleWrapper) {
            return ((MoserEmbeddedModuleWrapper)this.module).srcMetadataConnection.getFunction(name);
        }
        if (this.mPackages != null) {
            for (Pair p : this.mPackages.values()) {
                MetadataConnection mdc = (MetadataConnection)p.getFirst();
                IMetadata f = mdc.getFunction(name);
                if (f == null) continue;
                return f;
            }
        }
        return null;
    }

    @Override
    public IScopeRelationship[] getScopeRelationships(String id) {
        return null;
    }

    @Override
    public List<IMetadata> getRelationships() {
        return this.getPackageRelationships();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<IMetadata> getPackageRelationships() {
        if (this.module instanceof MoserEmbeddedModuleWrapper) {
            return ((MoserEmbeddedModuleWrapper)this.module).srcMetadataConnection.getPackageRelationships();
        }
        this.readLock.lock();
        try {
            ArrayList<IMetadata> relationships = new ArrayList<IMetadata>();
            if (this.module == null) {
                ArrayList<IMetadata> arrayList = relationships;
                return arrayList;
            }
            for (Pair p : this.mPackages.values()) {
                MetadataConnection mdc = (MetadataConnection)p.getFirst();
                List<IMetadata> packageRelationships = mdc.getRelationships();
                if (packageRelationships == null || packageRelationships.isEmpty()) continue;
                relationships.addAll(packageRelationships);
            }
            ArrayList<IMetadata> arrayList = relationships;
            return arrayList;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public List<IMetadata> getRelationshipShortcuts() {
        return new ArrayList<IMetadata>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<IMetadata> getJoins(Governors governors) {
        if (this.module instanceof MoserEmbeddedModuleWrapper) {
            return ((MoserEmbeddedModuleWrapper)this.module).srcMetadataConnection.getJoins(governors);
        }
        this.readLock.lock();
        try {
            List<IMetadata> moduleJoins;
            ArrayList<IMetadata> joins = new ArrayList<IMetadata>();
            if (this.module != null && (moduleJoins = this.module.getJoins(this.theConnectionPassport, this.cookies)) != null && !moduleJoins.isEmpty()) {
                joins.addAll(moduleJoins);
            }
            for (Pair p : this.mPackages.values()) {
                MetadataConnection mdc = (MetadataConnection)p.getFirst();
                List<IMetadata> packageJoins = mdc.getJoins(governors);
                if (packageJoins == null || packageJoins.isEmpty()) continue;
                joins.addAll(packageJoins);
            }
            ArrayList<IMetadata> arrayList = joins;
            return arrayList;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public List<IMetadata> getDummyRelationships(Governors governors) {
        return Collections.emptyList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<IMetadata> getEntities() {
        if (this.module instanceof MoserEmbeddedModuleWrapper) {
            return ((MoserEmbeddedModuleWrapper)this.module).srcMetadataConnection.getEntities();
        }
        this.readLock.lock();
        try {
            List<IMetadata> moduleEntities;
            ArrayList<IMetadata> ents = new ArrayList<IMetadata>();
            if (this.module != null && (moduleEntities = this.module.getEntities(this.theConnectionPassport, this.cookies)) != null && !moduleEntities.isEmpty()) {
                ents.addAll(moduleEntities);
            }
            for (Pair p : this.mPackages.values()) {
                MetadataConnection mdc = (MetadataConnection)p.getFirst();
                List<IMetadata> packageEntities = mdc.getEntities();
                if (packageEntities == null || packageEntities.isEmpty()) continue;
                ents.addAll(packageEntities);
            }
            ArrayList<IMetadata> arrayList = ents;
            return arrayList;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public IUndirectedGraph getGraph(Governors governors) {
        if (this.module instanceof MoserEmbeddedModuleWrapper) {
            return ((MoserEmbeddedModuleWrapper)this.module).srcMetadataConnection.getGraph(governors);
        }
        this.readLock.lock();
        try {
            IUndirectedGraph iUndirectedGraph = this.buildGraph(governors);
            return iUndirectedGraph;
        }
        finally {
            this.readLock.unlock();
        }
    }

    protected IUndirectedGraph buildGraph(Governors governors) {
        UndirectedGraph newGraph = new UndirectedGraph(this.modulePath);
        for (IMetadata entObj : this.getEntities()) {
            String entId = this.getID(entObj);
            newGraph.addNode(entId);
        }
        for (IMetadata mdObj : this.getJoins(governors)) {
            if (!(mdObj instanceof IRelationship)) continue;
            IRelationship joinObj = (IRelationship)mdObj;
            int weight = RQPJoinPathFinder.Weight.Default.getWeight();
            newGraph.addEdge(this.getID(joinObj), this.getID(joinObj.getLeftRefObject()), this.getID(joinObj.getRightRefObject()), weight, false);
        }
        return newGraph;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HashMap<String, IMetadata> getIdToJoinMap(Governors governors) {
        if (this.module instanceof MoserEmbeddedModuleWrapper) {
            return ((MoserEmbeddedModuleWrapper)this.module).srcMetadataConnection.getIdToJoinMap(governors);
        }
        this.readLock.lock();
        try {
            HashMap<String, IRelationship> idToJoin = new HashMap<String, IRelationship>();
            for (IMetadata mdObj : this.getJoins(governors)) {
                if (!(mdObj instanceof IRelationship)) continue;
                IRelationship joinObj = (IRelationship)mdObj;
                String joinId = this.getID(joinObj);
                idToJoin.put(joinId, joinObj);
            }
            HashMap<String, IRelationship> hashMap = idToJoin;
            return hashMap;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public Locale getExpressionLocale() {
        this.readLock.lock();
        try {
            Locale locale = this.defaultLocale;
            return locale;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public Locale getContentLocale() {
        this.readLock.lock();
        try {
            Locale locale = this.theContentLocale;
            return locale;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public Locale getProductLocale() {
        this.readLock.lock();
        try {
            Locale locale = this.theProductLocale;
            return locale;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Locale getDefaultLocale(IMetadata obj) {
        this.readLock.lock();
        try {
            Locale moduleLocale;
            if (obj != null) {
                Locale objLocale;
                MetadataConnection objMDConn = obj.getConnection();
                if (objMDConn != null && objMDConn != this) {
                    Locale locale = objMDConn.getDefaultLocale(obj);
                    return locale;
                }
                if (obj instanceof MoserBaseMetadata && (objLocale = ((MoserBaseMetadata)((Object)obj)).getDefaultLocale()) != null) {
                    Locale locale = objLocale;
                    return locale;
                }
            } else if (this.module != null && (moduleLocale = this.module.getExpressionLocale()) != null) {
                Locale locale = moduleLocale;
                return locale;
            }
        }
        finally {
            this.readLock.unlock();
        }
        return this.defaultLocale;
    }

    @Override
    public List<IShortcut> getAllShortcuts(IMetadata shortcutOrQuerySubject) {
        return null;
    }

    @Override
    public String getDefaultLocaleString() {
        return null;
    }

    @Override
    public IPhysicalTable getPhysicalTable(String dataSource, String catalog, String schema, String name) {
        return null;
    }

    @Override
    public String getPackageName() {
        return null;
    }

    @Override
    public long getModelModificationTime(String passport, BIBusEnvelope envelope) {
        return 0L;
    }

    @Override
    public boolean isTreatedAsAlias(IShortcut sc, Governors governors) {
        return false;
    }

    @Override
    public IMetadata getTargetOfReferenceShortcut(IMetadata metadata) {
        return null;
    }

    protected IMetadata getMetadataFromModule(String ref, MoserEnv env) {
        IMetadata md = null;
        if (this.module instanceof MoserEmbeddedModuleWrapper) {
            md = ((MoserEmbeddedModuleWrapper)this.module).srcMetadataConnection.getMetadataFromModule(ref, env);
        }
        if (md != null) {
            return md;
        }
        if (this.module == null) {
            return null;
        }
        String uName = MoserModuleUtil.normalizeName(ref);
        return this.module.getExpressionObjectByUName(uName, this.theConnectionPassport, this.cookies, true, env);
    }

    protected IMetadata getMetadata(String ref, String[] rt, boolean bThrow) {
        MoserEnv env = new MoserEnv();
        IMetadata md = null;
        if (this.shouldBindToPackage(ref)) {
            md = this.bindMetadataFromPackages(ref, rt);
            if (bThrow && md == null && !MoserMetadataConnection.isValidateContext(env)) {
                throw new MetadataBindingException(ref);
            }
            return md;
        }
        md = this.getMetadataFromModule(ref, env);
        if (md != null) {
            return md;
        }
        md = this.getFirstMetadataFromPackages(ref, rt);
        if (bThrow && md == null && !MoserMetadataConnection.isValidateContext(env)) {
            throw new MetadataBindingException(ref);
        }
        return md;
    }

    @Override
    public IMetadata bindMetadataReference(String ref) {
        if (ref == null) {
            return null;
        }
        this.readLock.lock();
        try {
            IMetadata iMetadata = this.getMetadata(ref, null, true);
            return iMetadata;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public static boolean isValidateContext(MoserEnv env) {
        RequestEnvironment reqEnv = (RequestEnvironment)env.getExecutionEnvironment().getRequestEnvironment();
        if (reqEnv == null) {
            return false;
        }
        return reqEnv.isValidateRequest();
    }

    protected boolean shouldBindToPackage(String ref) {
        if (this.module instanceof MoserEmbeddedModuleWrapper) {
            return ((MoserEmbeddedModuleWrapper)this.module).srcMetadataConnection.shouldBindToPackage(ref);
        }
        if (this.mPackages.isEmpty()) {
            return false;
        }
        if (!MetadataUtil.isIdForPackage(ref)) {
            return false;
        }
        int idxSQ = ref.indexOf(OPEN_SQUARE_BRACKET);
        if (idxSQ > 0) {
            return true;
        }
        int idxCloseSQ = ref.indexOf(CLOSE_SQUARE_BRACKET);
        String alias = ref.substring(1, idxCloseSQ);
        Pair p = this.mPackages.get(alias);
        return p != null;
    }

    protected IMetadata bindMetadataFromPackages(String ref, String[] rtStoreId) {
        String packageRef;
        String alias;
        if (this.module instanceof MoserEmbeddedModuleWrapper) {
            return ((MoserEmbeddedModuleWrapper)this.module).srcMetadataConnection.bindMetadataFromPackages(ref, rtStoreId);
        }
        int idxSQ = ref.indexOf(OPEN_SQUARE_BRACKET);
        if (idxSQ > 0) {
            alias = ref.substring(0, idxSQ - 1);
            packageRef = ref.substring(idxSQ);
        } else {
            int idxCloseSQ = ref.indexOf(CLOSE_SQUARE_BRACKET);
            alias = ref.substring(1, idxCloseSQ);
            packageRef = ref.substring(idxCloseSQ + 2);
        }
        Pair p = this.mPackages.get(alias);
        if (p != null) {
            MetadataConnection mc = (MetadataConnection)p.getFirst();
            if (rtStoreId != null) {
                Map useSpec = (Map)p.getSecond();
                rtStoreId[0] = (String)useSpec.get("storeID");
            }
            return mc.bindMetadataReference(packageRef);
        }
        return null;
    }

    protected IMetadata getFirstMetadataFromPackages(String ref, String[] rt) {
        if (this.module instanceof MoserEmbeddedModuleWrapper) {
            return ((MoserEmbeddedModuleWrapper)this.module).srcMetadataConnection.getFirstMetadataFromPackages(ref, rt);
        }
        if (ref.contains("SKIP_SELF")) {
            return null;
        }
        for (Pair p : this.mPackages.values()) {
            MetadataConnection mdc = (MetadataConnection)p.getFirst();
            try {
                IMetadata md = mdc.bindMetadataReference(ref);
                if (md == null) continue;
                if (rt != null) {
                    Map useSpec = (Map)p.getSecond();
                    rt[0] = (String)useSpec.get("storeID");
                }
                return md;
            }
            catch (MetadataBindingException e) {
            }
        }
        return null;
    }

    public IMetadata bindQuerySubjectReference(String qs) {
        if (this.module instanceof MoserEmbeddedModuleWrapper) {
            return ((MoserEmbeddedModuleWrapper)this.module).srcMetadataConnection.bindQuerySubjectReference(qs);
        }
        this.readLock.lock();
        try {
            if (this.shouldBindToPackage(qs)) {
                IMetadata iMetadata = this.bindMetadataFromPackages(qs, null);
                return iMetadata;
            }
            if (this.module != null) {
                IMetadata iMetadata = this.module.getQuerySubjectByUName(qs);
                return iMetadata;
            }
            IMetadata iMetadata = this.bindMetadataReference(qs);
            return iMetadata;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public IMetadata updateIDToMetadataReferenceMap(String ref, IMetadata metadata) {
        return null;
    }

    @Override
    public String verifyModelPath(String modelPath) {
        return null;
    }

    @Override
    public boolean toFile() {
        return false;
    }

    @Override
    public IMultiRequestGateway getGateway() {
        return null;
    }

    @Override
    public Object getModelConnectionItem(String item) {
        return null;
    }

    @Override
    public IAggregateAwareness getAggregateAwareness() {
        return this.aggrAwareNess;
    }

    @Override
    public IMetadataContextManager getMetadataContextManager() {
        return null;
    }

    public String toString() {
        this.readLock.lock();
        try {
            JSONObject v = new JSONObject();
            v.put((Object)"class", (Object)super.toString());
            if (this.modulePath != null) {
                v.put((Object)"modulePath", (Object)this.modulePath);
            }
            v.put((Object)"modules", (Object)this.moduleManager.toJSONArray());
            String string = v.toString();
            return string;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public String getModelType() {
        return "module";
    }

    public MoserModule getModule() {
        this.readLock.lock();
        try {
            MoserModule moserModule = this.module;
            return moserModule;
        }
        finally {
            this.readLock.unlock();
        }
    }

    protected IMoserModule getModule(ModuleIdPair idPair, String userPassport, Map<String, String> cookiesToMoser, MoserEnv env) {
        IMoserModule m = null;
        if (this.module instanceof MoserEmbeddedModuleWrapper) {
            m = ((MoserEmbeddedModuleWrapper)this.module).srcMetadataConnection.getModule(idPair, userPassport, cookiesToMoser, env);
        }
        if (m != null) {
            return m;
        }
        return this.moduleManager.getModule(idPair, userPassport, cookiesToMoser, env);
    }

    protected IMoserModule getPhysicalModuleFromPhysicalDefinition(ModuleIdPair idPair, JSONObject physical, String userPassport, Map<String, String> cookiesToMoser, MoserEnv env) {
        if (this.module instanceof MoserEmbeddedModuleWrapper) {
            return ((MoserEmbeddedModuleWrapper)this.module).srcMetadataConnection.getPhysicalModuleFromPhysicalDefinition(idPair, physical, userPassport, cookiesToMoser, env);
        }
        return this.moduleManager.getPhysicalModuleFromPhysicalDefinition(idPair, physical, userPassport, cookiesToMoser, env);
    }

    @Override
    public void refreshMetadata() {
    }

    protected Pair getModuleUsingAlias(String alias) {
        if (this.module instanceof MoserEmbeddedModuleWrapper) {
            return ((MoserEmbeddedModuleWrapper)this.module).srcMetadataConnection.getModuleUsingAlias(alias);
        }
        return this.moduleManager.getModuleUsingAlias(alias);
    }

    protected List<ModuleIdPair> getAllModulePairs() {
        if (this.module instanceof MoserEmbeddedModuleWrapper) {
            return ((MoserEmbeddedModuleWrapper)this.module).srcMetadataConnection.getAllModulePairs();
        }
        return this.moduleManager.getAllModulePairs();
    }

    public boolean throwNoRelationship(List<IMetadata> objs, PlanningEnvironment planEnv) {
        this.readLock.lock();
        try {
            String moduleLabel = null;
            TreeSet<String> labels = new TreeSet<String>();
            for (IMetadata m : objs) {
                String qsLabel;
                if (m instanceof MoserQuerySubject) {
                    MoserModule parentModule;
                    MoserQuerySubject qs = (MoserQuerySubject)m;
                    String opName = ((RequestEnvironment)planEnv.getRequestEnvironment()).getOperationName();
                    if ("validateAll".equals(opName)) {
                        boolean bl = true;
                        return bl;
                    }
                    if (moduleLabel == null && (moduleLabel = (parentModule = qs.getParentModule()).getLabel()) == null) {
                        moduleLabel = parentModule.getIdentifier();
                    }
                    if ((qsLabel = qs.getLabel()) == null) {
                        qsLabel = qs.getName();
                    }
                } else {
                    boolean qs = false;
                    return qs;
                }
                labels.add(qsLabel);
            }
            StringBuilder sb = new StringBuilder();
            Iterator iter = labels.iterator();
            boolean isTopElement = true;
            while (iter.hasNext()) {
                if (!isTopElement) {
                    sb.append("\", \"");
                } else {
                    isTopElement = false;
                }
                sb.append((String)iter.next());
            }
            throw new XQERuntimeException(XQEMessageKeys.MSR_NoRelationship, moduleLabel, sb.toString());
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void throwQueryItemNoExpr(IMetadata queryItem) {
        this.readLock.lock();
        try {
            String moduleLabel = "";
            String qsLabel = "";
            String qiLabel = "";
            boolean needthrow = false;
            if (queryItem instanceof MoserQueryItem) {
                MoserQuerySubject qs;
                MoserQueryItem qi = (MoserQueryItem)queryItem;
                qiLabel = qi.getLabel();
                if (qiLabel == null) {
                    qiLabel = qi.getName();
                }
                if ((qs = (MoserQuerySubject)qi.getQuerySubject()) != null && !"dbQuery".equals(qs.getDefinitionType())) {
                    MoserModule parentModule;
                    qsLabel = qs.getLabel();
                    if (qsLabel == null) {
                        qsLabel = qs.getName();
                    }
                    if ((parentModule = qs.getParentModule()) != null && parentModule.getModuleType() != IMoserModule.ModuleType.PHYSICAL && qs.getClassifier() != QsClassifierType.OPERATION_QUERY_SUBJECT) {
                        needthrow = true;
                        moduleLabel = parentModule.getLabel();
                        if (moduleLabel == null) {
                            moduleLabel = parentModule.getIdentifier();
                        }
                    }
                }
            }
            if (needthrow) {
                throw new XQERuntimeException(XQEMessageKeys.MSR_QueryItemNoExpr, (Object)qiLabel, (Object)qsLabel, (Object)moduleLabel);
            }
        }
        finally {
            this.readLock.unlock();
        }
    }

    public void throwCalculationNoExpr(IMetadata calc) {
        this.readLock.lock();
        try {
            String moduleLabel = "";
            String calcLabel = "";
            if (calc instanceof MoserCalculation) {
                MoserModule parentModule;
                MoserCalculation c = (MoserCalculation)calc;
                calcLabel = c.getLabel();
                if (calcLabel == null) {
                    calcLabel = c.getName();
                }
                if ((parentModule = c.getParentModule()) != null && (moduleLabel = parentModule.getLabel()) == null) {
                    moduleLabel = parentModule.getIdentifier();
                }
            }
            throw new XQERuntimeException(XQEMessageKeys.MSR_CalculationNoExpr, calcLabel, moduleLabel);
        }
        catch (Throwable throwable) {
            this.readLock.unlock();
            throw throwable;
        }
    }

    protected void addNagMessage(String nagMessage) {
        this.nagMessages.add(nagMessage);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void transferNags(IExecutionEnvironment execEnv) {
        this.readLock.lock();
        try {
            for (String nag : this.nagMessages) {
                execEnv.addNag(nag);
            }
        }
        finally {
            this.readLock.unlock();
        }
    }

    public Date getDatasetLastModified() {
        if (this.module instanceof MoserEmbeddedModuleWrapper) {
            return ((MoserEmbeddedModuleWrapper)this.module).srcMetadataConnection.getDatasetLastModified();
        }
        this.readLock.lock();
        try {
            Date date = this.moduleManager.getDatasetLastModified();
            return date;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public MoserModuleManager getModuleManager() {
        return this.moduleManager;
    }

    public String getPackageDataCacheExpiry(MetadataConnection mfwMetadataConnection) {
        if (mfwMetadataConnection instanceof MFWMetadataConnection) {
            return ((MFWMetadataConnection)mfwMetadataConnection).getDataCacheExpiry();
        }
        return null;
    }

    public void addPackage(String alias, String packageSearchPath, String dataCacheExpiry, HashMap useSpec, MoserEnv env) {
        Pair p = this.mPackages.get(alias);
        if (p == null) {
            boolean forceMetadataRefresh = true;
            boolean reuseCachedConnection = true;
            boolean metadataRequest = false;
            boolean[] connectionOptions = MetadataService.getConnectionOptions(this.mForceCMTrusted, forceMetadataRefresh, metadataRequest);
            MFWRequestContext requestContext = MetadataService.getRequestContext(env.getExecutionEnvironment(), this.mContentLocale, this.mProductLocale, this.theConnectionPassport, connectionOptions);
            MetadataConnection mc = MetadataService.getInstance().getConnection("MFW4J", packageSearchPath, this.mExpressionLocale, env.getExecutionEnvironment(), reuseCachedConnection, requestContext);
            if (dataCacheExpiry != null) {
                ((MFWMetadataConnection)mc).setDataCacheExpiry(dataCacheExpiry);
            }
            mc.getModelDataSources();
            this.mPackages.put(alias, new Pair(mc, useSpec));
        }
    }

    public MoserQuerySubject createDynamicSQS(String baseName) {
        MoserQuerySubject dynamicSQS = this.createQS(baseName, IQuerySubject.QuerySubjectUsageEnum.SUMMARY_QUERY, "dynamicSQS_");
        dynamicSQS.setDynamicSQS(true);
        return dynamicSQS;
    }

    public MoserQuerySubject createQS(String baseName, IQuerySubject.QuerySubjectUsageEnum usage, String namePrefix) {
        long id = this.getNextId();
        String qsName = namePrefix + baseName + id;
        MoserQuerySubject qs = new MoserQuerySubject(id, usage, qsName);
        qs.setIsHidden(true);
        qs.setDefinitionType("modelQuery");
        qs.setQuerySubjectType(IQuerySubject.QuerySubjectTypeEnum.MODELQUERYSUBJECT);
        qs.setUniqueID(this.module.getUniqueName() + "." + qs.getName());
        qs.setV5UniqueName(UniqueNameGenerator.createEscapedUniqueName(this.module.getUniqueName(), qs.getName()));
        qs.setParentModule(this.module);
        qs.setGeneratedSQLOption("minimized");
        this.module.addQuerySubject(qs);
        return qs;
    }

    public long getNextId() {
        if (this.moduleManager == null) {
            return -1L;
        }
        return this.moduleManager.getNextId();
    }

    public boolean hasFMPackage() {
        if (this.module instanceof MoserEmbeddedModuleWrapper) {
            return ((MoserEmbeddedModuleWrapper)this.module).srcMetadataConnection.hasFMPackage();
        }
        return !this.mPackages.isEmpty();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void addPackageForLWOLAP(String useSpecAlias, IMoserModule baseModule, String userPassport, HashMap useSpec, MoserEnv env) {
        List<ModuleIdPair> imports = ((MoserModule)baseModule).getImports();
        MoserModuleManager mm = this.getModuleManager();
        IMoserModule physModule = mm.getExistModuleWrapper(imports.get(0), userPassport);
        if (physModule == null) {
            return;
        }
        MoserDataSource ds = ((MoserModule)physModule).getDataSources().get(0);
        String modelPath = null;
        try {
            modelPath = MoserOlapPackageGenerator.writePackageContentToTempFile(ds.getInterface(), ds.getCMDataSourceName(), ds.getCatalog().getName(), ds.getSchema(), this.mContentLocale, this.mExpressionLocale);
            this.addPackage(useSpecAlias, modelPath, null, useSpec, env);
            if (modelPath == null) return;
        }
        catch (IOException e) {
            try {
                throw new XQERuntimeException(e);
            }
            catch (Throwable throwable) {
                if (modelPath == null) throw throwable;
                TempFileUtil.deleteTempFile(modelPath);
                throw throwable;
            }
        }
        TempFileUtil.deleteTempFile(modelPath);
        return;
    }

    public MetadataConnection getLWOLAPModulePackageConnection() {
        if (this.module instanceof MoserEmbeddedModuleWrapper) {
            return ((MoserEmbeddedModuleWrapper)this.module).srcMetadataConnection.getLWOLAPModulePackageConnection();
        }
        if (this.mPackages != null && !this.mPackages.isEmpty()) {
            return (MetadataConnection)this.mPackages.values().iterator().next().getFirst();
        }
        return null;
    }

    public String getAliasMFWMetadataConnection(MetadataConnection mc) {
        if (this.module instanceof MoserEmbeddedModuleWrapper) {
            return ((MoserEmbeddedModuleWrapper)this.module).srcMetadataConnection.getAliasMFWMetadataConnection(mc);
        }
        if (mc == null) {
            return null;
        }
        for (Map.Entry<String, Pair> entry : this.mPackages.entrySet()) {
            Pair p = entry.getValue();
            MetadataConnection fmMc = (MetadataConnection)p.getFirst();
            if (!mc.equals(fmMc) || this.usedInEmbeddedModule((HashMap)p.getSecond())) continue;
            return entry.getKey();
        }
        return null;
    }

    public boolean usedInEmbeddedModule(HashMap useSpec) {
        if (useSpec == null) {
            return false;
        }
        return "*".equals(useSpec.get("imports"));
    }

    public String getExpressionOverride(String contextId) {
        if (contextId.equals(this.mContextIdentifier)) {
            return this.mExpressionToValidate;
        }
        return null;
    }

    public void setExpressionOverride(String objId, String expr) {
        this.mContextIdentifier = objId;
        this.mExpressionToValidate = expr;
    }

    public Locale getModuleExpressionLocale() {
        if (this.module != null) {
            return this.module.getExpressionLocale();
        }
        return null;
    }

    public String generateTopLevelObjectID(String name) {
        if (this.module != null) {
            return this.module.generateTopLevelObjectID(name);
        }
        return name;
    }

    public Map<String, Pair> getPackages() {
        if (this.module instanceof MoserEmbeddedModuleWrapper) {
            return ((MoserEmbeddedModuleWrapper)this.module).srcMetadataConnection.getPackages();
        }
        return new TreeMap<String, Pair>(this.mPackages);
    }

    @Override
    public String getID(IMetadata metadata) {
        return this.getNamePrependedWithAlias(metadata, metadata.getID());
    }

    @Override
    public String getV5UniqueName(IMetadata metadata) {
        return this.getNamePrependedWithAlias(metadata, metadata.getV5UniqueName());
    }

    private String getNamePrependedWithAlias(IMetadata metadata, String name) {
        if (this.module instanceof MoserEmbeddedModuleWrapper) {
            return ((MoserEmbeddedModuleWrapper)this.module).srcMetadataConnection.getNamePrependedWithAlias(metadata, name);
        }
        if (metadata.getConnection() instanceof MoserMetadataConnection) {
            return name;
        }
        if (metadata.getConnection() == null) {
            if (metadata instanceof DMRelationship) {
                String alias;
                DMRelationship join = (DMRelationship)metadata;
                IMetadata left = join.getLeftRefObject();
                IMetadata right = join.getRightRefObject();
                if (left.getConnection() == right.getConnection() && left.getConnection() != null && (alias = this.getAliasMFWMetadataConnection(left.getConnection())) != null && !alias.isEmpty()) {
                    StringBuffer buff = new StringBuffer();
                    buff.append(UniqueNameGenerator.createUniqueName(alias)).append(".").append(name);
                    return buff.toString();
                }
            }
            return name;
        }
        String alias = this.getAliasMFWMetadataConnection(metadata.getConnection());
        if (alias == null || alias.isEmpty()) {
            return name;
        }
        StringBuffer buff = new StringBuffer();
        buff.append(UniqueNameGenerator.createUniqueName(alias)).append(".").append(name);
        return buff.toString();
    }

    public List<IMoserModule> getModuleForReport() {
        if (this.module instanceof MoserEmbeddedModuleWrapper) {
            return ((MoserEmbeddedModuleWrapper)this.module).srcMetadataConnection.getModuleForReport();
        }
        ArrayList<IMoserModule> rt = new ArrayList<IMoserModule>();
        if (this.module == null || this.moduleManager == null) {
            return rt;
        }
        TreeSet<ModuleIdPair> imports = this.module.getImportModules();
        for (ModuleIdPair id : imports) {
            IMoserModule m = this.moduleManager.getExistModuleWrapper(id, this.theConnectionPassport);
            if (m == null || IMoserModule.ModuleType.REPORT != m.getModuleType()) continue;
            if ("ES".equals(id.getAlias())) {
                rt.add(m);
                return rt;
            }
            return rt;
        }
        return rt;
    }

    public String tryToGetPhysicalSource(MoserQuerySubject querySubject) {
        if (this.module instanceof MoserEmbeddedModuleWrapper) {
            return ((MoserEmbeddedModuleWrapper)this.module).srcMetadataConnection.tryToGetPhysicalSource(querySubject);
        }
        MoserModule parentModule = querySubject.getParentModule();
        if (parentModule == null) {
            return this.getModelPath();
        }
        HashSet<String> sources = new HashSet<String>();
        HashSet<String> visited = new HashSet<String>();
        this.getQuerySubjectSources(querySubject, sources, visited);
        if (sources.isEmpty() || sources.size() > 1) {
            return this.getModelPath();
        }
        return (String)sources.iterator().next();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getQuerySubjectSources(MoserQuerySubject querySubject, Set<String> sources, Set<String> visited) {
        if (visited.contains(querySubject.getID())) {
            return;
        }
        try {
            List<IQuerySubject> qsSources;
            visited.add(querySubject.getID());
            MoserModule parentModule = querySubject.getParentModule();
            if (parentModule != null && IMoserModule.ModuleType.PHYSICAL == parentModule.getModuleType()) {
                this.getSourcesFromPhysicalModule(parentModule, sources);
                return;
            }
            String sqlSource = querySubject.getTypeInSQLSource();
            if (sqlSource != null) {
                List<IModelDataSource> modelDSs = parentModule.getMetadataConnection().getModelDataSources();
                for (IModelDataSource modelDS : modelDSs) {
                    if (!sqlSource.equals(modelDS.getCMDataSourceName())) continue;
                    sources.add(sqlSource);
                    return;
                }
            }
            if ((qsSources = querySubject.getSourceQuerySubject()) != null && qsSources.size() > 0) {
                this.getSourcesFromSourcesQuerySubjects(querySubject, sources, visited);
                return;
            }
            if (querySubject.getRefs() == null) {
                return;
            }
            for (String ref : querySubject.getRefs()) {
                IMetadata refQS;
                block20: {
                    block19: {
                        String[] nameParts = ref.split("\\.");
                        if (nameParts == null || nameParts.length == 0) continue;
                        refQS = null;
                        if (nameParts == null || nameParts.length <= 1) break block19;
                        String[] rtRef = new String[]{null};
                        MoserModule childModule = (MoserModule)MoserModuleUtil.getImportModuleByAlias(parentModule, nameParts, this.theConnectionPassport, this.cookies, rtRef, new MoserEnv());
                        if (childModule != null) {
                            refQS = childModule.getQuerySubjectInThis(nameParts[1]);
                        }
                        if (refQS != null) break block20;
                        refQS = parentModule.getMetadataConnection().bindMetadataReference(ref);
                        break block20;
                    }
                    refQS = parentModule.getQuerySubjectInThis(ref);
                    if (refQS == null || visited.contains(refQS.getID())) {
                        for (ModuleIdPair id : parentModule.getImports()) {
                            MoserModule childModule = (MoserModule)this.module.getMetadataConnection().getModule(id, this.theConnectionPassport, this.cookies, new MoserEnv());
                            if (childModule == null || (refQS = childModule.getQuerySubjectInThis(ref)) == null) continue;
                            break;
                        }
                    }
                }
                if (refQS == null) continue;
                if (refQS instanceof MoserQuerySubject) {
                    this.getQuerySubjectSources((MoserQuerySubject)refQS, sources, visited);
                    continue;
                }
                if (!(refQS instanceof IQuerySubject) && !(refQS instanceof IShortcut)) continue;
                sources.add(refQS.getConnection().getModelPath());
            }
        }
        finally {
            visited.remove(querySubject.getID());
        }
    }

    private void getSourcesFromPhysicalModule(MoserModule physicalModule, Set<String> sources) {
        if (physicalModule.getDataSources() != null) {
            for (MoserDataSource ds : physicalModule.getDataSources()) {
                if (ds == null) continue;
                if (this.isPQDataSource(ds.getInterface())) {
                    sources.add("PARQUET_as_one_DS");
                    continue;
                }
                sources.add(ds.getCMDataSourceName());
            }
        }
    }

    protected boolean isPQDataSource(String tp) {
        return "PARQUET".equals(tp) || "FLINT".equals(tp);
    }

    private void getSourcesFromSourcesQuerySubjects(MoserQuerySubject querySubject, Set<String> sources, Set<String> visited) {
        List<IQuerySubject> qsSources = querySubject.getSourceQuerySubject();
        if (qsSources == null) {
            return;
        }
        for (IQuerySubject sourceQS : qsSources) {
            MetadataConnection srcMDConnection = sourceQS.getConnection();
            if (srcMDConnection instanceof MoserMetadataConnection) {
                this.getQuerySubjectSources((MoserQuerySubject)sourceQS, sources, visited);
                continue;
            }
            sources.add(srcMDConnection.getModelPath());
        }
    }

    @Override
    public String getJoinGraph() {
        return this.mJoinGraph;
    }

    @Override
    public void setJoinGraph(String joinGraph) {
        this.mJoinGraph = joinGraph;
    }

    public void deregister() {
        if (!MoserModuleUtil.isSessionTempID(this.modulePath) && this.moduleReader.is304Capable() && this.module != null) {
            MoserModuleIsStaleChecker.getInstance().deregisterConnection(this, this.modulePath, this.getModule().getCacheKey());
        }
    }

    public void setTopModule(MoserModule topModule) {
        this.module = topModule;
    }

    protected void appendEmbeddedFilter(MoserQuerySubject qs, List<IEmbeddedFilter> rt) {
        if (this.module instanceof MoserEmbeddedModuleWrapper) {
            ((MoserEmbeddedModuleWrapper)this.module).appendEmbeddedFilter(qs, rt);
        }
    }

    protected void appendQueryItem(MoserQuerySubject qs, List<IMetadata> rt) {
        if (this.module instanceof MoserEmbeddedModuleWrapper) {
            ((MoserEmbeddedModuleWrapper)this.module).appendQueryItem(qs, rt);
        }
    }

    protected String getPropertyOverride(String defaultV, MoserQueryItem qi, String propName) {
        if (this.module instanceof MoserEmbeddedModuleWrapper) {
            return ((MoserEmbeddedModuleWrapper)this.module).getPropertyOverride(defaultV, qi, propName);
        }
        return defaultV;
    }

    protected IFacet getFacetOverride(IFacet defaultFacet, MoserQueryItem qi) {
        if (this.module instanceof MoserEmbeddedModuleWrapper) {
            return ((MoserEmbeddedModuleWrapper)this.module).getFacetOverride(defaultFacet, qi);
        }
        return defaultFacet;
    }

    public long getLifeTime() {
        return this.lifetime;
    }
}

