/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqemoser;

import com.cognos.xqe.ast.sql.parser.ParseException;
import com.cognos.xqe.ast.sql.parser.SQLProcessor;
import com.cognos.xqe.bibushandler.RequestEnvironment;
import com.cognos.xqe.bibushandler.XQEService;
import com.cognos.xqe.config.ConfigService;
import com.cognos.xqe.config.ServiceEnumeration;
import com.cognos.xqe.config.XQEConfiguration;
import com.cognos.xqe.config.XQEConfigurationManager;
import com.cognos.xqe.data.model.IDataSource;
import com.cognos.xqe.data.model.LogonFailureException;
import com.cognos.xqe.data.model.ProviderException;
import com.cognos.xqe.data.providers.DataSourceTypeEnum;
import com.cognos.xqe.data.providers.IDataProvider;
import com.cognos.xqe.data.providers.ProviderManager;
import com.cognos.xqe.data.providers.SimpleDataSource;
import com.cognos.xqe.data.providers.SimpleDataSourceConnection;
import com.cognos.xqe.data.providers.connection.parameters.DataSourceParameter;
import com.cognos.xqe.data.types.DataTypeFactory;
import com.cognos.xqe.data.types.IDataType;
import com.cognos.xqe.data.types.IntervalType;
import com.cognos.xqe.data.types.RowType;
import com.cognos.xqe.exception.XQEException;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQEMessages;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.metadata.IDeterminant;
import com.cognos.xqe.metadata.IFacet;
import com.cognos.xqe.metadata.IMetadata;
import com.cognos.xqe.metadata.IQueryItem;
import com.cognos.xqe.metadata.IQuerySubject;
import com.cognos.xqe.metadata.IRelationship;
import com.cognos.xqe.metadata.ISecurityObject;
import com.cognos.xqe.metadata.ISortItem;
import com.cognos.xqe.metadata.MetadataConstants;
import com.cognos.xqe.metadata.MetadataUtil;
import com.cognos.xqe.metadata.RoleTypeEnum;
import com.cognos.xqe.metadata.provider.MetadataConnection;
import com.cognos.xqe.metadata.provider.MetadataService;
import com.cognos.xqe.pool.connection.ConnectionParameters;
import com.cognos.xqe.pool.connection.IPooledConnection;
import com.cognos.xqe.query.engine.ExecutionEnvironment;
import com.cognos.xqe.query.engine.IExecutionEnvironment;
import com.cognos.xqe.runtree.relational.dataset.parquet.ParquetDatasetReadSupport;
import com.cognos.xqe.source.AbstractSource;
import com.cognos.xqe.source.BaseModuleSource;
import com.cognos.xqe.source.DataSet2Source;
import com.cognos.xqe.source.DatasourceSource;
import com.cognos.xqe.source.ModuleSource;
import com.cognos.xqe.source.UploadedFileSource;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.trace.OperationEnum;
import com.cognos.xqe.transformation.v5tocogsql.util.joinRefinement.RQPJoinPathFinder;
import com.cognos.xqe.util.Pair;
import com.cognos.xqe.util.StringSubstitutionEngine;
import com.cognos.xqe.util.UniqueNameGenerator;
import com.cognos.xqe.util.UniqueNameParser;
import com.cognos.xqe.util.context.ExecutionEnvironmentContext;
import com.cognos.xqe.util.datasets.DatasetManager;
import com.cognos.xqe.util.datasets.FlintServerManager;
import com.cognos.xqe.util.datasets.FlintServerManagerConfig;
import com.cognos.xqe.util.datasets.FlintUtils;
import com.cognos.xqe.util.datasets.IDatasetManager;
import com.cognos.xqe.util.datasets.IFlintServerManager;
import com.cognos.xqe.util.datasets.IFlintServerManagerConfig;
import com.cognos.xqe.util.datasets.MetadataInfo;
import com.cognos.xqe.util.eviction.ConcurrentSimpleDLinkLRUMap;
import com.cognos.xqe.util.primitive.ArrayListInt;
import com.cognos.xqemoser.ContentServiceClient;
import com.cognos.xqemoser.HTTPClientResponse;
import com.cognos.xqemoser.IMoserModule;
import com.cognos.xqemoser.JDBCStringBuilder;
import com.cognos.xqemoser.ModuleIdPair;
import com.cognos.xqemoser.MoserBaseMetadata;
import com.cognos.xqemoser.MoserCacheCleanupRunnable;
import com.cognos.xqemoser.MoserCalculation;
import com.cognos.xqemoser.MoserCatalog;
import com.cognos.xqemoser.MoserCube;
import com.cognos.xqemoser.MoserDataSource;
import com.cognos.xqemoser.MoserDimension;
import com.cognos.xqemoser.MoserEmbeddedFilter;
import com.cognos.xqemoser.MoserEmbeddedModuleWrapper;
import com.cognos.xqemoser.MoserEnv;
import com.cognos.xqemoser.MoserFacet;
import com.cognos.xqemoser.MoserFilter;
import com.cognos.xqemoser.MoserHierarchy;
import com.cognos.xqemoser.MoserItemNormalization;
import com.cognos.xqemoser.MoserItemNormalizationGroup;
import com.cognos.xqemoser.MoserLevel;
import com.cognos.xqemoser.MoserMember;
import com.cognos.xqemoser.MoserMetadataConnection;
import com.cognos.xqemoser.MoserModule;
import com.cognos.xqemoser.MoserModuleManager;
import com.cognos.xqemoser.MoserModuleReader;
import com.cognos.xqemoser.MoserParameterUtil;
import com.cognos.xqemoser.MoserPhysicalColumn;
import com.cognos.xqemoser.MoserPhysicalTable;
import com.cognos.xqemoser.MoserQueryItem;
import com.cognos.xqemoser.MoserQueryItemFolder;
import com.cognos.xqemoser.MoserQueryItemOfLevel;
import com.cognos.xqemoser.MoserQuerySubject;
import com.cognos.xqemoser.MoserRelationship;
import com.cognos.xqemoser.MoserSecurityObject;
import com.cognos.xqemoser.MoserSortItem;
import com.cognos.xqemoser.ParquetsUpgradeClient;
import com.cognos.xqemoser.QsClassifierType;
import com.cognos.xqemoser.report.MoserReportUtil;
import com.cognos.xqemoser.time.MoserTimeQuerySubject;
import com.cognos.xqemoser.time.MoserTimeUtil;
import com.cognos.xqerdp.flint.FlintApiFacade;
import com.cognos.xqerdp.flint.FlintConnection;
import com.ibm.ba.flint.avro.AvroRowWriter;
import com.ibm.ba.flint.thrift.buffer.RowBufferSpec;
import com.ibm.ba.flint.thrift.core.CacheLevel;
import com.ibm.ba.flint.thrift.dataset.AnalyzeOptions;
import com.ibm.ba.flint.thrift.dataset.CacheOptions;
import com.ibm.ba.flint.thrift.dataset.DatasetSpec;
import com.ibm.ba.flint.thrift.dataset.NoSuchDatasetException;
import com.ibm.ba.flint.thrift.sinks.AnySink;
import com.ibm.ba.flint.thrift.sinks.ConflictAction;
import com.ibm.ba.flint.thrift.sinks.FileSink;
import com.ibm.ba.flint.thrift.sinks.SaveOptions;
import com.ibm.ba.flint.thrift.sources.AnySource;
import com.ibm.ba.flint.thrift.sources.ParquetSource;
import com.ibm.ba.flint.thrift.types.Schema;
import com.ibm.bi.org.apache.hadoop.io.CryptoProvider;
import com.ibm.bi.platform.datasetutils.parquet.DatasetParquetReadHelper;
import com.ibm.bi.platform.datasetutils.parquet.ParquetVersionEnum;
import com.ibm.bi.platform.moser.common.utils.FormatConverter;
import com.ibm.bi.platform.moser.common.utils.ItemScanner;
import com.ibm.icu.text.DateFormat;
import com.ibm.icu.text.SimpleDateFormat;
import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import com.ibm.json.java.OrderedJSONObject;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.PrimitiveIterator;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import java.util.zip.CRC32;
import javax.crypto.Cipher;
import javax.servlet.http.HttpServletRequest;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import org.apache.avro.util.ByteBufferOutputStream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.parquet.format.converter.ParquetMetadataConverter;
import org.apache.parquet.hadoop.ParquetFileReader;
import org.apache.parquet.hadoop.ParquetReader;
import org.apache.parquet.hadoop.api.ReadSupport;
import org.apache.parquet.hadoop.metadata.FileMetaData;
import org.apache.parquet.hadoop.metadata.ParquetMetadata;
import org.apache.parquet.schema.MessageType;
import org.apache.thrift.TException;
import shaded.org.apache.hadoop.conf.Configuration;
import shaded.org.apache.hadoop.fs.FileStatus;
import shaded.org.apache.hadoop.fs.FileSystem;

public final class MoserModuleUtil {
    public static final String FLINT_ENCRYPTION_ON_VALUE = "ON";
    public static final String FLINT_ENCRYPTION_OFF_VALUE = "OFF";
    public static final String FLINT_PQV1_GEN_MSG = "New data set (%s, %s, %s).";
    public static final String FLINT_PQV1_ENCRYPTION_MSG = "Encryption is %s for data set (%s, %s, %s).";
    public static final String FLINT_PQV1_GEN_SUCCESS_MSG = "New data set (%s, %s, %s) successful.";
    public static final String FLINT_AVRO_TO_PQV1_CONVERSION_TIME_MSG = "Stream data set (%s, %s, %s) (%.3f secs).";
    public static final String FLINT_PQV0_TO_AVRO_CONVERSION_TIME_MSG = "Build data set (%s, %s, %s) (%.3f secs).";
    public static final String FLINT_PQV1_OVERALL_CONVERSION_TIME_MSG = "Total time (%s, %s, %s) (%.3f secs).";
    public static final String FLINT_PREPARE_DATASET_MSG = "Prepare data set (%s, %s, %s) (%.3f secs).";
    public static final String FLINT_TOUCH_DATASET_ERROR_MSG = "Cannot touch the flint dataset associated with the following metadata connection: (%s, %s).";
    public static final String FLINT_PQ_FILE_NOT_FOUND_ERROR_MSG = "Cannot find the parquet file associated with the flint dataset: (%s, %s).";
    public static final String FLINT_PREPARE_DATASET_ENCRYPTION_MSG = "Encryption is %s for prepared data set (%s, %s, %s).";
    public static final String FLINT_PROMOTION_FAILED_MSG = "Promoting to flint connection failed.\nReason: ";
    private static final boolean FLINT_USE_AVRO = true;
    public static final String FLINT_SERVER_ENABLED_KEY = "queryExecution.flintServer[@enabled]";
    public static final String FLINT_LAZY_CONVERSION = "queryExecution.flintServer.lazyConversion[@enabled]";
    static final String FALSE_BOOLEAN_STR = "false";
    static final String OPTION_ENCRYPTED_PAGES_FLAG = "com.ibm.ba.parquet.encrypted-pages";
    static final String OPTION_ENCRYPTED_PAGE_FLAG = "com.ibm.ba.parquet.encrypted-page-flag";
    static final String OPTION_CRYPTO_PROVIDER = "com.ibm.ba.parquet.crypto-provider";
    static final String CAM_CRYPTO_PROVIDER = "com.ibm.ba.flint.crypto.provider.JCAMCryptoProvider";
    public static final String DATE_FORMAT_PATTERN = "yyyy-MM-dd'T'HH:mm:ss.SSS'Z'";
    public static final DateFormat DATEFORMAT;
    public static final DateTimeFormatter DATETIMEFORMATTER;
    private static final int FLINT_BATCH_SIZE = 10000;
    private static final char SLASH_CHAR = '/';
    public static final String USESPEC_TYPE = "type";
    public static final String TYPE_MODULE = "module";
    public static final String TYPE_FILE = "file";
    public static final String TYPE_DATABASE = "database";
    public static final String TYPE_DATASET = "dataset";
    public static final String TYPE_LWOLAP = "lwOLAP";
    public static final String TYPE_REPORT = "report";
    private static final String DOT_BASE = ".base";
    public static final String DOT_PHYSICALMODULE = ".physicalmodule";
    protected static final String PHYSICALMODULE = "physicalmodule";
    protected static final String TRANSIENT_MODULE = "transientModule";
    public static final String COLON = ":";
    public static final String STORE_ID = "storeID";
    public static final String SEARCHPATH = "searchPath";
    public static final String MOSER_DOUBLE_QUOTE = "\"";
    public static final String MOSER_DOT = ".";
    public static final String MOSER_EMPTY_STRING = "";
    public static final String MOSER_USE = "use";
    protected static final String MOSER_USESPEC = "useSpec";
    public static final String MOSER_QS = "querySubject";
    public static final String MOSER_ID = "identifier";
    public static final String MOSER_CONTAINER = "container";
    public static final String MOSER_EXPR_LOCALE = "expressionLocale";
    public static final String MOSER_DATA_CACHE_EXPIRY = "dataCacheExpiry";
    public static final String MOSER_DATASOURCE = "dataSource";
    public static final String MOSER_NAME = "name";
    public static final String MOSER_CMDATASOURCE = "cmDataSource";
    public static final String MOSER_CONNECTION = "connection";
    public static final String MOSER_CONNECTIONSTRING = "connectionString";
    public static final String MOSER_FALLBACK_CONNECTIONSTRING = "fallbackConnectionString";
    public static final String MOSER_DBTYPE = "databaseType";
    public static final String MOSER_CATALOG = "catalog";
    public static final String MOSER_SCHEMA = "schema";
    public static final String MOSER_QUERYITEM = "queryItem";
    public static final String MOSER_USAGE = "usage";
    public static final String MOSER_QUERYSUBJECTUSAGE = "querySubjectUsage";
    public static final String MOSER_SELECTLISTCONTROL = "selectListControl";
    private static final String MOSER_GENERATESQL = "generateSQL";
    public static final String MOSER_RELATIONSHIP = "relationship";
    public static final String MOSER_CALCULATION = "calculation";
    private static final String MOSER_LEFT = "left";
    private static final String MOSER_RIGHT = "right";
    public static final String MOSER_REF = "ref";
    private static final String MOSER_MINCARD = "mincard";
    private static final String MOSER_MAXCARD = "maxcard";
    public static final String MOSER_TABLE = "table";
    public static final String MOSER_MEASUREDIMENSION = "dimension/measure";
    public static final String MOSER_REGULARDIMENSION = "dimension/regular";
    public static final String MOSER_COLUMN = "column";
    public static final String MOSER_MULTISET = "multiset";
    public static final String MOSER_STRUCT = "struct";
    public static final String MOSER_TABLEITEM = "tableItem";
    public static final String MOSER_PROPERTY = "property";
    public static final String MOSER_DATATYPE = "datatype";
    public static final String MOSER_NULLABLE = "nullable";
    public static final String MOSER_EXPRESSION = "expression";
    public static final String MOSER_REGULARAGGREGATETYPE = "regularAggregate";
    private static final String MOSER_LINK = "link";
    private static final String MOSER_LEFTREF = "leftRef";
    private static final String MOSER_RIGHTREF = "rightRef";
    public static final String MOSER_FACETDEFINITION = "facetDefinition";
    public static final String MOSER_ENABLED = "enabled";
    private static final String MOSER_TRUE = "true";
    public static final String MOSER_AUTOMATIC = "automatic";
    private static final String MOSER_SORTLIST = "sortList";
    private static final String MOSER_SORTITEM = "sortItem";
    private static final String MOSER_ORDER = "order";
    private static final String MOSER_NULLPLACEMENT = "nullPlacement";
    private static final String MOSER_FIRST = "first";
    private static final String MOSER_LAST = "last";
    protected static final String MOSER_ATTRIBUTE = "attribute";
    private static final String VARCHAR2000 = "varchar(2000)";
    public static final String STR_DB_QUERY = "dbQuery";
    public static final String STR_MODEL_QUERY = "modelQuery";
    public static final String PREFIX_PARQUET_CONNECTION_STR = ";LOCAL;PARQUET;URL=";
    private static final String MOSER_JOIN_FILTER_TYPE = "joinFilterType";
    public static final String MOSER_FILTER = "filter";
    public static final String MOSER_SECURITY_FILTER = "securityFilter";
    public static final String MOSER_SECURITY_OBJECT = "securityObject";
    protected static final String MOSER_POSTAUTOAGGREGATION = "postAutoAggregation";
    public static final String MOSER_LABEL = "label";
    public static final String MOSER_DESCRIPTION = "description";
    public static final String MOSER_SCREEN_TIP = "screenTip";
    public static final String MOSER_FORMAT = "format";
    private static final String STR_SESSION_TEMP = "_sessionTemp";
    public static final String STR_DOT_REGX = "\\.";
    private static final String BACK_SLASH = "\\";
    private static final String DATA_DESCRIPTOR = "dataDescriptor";
    private static final String DATA = "data";
    public static final String DOT_DATA = ".data";
    public static final String DOT_PARQUET = ".parquet";
    public static final String DOT_TMP = ".tmp";
    public static final String FORWARD_SLASH = "/";
    private static final String ID = "id";
    private static final String MOSER_PRIMARYKEY = "primaryKey";
    private static final String MOSER_KEYEDCOLUMN = "keyedColumn";
    public static final String MOSER_FOLDER = "folder";
    public static final String MOSER_ITEM = "item";
    public static final String MOSER_LEVEL = "level";
    public static final String MOSER_PARENTCHILDHIERARCHY = "hierarchy/parent-child";
    public static final String MOSER_LEVELHIERARCHY = "hierarchy/level";
    public static final String MOSER_SOURCE_CATEGORY = "sourceCategory";
    public static final String MOSER_REFTOHIERARCHY = "refToHierarchy";
    public static final String MOSER_IS_MULTIROOT = "hierarchyHasMultipleRoots";
    public static final String MOSER_ROOTMEMBER = "rootMember";
    public static final String MOSER_HIDDEN = "hidden";
    public static final String MOSER_AGGREGATE_MODE = "aggregateMode";
    public static final String MOSER_STATIC = "static";
    public static final String MOSER_DYNAMIC = "dynamic";
    public static final String MOSER_COUNT = "count";
    public static final String TRUE = "true";
    private static final String DEFAULT_NAME = "defaultName";
    private static final String ITEMS = "items";
    private static final String OUTPUT = "output";
    private static final String REPORT_VERSION = "reportVersion";
    private static final String MODIFICATION_TIME = "modificationTime";
    private static final String MOSER_DB_UID = "user";
    private static final String MOSER_DB_PW = "password";
    private static final String ENCRYPTION_PREFIX = "{enc}";
    private static final int ENCRYPTION_OFFSET = 5;
    private static final String MOSER_JDBC = "jdbc";
    private static final String ENCRYPTION_KEYPAIR = "keyPair";
    private static final String MOSER_JDBCURL = "jdbcUrl";
    private static final String MOSER_CSVURL = "csvUrl";
    private static final String MOSER_DRIVERCLASSNAME = "driverClassName";
    private static final String MOSER_CONNECTIONPROPERTIES = "connectionProperties";
    private static final String DS_UID = "userID";
    private static final String DS_PW = "password";
    private static final String DS_ANONYMOUS = "Anonymous";
    public static final String MOSER_QS_CLASSIFIED = "classifier";
    public static final String MOSER_DRILLGROUP = "drillGroup";
    public static final String MOSER_SEGMENT = "segment";
    public static final String MOSER_ALL = "all";
    private static final String MOSER_ITEMHIERARCHY = "itemHierarchy";
    public static final String MOSER_UNDERSCORE = "_";
    private static final String MOSER_CALCULATED_MEMBER = "calculatedMember";
    private static final String MOSER_LOCALREF = "localRef";
    public static final String MOSER_NONE = "none";
    protected static final String JMD_DT_INTERVAL_YEAR = "INTERVAL_YEAR";
    protected static final String JMD_DT_INTERVAL_YEAR_TO_MONTH = "INTERVAL_YEAR_TO_MONTH";
    protected static final String JMD_DT_INTERVAL_MONTH = "INTERVAL_MONTH";
    protected static final String JMD_DT_INTERVAL_DAY = "INTERVAL_DAY";
    protected static final String JMD_DT_INTERVAL_DAY_TO_HOUR = "INTERVAL_DAY_TO_HOUR";
    protected static final String JMD_DT_INTERVAL_DAY_TO_MINUTE = "INTERVAL_DAY_TO_MINUTE";
    protected static final String JMD_DT_INTERVAL_DAY_TO_SECOND = "INTERVAL_DAY_TO_SECOND";
    protected static final String JMD_DT_INTERVAL_HOUR = "INTERVAL_HOUR";
    protected static final String JMD_DT_INTERVAL_HOUR_TO_MINUTE = "INTERVAL_HOUR_TO_MINUTE";
    protected static final String JMD_DT_INTERVAL_HOUR_TO_SECOND = "INTERVAL_HOUR_TO_SECOND";
    protected static final String JMD_DT_INTERVAL_MINUTE = "INTERVAL_MINUTE";
    protected static final String JMD_DT_INTERVAL_MINUTE_TO_SECOND = "INTERVAL_MINUTE_TO_SECOND";
    protected static final String JMD_DT_INTERVAL_SECOND = "INTERVAL_SECOND";
    protected static final String JMD_DT_TIMESTAMP_TZ = "TIMESTAMP_TZ";
    protected static final String JMD_DT_TIME_TZ = "TIME_TZ";
    protected static final String JMD_DT_NVARCHAR_MAX = "NVARCHAR(MAX)";
    private static final String MOSER_WA_ASSETID = "wa_assetId";
    public static final String MOSER_VALUE = "value";
    public static final String MOSER_WA_CONNECTIONINFO = "connectionInfo";
    private static final String MOSER_SPACE = " ";
    private static final String MOSER_ITEM_NORMALIZATION = "itemNormalization";
    private static final String MOSER_ITEM_NORMALIZATION_GROUP = "itemNormalizationGroup";
    private static final String MOSER_ITEMREF = "itemRef";
    private static final String MOSER_PARENTGROUPREF = "parentGroupRef";
    protected static final String MOSER_USAGE_FACT = "fact";
    private static final String MOSER_KEY = "key";
    private static final String MOSER_KEYCONSTRAINT = "keyConstraint";
    private static final String MOSER_KEYUNIQUE = "unique";
    private static final String MOSER_KEYCOMPOSITION = "keyComposition";
    private static final String MOSER_KEYINDEPENDENT = "independent";
    private static final String MOSER_SQLOPERATOR = "sqlOperator";
    public static final String MOSER_DATASOURCEREF = "datasourceRef";
    public static final String MOSER_SQLTYPE = "sqlType";
    public static final String MOSER_SQLTEXT = "sqlText";
    public static final String SQLTYPE_COGNOS = "cognos";
    public static final String SQLTYPE_NATIVE = "native";
    public static final String SQLTYPE_PASSTHROUGH = "passThrough";
    public static final String MOSER_EXTERNALNAME = "externalName";
    protected static final String MOSER_PARAMETERMAP = "parameterMap";
    protected static final String MOSER_METADATATREEVIEW = "metadataTreeView";
    protected static final String MOSER_NAMEDSET = "namedSet";
    protected static final String MOSER_QUERYOPERATION = "queryOperation";
    protected static final String MOSER_JOINOPERATION = "joinOperation";
    protected static final String MOSER_QUERYREF = "queryRef";
    public static final String MOSER_ID_FOREXPRESSION = "idForExpression";
    public static final String MOSER_TARGET = "shortcutTargetQuerySubjectRef";
    public static final String MOSER_PROJECTEDITEM = "projectedItem";
    public static final String MOSER_QS_USAGE_TIME = "time";
    public static final String MOSER_SPLIT_DEFINITION = "splitDefinition";
    protected static final String MOSER_ORIGINAL_REF = "originalRef";
    protected static final String MOSER_COMPARISON_OPERATOR = "comparisonOperator";
    public static final String MOSER_EQUALTO = "equalTo";
    protected static final String MOSER_V5_EQUAL = " = ";
    public static final String MOSER_GREATERTHAN = "greaterThan";
    protected static final String MOSER_V5_GREATERTHAN = " > ";
    public static final String MOSER_LESSTHAN = "lessThan";
    protected static final String MOSER_V5_LESSTHAN = " < ";
    public static final String MOSER_GREATERTHAN_EQUALTO = "greaterThanOrEqualTo";
    protected static final String MOSER_V5_GREATERTHAN_EQUALTO = " >= ";
    public static final String MOSER_LESSTHAN_EQUALTO = "lessThanOrEqualTo";
    protected static final String MOSER_V5_LESSTHAN_EQUALTO = " <= ";
    public static final String MOSER_NOTEQUALTO = "notEqualTo";
    protected static final String MOSER_V5_NOTEQUALTO = " <> ";
    public static final String MOSER_EQUALTO_BOTHNULL = "equalToOrBothNull";
    protected static final String MOSER_V5_AND = " AND ";
    protected static final String MOSER_V5_OR = " OR ";
    protected static final String MOSER_V5_OPEN_PARENTHESIS = "(";
    protected static final String MOSER_V5_CLOSE_PARENTHESIS = ")";
    protected static final String MOSER_V5_ISNULL = " is NULL ";
    public static final String MOSER_NOTEQUALTO_ONENULL = "notEqualToOrOneNull";
    protected static final String MOSER_V5_ISNOTNULL = " is not NULL ";
    protected static final String MOSER_WKC = "wkc";
    protected static final String MOSER_WKC_CONN_NAME = "wkcConnectionName";
    protected static final String CA_ENCRYPTION_PREFIX = "{CA_enc}";
    public static final Object MOSER_CUBE;
    public static final Object MOSER_CUBE_DESCRIPTION;
    public static final Object MOSER_CUBE_IS_OPTIMIZED;
    public static final Object MOSER_DEFAULT_MEASURE;
    public static final Object MOSER_SCHEMA_UPDATED_DATE;
    public static final Object MOSER_UPDATED_DATE;
    public static final Object MOSER_CREATED_DATE;
    public static final Object MOSER_CURRENT_PERIOD;
    public static final Object PROMPT_INFO;
    public static final Object PROMPT_TYPE;
    public static final Object PROMPT_CASCADE_ON_REF;
    public static final Object PROMPT_FILTER_ITEM_REF;
    public static final Object PROMPT_DISPLAY_ITEM_REF;
    public static final Object PROMPT_USE_ITEM_REF;
    public static final String DYNAMIC_DS_XQE_CATALOG = "_XQE_catalog";
    public static final String DYNAMIC_DS_XQE_SCHEMA = "_XQE_schema";
    public static final String XQE_EMBEDDED_MODULE = "_XQE_embedded_Module";
    private static final HashSet<String> FACET_DT;
    public static final String MOSER_DS_LOGICAL_NAME = "dsLogicalName";
    private static final String STR_CONNECTION_STRING = "connectionString";
    private static final String STR_LAST_MODIFIED = "lastModified";
    public static final String STR_VERSION = "version";
    private static final String PQ_VERSION_KEY = "parquet.version";
    private static final String STR_PARQUET_PATH = "parquet_file_path";
    private static final int DEFAULT_MAX_TMP_AGE;
    private static final int DEFAULT_FLINT_DATASET_IDLE_SECONDS_VALUE;
    private static final int MAX_FLINT_DATASET_IDLE_SECONDS_VALUE;
    private static final int MIN_FLINT_DATASET_IDLE_SECONDS_VALUE;
    public static final String STR_NUMROWS = "numRows";
    private static volatile ScheduledFuture<?> scheduledCacheCleanup;
    private static final Object cleanupLock;
    public static final String TYPE_PACKAGE = "package";
    private static final int DEFAULT_LOCK_SIZE = 500;
    private static ConcurrentSimpleDLinkLRUMap<String, Object> sidLOCK;
    protected static int maxTmpAge;
    private static final Pattern XSD_DATE_TIME_PATTERN;
    private static final XQEConfiguration CONFIG;
    private static final String SET_OPERATION_PROP = "setOperation";
    private static final String DUPLICATES_PROP = "duplicates";
    private static DatatypeFactory datatypeFactory;

    private MoserModuleUtil() {
    }

    public static String normalizeName(String name) {
        String[] parts = UniqueNameParser.parseNoThrow(name);
        if (parts == null) {
            return name;
        }
        return MoserModuleUtil.buildNameFromParts(parts);
    }

    protected static String buildNameFromParts(String[] parts) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < parts.length; ++i) {
            if (i > 0) {
                sb.append(MOSER_DOT);
            }
            sb.append(parts[i]);
        }
        return sb.toString();
    }

    public static boolean isSessionTempID(String moduleId) {
        return moduleId != null && MoserModuleUtil.extractStoreIDPrefix(moduleId).endsWith(STR_SESSION_TEMP);
    }

    public static String extractStoreIDPrefix(String moduleId) {
        if (moduleId.startsWith("storeID(")) {
            moduleId = moduleId.replaceFirst("storeID\\(\"", MOSER_EMPTY_STRING);
            moduleId = moduleId.replaceFirst("\"\\)", MOSER_EMPTY_STRING);
        }
        return moduleId;
    }

    private static boolean notEmptyArray(JSONArray a) {
        return a != null && !a.isEmpty();
    }

    public static IMoserModule loadMoserModule(MoserMetadataConnection metadataConnection, String moduleId, JSONObject jObj, String userPassport, Map<String, String> cookiesToMoser, JSONObject moduleInfo, boolean bTop, MoserEnv env, FormatConverter fc) {
        MoserModule module = new MoserModule(metadataConnection);
        module.setModuleInfo(moduleInfo);
        module.setModificationTime(metadataConnection.getModuleManager().getLastModified());
        module.setUniqueName(moduleId);
        JSONArray relationships = null;
        JSONArray calculations = null;
        JSONArray filters = null;
        String label = null;
        JSONArray uses = (JSONArray)jObj.get((Object)MOSER_USE);
        JSONArray useSpecs = (JSONArray)jObj.get((Object)MOSER_USESPEC);
        JSONArray dataSources = (JSONArray)jObj.get((Object)MOSER_DATASOURCE);
        JSONArray querySubjects = (JSONArray)jObj.get((Object)MOSER_QS);
        JSONArray parameterMaps = (JSONArray)jObj.get((Object)MOSER_PARAMETERMAP);
        String waAssetId = null;
        JSONArray moduleProps = (JSONArray)jObj.get((Object)MOSER_PROPERTY);
        if (MoserModuleUtil.notEmptyArray(moduleProps)) {
            block8: for (int i = 0; i < moduleProps.size(); ++i) {
                String propName;
                JSONObject prop = (JSONObject)moduleProps.get(i);
                switch (propName = (String)prop.get((Object)MOSER_NAME)) {
                    case "wa_assetId": {
                        waAssetId = (String)prop.get((Object)MOSER_VALUE);
                        continue block8;
                    }
                    case "_XQE_embedded_Module": {
                        module.properties.put(propName, prop.get((Object)MOSER_VALUE));
                        continue block8;
                    }
                }
            }
        }
        if (MoserModuleUtil.notEmptyArray(useSpecs)) {
            MoserModuleUtil.processUseSpecs(moduleId, module, useSpecs, userPassport, cookiesToMoser, env);
            if (MoserEmbeddedModuleWrapper.getSourceModuleIdForUnResolvedEmbeddedModule(module) != null) {
                module.setModuleType(IMoserModule.ModuleType.EMBEDDED);
            }
        } else if (MoserModuleUtil.notEmptyArray(uses)) {
            MoserModuleUtil.processUse(moduleId, module, uses, userPassport, cookiesToMoser, env);
            module.setModuleType(IMoserModule.ModuleType.BASE);
        } else if (MoserModuleUtil.notEmptyArray(querySubjects) && MoserModuleUtil.notEmptyArray(dataSources)) {
            jObj.remove((Object)MOSER_DATASOURCE);
            JSONObject jPhysicalModule = new JSONObject();
            jPhysicalModule.put((Object)MOSER_CONTAINER, (Object)TRANSIENT_MODULE);
            jPhysicalModule.put((Object)MOSER_ID, (Object)PHYSICALMODULE);
            String lb = (String)jObj.get((Object)MOSER_LABEL);
            if (lb != null) {
                jPhysicalModule.put((Object)MOSER_LABEL, (Object)lb);
            }
            if (waAssetId != null) {
                JSONArray jProps = new JSONArray();
                JSONObject jProp = new JSONObject();
                jProp.put((Object)MOSER_NAME, (Object)MOSER_WA_ASSETID);
                jProp.put((Object)MOSER_VALUE, (Object)waAssetId);
                jProps.add((Object)jProp);
                jPhysicalModule.put((Object)MOSER_PROPERTY, (Object)jProps);
            }
            if (MoserModuleUtil.notEmptyArray(moduleProps)) {
                jPhysicalModule.put((Object)MOSER_PROPERTY, (Object)moduleProps);
            }
            jPhysicalModule.put((Object)MOSER_DATASOURCE, (Object)dataSources);
            dataSources = null;
            MoserModuleUtil.processPhysical(moduleId, module, jPhysicalModule, userPassport, cookiesToMoser, env);
            module.setModuleType(IMoserModule.ModuleType.BASE);
        }
        for (Object k : jObj.keySet()) {
            String kName = (String)k;
            Object v = jObj.get(k);
            if (v == null) continue;
            if (kName.equals(MOSER_ID)) {
                module.setIdentifier((String)v);
                continue;
            }
            if (kName.equals(MOSER_CONTAINER)) {
                module.setContainer((String)v);
                continue;
            }
            if (kName.equals(MOSER_EXPR_LOCALE)) {
                module.setExpressionLocale((String)v);
                continue;
            }
            if (kName.equals(MOSER_RELATIONSHIP)) {
                relationships = (JSONArray)v;
                continue;
            }
            if (kName.equals(MOSER_CALCULATION)) {
                calculations = (JSONArray)v;
                continue;
            }
            if (kName.equals(MOSER_FILTER)) {
                filters = (JSONArray)v;
                continue;
            }
            if (!kName.equals(MOSER_LABEL)) continue;
            label = (String)v;
        }
        if (label != null) {
            module.setLabel(label);
        }
        if (MoserModuleUtil.notEmptyArray(dataSources)) {
            MoserModuleUtil.processDataSource(moduleId, module, dataSources, userPassport, cookiesToMoser, waAssetId, jObj, env);
        }
        ArrayList<ExpressionResolveContext> objectToResolve = new ArrayList<ExpressionResolveContext>();
        if (MoserModuleUtil.notEmptyArray(querySubjects)) {
            MoserModuleUtil.processQuerySubject(module, querySubjects, userPassport, objectToResolve, cookiesToMoser, bTop, env, fc);
        }
        if (MoserModuleUtil.notEmptyArray(relationships)) {
            MoserModuleUtil.processRelationship(module, relationships);
        }
        if (MoserModuleUtil.notEmptyArray(calculations)) {
            MoserModuleUtil.processCalculations(module, calculations, objectToResolve, fc, bTop, env, userPassport, cookiesToMoser);
        }
        if (MoserModuleUtil.notEmptyArray(filters)) {
            MoserModuleUtil.processFilters(module, filters, objectToResolve);
        }
        if (MoserModuleUtil.notEmptyArray(parameterMaps)) {
            MoserModuleUtil.processParameterMaps(module, parameterMaps);
        }
        MoserModuleUtil.postResolve(metadataConnection, objectToResolve, bTop, env);
        if (MoserModuleManager.loggingEnabled()) {
            MoserModuleManager.log(LogLevel.INFO, module.toString());
        }
        module.setCacheKey((String)jObj.get((Object)"cacheKey"));
        if (bTop) {
            for (Object aO : jObj.keySet()) {
                JSONArray lst;
                String kName = (String)aO;
                Object v = jObj.get(aO);
                if (v == null || !kName.equals(MOSER_QS) && !kName.equals(MOSER_FILTER) && !kName.equals(MOSER_CALCULATION) && !kName.equals(MOSER_RELATIONSHIP) && !kName.equals(MOSER_PARAMETERMAP) && !kName.equals(MOSER_METADATATREEVIEW) && !kName.equals(MOSER_DRILLGROUP) && !kName.equals(MOSER_NAMEDSET) || !MoserModuleUtil.notEmptyArray(lst = (JSONArray)v)) continue;
                for (int i = 0; i < lst.size(); ++i) {
                    JSONObject aTop = (JSONObject)lst.get(i);
                    String aID = (String)aTop.get((Object)MOSER_ID);
                    if (aID == null) continue;
                    module.allTopObjId.add(aID);
                }
            }
        }
        MoserParameterUtil.loadParameters(jObj, module);
        return module;
    }

    private static String getCRC32(String str) {
        CRC32 crc = new CRC32();
        crc.update(str.getBytes());
        return Long.toString(crc.getValue());
    }

    protected static String convertJSONFormatToXMLFormat(FormatConverter fc, String jFormat, Locale exprLC) {
        block5: {
            if (jFormat == null || jFormat.isEmpty()) {
                return null;
            }
            try {
                String xmlFormat;
                String sExprLC = null;
                if (exprLC != null) {
                    sExprLC = exprLC.toString();
                }
                if ((xmlFormat = fc.revertAndAddXMLLang(jFormat, sExprLC)) != null && !xmlFormat.isEmpty()) {
                    return StringEscapeUtils.escapeXml((String)xmlFormat);
                }
            }
            catch (Exception e) {
                if (!MoserModuleManager.loggingEnabled()) break block5;
                MoserModuleManager.log(LogLevel.TRACE, e.getLocalizedMessage());
            }
        }
        return null;
    }

    protected static void processCalculations(MoserModule module, JSONArray calculations, List<ExpressionResolveContext> objectToResolve, FormatConverter fc, boolean bTop, MoserEnv env, String userPassport, Map<String, String> cookiesToMoser) {
        if (MoserModuleManager.loggingEnabled()) {
            MoserModuleManager.log(LogLevel.TRACE, "processCalculations of moduleId=" + module.getIdentifier());
        }
        for (int i = 0; i < calculations.size(); ++i) {
            JSONArray items;
            String xmlFormat;
            JSONObject calculation = (JSONObject)calculations.get(i);
            String name = (String)calculation.get((Object)MOSER_ID);
            String expr = (String)calculation.get((Object)MOSER_EXPRESSION);
            String regAgg = (String)calculation.get((Object)MOSER_REGULARAGGREGATETYPE);
            String label = (String)calculation.get((Object)MOSER_LABEL);
            String formatStr = (String)calculation.get((Object)MOSER_FORMAT);
            MoserCalculation calc = new MoserCalculation(module.getMetadataConnection().getNextId(), name, i);
            calc.setParentModule(module);
            module.addCalculation(calc);
            calc.setDefaultLocale(module.getExpressionLocale());
            calc.setUniqueID(module.getUniqueName() + MOSER_DOT + calc.getName());
            calc.setV5UniqueName(UniqueNameGenerator.createEscapedUniqueName(module.getUniqueName(), calc.getName()));
            calc.setExpression(expr);
            if (regAgg != null) {
                calc.setRegularAggregate(regAgg);
            }
            if (label != null) {
                calc.setLabel(label);
            }
            if ((xmlFormat = MoserModuleUtil.convertJSONFormatToXMLFormat(fc, formatStr, module.getExpressionLocale())) != null && !xmlFormat.isEmpty()) {
                calc.format = xmlFormat;
            }
            module.registerExpressionObject(calc.getUniqueID(), calc);
            if (objectToResolve != null) {
                ExpressionResolveContext o = new ExpressionResolveContext();
                o.objResolve = calc;
                o.moserModule = module;
                objectToResolve.add(o);
            }
            if (!MoserModuleUtil.notEmptyArray(items = (JSONArray)calculation.get((Object)MOSER_ITEM))) continue;
            DeterminantDef det = new DeterminantDef();
            det.bStop = false;
            det.userPassport = userPassport;
            det.cookiesToMoser = cookiesToMoser;
            MoserModuleUtil.processItem(module, null, items, objectToResolve, det, bTop, calc, env, fc);
        }
    }

    protected static void processFilters(MoserModule module, JSONArray filters, List<ExpressionResolveContext> objectToResolve) {
        if (MoserModuleManager.loggingEnabled()) {
            MoserModuleManager.log(LogLevel.TRACE, "processFilters of moduleId=" + module.getIdentifier());
        }
        int filterPos = 0;
        for (Object f : filters) {
            JSONObject filt = (JSONObject)f;
            String name = (String)filt.get((Object)MOSER_ID);
            String expr = (String)filt.get((Object)MOSER_EXPRESSION);
            MoserFilter filter = new MoserFilter(module.getMetadataConnection().getNextId(), name, filterPos);
            ++filterPos;
            filter.setParentModule(module);
            module.addFilter(filter);
            filter.setDefaultLocale(module.getExpressionLocale());
            filter.setUniqueID(module.getUniqueName() + MOSER_DOT + filter.getName());
            filter.setV5UniqueName(UniqueNameGenerator.createEscapedUniqueName(module.getUniqueName(), filter.getName()));
            filter.setExpression(expr);
            module.registerExpressionObject(filter.getUniqueID(), filter);
            if (objectToResolve == null) continue;
            ExpressionResolveContext o = new ExpressionResolveContext();
            o.objResolve = filter;
            o.moserModule = module;
            objectToResolve.add(o);
        }
    }

    protected static void processUse(String moduleId, MoserModule module, JSONArray incModules, String userPassport, Map<String, String> cookiesToMoser, MoserEnv env) {
        for (Object o : incModules) {
            String importUseModuleId = (String)o;
            String importModuleId = importUseModuleId.replaceAll(COLON, MOSER_DOT);
            if (importModuleId.endsWith(DOT_PHYSICALMODULE)) {
                String id = moduleId.replaceAll(COLON, MOSER_DOT);
                if (id.endsWith(DOT_BASE)) {
                    id = id.substring(0, id.length() - DOT_BASE.length());
                }
                importModuleId = id + DOT_PHYSICALMODULE;
            }
            ModuleIdPair idPair = new ModuleIdPair(importUseModuleId, importModuleId, null);
            MoserModule subModule = (MoserModule)module.getMetadataConnection().getModule(idPair, userPassport, cookiesToMoser, env);
            if (subModule == null) continue;
            module.addImportModule(idPair);
            Map<String, Object> useSpec = module.getModuleInfo();
            MoserModuleUtil.addPhysicalModuleSource(subModule, importModuleId, useSpec, env);
        }
    }

    protected static void processPhysical(String moduleId, MoserModule module, JSONObject physical, String userPassport, Map<String, String> cookiesToMoser, MoserEnv env) {
        String importUseModuleId = moduleId;
        String importModuleId = importUseModuleId.replaceAll(COLON, MOSER_DOT);
        if (importModuleId.endsWith(DOT_BASE)) {
            importModuleId = importModuleId.substring(0, importModuleId.length() - DOT_BASE.length());
        }
        importModuleId = importModuleId + DOT_PHYSICALMODULE;
        ModuleIdPair idPair = new ModuleIdPair(importUseModuleId, importModuleId, null);
        MoserModule subModule = (MoserModule)module.getMetadataConnection().getPhysicalModuleFromPhysicalDefinition(idPair, physical, userPassport, cookiesToMoser, env);
        if (subModule != null) {
            module.addImportModule(idPair);
            Map<String, Object> useSpec = module.getModuleInfo();
            MoserModuleUtil.addPhysicalModuleSource(subModule, importModuleId, useSpec, env);
        }
    }

    protected static void processUseSpecs(String moduleId, MoserModule module, JSONArray useSpecs, String userPassport, Map<String, String> cookiesToMoser, MoserEnv env) {
        if (MoserModuleManager.loggingEnabled()) {
            MoserModuleManager.log(LogLevel.TRACE, "processUseSpecs of moduleId=" + moduleId);
        }
        for (Object o : useSpecs) {
            JSONObject importUseSpec = (JSONObject)o;
            module.addUseSpec(importUseSpec);
            if (MoserModuleManager.loggingEnabled()) {
                MoserModuleManager.log(LogLevel.TRACE, "importUseSpec=" + importUseSpec.toString());
            }
            String useSpecAlias = (String)importUseSpec.get((Object)MOSER_ID);
            ModuleIdPair idPair = new ModuleIdPair((String)importUseSpec.get((Object)STORE_ID), (String)importUseSpec.get((Object)STORE_ID), useSpecAlias);
            try {
                String dataCacheExpiry = (String)importUseSpec.get((Object)MOSER_DATA_CACHE_EXPIRY);
                MoserModuleManager mm = module.getMetadataConnection().getModuleManager();
                String tp = (String)importUseSpec.get((Object)USESPEC_TYPE);
                if (TYPE_PACKAGE.equals(tp)) {
                    module.getMetadataConnection().addPackage(useSpecAlias, (String)importUseSpec.get((Object)SEARCHPATH), dataCacheExpiry, new HashMap(importUseSpec), env);
                    continue;
                }
                if (TYPE_REPORT.contentEquals(tp)) {
                    idPair.moduleType = IMoserModule.ModuleType.REPORT;
                    IMoserModule moduleReport = MoserReportUtil.loadReport(module.getMetadataConnection(), mm, idPair, userPassport, cookiesToMoser, importUseSpec, env);
                    if (moduleReport == null) continue;
                    module.addImportModule(idPair);
                    continue;
                }
                MoserModule subModule = (MoserModule)mm.getModuleById(idPair, userPassport, cookiesToMoser, importUseSpec, false, env);
                if (subModule == null) continue;
                module.addImportModule(idPair);
                MoserModuleUtil.addModuleSource(subModule, (String)importUseSpec.get((Object)STORE_ID), (String)importUseSpec.get((Object)USESPEC_TYPE), (String)importUseSpec.get((Object)SEARCHPATH));
                if (dataCacheExpiry != null) {
                    subModule.setDataCacheExpiry(dataCacheExpiry);
                }
                subModule.setType((String)importUseSpec.get((Object)USESPEC_TYPE));
            }
            catch (XQERuntimeException e) {
                if (XQEMessageKeys.MD_MetadataConnectionFailed.equals(e.getMessageKey()) || XQEMessageKeys.GEN_ModelDoesNotExist.equals(e.getMessageKey()) || e instanceof ProviderException) {
                    ExecutionEnvironment exeEnv = (ExecutionEnvironment)ExecutionEnvironmentContext.getExecutionEnvironment();
                    if (exeEnv == null) continue;
                    String searchPath = (String)importUseSpec.get((Object)SEARCHPATH);
                    String nagMessage = XQEMessages.getMessage(XQEMessageKeys.MD_MetadataConnectionFailed, XQEMessages.getCurrProductLocale(), searchPath);
                    module.getMetadataConnection().addNagMessage(nagMessage);
                    module.addMissingModule(searchPath);
                    continue;
                }
                throw e;
            }
        }
    }

    protected static void processQuerySubject(IMoserModule module, JSONArray querySubjects, String userPassport, List<ExpressionResolveContext> c, Map<String, String> cookiesToMoser, boolean bTop, MoserEnv env, FormatConverter fc) {
        if (MoserModuleManager.loggingEnabled()) {
            MoserModuleManager.log(LogLevel.TRACE, "processQuerySubject of moduleId=" + module.getIdentifier());
        }
        block6: for (int i = 0; i < querySubjects.size(); ++i) {
            JSONObject jQS = (JSONObject)querySubjects.get(i);
            String qsUsage = (String)jQS.get((Object)MOSER_QUERYSUBJECTUSAGE);
            if (qsUsage != null && qsUsage.startsWith(MOSER_QS_USAGE_TIME)) {
                MoserTimeUtil.createTimeQuerySubject(jQS, module, userPassport, c, cookiesToMoser, bTop, env, fc);
                continue;
            }
            String name = (String)jQS.get((Object)MOSER_ID);
            QsClassifierType type = QsClassifierType.QUERY_SUBJECT;
            String classified = (String)jQS.get((Object)MOSER_QS_CLASSIFIED);
            if (classified != null) {
                try {
                    type = QsClassifierType.fromValue(classified);
                }
                catch (IllegalArgumentException e) {
                    MoserModuleManager.log(LogLevel.WARN, "Wrong classifier set to query subject in " + module.getIdentifier());
                }
            }
            Boolean isHidden = (Boolean)jQS.get((Object)MOSER_HIDDEN);
            MoserQuerySubject qs = new MoserQuerySubject(module.getMetadataConnection().getNextId(), name, i);
            qs.setParentModule((MoserModule)module);
            ((MoserModule)module).addQuerySubject(qs);
            qs.setDefaultLocale(((MoserModule)module).getExpressionLocale());
            if (Boolean.TRUE.equals(isHidden)) {
                qs.setIsHidden(true);
            }
            switch (type) {
                case OPERATION_QUERY_SUBJECT: {
                    MoserModuleUtil.initializeOperationQuerySubject(module, qs, jQS, userPassport, c, cookiesToMoser, bTop, env, fc);
                    continue block6;
                }
                case SQL_QUERY_SUBJECT: {
                    MoserModuleUtil.initializeQuerySubjectTypedInSQL(module, qs, jQS, userPassport, c, cookiesToMoser, bTop, env, fc);
                    continue block6;
                }
                default: {
                    qs.setClassifier(type);
                    MoserModuleUtil.initializeQuerySubject(module, qs, jQS, userPassport, c, cookiesToMoser, bTop, env, fc);
                }
            }
        }
    }

    protected static void processDataSource(String moduleId, MoserModule module, JSONArray dataSources, String userPassport, Map<String, String> cookiesToMoser, String waAssetId, JSONObject jObjOrig, MoserEnv env) {
        module.setModuleType(IMoserModule.ModuleType.PHYSICAL);
        if (MoserModuleManager.loggingEnabled()) {
            MoserModuleManager.log(LogLevel.TRACE, "processDataSource of moduleId=" + moduleId);
        }
        for (int i = 0; i < dataSources.size(); ++i) {
            JSONObject jDS = (JSONObject)dataSources.get(i);
            String name = (String)jDS.get((Object)MOSER_NAME);
            MoserDataSource ds = new MoserDataSource(module.getMetadataConnection().getNextId(), name);
            module.addDataSource(ds);
            MoserModuleUtil.initializeDataSource(moduleId, module, ds, jDS, userPassport, cookiesToMoser, waAssetId, false, jObjOrig, env);
        }
    }

    protected static String replaceWithReal(JSONObject jDS, String key, JSONObject real) {
        if (real != null && real.containsKey((Object)key)) {
            return (String)real.get((Object)key);
        }
        return (String)jDS.get((Object)key);
    }

    private static String decryptConnection(PrivateKey privateKey, String encrypted) {
        try {
            String[] parts;
            Cipher cipher = Cipher.getInstance(privateKey.getAlgorithm());
            cipher.init(2, privateKey);
            StringBuilder resp = new StringBuilder();
            for (String part : parts = encrypted.split(COLON)) {
                if (part == null || part.isEmpty()) continue;
                resp.append(new String(cipher.doFinal(Base64.getDecoder().decode(part)), StandardCharsets.UTF_8));
            }
            return resp.toString();
        }
        catch (Exception e) {
            throw new LogonFailureException(LogonFailureException.SubCodeEnum.INVALID_CONN_STRING, (Throwable)e);
        }
    }

    protected static String decryptValue(String encrypted) {
        try {
            return new String(CryptoProvider.decrypt((byte[])Base64.getDecoder().decode(encrypted)), StandardCharsets.UTF_8);
        }
        catch (Exception e) {
            if (MoserModuleManager.loggingEnabled()) {
                MoserModuleManager.log(LogLevel.TRACE, e.getLocalizedMessage());
            }
            return encrypted;
        }
    }

    private static PrivateKey getPrivateKey() {
        KeyPair kp;
        HttpServletRequest httpServletRequest;
        ExecutionEnvironment exeEnv = (ExecutionEnvironment)ExecutionEnvironmentContext.getExecutionEnvironment();
        if (exeEnv != null && (httpServletRequest = ((RequestEnvironment)exeEnv.getRequestEnvironment()).getHttpServletRequest()) != null && (kp = (KeyPair)httpServletRequest.getAttribute(ENCRYPTION_KEYPAIR)) != null) {
            return kp.getPrivate();
        }
        return null;
    }

    private static String buildConnectionString(PrivateKey pk, JSONObject source) {
        String connectionProperties;
        String driverClassName;
        String jdbcUrl = (String)source.get((Object)MOSER_JDBCURL);
        if (jdbcUrl.startsWith(ENCRYPTION_PREFIX)) {
            jdbcUrl = MoserModuleUtil.decryptConnection(pk, jdbcUrl.substring(5));
        }
        if ((driverClassName = (String)source.get((Object)MOSER_DRIVERCLASSNAME)) != null && driverClassName.startsWith(ENCRYPTION_PREFIX)) {
            driverClassName = MoserModuleUtil.decryptConnection(pk, driverClassName.substring(5));
        }
        if ((connectionProperties = (String)source.get((Object)MOSER_CONNECTIONPROPERTIES)) != null && connectionProperties.startsWith(ENCRYPTION_PREFIX)) {
            connectionProperties = MoserModuleUtil.decryptConnection(pk, connectionProperties.substring(5));
        }
        return JDBCStringBuilder.buildConnectionString(jdbcUrl, driverClassName, connectionProperties);
    }

    public static void checkPQFileAccessible(String logicalName, Map<String, Object> props) {
        String pqConnectionString = (String)props.get("connectionString");
        if (null == pqConnectionString) {
            MoserModuleManager.log(LogLevel.ERROR, String.format("Invalid connection string for logical parquet file '%s': %s", logicalName, pqConnectionString));
            return;
        }
        String filePathLocation = pqConnectionString.substring(PREFIX_PARQUET_CONNECTION_STR.length());
        String flintDSURIString = FlintUtils.getUnencryptedHadoopURIString(filePathLocation);
        try {
            Configuration config = FlintUtils.getHadoopConfiguration();
            shaded.org.apache.hadoop.fs.Path filePath = new shaded.org.apache.hadoop.fs.Path(flintDSURIString);
            FileSystem fs = filePath.getFileSystem(config);
            if (!fs.isFile(filePath)) {
                throw new IllegalStateException("The path location does to correspond to a parquet file.");
            }
            FileStatus fileStatus = fs.getFileStatus(filePath);
            Instant accessInstant = Instant.ofEpochMilli(fileStatus.getAccessTime());
            Instant modificationInstant = Instant.ofEpochMilli(fileStatus.getModificationTime());
            MoserModuleManager.log(LogLevel.INFO, String.format("Valid logical file '%s' detected at location '%s'. Size: %d bytes - Access Time: %s - Modification Time: %s", logicalName, flintDSURIString, fileStatus.getLen(), accessInstant, modificationInstant));
        }
        catch (Exception e) {
            MoserModuleManager.log(LogLevel.ERROR, String.format("Error accessing logical file '%s' at location '%s'. Reason: %s", logicalName, flintDSURIString, e.getMessage()), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void touchFlintDataset(MoserDataSource mDS, IExecutionEnvironment execEnv) throws XQEException, IOException {
        IDatasetManager datasetMgr = MoserModuleManager.getDatasetManager();
        IFlintServerManager flintServerMgr = datasetMgr.getFlintServerManagerInstance();
        String flintConnectionString = flintServerMgr.constructConnectionString(Long.MIN_VALUE);
        String flintDatasetName = FlintUtils.generateFlintDatasetName(mDS.getName(), (String)mDS.getMetadataProperties().get(MOSER_DS_LOGICAL_NAME));
        if (mDS.getMetadataProperties().get("connectionString").toString().compareTo(flintConnectionString) != 0) {
            throw new IllegalStateException(String.format(FLINT_TOUCH_DATASET_ERROR_MSG, flintDatasetName, mDS.toString()));
        }
        ConnectionParameters parameters = new ConnectionParameters();
        SimpleDataSourceConnection simpleDSConn = new SimpleDataSourceConnection(flintConnectionString, null);
        SimpleDataSource simpleDS = new SimpleDataSource(mDS.getName(), null, simpleDSConn, mDS.getMetadataProperties());
        IPooledConnection flintPooledConnection = null;
        try {
            String pqConnectionString = mDS.getMetadataProperties().get(MOSER_FALLBACK_CONNECTIONSTRING).toString();
            String filePathLocation = pqConnectionString.substring(PREFIX_PARQUET_CONNECTION_STR.length());
            String flintDSURIString = FlintUtils.getUnencryptedHadoopURIString(filePathLocation);
            Configuration config = FlintUtils.getHadoopConfiguration();
            shaded.org.apache.hadoop.fs.Path filePath = new shaded.org.apache.hadoop.fs.Path(flintDSURIString);
            FileSystem fs = filePath.getFileSystem(config);
            if (!fs.isFile(filePath) || !fs.exists(filePath)) {
                throw new IOException(String.format(FLINT_PQ_FILE_NOT_FOUND_ERROR_MSG, flintDSURIString, flintDatasetName));
            }
            IDataProvider flintProvider = ProviderManager.getInstance().getProvider("FLINT");
            parameters.put(new DataSourceParameter(simpleDS));
            flintPooledConnection = flintProvider.borrowConnection(parameters, execEnv);
            FlintConnection flintConnection = (FlintConnection)flintPooledConnection.getConnection();
            flintConnection.connect(null);
            FlintApiFacade apiFacade = flintConnection.getApiFacade();
            if (!apiFacade.touchDataset(flintDatasetName)) {
                throw new IllegalStateException(String.format(FLINT_TOUCH_DATASET_ERROR_MSG, flintDatasetName, mDS.toString()));
            }
            long now = System.currentTimeMillis();
            fs.setTimes(filePath, now, now);
            String fileDirLocation = filePathLocation.substring(0, filePathLocation.lastIndexOf(47));
            MoserModuleUtil.touchFlintDatasetSelfJoinFiles(apiFacade, fileDirLocation, mDS.getName(), (String)mDS.getMetadataProperties().get(MOSER_DS_LOGICAL_NAME), now, fs);
        }
        finally {
            if (flintPooledConnection != null) {
                flintPooledConnection.returnConnection();
            }
        }
    }

    private static void touchFlintDatasetSelfJoinFiles(FlintApiFacade apiFacade, String directory, String id, String logicalName, long lastModified, FileSystem fs) throws IOException {
        try (Stream<Path> ls = Files.list(Paths.get(directory, new String[0]));){
            ls.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).forEach(file -> {
                String fileName = file.getFileName().toString();
                Matcher matcher = FlintUtils.HARD_LINK_PATTERN.matcher(fileName);
                if (!matcher.matches()) {
                    matcher = FlintUtils.COPY_FILE_PATTERN.matcher(fileName);
                }
                if (matcher.matches()) {
                    String newLogicalName = logicalName + Integer.valueOf(matcher.group(3));
                    String flintDatasetName = FlintUtils.generateFlintDatasetName(id, newLogicalName);
                    if (!apiFacade.touchDataset(flintDatasetName)) {
                        throw new IllegalStateException(String.format(FLINT_TOUCH_DATASET_ERROR_MSG, flintDatasetName, id));
                    }
                    String flintDSURIString = FlintUtils.getUnencryptedHadoopURIString(directory + '/' + fileName);
                    try {
                        fs.setTimes(new shaded.org.apache.hadoop.fs.Path(flintDSURIString), lastModified, lastModified);
                    }
                    catch (IOException ioe) {
                        throw new IllegalStateException(String.format(FLINT_TOUCH_DATASET_ERROR_MSG, flintDatasetName, id));
                    }
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IDataSource promoteSQLRelationDSForFlint(IDataSource dataSource, IExecutionEnvironment execEnv) {
        if (DataSourceTypeEnum.isColumnar(dataSource.getType())) {
            File dataFile;
            MoserDataSource mDS = new MoserDataSource(1L, dataSource.getName());
            mDS.setCMDataSource(mDS.getName());
            mDS.setInterface("PARQUET");
            HashMap<String, Object> properties = new HashMap<String, Object>();
            for (Map.Entry<String, Object> entry : dataSource.getMetadataProperties().entrySet()) {
                properties.put(entry.getKey(), entry.getValue());
            }
            String pqVersion = (String)properties.get(STR_VERSION);
            String logicalName = (String)properties.get(MOSER_DS_LOGICAL_NAME);
            String pqConnStr = (String)properties.get("connectionString");
            String pqFileLocation = pqConnStr.replace(PREFIX_PARQUET_CONNECTION_STR, MOSER_EMPTY_STRING);
            String outputId = pqFileLocation.substring(pqFileLocation.lastIndexOf(47) + 1);
            if (outputId.endsWith(DOT_DATA)) {
                outputId = outputId.substring(0, outputId.lastIndexOf(DOT_DATA));
            } else if (outputId.endsWith(DOT_PARQUET)) {
                outputId = outputId.substring(0, outputId.lastIndexOf(DOT_PARQUET));
            }
            if (null != pqVersion && pqVersion.equals(ParquetVersionEnum.VERSION_1.getValue()) && outputId.endsWith(pqVersion)) {
                outputId = outputId.substring(0, outputId.lastIndexOf(pqVersion));
            }
            if (!(dataFile = new File(pqFileLocation)).exists()) {
                Object lck = new Object();
                Object otherLck = sidLOCK.putIfAbsent(outputId, lck);
                if (otherLck != null) {
                    lck = otherLck;
                }
                Object object = lck;
                synchronized (object) {
                    TreeMap<String, String> cookies = new TreeMap<String, String>();
                    Object reqEnv = execEnv.getRequestEnvironment();
                    Map<String, String> ck = reqEnv.getCookies();
                    if (ck != null) {
                        cookies.putAll(ck);
                    }
                    ContentServiceClient csr = new ContentServiceClient(execEnv.getRequestEnvironment().getCAMPassport(), cookies);
                    MoserModuleUtil.loadPQFromCMToDiskShared(dataFile, csr, outputId, pqVersion);
                }
            }
            if (Boolean.parseBoolean(CONFIG.getStringProperty(FLINT_SERVER_ENABLED_KEY, "true"))) {
                MoserModuleUtil.tryToPromoteDSForFlint(mDS, properties, execEnv, LocalDateTime.now(), pqVersion, false, logicalName, true);
                if ("FLINT".equals(mDS.getInterface())) {
                    SimpleDataSourceConnection simpleDSConn = new SimpleDataSourceConnection((String)mDS.getProperty("connectionString"), null);
                    return new SimpleDataSource(mDS.getName(), mDS.getInterface(), simpleDSConn, properties);
                }
            }
        }
        return dataSource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void tryToPromoteDSForFlint(MoserDataSource mDS, Map<String, Object> props, IExecutionEnvironment execEnv, LocalDateTime lastModifiedLDT, String pqVersion, boolean shouldBeEncrypted, String logicalName, boolean skipConversion) {
        String flintConnectionString;
        IDatasetManager datasetMgr = MoserModuleManager.getDatasetManager();
        IFlintServerManager flintServerMgr = datasetMgr.getFlintServerManagerInstance();
        long uniqueLoggingID = flintServerMgr.getUniqueLoggingId();
        try {
            IFlintServerManagerConfig flintServerMgrConfig = flintServerMgr.getConfig();
            flintConnectionString = FlintServerManagerConfig.FlintConnectionsPolicy.WAIT != flintServerMgrConfig.getFlintConnectionsPolicy() ? flintServerMgr.constructConnectionString(uniqueLoggingID) : flintServerMgr.constructConnectionString(Long.MIN_VALUE);
        }
        catch (IllegalStateException ise) {
            MoserModuleManager.log(LogLevel.WARN, ise.getMessage());
            try {
                flintConnectionString = MoserModuleUtil.determineActionOnFlintServerNotRunning((FlintServerManager)flintServerMgr, uniqueLoggingID);
            }
            catch (IllegalStateException iseOnAction) {
                MoserModuleManager.log(LogLevel.WARN, iseOnAction.getLocalizedMessage());
                return;
            }
        }
        String flintDatasetName = FlintUtils.generateFlintDatasetName(mDS.getName(), logicalName);
        String pqConnectionString = (String)props.put("connectionString", flintConnectionString);
        props.put(MOSER_FALLBACK_CONNECTIONSTRING, pqConnectionString);
        mDS.setInterface("FLINT");
        ConnectionParameters parameters = new ConnectionParameters();
        SimpleDataSourceConnection simpleDSConn = new SimpleDataSourceConnection(flintConnectionString, null);
        SimpleDataSource simpleDS = new SimpleDataSource(mDS.getName(), null, simpleDSConn, props);
        IPooledConnection flintPooledConnection = null;
        try {
            Configuration config;
            shaded.org.apache.hadoop.fs.Path filePath;
            FileSystem fs;
            FlintApiFacade apiFacade;
            String flintDSURIString;
            String filePathLocation;
            String storeID;
            block44: {
                IDataProvider flintProvider = ProviderManager.getInstance().getProvider("FLINT");
                parameters.put(new DataSourceParameter(simpleDS));
                flintPooledConnection = flintProvider.borrowConnection(parameters, execEnv);
                FlintConnection flintConnection = (FlintConnection)flintPooledConnection.getConnection();
                flintConnection.connect(null);
                storeID = pqConnectionString.substring(pqConnectionString.lastIndexOf(47) + 1, pqConnectionString.lastIndexOf(46));
                filePathLocation = pqConnectionString.substring(PREFIX_PARQUET_CONNECTION_STR.length());
                flintDSURIString = FlintUtils.getUnencryptedHadoopURIString(filePathLocation);
                apiFacade = flintConnection.getApiFacade();
                if (!skipConversion && (pqVersion == null || !ParquetVersionEnum.VERSION_1.getValue().equals(pqVersion) && Boolean.parseBoolean(CONFIG.getStringProperty(FLINT_LAZY_CONVERSION, FALSE_BOOLEAN_STR)))) {
                    String flintDSDirPath = MoserModuleUtil.getDatasetDirectory() + flintDatasetName;
                    File f = new File(flintDSDirPath + '/' + "_SUCCESS");
                    MetadataInfo mdInfo = datasetMgr.getMetadataInfo(storeID);
                    flintDSURIString = FlintUtils.getUnencryptedHadoopURIString(flintDSDirPath);
                    if (!f.exists() || lastModifiedLDT != null && lastModifiedLDT.compareTo(mdInfo.getUploadedFileTimestamp()) > 0) {
                        ReentrantLock lock = datasetMgr.getPQConversionLock(flintDatasetName);
                        lock.lock();
                        try {
                            MetadataInfo newMDInfo = datasetMgr.getMetadataInfo(storeID);
                            if (!f.exists() || lastModifiedLDT != null && lastModifiedLDT.compareTo(newMDInfo.getUploadedFileTimestamp()) > 0) {
                                try {
                                    apiFacade.removeDataset(flintDatasetName);
                                }
                                catch (NoSuchDatasetException noSuchDatasetEx) {
                                    MoserModuleManager.log(LogLevel.INFO, "Trying to remove an non-existing dataset: " + (Object)((Object)noSuchDatasetEx));
                                }
                                String pqFilePath = pqConnectionString.substring(PREFIX_PARQUET_CONNECTION_STR.length());
                                MoserModuleUtil.generateFlintPQDirAndFiles(pqFilePath, apiFacade, flintDSURIString, logicalName, storeID, flintDatasetName, shouldBeEncrypted);
                                break block44;
                            }
                            if (lastModifiedLDT != null && lastModifiedLDT.compareTo(newMDInfo.getUploadedFileTimestamp()) < 0) {
                                throw new XQERuntimeException(XQEMessageKeys.MSR_StaleDataAccess, (Object)storeID, (Object)newMDInfo.getUploadedFileTimestamp(), (Object)lastModifiedLDT.toString());
                            }
                        }
                        finally {
                            lock.unlock();
                        }
                    }
                }
            }
            if ((fs = (filePath = new shaded.org.apache.hadoop.fs.Path(flintDSURIString)).getFileSystem(config = FlintUtils.getHadoopConfiguration())).isFile(filePath) && null != pqVersion && !ParquetVersionEnum.VERSION_1.getValue().equals(pqVersion)) {
                props.put("connectionString", pqConnectionString);
                props.remove(MOSER_FALLBACK_CONNECTIONSTRING);
                mDS.setInterface("PARQUET");
                MoserModuleManager.log(LogLevel.WARN, FLINT_PROMOTION_FAILED_MSG + String.format("Logical File (%s) with storeID (%s) is in LEGACY format.", logicalName, storeID));
                return;
            }
            if (!apiFacade.touchDataset(flintDatasetName)) {
                MoserModuleUtil.prepareDataset(apiFacade, flintDatasetName, flintDSURIString, logicalName, storeID, props);
            }
            String fileDirLocation = filePathLocation.substring(0, filePathLocation.lastIndexOf(47));
            try (Stream<Path> ls = Files.list(Paths.get(fileDirLocation, new String[0]));){
                List files = ls.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).collect(Collectors.toList());
                for (Path file : files) {
                    String fileName = file.getFileName().toString();
                    Matcher matcher = FlintUtils.HARD_LINK_PATTERN.matcher(fileName);
                    if (!matcher.matches()) {
                        matcher = FlintUtils.COPY_FILE_PATTERN.matcher(fileName);
                    }
                    if (!matcher.matches()) continue;
                    String newLogicalName = logicalName + Integer.valueOf(matcher.group(3));
                    String flintDatasetNameSJ = FlintUtils.generateFlintDatasetName(mDS.getName(), newLogicalName);
                    if (!apiFacade.touchDataset(flintDatasetNameSJ)) {
                        MoserModuleUtil.prepareDataset(apiFacade, flintDatasetNameSJ, FlintUtils.getUnencryptedHadoopURIString(file.toString()), newLogicalName, storeID, props);
                    }
                    long time = System.currentTimeMillis();
                    fs.setTimes(new shaded.org.apache.hadoop.fs.Path(FlintUtils.getUnencryptedHadoopURIString(file.toString())), time, time);
                }
            }
            long modificationTime = System.currentTimeMillis();
            fs.setTimes(filePath, modificationTime, modificationTime);
        }
        catch (TException te) {
            props.put("connectionString", pqConnectionString);
            props.remove(MOSER_FALLBACK_CONNECTIONSTRING);
            mDS.setInterface("PARQUET");
            if (null != flintPooledConnection) {
                flintPooledConnection.setNotReusable();
            }
            MoserModuleManager.log(LogLevel.WARN, FLINT_PROMOTION_FAILED_MSG + te.getLocalizedMessage());
        }
        catch (XQEException xqee) {
            props.put("connectionString", pqConnectionString);
            props.remove(MOSER_FALLBACK_CONNECTIONSTRING);
            mDS.setInterface("PARQUET");
            if (null != flintPooledConnection) {
                flintPooledConnection.setNotReusable();
            }
            MoserModuleManager.log(LogLevel.WARN, FLINT_PROMOTION_FAILED_MSG + xqee.getLocalizedMessage());
        }
        catch (IOException ioe) {
            props.put("connectionString", pqConnectionString);
            props.remove(MOSER_FALLBACK_CONNECTIONSTRING);
            mDS.setInterface("PARQUET");
            if (null != flintPooledConnection) {
                flintPooledConnection.setNotReusable();
            }
            MoserModuleManager.log(LogLevel.WARN, FLINT_PROMOTION_FAILED_MSG + ioe.getLocalizedMessage());
        }
        finally {
            if (null != flintPooledConnection) {
                flintPooledConnection.returnConnection();
            }
        }
    }

    public static void prepareDataset(FlintApiFacade apiFacade, String flintDatasetName, String flintDSURIString, String logicalName, String storeID, Map<String, Object> props) {
        int datasetIdleSeconds;
        MoserModuleManager.log(LogLevel.INFO, String.format("Attempting to prepare flint dataset: %s", flintDatasetName));
        String datasetIdleSecondsValue = null;
        try {
            datasetIdleSecondsValue = CONFIG.getStringProperty("queryExecution.flintServer.datasetIdleSeconds[@value]", String.valueOf(DEFAULT_FLINT_DATASET_IDLE_SECONDS_VALUE));
            datasetIdleSeconds = Integer.parseInt(datasetIdleSecondsValue);
            if (datasetIdleSeconds > MAX_FLINT_DATASET_IDLE_SECONDS_VALUE) {
                MoserModuleManager.log(LogLevel.INFO, String.format("Value '%s' for property '%s' exceeds the max allowed '%s' - defaulting to '%s'", datasetIdleSecondsValue, "queryExecution.flintServer.datasetIdleSeconds[@value]", MAX_FLINT_DATASET_IDLE_SECONDS_VALUE, MAX_FLINT_DATASET_IDLE_SECONDS_VALUE));
                datasetIdleSeconds = MAX_FLINT_DATASET_IDLE_SECONDS_VALUE;
            } else if (datasetIdleSeconds < MIN_FLINT_DATASET_IDLE_SECONDS_VALUE) {
                MoserModuleManager.log(LogLevel.INFO, String.format("Value '%s' for property '%s' lower than min allowed '%s' - defaulting to '%s'", datasetIdleSecondsValue, "queryExecution.flintServer.datasetIdleSeconds[@value]", MIN_FLINT_DATASET_IDLE_SECONDS_VALUE, MIN_FLINT_DATASET_IDLE_SECONDS_VALUE));
                datasetIdleSeconds = MIN_FLINT_DATASET_IDLE_SECONDS_VALUE;
            }
        }
        catch (Exception e) {
            MoserModuleManager.log(LogLevel.INFO, String.format("Invalid value '%s' for property '%s' - defaulting to '%s'", datasetIdleSecondsValue, "queryExecution.flintServer.datasetIdleSeconds[@value]", DEFAULT_FLINT_DATASET_IDLE_SECONDS_VALUE));
            datasetIdleSeconds = DEFAULT_FLINT_DATASET_IDLE_SECONDS_VALUE;
        }
        HashMap<String, String> encryptionOptions = new HashMap<String, String>();
        encryptionOptions.put(OPTION_ENCRYPTED_PAGE_FLAG, "true");
        encryptionOptions.put(OPTION_CRYPTO_PROVIDER, CAM_CRYPTO_PROVIDER);
        AnySource source = AnySource.parquet((ParquetSource)new ParquetSource(Arrays.asList(flintDSURIString)).setOptions(encryptionOptions));
        CacheOptions cacheOpts = new CacheOptions().setLevel(CacheLevel.NONE);
        AnalyzeOptions analyzeOptions = new AnalyzeOptions();
        if (props.containsKey(STR_NUMROWS)) {
            analyzeOptions.setCustomRowCount(((Long)props.get(STR_NUMROWS)).longValue());
        }
        DatasetSpec spec = new DatasetSpec(flintDatasetName, source).setIdleSeconds(datasetIdleSeconds).setAnalyzeOptions(analyzeOptions);
        long start = System.nanoTime();
        apiFacade.prepareDataset(spec, cacheOpts);
        long end = System.nanoTime();
        MoserModuleManager.log(LogLevel.INFO, String.format(FLINT_PREPARE_DATASET_MSG, logicalName, storeID, flintDatasetName, Float.valueOf((float)(end - start) * 1.0f / (float)TimeUnit.SECONDS.toNanos(1L))));
    }

    protected static String determineActionOnFlintServerNotRunning(FlintServerManager theFlintServerMgr, long uniqueLoggingID) {
        FlintServerManagerConfig flintServerMgrCnfg = theFlintServerMgr.getConfig();
        switch (flintServerMgrCnfg.getFlintConnectionsPolicy()) {
            case FALLBACK: {
                if (flintServerMgrCnfg.isFlintEnabled() && FlintServerManagerConfig.FlintServerLoadingPolicy.LAZY == flintServerMgrCnfg.getFlintServerLoadingPolicy()) {
                    try {
                        theFlintServerMgr.startFlintServer();
                    }
                    catch (IllegalStateException ise) {
                        MoserModuleManager.log(LogLevel.WARN, ise.getLocalizedMessage());
                    }
                }
                throw new IllegalStateException("Flint Server not running and Flint Connection Policy set to 'FALLBACK'. Falling back to PQ V1 local execution.");
            }
            case ERROR: {
                throw new XQERuntimeException(XQEMessageKeys.FLT_ComputeServiceNotRunningError);
            }
            case WAIT: {
                if (flintServerMgrCnfg.isFlintEnabled() && FlintServerManagerConfig.FlintServerLoadingPolicy.LAZY == flintServerMgrCnfg.getFlintServerLoadingPolicy()) {
                    try {
                        theFlintServerMgr.startFlintServer();
                    }
                    catch (IllegalStateException ise) {
                        MoserModuleManager.log(LogLevel.WARN, ise.getLocalizedMessage());
                    }
                }
                try {
                    Thread.sleep(flintServerMgrCnfg.getFlintConnectionsMaxWaitTime().toMillis());
                }
                catch (InterruptedException ie) {
                    MoserModuleManager.log(LogLevel.WARN, ie);
                }
                break;
            }
        }
        try {
            return theFlintServerMgr.constructConnectionString(uniqueLoggingID);
        }
        catch (IllegalStateException ise) {
            throw new XQERuntimeException(XQEMessageKeys.FLT_ComputeServiceNotRunningError, (Throwable)ise);
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Deprecated
    protected static void generateFlintPQDirAndFiles(String pathToPQFile, FlintApiFacade apiFacade, String flintDatasetPathURIString, String logicalName, String storeID, String flintDatasetName, boolean isEncrypted) throws TException {
        ByteBufferOutputStream bbos;
        ParquetReader reader;
        block16: {
            String bufferId = null;
            reader = null;
            bbos = null;
            try {
                MoserModuleManager.log(LogLevel.INFO, String.format(FLINT_PQV1_GEN_MSG, logicalName, storeID, flintDatasetName));
                long startOverall = System.nanoTime();
                Configuration config = FlintUtils.getHadoopConfiguration();
                shaded.org.apache.hadoop.fs.Path file = new shaded.org.apache.hadoop.fs.Path(pathToPQFile);
                File parquetFile = new File(file.toString());
                if (!parquetFile.exists()) {
                    MoserModuleManager.log(LogLevel.ERROR, file.toString() + " does not exist");
                    throw new XQERuntimeException(XQEMessageKeys.EXE_DataSetNotFound);
                }
                parquetFile.setLastModified(Instant.now().getEpochSecond() * 1000L);
                ParquetMetadata metadata = ParquetFileReader.readFooter((Configuration)config, (shaded.org.apache.hadoop.fs.Path)file, (ParquetMetadataConverter.MetadataFilter)ParquetMetadataConverter.NO_FILTER);
                FileMetaData fileMetadata = metadata.getFileMetaData();
                MessageType fileSchema = fileMetadata.getSchema();
                Map extraMetadata = fileMetadata.getKeyValueMetaData();
                config.set("parquet.dq.projection", fileSchema.toString());
                MoserModuleManager.log(LogLevel.INFO, "fileSchema: " + fileSchema.toString());
                MoserModuleManager.log(LogLevel.INFO, "extraMetadata: " + extraMetadata.toString());
                ParquetReader.Builder builder = ParquetReader.builder((ReadSupport)new ParquetDatasetReadSupport(), (shaded.org.apache.hadoop.fs.Path)file).withConf(config);
                reader = builder.build();
                Object[] inputRow = (Object[])reader.read();
                MoserModuleManager.log(LogLevel.INFO, "First row read.");
                RowType rowType = ParquetDatasetReadSupport.getRowType(extraMetadata);
                ArrayListInt dateColumns = new ArrayListInt();
                ArrayListInt timestampColumns = new ArrayListInt();
                Schema schema = FlintUtils.generateFlintSchema(fileSchema, rowType, dateColumns, timestampColumns);
                RowBufferSpec spec = new RowBufferSpec(schema);
                bufferId = apiFacade.createRowBuffer(spec);
                List batch = null;
                AvroRowWriter writer = null;
                bbos = new ByteBufferOutputStream();
                writer = new AvroRowWriter(schema, (OutputStream)bbos);
                int rowCount = 0;
                int batchIndex = 0;
                while (inputRow != null) {
                    if (rowCount == 10000) {
                        writer.close();
                        apiFacade.putRowBufferAvro(bufferId, batchIndex, bbos.getBufferList());
                        ++batchIndex;
                        rowCount = 0;
                        writer = new AvroRowWriter(schema, (OutputStream)bbos);
                    } else if (batch != null && batch.size() == 10000) {
                        apiFacade.putRowBufferList(bufferId, batchIndex, batch);
                        ++batchIndex;
                        batch.clear();
                    }
                    FlintUtils.convertPQRowToFlintRow(inputRow, dateColumns, timestampColumns);
                    writer.writeArray(inputRow);
                    ++rowCount;
                    inputRow = (Object[])reader.read();
                }
                if (rowCount > 0) {
                    writer.close();
                    apiFacade.putRowBufferAvro(bufferId, batchIndex, bbos.getBufferList());
                    ++batchIndex;
                    rowCount = 0;
                } else if (batch != null && !batch.isEmpty()) {
                    apiFacade.putRowBufferList(bufferId, batchIndex, batch);
                    ++batchIndex;
                    batch.clear();
                }
                long endPQV0toAvro = System.nanoTime();
                AnySink sink = new AnySink();
                FileSink fileSink = new FileSink("parquet", flintDatasetPathURIString);
                HashMap<String, String> encryptionOptions = new HashMap<String, String>();
                encryptionOptions.put(OPTION_ENCRYPTED_PAGES_FLAG, Boolean.toString(isEncrypted));
                encryptionOptions.put(OPTION_ENCRYPTED_PAGE_FLAG, "true");
                encryptionOptions.put(OPTION_CRYPTO_PROVIDER, CAM_CRYPTO_PROVIDER);
                fileSink.setOptions(encryptionOptions);
                if (isEncrypted) {
                    MoserModuleManager.log(LogLevel.INFO, String.format(FLINT_PQV1_ENCRYPTION_MSG, FLINT_ENCRYPTION_ON_VALUE, logicalName, storeID, flintDatasetName));
                } else {
                    MoserModuleManager.log(LogLevel.INFO, String.format(FLINT_PQV1_ENCRYPTION_MSG, FLINT_ENCRYPTION_OFF_VALUE, logicalName, storeID, flintDatasetName));
                }
                sink.setFile(fileSink);
                SaveOptions saveOpts = new SaveOptions();
                saveOpts.setConflictAction(ConflictAction.OVERWRITE);
                long startAvroToPQV1 = System.nanoTime();
                apiFacade.saveRowBuffer(bufferId, sink, saveOpts);
                long endAvroToPQV1 = System.nanoTime();
                long endOverall = System.nanoTime();
                MoserModuleManager.log(LogLevel.INFO, String.format(FLINT_PQV0_TO_AVRO_CONVERSION_TIME_MSG, logicalName, storeID, flintDatasetName, Float.valueOf((float)(endPQV0toAvro - startOverall) * 1.0f / (float)TimeUnit.SECONDS.toNanos(1L))));
                MoserModuleManager.log(LogLevel.INFO, String.format(FLINT_AVRO_TO_PQV1_CONVERSION_TIME_MSG, logicalName, storeID, flintDatasetName, Float.valueOf((float)(endAvroToPQV1 - startAvroToPQV1) * 1.0f / (float)TimeUnit.SECONDS.toNanos(1L))));
                MoserModuleManager.log(LogLevel.INFO, String.format(FLINT_PQV1_OVERALL_CONVERSION_TIME_MSG, logicalName, storeID, flintDatasetName, Float.valueOf((float)(endOverall - startOverall) * 1.0f / (float)TimeUnit.SECONDS.toNanos(1L))));
                MoserModuleManager.log(LogLevel.INFO, String.format(FLINT_PQV1_GEN_SUCCESS_MSG, logicalName, storeID, flintDatasetName));
                if (bufferId == null) break block16;
            }
            catch (ParseException e) {
                try {
                    MoserModuleManager.log(LogLevel.ERROR, "Error parsing data file.");
                    throw new XQERuntimeException(e);
                    catch (IOException e2) {
                        MoserModuleManager.log(LogLevel.ERROR, "Error reading data file.");
                        throw new XQERuntimeException(e2);
                    }
                }
                catch (Throwable throwable) {
                    if (bufferId != null) {
                        apiFacade.removeRowBuffer(bufferId);
                    }
                    IOUtils.closeQuietly(reader);
                    IOUtils.closeQuietly(bbos);
                    throw throwable;
                }
            }
            apiFacade.removeRowBuffer(bufferId);
        }
        IOUtils.closeQuietly((Closeable)reader);
        IOUtils.closeQuietly((OutputStream)bbos);
    }

    private static String getCSVToParquetLocation(MoserModule module, Map<String, String> cookiesToMoser, JSONObject jObjOrig, MoserEnv env) {
        MoserModuleManager mm = module.getMetadataConnection().getModuleManager();
        return mm.getCSVToParquet(module.getLabel(), jObjOrig.toString(), cookiesToMoser, env);
    }

    protected static void initializeDataSource(String moduleId, MoserModule module, MoserDataSource ds, JSONObject jDS, String userPassport, Map<String, String> cookiesToMoser, String waAssetId, boolean bOnlyTable, JSONObject jObjOrig, MoserEnv env) {
        JSONObject dbConnectionInfo = null;
        if (waAssetId != null) {
            MoserModuleManager mm = module.getMetadataConnection().getModuleManager();
            dbConnectionInfo = mm.getDataSourceConnectionInfo(waAssetId, cookiesToMoser, env);
        }
        JSONArray tables = null;
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put("queryType", "relational");
        String dbType = MoserModuleUtil.replaceWithReal(jDS, MOSER_DBTYPE, dbConnectionInfo);
        PrivateKey pk = null;
        if (MetadataService.getInstance().getDsDriverBasePath() != null) {
            dbType = "JDBC";
            pk = MoserModuleUtil.getPrivateKey();
        }
        String dbUID = MoserModuleUtil.replaceWithReal(jDS, MOSER_DB_UID, dbConnectionInfo);
        String dbPW = MoserModuleUtil.replaceWithReal(jDS, "password", dbConnectionInfo);
        String dbConnectionString = MoserModuleUtil.replaceWithReal(jDS, "connectionString", dbConnectionInfo);
        String dbConnection = MoserModuleUtil.replaceWithReal(jDS, MOSER_CONNECTION, dbConnectionInfo);
        String csvUrl = MoserModuleUtil.replaceWithReal(jDS, MOSER_CSVURL, dbConnectionInfo);
        if (dbUID != null && dbUID.startsWith(ENCRYPTION_PREFIX)) {
            dbUID = MoserModuleUtil.decryptConnection(pk, dbUID.substring(5));
        }
        if (dbPW != null) {
            if (dbPW.startsWith(ENCRYPTION_PREFIX)) {
                dbPW = MoserModuleUtil.decryptConnection(pk, dbPW.substring(5));
            } else if (dbPW.startsWith(CA_ENCRYPTION_PREFIX)) {
                dbPW = MoserModuleUtil.decryptValue(dbPW.substring(CA_ENCRYPTION_PREFIX.length()));
            }
        }
        if (dbConnectionString != null && dbConnectionString.startsWith(ENCRYPTION_PREFIX)) {
            dbConnectionString = MoserModuleUtil.decryptConnection(pk, dbConnectionString.substring(5));
        }
        if (jDS != null && jDS.containsKey((Object)MOSER_JDBC)) {
            dbConnectionString = MoserModuleUtil.buildConnectionString(pk, (JSONObject)jDS.get((Object)MOSER_JDBC));
        }
        if (csvUrl != null) {
            ds.setInterface("PARQUET");
            String connectionString = MoserModuleUtil.getCSVToParquetLocation(module, cookiesToMoser, jObjOrig, env);
            String logicalName = module.getLabel();
            properties.put("connectionString", connectionString);
            ds.setName(MoserModuleUtil.getCRC32(csvUrl));
            ds.setCMDataSource(ds.getName());
            ds.setIsContentManager(false);
            properties.put(DS_UID, DS_ANONYMOUS);
            properties.put("password", DS_ANONYMOUS);
            properties.put(MOSER_DS_LOGICAL_NAME, logicalName);
            properties.put(STR_VERSION, ParquetVersionEnum.VERSION_1.getValue());
            MoserModuleUtil.checkPQFileAccessible(logicalName, properties);
            if (Boolean.parseBoolean(CONFIG.getStringProperty(FLINT_SERVER_ENABLED_KEY, "true"))) {
                MoserModuleUtil.tryToPromoteDSForFlint(ds, properties, env.getExecutionEnvironment(), LocalDateTime.now(), ParquetVersionEnum.VERSION_1.getValue(), false, logicalName, false);
            }
            dbConnectionString = null;
            dbType = null;
        }
        if (dbType != null) {
            ds.setInterface(dbType);
            if ("PARQUET".equals(dbType)) {
                ContentServiceClient csr = new ContentServiceClient(userPassport, cookiesToMoser);
                boolean shouldBeEncrypted = ConfigService.getInstance().getDatasetServiceEnableEncryption();
                String nonEncodedDSName = ds.getName();
                JSONObject jObj = MoserModuleUtil.preLoadOutput(csr, moduleId, module.getLabel(), nonEncodedDSName);
                if (!Boolean.parseBoolean(CONFIG.getStringProperty(FLINT_LAZY_CONVERSION, FALSE_BOOLEAN_STR)) && ParquetVersionEnum.VERSION_1.getValue().equals(ConfigService.getInstance().getDatasetServicePQVersion())) {
                    MoserModuleUtil.upgradeParquetFileRequest(jObj, userPassport, cookiesToMoser);
                }
                String connectionString = (String)jObj.get((Object)"connectionString");
                Date d = MoserModuleUtil.convertToDate((String)jObj.get((Object)STR_LAST_MODIFIED));
                Date lastModified = module.getDatasetLastModifiedDate();
                if (lastModified == null || lastModified.compareTo(d) > 0) {
                    module.setDatasetLastModifiedDate(d);
                }
                String logicalName = module.getLabel() + MOSER_UNDERSCORE + nonEncodedDSName;
                properties.put("connectionString", connectionString);
                properties.put(MOSER_DS_LOGICAL_NAME, logicalName);
                properties.put(STR_VERSION, jObj.get((Object)STR_VERSION));
                properties.put(STR_NUMROWS, jObj.get((Object)STR_NUMROWS));
                ds.setName(MoserModuleUtil.getCRC32(connectionString));
                ds.setCMDataSource(ds.getName());
                ds.setInterface("PARQUET");
                ds.parquetFilePath = (String)jObj.get((Object)STR_PARQUET_PATH);
                if (Boolean.parseBoolean(CONFIG.getStringProperty(FLINT_SERVER_ENABLED_KEY, "true")) && Boolean.parseBoolean(CONFIG.getStringProperty(FLINT_LAZY_CONVERSION, FALSE_BOOLEAN_STR))) {
                    String pqVersion = (String)jObj.get((Object)STR_VERSION);
                    LocalDateTime modLDT = MoserModuleUtil.convertToLocalDateTime((String)jObj.get((Object)STR_LAST_MODIFIED));
                    MoserModuleUtil.tryToPromoteDSForFlint(ds, properties, env.getExecutionEnvironment(), modLDT, pqVersion, shouldBeEncrypted, logicalName, false);
                }
                dbConnectionString = null;
            }
        }
        if (dbConnectionString != null) {
            if (dbType == null) {
                XQEConfiguration xqeConfig = XQEConfigurationManager.getInstance().getConfiguration(ServiceEnumeration.XQE);
                boolean isRelativePath = xqeConfig.getBooleanProperty("dataset.connectionStringIsRelativePath[@enabled]", true);
                if (isRelativePath) {
                    dbConnectionString = MoserModuleUtil.unObfuscatePath(moduleId, dbConnectionString);
                    MoserMetadataConnection moserConn = module.getMetadataConnection();
                    dbConnectionString = MoserModuleUtil.makeConnectionStringAbsolute(MoserModuleManager.getDefaultDataFilePath(), dbConnectionString);
                }
                String nonEncodedDSName = ds.getName();
                properties.put("connectionString", dbConnectionString);
                properties.put(MOSER_DS_LOGICAL_NAME, nonEncodedDSName);
                properties.put(STR_VERSION, System.getProperty(PQ_VERSION_KEY, null));
                String numRows = System.getProperty(STR_NUMROWS);
                if (numRows != null) {
                    properties.put(STR_NUMROWS, Long.parseLong(numRows));
                }
                ds.setName(MoserModuleUtil.getCRC32(dbConnectionString));
                ds.setCMDataSource(ds.getName());
                ds.setInterface("PARQUET");
                if (Boolean.parseBoolean(CONFIG.getStringProperty(FLINT_SERVER_ENABLED_KEY, "true"))) {
                    ds.setName(nonEncodedDSName);
                    String pqVersion = System.getProperty(PQ_VERSION_KEY, null);
                    if (Boolean.parseBoolean(CONFIG.getStringProperty(FLINT_LAZY_CONVERSION, FALSE_BOOLEAN_STR))) {
                        MoserModuleUtil.tryToPromoteDSForFlint(ds, properties, env.getExecutionEnvironment(), null, pqVersion, false, nonEncodedDSName, false);
                    }
                }
            } else {
                dbType = dbConnectionString.startsWith("URL=jdbc:netezza:") ? "JD-NZ" : "JDBC";
                ds.setInterface(dbType);
                if (dbConnection != null) {
                    dbConnectionString = dbConnection;
                }
                properties.put("connectionString", dbConnectionString);
                if (dbUID != null && !dbUID.isEmpty()) {
                    properties.put(DS_UID, dbUID);
                }
                if (dbPW != null && !dbPW.isEmpty()) {
                    properties.put("password", dbPW);
                }
                ds.setIsContentManager(false);
                StringBuilder sb = new StringBuilder();
                sb.append(dbConnectionString);
                sb.append(dbUID);
                sb.append(dbPW);
                ds.setName(MoserModuleUtil.getCRC32(sb.toString()));
                ds.setCMDataSource(ds.getName());
                if (MOSER_WKC.equals(dbConnectionString)) {
                    MoserModuleUtil.markInvalidDS(ds, dbConnectionString);
                }
            }
        }
        for (Object k : jDS.keySet()) {
            String kName = (String)k;
            Object v = jDS.get(k);
            if (v == null) continue;
            if (kName.equals(MOSER_CMDATASOURCE)) {
                ds.setCMDataSource((String)v);
                continue;
            }
            if (kName.equals(MOSER_CATALOG)) {
                MoserCatalog cat = new MoserCatalog(module.getMetadataConnection().getNextId(), MoserModuleUtil.replaceWithReal(jDS, MOSER_CATALOG, dbConnectionInfo));
                ds.setCatalog(cat);
                if (ds.isContentManager()) continue;
                properties.put(MOSER_CATALOG, cat.getName());
                continue;
            }
            if (kName.equals(MOSER_SCHEMA)) {
                String schema = MoserModuleUtil.replaceWithReal(jDS, MOSER_SCHEMA, dbConnectionInfo);
                if (schema.startsWith(ENCRYPTION_PREFIX)) {
                    schema = MoserModuleUtil.decryptConnection(pk, schema.substring(5));
                }
                ds.setSchema(schema);
                if (ds.isContentManager()) continue;
                properties.put(MOSER_SCHEMA, schema);
                continue;
            }
            if (!kName.equals(MOSER_TABLE)) continue;
            tables = (JSONArray)v;
        }
        if (ds.getCMDataSourceName() == null) {
            ds.setCMDataSource(ds.getName());
        }
        if (!properties.isEmpty()) {
            ds.setMetadataProperties(properties);
        }
        if (tables != null) {
            MoserModuleUtil.processTables(module, ds, tables, bOnlyTable);
        }
    }

    protected static void markInvalidDS(MoserDataSource ds, String dbConnectionString) {
        String connName;
        block3: {
            connName = MOSER_WKC;
            try {
                JSONObject jObj = OrderedJSONObject.parse((String)dbConnectionString);
                Object wkcConnName = jObj.get((Object)MOSER_WKC_CONN_NAME);
                if (wkcConnName instanceof String) {
                    connName = (String)wkcConnName;
                }
            }
            catch (Exception e) {
                if (!MoserModuleManager.loggingEnabled()) break block3;
                MoserModuleManager.log(LogLevel.TRACE, e.getLocalizedMessage());
            }
        }
        ds.error = new XQERuntimeException(XQEMessageKeys.MSR_InvalideDataSource, connName);
    }

    private static LocalDateTime convertToLocalDateTime(String utcDate) {
        try {
            return LocalDateTime.parse(utcDate, DATETIMEFORMATTER);
        }
        catch (DateTimeParseException e) {
            throw new XQERuntimeException(e);
        }
    }

    private static Date convertToDate(String utcDate) {
        try {
            return DATEFORMAT.parse(utcDate);
        }
        catch (java.text.ParseException e) {
            throw new XQERuntimeException(e);
        }
    }

    private static String setConnectionString(JSONObject jsonResult, File dataFile) {
        String connectionStr = PREFIX_PARQUET_CONNECTION_STR + dataFile.getAbsolutePath().replace(BACK_SLASH, FORWARD_SLASH);
        jsonResult.put((Object)"connectionString", (Object)connectionStr);
        return connectionStr;
    }

    private static String buildBasePath(String dir, String outputId) {
        StringBuilder path = new StringBuilder();
        path.append(dir);
        path.append(outputId.substring(1, 3));
        path.append(FORWARD_SLASH);
        path.append(outputId.substring(3, 4));
        path.append(FORWARD_SLASH);
        return path.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static JSONObject preLoadOutput(ContentServiceClient csr, String objectId, String objectName, String outputName) {
        String cacheDir = MoserModuleUtil.getDatasetDirectory();
        String storeId = MoserModuleUtil.extractStoreId(objectId);
        JSONObject version = MoserModuleUtil.getVersion(csr, storeId);
        if (version == null) {
            throw new XQERuntimeException(XQEMessageKeys.MSR_ErrorLoadDataFile, storeId);
        }
        String versionId = (String)version.get((Object)ID);
        JSONObject output = MoserModuleUtil.getOutput(csr, versionId, outputName);
        if (output == null) {
            output = MoserModuleUtil.waitForOutputToBeRefreshed(csr, version, outputName);
        }
        if (output == null) {
            throw new XQERuntimeException(XQEMessageKeys.MSR_ErrorLoadDataFile, storeId);
        }
        String outputId = (String)output.get((Object)ID);
        String basePath = MoserModuleUtil.buildBasePath(cacheDir, outputId);
        JSONObject jsonResult = new JSONObject();
        String outputLastModified = (String)output.get((Object)MODIFICATION_TIME);
        JSONObject dataDescriptor = (JSONObject)output.get((Object)DATA_DESCRIPTOR);
        String pqVersion = String.valueOf(dataDescriptor.get((Object)STR_VERSION));
        Long numRows = (Long)dataDescriptor.get((Object)STR_NUMROWS);
        jsonResult.put((Object)ID, (Object)outputId);
        jsonResult.put((Object)STR_LAST_MODIFIED, (Object)outputLastModified);
        jsonResult.put((Object)STR_VERSION, (Object)pqVersion);
        jsonResult.put((Object)STR_NUMROWS, (Object)numRows);
        LocalDateTime modLDT = MoserModuleUtil.convertToLocalDateTime(outputLastModified);
        File dataFile = !ParquetVersionEnum.VERSION_1.getValue().equals(pqVersion) ? new File(basePath + outputId + DOT_DATA) : new File(basePath + outputId + pqVersion + DOT_DATA);
        jsonResult.put((Object)STR_PARQUET_PATH, (Object)dataFile.getAbsolutePath());
        String connStr = MoserModuleUtil.setConnectionString(jsonResult, dataFile);
        if (dataFile.exists()) {
            if (Boolean.parseBoolean(CONFIG.getStringProperty(FLINT_SERVER_ENABLED_KEY, "true")) && Boolean.parseBoolean(CONFIG.getStringProperty(FLINT_LAZY_CONVERSION, FALSE_BOOLEAN_STR))) {
                IDatasetManager datasetMgr = MoserModuleManager.getDatasetManager();
                MetadataInfo metaInfo = datasetMgr.getMetadataInfo(outputId);
                String logicalName = objectName + MOSER_UNDERSCORE + outputName;
                if (metaInfo != null && modLDT.compareTo(metaInfo.getUploadedFileTimestamp()) < 0) {
                    throw new XQERuntimeException(XQEMessageKeys.MSR_StaleDataAccess, (Object)outputId, (Object)metaInfo.getUploadedFileTimestamp(), (Object)outputLastModified);
                }
                if (metaInfo == null || modLDT.compareTo(metaInfo.getUploadedFileTimestamp()) > 0) {
                    MoserModuleUtil.updateMetadataInfo(outputId, logicalName, connStr, modLDT);
                }
            }
            return jsonResult;
        }
        if (Boolean.parseBoolean(CONFIG.getStringProperty(FLINT_LAZY_CONVERSION, FALSE_BOOLEAN_STR))) {
            Object lck = new Object();
            Object otherLck = sidLOCK.putIfAbsent(outputId, lck);
            if (otherLck != null) {
                lck = otherLck;
            }
            Object object = lck;
            synchronized (object) {
                MoserModuleUtil.loadPQFromCMToDiskShared(dataFile, csr, outputId, pqVersion);
                if (Boolean.parseBoolean(CONFIG.getStringProperty(FLINT_SERVER_ENABLED_KEY, "true"))) {
                    String logicalName = objectName + MOSER_UNDERSCORE + outputName;
                    MoserModuleUtil.updateMetadataInfo(outputId, logicalName, connStr, modLDT);
                }
            }
        }
        return jsonResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void upgradeParquetFileRequest(JSONObject parquetDescriptor, String cmPassport, Map<String, String> cookies) {
        MoserModuleManager.log(LogLevel.INFO, "Attempting to request for upgrade for the parquet file with descriptor: " + parquetDescriptor.toString());
        String storeID = (String)parquetDescriptor.get((Object)ID);
        String pqVersion = (String)parquetDescriptor.get((Object)STR_VERSION);
        if (!ParquetVersionEnum.VERSION_1.getValue().equals(pqVersion)) {
            DatasetManager datasetManager = (DatasetManager)MoserModuleManager.getDatasetManager();
            if (null == datasetManager) {
                MoserModuleManager.log(LogLevel.WARN, String.format("Upgrade request for parquet file with store id (%s) cannot be processed because Dataset Manager is not enabled.", storeID));
                return;
            }
            ReentrantLock lock = datasetManager.getPQUpgradeRequestToMoserLock(storeID);
            lock.lock();
            try {
                if (datasetManager.hasConversionBeenRequested(storeID)) {
                    MoserModuleManager.log(LogLevel.INFO, String.format("Already requested upgrade for parquet file with store id: %s.", storeID));
                    return;
                }
                ParquetsUpgradeClient pqUpgradeClient = new ParquetsUpgradeClient(cmPassport, cookies);
                HTTPClientResponse response = pqUpgradeClient.doUpgradeRequest(storeID, ParquetVersionEnum.VERSION_1.getValue());
                if (202 == response.getRespondeCode()) {
                    datasetManager.markForConversion(storeID);
                    MoserModuleManager.log(LogLevel.INFO, String.format("Upgrade request accepted successfully for parquet file with store id: %s.", storeID));
                }
                MoserModuleManager.log(LogLevel.WARN, String.format("Upgrade request failed for parquet file with store id (%s). The response is: %s.", storeID, response.toString()));
            }
            finally {
                lock.unlock();
            }
        } else {
            MoserModuleManager.log(LogLevel.INFO, String.format("The parquet file with storeID (%s) is already in the desired format.", storeID));
        }
    }

    private static void updateMetadataInfo(String storeID, String fileName, String connectionString, LocalDateTime lastModified) {
        MoserModuleManager.log(LogLevel.INFO, "Attempting to persist metadata info for file with storeID: " + storeID);
        IDatasetManager datasetMgr = MoserModuleManager.getDatasetManager();
        MetadataInfo metaInfo = new MetadataInfo(storeID, fileName, lastModified);
        metaInfo.setCAPQAbsolutePath(connectionString.substring(PREFIX_PARQUET_CONNECTION_STR.length()));
        metaInfo.setFlintPQAbsolutePath(MoserModuleUtil.getDatasetDirectory() + FlintUtils.generateFlintDatasetName(MoserModuleUtil.getCRC32(connectionString), fileName));
        if (!datasetMgr.persistMetadataInfo(storeID, metaInfo)) {
            throw new XQERuntimeException(XQEMessageKeys.MSR_PersistMDInfoFailure, storeID);
        }
    }

    private static JSONObject waitForOutputToBeRefreshed(ContentServiceClient csr, JSONObject version, String outputName) {
        long maxWaitTime = ConfigService.getInstance().getMaxWaitTimeDataset2Refresh();
        if (MoserModuleManager.loggingEnabled()) {
            MoserModuleManager.log(LogLevel.INFO, "Check if module is being refreshed. Waiting at most " + maxWaitTime + "ms");
        }
        String versionId = (String)version.get((Object)ID);
        if (!MoserModuleUtil.versionModifiedRecently(version)) {
            if (MoserModuleManager.loggingEnabled()) {
                MoserModuleManager.log(LogLevel.INFO, "Dataset not modified recently.");
            }
            return null;
        }
        JSONObject response = null;
        int numTries = 0;
        long sleepTime = 1000L;
        long maxTries = maxWaitTime / sleepTime;
        long startTime = System.currentTimeMillis();
        while ((long)numTries < maxTries) {
            block10: {
                try {
                    Thread.sleep(sleepTime);
                    response = MoserModuleUtil.getOutput(csr, versionId, outputName);
                }
                catch (InterruptedException e) {
                    if (!MoserModuleManager.loggingEnabled()) break block10;
                    MoserModuleManager.log(LogLevel.INFO, e);
                }
            }
            if (response != null) break;
            ++numTries;
        }
        long endTime = System.currentTimeMillis();
        if (response != null) {
            if (MoserModuleManager.loggingEnabled()) {
                MoserModuleManager.log(LogLevel.INFO, "Module is refreshed. Waited " + (endTime - startTime) + "milliseconds.");
            }
        } else if (MoserModuleManager.loggingEnabled()) {
            MoserModuleManager.log(LogLevel.INFO, "Module still not refreshed after waiting " + (endTime - startTime) + "ms.");
        }
        return response;
    }

    private static boolean versionModifiedRecently(JSONObject version) {
        String modificationTime = (String)version.get((Object)MODIFICATION_TIME);
        long lastModified = MoserModuleUtil.getTimeInMillis(modificationTime);
        long currentTime = System.currentTimeMillis();
        return currentTime - lastModified <= ConfigService.getInstance().getDatasetLastModifiedThreshold();
    }

    private static void loadPQFromCMToDiskShared(File dataFile, ContentServiceClient csr, String outputId, String dataDescriptorPQVersion) {
        block6: {
            if (dataFile.exists()) {
                return;
            }
            File folder = dataFile.getParentFile();
            File tmpFile = null;
            try {
                folder.mkdirs();
                tmpFile = File.createTempFile(outputId, DOT_TMP, folder);
                MoserModuleUtil.loadDataFileFromCMOnDisk(tmpFile, csr, outputId);
                if (dataFile.exists()) {
                    FileUtils.deleteQuietly((File)tmpFile);
                } else {
                    MoserModuleUtil.comparePQVersionAgainstOutputDataDescriptorVersion(tmpFile, dataDescriptorPQVersion);
                    Files.move(tmpFile.toPath(), dataFile.toPath(), new CopyOption[0]);
                }
            }
            catch (Exception e) {
                if (tmpFile != null) {
                    FileUtils.deleteQuietly(tmpFile);
                }
                if (dataFile.exists()) break block6;
                throw new XQERuntimeException(XQEMessageKeys.MSR_ErrorLoadDataFile, (Throwable)e, outputId);
            }
        }
    }

    private static boolean comparePQVersionAgainstOutputDataDescriptorVersion(File pqFile, String theDataDescriptorPQVersion) throws IOException {
        boolean result = true;
        Configuration config = FlintUtils.getHadoopConfiguration();
        DatasetParquetReadHelper pqHelper = new DatasetParquetReadHelper();
        pqHelper.readFooter(new shaded.org.apache.hadoop.fs.Path(pqFile.toString()), config);
        String pqFileVersion = pqHelper.getKeyValueMetadata().getOrDefault("parquet.ca.version", ParquetVersionEnum.LEGACY.getValue());
        if (ParquetVersionEnum.VERSION_1.getValue().compareTo(theDataDescriptorPQVersion) == 0 && theDataDescriptorPQVersion.compareTo(pqFileVersion) != 0) {
            result = false;
        }
        if (!result) {
            throw new XQERuntimeException(XQEMessageKeys.GEN_FoundInternalErrorParam_INTERNAL, String.format("Unexpected Dataset Descriptor: expected (%s) found (%s).", pqFileVersion, theDataDescriptorPQVersion));
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void loadDataFileFromCMOnDisk(File dataFile, ContentServiceClient csr, String outputId) throws IOException {
        if (MoserModuleManager.loggingEnabled()) {
            MoserModuleManager.log(LogLevel.INFO, OperationEnum.START, "start loading data file for " + outputId);
        }
        FileOutputStream fos = null;
        FilterOutputStream bos = null;
        try {
            fos = new FileOutputStream(dataFile);
            bos = new BufferedOutputStream(fos);
            csr.getData(outputId, bos);
        }
        finally {
            if (bos != null) {
                bos.close();
            }
            if (fos != null) {
                fos.close();
            }
        }
        if (MoserModuleManager.loggingEnabled()) {
            MoserModuleManager.log(LogLevel.INFO, OperationEnum.END, "end loading data file for " + outputId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getDatasetDirectory() {
        if (MoserModuleManager.loggingEnabled()) {
            MoserModuleManager.log(LogLevel.INFO, "Getting dataset directory.");
        }
        ConfigService config = ConfigService.getInstance();
        String datasetCacheDirectory = config.getDatasetCacheDirectory();
        if (scheduledCacheCleanup == null) {
            Object object = cleanupLock;
            synchronized (object) {
                if (scheduledCacheCleanup == null) {
                    long cleanupFrequency = config.getDatasetCleanupFrequency();
                    if (MoserModuleManager.loggingEnabled()) {
                        MoserModuleManager.log(LogLevel.INFO, "Initializing dataset cache cleanup thread to run every " + Long.toString(cleanupFrequency) + " seconds.");
                    }
                    MoserCacheCleanupRunnable r = MoserCacheCleanupRunnable.getInstance();
                    r.deleteDirectories(datasetCacheDirectory, MoserCacheCleanupRunnable.CleanOption.CLEAN_TEMPORARY);
                    scheduledCacheCleanup = XQEService.getWorkerPool().scheduleWithFixedDelay(r, cleanupFrequency, cleanupFrequency, TimeUnit.SECONDS);
                }
            }
        }
        MoserCacheCleanupRunnable.getInstance().addDirectory(datasetCacheDirectory);
        return datasetCacheDirectory;
    }

    private static JSONObject getVersion(ContentServiceClient csr, String storeId) {
        HTTPClientResponse response = csr.getJSON(storeId, ITEMS, REPORT_VERSION, new String[0]);
        if (response == null) {
            throw new XQERuntimeException(XQEMessageKeys.MSR_ErrorLoadDataFile, storeId);
        }
        if (response.getRespondeCode() >= 400) {
            throw new XQERuntimeException(XQEMessageKeys.GEN_InvalidResponse, response.getRespondeCode(), (Object)response.toString());
        }
        JSONObject output = response.getJSONObjectResponse();
        if (output == null) {
            return null;
        }
        JSONArray data = (JSONArray)output.get((Object)DATA);
        if (data == null || data.isEmpty()) {
            return null;
        }
        return (JSONObject)data.get(0);
    }

    private static JSONObject getOutput(ContentServiceClient csr, String storeId, String outputName) {
        HTTPClientResponse response = csr.getJSON(storeId, ITEMS, OUTPUT, DATA_DESCRIPTOR, DEFAULT_NAME);
        if (response == null) {
            throw new XQERuntimeException(XQEMessageKeys.MSR_ErrorLoadDataFile, storeId);
        }
        if (response.getRespondeCode() >= 400) {
            throw new XQERuntimeException(XQEMessageKeys.GEN_InvalidResponse, response.getRespondeCode(), (Object)response.toString());
        }
        JSONObject result = response.getJSONObjectResponse();
        if (result == null) {
            return null;
        }
        JSONArray outputs = (JSONArray)result.get((Object)DATA);
        if (outputs.size() == 1) {
            return (JSONObject)outputs.get(0);
        }
        for (Object o : outputs) {
            JSONObject output = (JSONObject)o;
            if (!outputName.equals(output.get((Object)DEFAULT_NAME))) continue;
            return output;
        }
        return null;
    }

    private static String extractStoreId(String moduleId) {
        return StringUtils.substringBeforeLast((String)moduleId, (String)MOSER_DOT);
    }

    private static String unObfuscatePath(String moduleId, String value) {
        String id = moduleId;
        id = id.replace(':', '.');
        id = id.replaceFirst("datasets.", MOSER_EMPTY_STRING);
        id = id.replaceFirst(DOT_PHYSICALMODULE, MOSER_EMPTY_STRING);
        return value.replace('\\', '/').replaceFirst(FORWARD_SLASH, FORWARD_SLASH + id);
    }

    private static String makeConnectionStringAbsolute(String providedPath, String value) {
        String path = providedPath;
        if (path == null) {
            path = ConfigService.getInstance().getDatasetServiceDirectory();
        }
        return value.replaceFirst(PREFIX_PARQUET_CONNECTION_STR, PREFIX_PARQUET_CONNECTION_STR + path);
    }

    protected static void processTables(MoserModule module, MoserDataSource ds, JSONArray tables, boolean bOnlyTable) {
        for (int i = 0; i < tables.size(); ++i) {
            JSONArray jTableItems;
            JSONArray jColumns;
            JSONObject jTable = (JSONObject)tables.get(i);
            String tableName = (String)jTable.get((Object)MOSER_NAME);
            String extTableName = (String)jTable.get((Object)MOSER_EXTERNALNAME);
            String dataCacheExpiry = (String)jTable.get((Object)MOSER_DATA_CACHE_EXPIRY);
            if (extTableName == null) {
                extTableName = tableName;
            }
            MoserQuerySubject qs = null;
            if (!bOnlyTable) {
                qs = new MoserQuerySubject(module.getMetadataConnection().getNextId(), tableName, i);
                qs.setParentModule(module);
                qs.setParentDataSource(ds);
                qs.setQuerySubjectDataCacheExpiry(dataCacheExpiry);
                module.addQuerySubject(qs);
                qs.setDefinitionType(STR_DB_QUERY);
                qs.setQuerySubjectType(IQuerySubject.QuerySubjectTypeEnum.DBQSASVIEW);
                qs.setUniqueID(module.getUniqueName() + MOSER_DOT + ds.getName() + MOSER_DOT + qs.getName());
                qs.setV5UniqueName(UniqueNameGenerator.createEscapedUniqueName(module.getUniqueName() + MOSER_DOT + ds.getName(), qs.getName()));
                String sqlText = MoserModuleUtil.generateCogSQL(qs.getName());
                qs.setSql(sqlText);
                qs.setClassifier(QsClassifierType.SQL_QUERY_SUBJECT);
            } else if (ds.getTableByName(tableName) != null) continue;
            MoserPhysicalTable tb = new MoserPhysicalTable(module.getMetadataConnection().getNextId(), tableName);
            ds.addTable(tableName, tb);
            tb.setExternalName(extTableName);
            String pkName = null;
            HashSet<String> pkColumnNames = null;
            JSONArray jPKs = (JSONArray)jTable.get((Object)MOSER_PRIMARYKEY);
            if (jPKs != null && jPKs.size() == 1) {
                JSONObject jPK = (JSONObject)jPKs.get(0);
                JSONArray jKeyedCols = (JSONArray)jPK.get((Object)MOSER_KEYEDCOLUMN);
                if (jKeyedCols != null && !jKeyedCols.isEmpty()) {
                    pkColumnNames = new HashSet<String>();
                    for (Object keyCol : jKeyedCols) {
                        pkColumnNames.add((String)keyCol);
                    }
                }
                if ((pkName = (String)jPK.get((Object)MOSER_NAME)) == null) {
                    pkName = MOSER_PRIMARYKEY;
                }
            }
            if ((jColumns = (JSONArray)jTable.get((Object)MOSER_COLUMN)) != null) {
                MoserModuleUtil.processColumn(module, qs, tb, jColumns, pkName, pkColumnNames);
            }
            if ((jTableItems = (JSONArray)jTable.get((Object)MOSER_TABLEITEM)) == null) continue;
            MoserModuleUtil.processTableItem(module, qs, tb, jTableItems, pkName, pkColumnNames);
        }
    }

    protected static String generateCogSQL(String tableName) {
        StringBuilder sb = new StringBuilder();
        sb.append("<sql type=\"cognos\">select <column>*</column> from <table>");
        sb.append(MOSER_DOUBLE_QUOTE);
        sb.append(tableName);
        sb.append(MOSER_DOUBLE_QUOTE);
        sb.append("</table></sql>");
        return sb.toString();
    }

    protected static void processColumn(MoserModule module, MoserQuerySubject qs, MoserPhysicalTable tb, JSONArray jColumns, String pkName, Set<String> pkColumnNames) {
        TreeSet<IQueryItem> primaryKeyQIs = new TreeSet<IQueryItem>();
        TreeSet<IQueryItem> attributeQIs = new TreeSet<IQueryItem>();
        for (Object o : jColumns) {
            JSONObject jCol = (JSONObject)o;
            MoserModuleUtil.processColumn(module, qs, tb, pkColumnNames, primaryKeyQIs, attributeQIs, jCol);
        }
    }

    protected static void processTableItem(MoserModule module, MoserQuerySubject qs, MoserPhysicalTable tb, JSONArray jTableItems, String pkName, Set<String> pkColumnNames) {
        TreeSet<IQueryItem> primaryKeyQIs = new TreeSet<IQueryItem>();
        TreeSet<IQueryItem> attributeQIs = new TreeSet<IQueryItem>();
        for (Object o : jTableItems) {
            JSONObject tableItem = (JSONObject)o;
            for (Object e : tableItem.entrySet()) {
                Map.Entry entry = (Map.Entry)e;
                if (!MOSER_COLUMN.equals(entry.getKey())) continue;
                MoserModuleUtil.processColumn(module, qs, tb, pkColumnNames, primaryKeyQIs, attributeQIs, (JSONObject)entry.getValue());
            }
        }
    }

    private static void processColumn(MoserModule module, MoserQuerySubject qs, MoserPhysicalTable tb, Set<String> pkColumnNames, TreeSet<IQueryItem> primaryKeyQIs, TreeSet<IQueryItem> attributeQIs, JSONObject jCol) {
        String name = (String)jCol.get((Object)MOSER_NAME);
        MoserQueryItem qi = null;
        if (qs != null) {
            qi = new MoserQueryItem(module.getMetadataConnection().getNextId(), name, -1);
            qi.setQuerySubject(qs);
            qi.setParent(qs);
            qi.setUniqueID(qs.getUniqueID() + MOSER_DOT + qi.getName());
            qi.setV5UniqueName(UniqueNameGenerator.appendUniqueName(qs.getV5UniqueName(), qi.getName()));
            qs.addQueryItem(qi);
            module.registerExpressionObject(qi.getUniqueID(), qi);
            if (pkColumnNames != null) {
                if (pkColumnNames.contains(name)) {
                    primaryKeyQIs.add(qi);
                } else {
                    attributeQIs.add(qi);
                }
            }
        }
        MoserPhysicalColumn cl = new MoserPhysicalColumn(module.getMetadataConnection().getNextId(), name);
        tb.addColumn(cl);
        MoserModuleUtil.initializeColumn(qi, cl, jCol);
    }

    protected static void initializeColumn(MoserQueryItem qi, MoserPhysicalColumn cl, JSONObject jCol) {
        for (Object k : jCol.keySet()) {
            String kName = (String)k;
            Object v = jCol.get(k);
            if (v == null) continue;
            if (kName.equals(MOSER_DATATYPE)) {
                String dtTxt = ((String)v).toLowerCase(Locale.ENGLISH);
                IDataType dt = null;
                while (dt == null) {
                    try {
                        dt = SQLProcessor.parseDataType(MoserModuleUtil.getSQLDataTypeFromJMDDataType(dtTxt));
                    }
                    catch (ParseException e) {
                        dtTxt = VARCHAR2000;
                    }
                }
                if (qi != null) {
                    qi.setDataType(dt);
                }
                cl.setDataType(dt);
                continue;
            }
            if (!kName.equals(MOSER_NULLABLE)) continue;
            Boolean f = (Boolean)v;
            if (qi != null) {
                qi.setIsNullable(f);
            }
            cl.setIsNullable(f);
        }
    }

    public static void initializeQuerySubject(IMoserModule module, MoserQuerySubject qs, JSONObject jQS, String userPassport, List<ExpressionResolveContext> c, Map<String, String> cookiesToMoser, boolean bTop, MoserEnv env, FormatConverter fc) {
        qs.setDefinitionType(STR_MODEL_QUERY);
        qs.setQuerySubjectType(IQuerySubject.QuerySubjectTypeEnum.MODELQUERYSUBJECT);
        qs.setUniqueID(((MoserModule)module).getUniqueName() + MOSER_DOT + qs.getName());
        qs.setV5UniqueName(UniqueNameGenerator.createEscapedUniqueName(((MoserModule)module).getUniqueName(), qs.getName()));
        MoserModuleUtil.initializeQuerySubjectDef(module, qs, jQS, userPassport, c, cookiesToMoser, bTop, env, fc);
    }

    protected static void initializeQuerySubjectDef(IMoserModule module, MoserQuerySubject qs, JSONObject jQS, String userPassport, List<ExpressionResolveContext> c, Map<String, String> cookiesToMoser, boolean bTop, MoserEnv env, FormatConverter fc) {
        JSONArray items = null;
        JSONArray queryItems = null;
        JSONArray filters = null;
        JSONArray securityFilters = null;
        JSONObject itemNormalization = null;
        String label = null;
        for (Object k : jQS.keySet()) {
            String kName = (String)k;
            Object v = jQS.get(k);
            if (kName.equals(MOSER_QUERYITEM)) {
                queryItems = (JSONArray)v;
                continue;
            }
            if (kName.equals(MOSER_QUERYSUBJECTUSAGE)) {
                qs.setQuerySubjectUsage(MoserModuleUtil.convertQuerySubjectUsageToEnum((String)v));
                continue;
            }
            if (kName.equals(MOSER_SELECTLISTCONTROL)) {
                qs.selectListControl = MoserModuleUtil.convertSelectListControlToEnum((String)v);
                continue;
            }
            if (kName.equals(MOSER_GENERATESQL)) {
                qs.setGeneratedSQLOption((String)v);
                continue;
            }
            if (kName.equals(MOSER_REF)) {
                qs.setRefs((JSONArray)v);
                continue;
            }
            if (kName.equals(MOSER_ORIGINAL_REF)) {
                qs.setOriginalRefs((JSONArray)v);
                continue;
            }
            if (kName.equals(MOSER_FILTER)) {
                filters = (JSONArray)v;
                continue;
            }
            if (kName.equals(MOSER_SECURITY_FILTER)) {
                securityFilters = (JSONArray)v;
                continue;
            }
            if (kName.equals(MOSER_LABEL)) {
                label = (String)v;
                continue;
            }
            if (kName.equals(MOSER_ITEM)) {
                items = (JSONArray)v;
                continue;
            }
            if (kName.equals(MOSER_ITEM_NORMALIZATION)) {
                itemNormalization = (JSONObject)v;
                continue;
            }
            if (!kName.equals(MOSER_DATA_CACHE_EXPIRY)) continue;
            qs.setQuerySubjectDataCacheExpiry((String)v);
        }
        if (label != null) {
            qs.setLabel(label);
        }
        DeterminantDef det = new DeterminantDef();
        det.bStop = true;
        det.userPassport = userPassport;
        det.cookiesToMoser = cookiesToMoser;
        if (items != null) {
            det.bStop = false;
            if (bTop) {
                det.calcUniqueIds = MoserModuleUtil.getQueryItemsTreatedAsCalculation(((MoserModule)module).getUniqueName(), qs.getUniqueID(), items);
            }
            MoserModuleUtil.processItem(module, qs, items, c, det, bTop, null, env, fc);
        } else if (queryItems != null) {
            det.bStop = false;
            MoserModuleUtil.processQueryItem(module, qs, queryItems, c, det, bTop, env, fc);
        }
        if (filters != null) {
            det.bStop = true;
            MoserModuleUtil.processEmbeddedFilters(module, qs, filters, c);
        }
        if (securityFilters != null) {
            MoserModuleUtil.processSecurityFilters(module, qs, securityFilters, c);
        }
        if (itemNormalization != null) {
            MoserModuleUtil.resolveItemNormalization(qs, itemNormalization);
        }
        QsClassifierType classifier = qs.getClassifier();
        if (c != null && (classifier == QsClassifierType.OPERATION_QUERY_SUBJECT || classifier == QsClassifierType.JOIN_QUERY_SUBJECT)) {
            ExpressionResolveContext o = new ExpressionResolveContext();
            o.objResolve = qs;
            o.parentChain = new ArrayList();
            o.moserModule = (MoserModule)module;
            o.userPassport = det.userPassport;
            o.cookiesToMoser = det.cookiesToMoser;
            o.jsonDef = jQS;
            c.add(o);
        }
    }

    protected static Set<String> getQueryItemsTreatedAsCalculation(String moduleUID, String qsUID, JSONArray items) {
        HashSet<String> calcsId4Expr = new HashSet<String>();
        HashSet<String> calcsId = new HashSet<String>();
        HashMap<String, JSONObject> others = new HashMap<String, JSONObject>();
        int prefixLen = moduleUID.length() + 1;
        MoserModuleUtil.getInitialCalculationIds(prefixLen, qsUID, false, items, calcsId4Expr, calcsId, others);
        if (calcsId4Expr.isEmpty() || others.isEmpty()) {
            return null;
        }
        HashMap<String, Pair> othersToIds = new HashMap<String, Pair>();
        for (Map.Entry<String, JSONObject> entry : others.entrySet()) {
            List ids;
            JSONObject jQI = entry.getValue();
            String expr = (String)jQI.get((Object)MOSER_EXPRESSION);
            if (expr == null || (ids = ItemScanner.collectIdentifiers((String)expr)).isEmpty()) continue;
            Pair p = new Pair(jQI.get((Object)MOSER_ID), ids);
            othersToIds.put(entry.getKey(), p);
        }
        if (othersToIds.isEmpty()) {
            return null;
        }
        HashSet<String> rt = new HashSet<String>();
        Set<Pair> tmp = MoserModuleUtil.getCalculations(othersToIds, calcsId4Expr, calcsId);
        while (!tmp.isEmpty()) {
            calcsId4Expr.clear();
            calcsId.clear();
            for (Pair p : tmp) {
                String fullId = (String)p.getSecond();
                String id = (String)p.getFirst();
                String id4Expr = fullId.substring(prefixLen);
                rt.add(fullId);
                calcsId4Expr.add(id4Expr);
                calcsId.add(id);
                othersToIds.remove(fullId);
            }
            tmp = MoserModuleUtil.getCalculations(othersToIds, calcsId4Expr, calcsId);
        }
        if (rt.isEmpty()) {
            return null;
        }
        return rt;
    }

    protected static Set<Pair> getCalculations(Map<String, Pair> othersToIds, Set<String> calcsId4Expr, Set<String> calcsId) {
        HashSet<Pair> r = new HashSet<Pair>();
        for (Map.Entry<String, Pair> entry : othersToIds.entrySet()) {
            String fullId = entry.getKey();
            Pair p = entry.getValue();
            String id = (String)p.getFirst();
            List usedIds = (List)p.getSecond();
            if (!MoserModuleUtil.idsUsed(usedIds, calcsId4Expr, calcsId)) continue;
            r.add(new Pair(id, fullId));
        }
        return r;
    }

    protected static boolean idsUsed(List<String[]> usedIds, Set<String> calcsId4Expr, Set<String> calcsId) {
        for (String[] usedId : usedIds) {
            String id4expr;
            if (!(usedId.length == 1 ? calcsId.contains(usedId[0]) : calcsId4Expr.contains(id4expr = MoserModuleUtil.buildNameFromParts(usedId)))) continue;
            return true;
        }
        return false;
    }

    protected static void getInitialCalculationIds(int prefix, String parentUID, boolean bSplit, JSONArray items, Set<String> calcsId4Expr, Set<String> calcsId, Map<String, JSONObject> others) {
        for (int i = 0; i < items.size(); ++i) {
            JSONArray jItems;
            JSONObject jITM = (JSONObject)items.get(i);
            JSONObject jQI = (JSONObject)jITM.get((Object)MOSER_QUERYITEM);
            JSONObject jFolder = null;
            if (jQI == null) {
                jFolder = (JSONObject)jITM.get((Object)MOSER_FOLDER);
            }
            if (jFolder != null) {
                JSONArray jItems2 = (JSONArray)jFolder.get((Object)MOSER_ITEM);
                if (jItems2 == null) continue;
                MoserModuleUtil.getInitialCalculationIds(prefix, parentUID, bSplit, jItems2, calcsId4Expr, calcsId, others);
                continue;
            }
            if (jQI == null) continue;
            String qiId = (String)jQI.get((Object)MOSER_ID);
            String uID = parentUID + MOSER_DOT + qiId;
            if (bSplit || MoserModuleUtil.isPostAggregateCalculation(jQI)) {
                calcsId4Expr.add(uID.substring(prefix));
                if (!bSplit) {
                    calcsId.add(qiId);
                }
            } else {
                others.put(uID, jQI);
            }
            boolean bS = false;
            JSONArray sp = (JSONArray)jQI.get((Object)MOSER_SPLIT_DEFINITION);
            if (MoserModuleUtil.notEmptyArray(sp)) {
                JSONObject aSP = (JSONObject)sp.get(0);
                String spRef = (String)aSP.get((Object)MOSER_REF);
                String[] nameParts = spRef.split(STR_DOT_REGX);
                boolean bl = bS = nameParts.length == 2;
            }
            if ((jItems = (JSONArray)jQI.get((Object)MOSER_ITEM)) == null) continue;
            MoserModuleUtil.getInitialCalculationIds(prefix, uID, bS, jItems, calcsId4Expr, calcsId, others);
        }
    }

    protected static String getId(IMetadata o) {
        ArrayList<String> lst = new ArrayList<String>();
        for (IMetadata p = o; p != null; p = p.getParentObject()) {
            if (p instanceof MoserQueryItem || p instanceof MoserCalculation || p instanceof MoserQuerySubject) {
                lst.add(0, p.getName());
            }
            if (p instanceof MoserQuerySubject) break;
        }
        return MoserModuleUtil.partsToString(lst.toArray(new String[0]));
    }

    protected static String partsToString(String[] parts) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < parts.length; ++i) {
            if (i > 0) {
                sb.append(MOSER_DOT);
            }
            if (parts[i].startsWith("[") && parts[i].endsWith("]")) {
                sb.append(parts[i].substring(1, parts[i].length() - 1));
                continue;
            }
            sb.append(parts[i]);
        }
        return sb.toString();
    }

    protected static boolean validateCalculatedQueryItemExpr(String qsId, String expr, String u, Set<String> idsCopy) {
        if (!MOSER_USAGE_FACT.equalsIgnoreCase(u)) {
            return false;
        }
        List objs = ItemScanner.collectIdentifiers((String)expr);
        for (String[] p : objs) {
            String id = MoserModuleUtil.partsToString(p);
            String first = p[0];
            if (first.startsWith("[") && first.endsWith("]")) {
                first = first.substring(1, first.length() - 1);
            }
            if (!qsId.equals(first)) {
                id = qsId + MOSER_DOT + id;
            }
            if (idsCopy.contains(id)) continue;
            return false;
        }
        return true;
    }

    public static XQERuntimeException preCheckCalculatedQueryItem(MoserCalculation calc, String calculationExpression) {
        MoserQuerySubject qs = MoserModuleUtil.getParentQuerySubject(calc);
        if (qs == null) {
            return null;
        }
        if (calc.usage == null) {
            return null;
        }
        HashSet<String> ids = new HashSet<String>();
        for (MoserQueryItem qi : qs.queryItems) {
            ids.add(MoserModuleUtil.getId(qi));
        }
        for (MoserCalculation c : qs.calculations) {
            if (c.equals(calc)) continue;
            ids.add(MoserModuleUtil.getId(c));
        }
        String u = calc.getUsage();
        if (!MoserModuleUtil.validateCalculatedQueryItemExpr(qs.getName(), calculationExpression, u, ids)) {
            XQERuntimeException e = new XQERuntimeException(XQEMessageKeys.MSR_InvalideCalculatedQueryItem, calc.getName(), qs.getName());
            return e;
        }
        return null;
    }

    public static XQERuntimeException preCheckCalculatedExpression(MoserQuerySubject qs, String calculationExpression, String usage) {
        HashSet<String> ids = new HashSet<String>();
        for (MoserQueryItem qi : qs.queryItems) {
            ids.add(MoserModuleUtil.getId(qi));
        }
        for (MoserCalculation c : qs.calculations) {
            ids.add(MoserModuleUtil.getId(c));
        }
        if (!MoserModuleUtil.validateCalculatedQueryItemExpr(qs.getName(), calculationExpression, usage, ids)) {
            XQERuntimeException e = new XQERuntimeException(XQEMessageKeys.MSR_InvalideCalculatedExpression, qs.getName());
            return e;
        }
        return null;
    }

    public static MoserQuerySubject getParentQuerySubject(IMetadata o) {
        for (IMetadata p = o; p != null; p = p.getParentObject()) {
            if (!(p instanceof MoserQuerySubject)) continue;
            return (MoserQuerySubject)p;
        }
        return null;
    }

    protected static void initializeQuerySubjectTypedInSQL(IMoserModule module, MoserQuerySubject qs, JSONObject jQS, String userPassport, List<ExpressionResolveContext> c, Map<String, String> cookiesToMoser, boolean bTop, MoserEnv env, FormatConverter fc) {
        qs.setClassifier(QsClassifierType.QUERY_SUBJECT);
        qs.setDefinitionType(STR_MODEL_QUERY);
        qs.setQuerySubjectType(IQuerySubject.QuerySubjectTypeEnum.MODELQUERYSUBJECT);
        qs.setUniqueID(((MoserModule)module).getUniqueName() + MOSER_DOT + qs.getName());
        qs.setV5UniqueName(UniqueNameGenerator.createEscapedUniqueName(((MoserModule)module).getUniqueName(), qs.getName()));
        JSONObject sqlQuery = (JSONObject)jQS.get((Object)"sqlQuery");
        qs.addSourceQuerySubjectsForBinding(MoserModuleUtil.createDBQuerySubjectForSQLQuery(module, sqlQuery, qs, env, fc));
        MoserModuleUtil.initializeQuerySubjectDef(module, qs, jQS, userPassport, c, cookiesToMoser, bTop, env, fc);
    }

    protected static MoserQuerySubject createDBQuerySubjectForSQLQuery(IMoserModule module, JSONObject sqlQuery, MoserQuerySubject parentQS, MoserEnv env, FormatConverter fc) {
        String id = (String)sqlQuery.get((Object)MOSER_ID);
        MoserQuerySubject qs = new MoserQuerySubject(module.getMetadataConnection().getNextId(), id, -1);
        qs.setParentModule((MoserModule)module);
        qs.setQuerySubjectType(IQuerySubject.QuerySubjectTypeEnum.DBQSASVIEW);
        qs.setDefinitionType(STR_DB_QUERY);
        qs.setUniqueID(parentQS.getUniqueID() + MOSER_DOT + qs.getName());
        qs.setV5UniqueName(UniqueNameGenerator.appendUniqueName(parentQS.getV5UniqueName(), qs.getName()));
        String[] cmDS = new String[]{null};
        qs.setSql(MoserModuleUtil.generateTypedInSQL(module, sqlQuery, cmDS));
        if (cmDS[0] != null) {
            qs.cmDataSourceName = cmDS[0];
        }
        qs.setClassifier(QsClassifierType.SQL_QUERY_SUBJECT);
        JSONArray projItems = (JSONArray)sqlQuery.get((Object)MOSER_PROJECTEDITEM);
        if (MoserModuleUtil.notEmptyArray(projItems)) {
            for (int i = 0; i < projItems.size(); ++i) {
                JSONObject aProjItem = (JSONObject)projItems.get(i);
                String name = (String)aProjItem.get((Object)MOSER_ID);
                MoserQueryItem qi = new MoserQueryItem(module.getMetadataConnection().getNextId(), name, i);
                qi.setQuerySubject(qs);
                qs.addQueryItem(qi);
                qi.setDefaultLocale(((MoserModule)module).getExpressionLocale());
                qi.setUniqueID(qs.getUniqueID() + MOSER_DOT + qi.getName());
                qi.setV5UniqueName(UniqueNameGenerator.appendUniqueName(qs.getV5UniqueName(), qi.getName()));
                MoserModuleUtil.initializeQueryItem(module, qi, aProjItem, qs, null, null, false, env, fc);
                ((MoserModule)module).registerExpressionObject(qi.getUniqueID(), qi);
            }
        }
        return qs;
    }

    protected static String generateTypedInSQL(IMoserModule module, JSONObject sqlQuery, String[] cmDS) {
        String sqlText = null;
        String sqlType = null;
        for (Object k : sqlQuery.keySet()) {
            JSONArray dsRef;
            String kName = (String)k;
            Object v = sqlQuery.get(k);
            if (kName.equals(MOSER_SQLTEXT)) {
                sqlText = (String)v;
                continue;
            }
            if (kName.equals(MOSER_SQLTYPE)) {
                sqlType = (String)v;
                continue;
            }
            if (!kName.equals(MOSER_DATASOURCEREF) || !MoserModuleUtil.notEmptyArray(dsRef = (JSONArray)v)) continue;
            cmDS[0] = (String)dsRef.get(0);
        }
        StringBuilder sb = new StringBuilder();
        sb.append("<sql");
        if (sqlType != null) {
            sb.append(" type=");
            sb.append(MOSER_DOUBLE_QUOTE);
            sb.append(sqlType);
            sb.append(MOSER_DOUBLE_QUOTE);
        }
        sb.append(">");
        if (sqlText != null) {
            sb.append(StringSubstitutionEngine.escapeString(sqlText));
        }
        sb.append("</sql>");
        return sb.toString();
    }

    private static void processEmbeddedFilters(IMoserModule module, MoserQuerySubject qs, JSONArray filters, List<ExpressionResolveContext> c) {
        if (MoserModuleManager.loggingEnabled()) {
            MoserModuleManager.log(LogLevel.TRACE, "processEmbeddedFilters of moduleId=" + module.getIdentifier());
        }
        for (int i = 0; i < filters.size(); ++i) {
            Boolean b;
            JSONObject filter = (JSONObject)filters.get(i);
            String name = (String)filter.get((Object)MOSER_ID);
            MoserEmbeddedFilter eFilter = new MoserEmbeddedFilter(module.getMetadataConnection().getNextId(), name);
            eFilter.setQuerySubject(qs);
            String fExpression = (String)filter.get((Object)MOSER_EXPRESSION);
            if (fExpression != null) {
                eFilter.setExpression(fExpression);
                eFilter.setDefaultLocale(((MoserModule)module).getExpressionLocale());
            }
            if (c != null) {
                ExpressionResolveContext o = new ExpressionResolveContext();
                o.objResolve = eFilter;
                o.parentChain = new ArrayList();
                o.parentChain.add(qs);
                o.moserModule = (MoserModule)module;
                c.add(o);
            }
            if (Boolean.TRUE.equals(b = (Boolean)filter.get((Object)MOSER_POSTAUTOAGGREGATION))) {
                eFilter.setPostAutoAggregation(true);
            }
            qs.addEmbeddedFilter(eFilter);
            ((MoserModule)module).registerExpressionObject(qs.getUniqueID() + MOSER_DOT + name, eFilter);
        }
    }

    private static void processSecurityFilters(IMoserModule module, MoserQuerySubject qs, JSONArray filters, List<ExpressionResolveContext> c) {
        if (MoserModuleManager.loggingEnabled()) {
            MoserModuleManager.log(LogLevel.TRACE, "processSecurityFilters of moduleId: " + module.getIdentifier());
        }
        for (Object current : filters) {
            MoserModuleUtil.processSecurityObjects((JSONObject)current, qs, module, c);
        }
    }

    private static void processSecurityObjects(JSONObject filter, MoserQuerySubject qs, IMoserModule module, List<ExpressionResolveContext> c) {
        if (!filter.containsKey((Object)MOSER_SECURITY_OBJECT)) {
            return;
        }
        JSONObject securityObj = (JSONObject)filter.get((Object)MOSER_SECURITY_OBJECT);
        String filterId = (String)filter.get((Object)MOSER_ID);
        String securityObjName = (String)securityObj.get((Object)"displayPath");
        JSONArray arrSecurityObj = (JSONArray)securityObj.get((Object)"cmSearchPath");
        for (Object current : arrSecurityObj) {
            ArrayList<ISecurityObject> objs = new ArrayList<ISecurityObject>();
            String name = qs.uniqueId + MOSER_DOT + filterId;
            MoserEmbeddedFilter eFilter = new MoserEmbeddedFilter(module.getMetadataConnection().getNextId(), name);
            eFilter.setQuerySubject(qs);
            String fExpression = (String)filter.get((Object)MOSER_EXPRESSION);
            if (fExpression != null) {
                eFilter.setExpression(fExpression);
                eFilter.setDefaultLocale(((MoserModule)module).getExpressionLocale());
            }
            if (c != null) {
                ExpressionResolveContext o = new ExpressionResolveContext();
                o.objResolve = eFilter;
                o.parentChain = new ArrayList();
                o.parentChain.add(qs);
                o.moserModule = (MoserModule)module;
                c.add(o);
            }
            objs.add(new MoserSecurityObject(module.getMetadataConnection().getNextId(), securityObjName, (String)current));
            eFilter.setSecurityObject(objs);
            qs.addSecurityFilter(eFilter);
            ((MoserModule)module).registerExpressionObject(qs.getUniqueID() + MOSER_DOT + name, eFilter);
        }
    }

    protected static IQuerySubject.QuerySubjectUsageEnum convertQuerySubjectUsageToEnum(String qsUsage) {
        if ("bridge".equals(qsUsage)) {
            return IQuerySubject.QuerySubjectUsageEnum.BRIDGE;
        }
        if ("summaryQuery".equals(qsUsage)) {
            return IQuerySubject.QuerySubjectUsageEnum.SUMMARY_QUERY;
        }
        return IQuerySubject.QuerySubjectUsageEnum.AUTOMATIC;
    }

    protected static IQuerySubject.SelectListControl convertSelectListControlToEnum(String v) {
        if ("usedQueryItems".equalsIgnoreCase(v)) {
            return IQuerySubject.SelectListControl.USEDQUERYITEMS;
        }
        if ("allQueryItems".equalsIgnoreCase(v)) {
            return IQuerySubject.SelectListControl.ALLQUERYITEMS;
        }
        return IQuerySubject.SelectListControl.AUTOMATIC;
    }

    protected static void processQueryItem(IMoserModule module, MoserQuerySubject qs, JSONArray jQIs, List<ExpressionResolveContext> c, DeterminantDef detDef, boolean bTop, MoserEnv env, FormatConverter fc) {
        for (int i = 0; i < jQIs.size(); ++i) {
            JSONObject jQI = (JSONObject)jQIs.get(i);
            String name = (String)jQI.get((Object)MOSER_ID);
            MoserQueryItem qi = new MoserQueryItem(module.getMetadataConnection().getNextId(), name, i);
            qi.setQuerySubject(qs);
            qi.setParent(qs);
            qs.addQueryItem(qi);
            qi.setDefaultLocale(((MoserModule)module).getExpressionLocale());
            qi.setUniqueID(qs.getUniqueID() + MOSER_DOT + qi.getName());
            qi.setV5UniqueName(UniqueNameGenerator.appendUniqueName(qs.getV5UniqueName(), qi.getName()));
            MoserModuleUtil.initializeQueryItem(module, qi, jQI, qs, c, detDef, bTop, env, fc);
            ((MoserModule)module).registerExpressionObject(qi.getUniqueID(), qi);
        }
    }

    public static IMetadata getParentQueryItemOrCalculation(IMetadata obj) {
        for (IMetadata tmp = obj; tmp != null; tmp = tmp.getParentObject()) {
            if (tmp instanceof MoserQueryItem || tmp instanceof MoserCalculation) {
                return tmp;
            }
            if (tmp instanceof MoserQuerySubject) break;
        }
        return null;
    }

    protected static String getSplitRef(IMetadata obj) {
        if (obj instanceof MoserQueryItem) {
            return ((MoserQueryItem)obj).splitRef;
        }
        if (obj instanceof MoserCalculation) {
            return ((MoserCalculation)obj).splitRef;
        }
        return null;
    }

    public static String getUniqueId(IMetadata obj) {
        if (obj instanceof MoserQueryItem) {
            return ((MoserQueryItem)obj).getUniqueID();
        }
        if (obj instanceof MoserCalculation) {
            return ((MoserCalculation)obj).getUniqueID();
        }
        return null;
    }

    public static String getV5UniqueName(IMetadata obj) {
        if (obj instanceof MoserQueryItem) {
            return ((MoserQueryItem)obj).getV5UniqueName();
        }
        if (obj instanceof MoserCalculation) {
            return ((MoserCalculation)obj).getV5UniqueName();
        }
        return null;
    }

    protected static String getSplitRefFromSplitDefinition(JSONObject jQI) {
        JSONObject aSP;
        String spRef;
        JSONArray sp = (JSONArray)jQI.get((Object)MOSER_SPLIT_DEFINITION);
        if (MoserModuleUtil.notEmptyArray(sp) && (spRef = (String)(aSP = (JSONObject)sp.get(0)).get((Object)MOSER_REF)) != null && !spRef.isEmpty() && !MOSER_NONE.equalsIgnoreCase(spRef)) {
            return spRef;
        }
        return null;
    }

    protected static void processItem(IMoserModule module, MoserQuerySubject qs, JSONArray jITMs, List<ExpressionResolveContext> c, DeterminantDef detDef, boolean bTop, IMetadata parentObj, MoserEnv env, FormatConverter fc) {
        for (int i = 0; i < jITMs.size(); ++i) {
            ExpressionResolveContext o;
            MoserDimension dim;
            String dimName;
            JSONObject jITM = (JSONObject)jITMs.get(i);
            JSONObject jQI = null;
            JSONObject jDrillGrp = null;
            JSONObject jItemHierarchy = null;
            JSONObject jFilter = null;
            JSONObject jFolder = null;
            JSONObject jCalc = null;
            for (Object k : jITM.keySet()) {
                String kName = (String)k;
                Object v = jITM.get(k);
                if (kName.equals(MOSER_QUERYITEM)) {
                    jQI = (JSONObject)v;
                    continue;
                }
                if (kName.equals(MOSER_DRILLGROUP)) {
                    jDrillGrp = (JSONObject)v;
                    continue;
                }
                if (kName.equals(MOSER_ITEMHIERARCHY)) {
                    jItemHierarchy = (JSONObject)v;
                    continue;
                }
                if (kName.equals(MOSER_FOLDER)) {
                    jFolder = (JSONObject)v;
                    continue;
                }
                if (kName.equals(MOSER_FILTER)) {
                    jFilter = (JSONObject)v;
                    continue;
                }
                if (!kName.equals(MOSER_CALCULATION)) continue;
                jCalc = (JSONObject)v;
            }
            if (jQI != null) {
                JSONArray childJItem;
                String xmlFormat;
                MoserCalculation calc;
                Boolean isHidden = (Boolean)jQI.get((Object)MOSER_HIDDEN);
                IMetadata parentQIorCalc = MoserModuleUtil.getParentQueryItemOrCalculation(parentObj);
                String parentSplitRef = MoserModuleUtil.getSplitRef(parentQIorCalc);
                if (parentSplitRef != null) {
                    String[] nameParts = parentSplitRef.split(STR_DOT_REGX);
                    if (nameParts.length != 2) continue;
                    calc = MoserTimeUtil.initializeItemCalculation(module, qs, jQI, parentQIorCalc, i);
                    calc.isRelativeTime = Boolean.TRUE;
                    if (Boolean.TRUE.equals(isHidden)) {
                        calc.setIsHidden(true);
                    }
                    calc.setIsTransient(true);
                    qs.calculations.add(calc);
                    continue;
                }
                boolean bcalc = MoserModuleUtil.isPostAggregateCalculation(jQI);
                if (!bcalc && detDef.calcUniqueIds != null) {
                    String qiId = (String)jQI.get((Object)MOSER_ID);
                    String qiUId = null;
                    qiUId = parentQIorCalc != null ? MoserModuleUtil.getUniqueId(parentQIorCalc) + MOSER_DOT + qiId : qs.getUniqueID() + MOSER_DOT + qiId;
                    bcalc = detDef.calcUniqueIds.contains(qiUId);
                }
                if (!bcalc) {
                    String name = (String)jQI.get((Object)MOSER_ID);
                    MoserQueryItem qi = new MoserQueryItem(module.getMetadataConnection().getNextId(), name, i);
                    if (Boolean.TRUE.equals(isHidden)) {
                        qi.setIsHidden(true);
                    }
                    qi.setQuerySubject(qs);
                    qs.addQueryItem(qi);
                    qi.setDefaultLocale(((MoserModule)module).getExpressionLocale());
                    if (parentObj != null) {
                        qi.setParent(parentObj);
                    } else {
                        qi.setParent(qs);
                    }
                    if (parentQIorCalc != null) {
                        qi.setUniqueID(MoserModuleUtil.getUniqueId(parentQIorCalc) + MOSER_DOT + qi.getName());
                        qi.setV5UniqueName(UniqueNameGenerator.appendUniqueName(MoserModuleUtil.getV5UniqueName(parentQIorCalc), qi.getName()));
                    } else {
                        qi.setUniqueID(qs.getUniqueID() + MOSER_DOT + qi.getName());
                        qi.setV5UniqueName(UniqueNameGenerator.appendUniqueName(qs.getV5UniqueName(), qi.getName()));
                    }
                    MoserModuleUtil.initializeQueryItem(module, qi, jQI, qs, c, detDef, bTop, env, fc);
                    ((MoserModule)module).registerExpressionObject(qi.getUniqueID(), qi);
                    continue;
                }
                calc = MoserTimeUtil.initializeItemCalculation(module, qs, jQI, parentQIorCalc, i);
                if (Boolean.TRUE.equals(isHidden)) {
                    calc.setIsHidden(true);
                }
                qs.calculations.add(calc);
                calc.usage = (String)jQI.get((Object)MOSER_USAGE);
                calc.splitRef = MoserModuleUtil.getSplitRefFromSplitDefinition(jQI);
                String fmt = (String)jQI.get((Object)MOSER_FORMAT);
                if (fmt != null && (xmlFormat = MoserModuleUtil.convertJSONFormatToXMLFormat(fc, fmt, ((MoserModule)module).getExpressionLocale())) != null && !xmlFormat.isEmpty()) {
                    calc.format = xmlFormat;
                }
                if (!MoserModuleUtil.notEmptyArray(childJItem = (JSONArray)jQI.get((Object)MOSER_ITEM))) continue;
                MoserModuleUtil.processItem(module, qs, childJItem, c, detDef, false, calc, env, fc);
                continue;
            }
            if (jCalc != null) {
                MoserCalculation calc = MoserTimeUtil.initializeItemCalculation(module, null, jCalc, null, i);
                Boolean isHidden = (Boolean)jCalc.get((Object)MOSER_HIDDEN);
                if (Boolean.TRUE.equals(isHidden)) {
                    calc.setIsHidden(true);
                }
                ((MoserModule)module).addCalculation(calc);
                calc.usage = (String)jCalc.get((Object)MOSER_USAGE);
                continue;
            }
            if (jDrillGrp != null) {
                dimName = qs.getName() + MOSER_UNDERSCORE + (String)jDrillGrp.get((Object)MOSER_ID);
                dim = new MoserDimension(module.getMetadataConnection().getNextId(), dimName);
                o = new ExpressionResolveContext();
                o.objResolve = dim;
                o.parentChain = new ArrayList();
                o.parentChain.add(qs);
                o.moserModule = (MoserModule)module;
                o.jsonDef = jDrillGrp;
                o.jsonType = MOSER_DRILLGROUP;
                c.add(o);
                continue;
            }
            if (jItemHierarchy != null) {
                dimName = qs.getName() + MOSER_UNDERSCORE + (String)jItemHierarchy.get((Object)MOSER_ID);
                dim = new MoserDimension(module.getMetadataConnection().getNextId(), dimName);
                o = new ExpressionResolveContext();
                o.objResolve = dim;
                o.parentChain = new ArrayList();
                o.parentChain.add(qs);
                o.moserModule = (MoserModule)module;
                o.jsonDef = jItemHierarchy;
                o.jsonType = MOSER_ITEMHIERARCHY;
                c.add(o);
                continue;
            }
            if (jFilter != null) {
                MoserTimeUtil.initializeItemFilter(module, qs, jFilter, parentObj, i);
                continue;
            }
            if (jFolder == null) continue;
            String folderName = (String)jFolder.get((Object)MOSER_ID);
            MoserQueryItemFolder newParentQIFld = new MoserQueryItemFolder(module.getMetadataConnection().getNextId(), folderName, i);
            newParentQIFld.setQuerySubject(qs);
            qs.addQueryItemFolder(newParentQIFld);
            if (parentObj != null) {
                newParentQIFld.setParent(parentObj);
            } else {
                newParentQIFld.setParent(qs);
            }
            JSONArray jItems = (JSONArray)jFolder.get((Object)MOSER_ITEM);
            if (jItems == null) continue;
            MoserModuleUtil.processItem(module, qs, jItems, c, detDef, bTop, newParentQIFld, env, fc);
        }
    }

    protected static boolean isPostAggregateCalculation(JSONObject jQI) {
        String regAgg = (String)jQI.get((Object)MOSER_REGULARAGGREGATETYPE);
        return "calculated".equalsIgnoreCase(regAgg);
    }

    protected static void initializeQueryItem(IMoserModule module, MoserQueryItem qi, JSONObject jQI, MoserQuerySubject qs, List<ExpressionResolveContext> c, DeterminantDef det, boolean bTop, MoserEnv env, FormatConverter fc) {
        JSONObject facetDef = null;
        String expr = null;
        String ref = null;
        JSONArray calcMembers = null;
        Object converter = null;
        JSONArray jItems = null;
        for (Object k : jQI.keySet()) {
            String kName = (String)k;
            Object v = jQI.get(k);
            if (v == null) continue;
            if (kName.equals(MOSER_USAGE)) {
                qi.setUsage((String)v);
                continue;
            }
            if (kName.equals(MOSER_DATATYPE)) {
                String dtTxt = ((String)v).toLowerCase(Locale.ENGLISH);
                IDataType dt = DataTypeFactory.getType(MoserModuleUtil.getSQLDataTypeFromJMDDataType(dtTxt));
                if (dt == null) {
                    dt = DataTypeFactory.getType(VARCHAR2000);
                }
                qi.setDataType(dt);
                continue;
            }
            if (kName.equals(MOSER_NULLABLE)) {
                Boolean f = (Boolean)v;
                qi.setIsNullable(f);
                continue;
            }
            if (kName.equals(MOSER_REF)) {
                ref = (String)v;
                continue;
            }
            if (kName.equals(MOSER_EXPRESSION)) {
                expr = (String)v;
                continue;
            }
            if (kName.equals(MOSER_REGULARAGGREGATETYPE)) {
                qi.setRegularAggregate((String)v);
                continue;
            }
            if (kName.equals(MOSER_LABEL)) {
                qi.setLabel((String)v);
                continue;
            }
            if (kName.equals(MOSER_FORMAT)) {
                String xmlFormat = MoserModuleUtil.convertJSONFormatToXMLFormat(fc, (String)v, ((MoserModule)module).getExpressionLocale());
                if (xmlFormat == null || xmlFormat.isEmpty()) continue;
                qi.setFormat(xmlFormat);
                continue;
            }
            if (kName.equals(MOSER_FACETDEFINITION)) {
                facetDef = (JSONObject)v;
                continue;
            }
            if (kName.equals(MOSER_CALCULATED_MEMBER)) {
                calcMembers = (JSONArray)v;
                continue;
            }
            if (kName.equals(MOSER_EXTERNALNAME)) {
                qi.setUniqueName((String)v);
                continue;
            }
            if (kName.equals(MOSER_SPLIT_DEFINITION)) {
                JSONArray sp = (JSONArray)v;
                if (!MoserModuleUtil.notEmptyArray(sp)) continue;
                JSONObject aSP = (JSONObject)sp.get(0);
                qi.setSplitRef((String)aSP.get((Object)MOSER_REF));
                String[] nameParts = qi.splitRef.split(STR_DOT_REGX);
                if (nameParts.length != 1) continue;
                ExpressionResolveContext o = MoserModuleUtil.registerQueryItemToResolve(c, qi, qs, module);
                o.jsonType = MOSER_SPLIT_DEFINITION;
                continue;
            }
            if (!kName.equals(MOSER_ITEM)) continue;
            jItems = (JSONArray)v;
        }
        qi.setOriginalExpression(expr);
        if (ref != null && !ref.trim().isEmpty() || expr != null && !expr.trim().isEmpty()) {
            MoserModuleUtil.processRefOrExpressionInQueryItem(module, qi, ref, expr, qs, c, det, env);
            MoserModuleUtil.resolveFacet(qi.usage, qi.datatype, qi, facetDef, qs, module, c);
        } else if (facetDef != null && module.getModuleType() == IMoserModule.ModuleType.EMBEDDED) {
            qi.facetDefinition = facetDef;
        }
        if (qs instanceof MoserTimeQuerySubject) {
            MoserTimeUtil.initializeTimePeriod(module, (MoserTimeQuerySubject)qs, qi, calcMembers);
        } else if (bTop && calcMembers != null && calcMembers.size() > 0) {
            boolean bCalculatedMember = true;
            if (MetadataConstants.FACT.equals(qi.getUsage())) {
                bCalculatedMember = false;
            }
            MoserLevel lvl = null;
            MoserHierarchy hier = null;
            if (bCalculatedMember) {
                lvl = qi.getOrCreateLevel();
                hier = (MoserHierarchy)lvl.getHierarchy();
            }
            for (int i = 0; i < calcMembers.size(); ++i) {
                JSONObject calc = (JSONObject)calcMembers.get(i);
                String calcId = (String)calc.get((Object)MOSER_ID);
                MoserMember cMember = new MoserMember(module.getMetadataConnection().getNextId(), calcId);
                cMember.expr = (String)calc.get((Object)MOSER_EXPRESSION);
                if (bCalculatedMember) {
                    hier.calculatedMembers.add(cMember);
                    cMember.hier = hier;
                    cMember.v5UniqueName = hier.getV5UniqueName() + MOSER_DOT + calcId;
                } else {
                    cMember.ownerQueryItem = qi;
                    cMember.v5UniqueName = qi.getV5UniqueName() + MOSER_DOT + calcId;
                }
                cMember.uniqueId = qi.getUniqueID() + MOSER_DOT + calcId;
                ((MoserModule)module).registerExpressionObject(cMember.getUniqueID(), cMember);
                String label = (String)calc.get((Object)MOSER_LABEL);
                if (label == null) continue;
                cMember.caption = label;
            }
        }
        if (MoserModuleUtil.notEmptyArray(jItems)) {
            MoserModuleUtil.processItem(module, qs, jItems, c, det, false, qi, env, fc);
        }
    }

    protected static void resolveFacet(String usage, IDataType dt, MoserQueryItem qi, JSONObject facetDef, MoserQuerySubject qs, IMoserModule module, List<ExpressionResolveContext> c) {
        MoserFacet facet;
        Boolean enabled = null;
        JSONObject sortList = null;
        boolean explicitlySetByModeler = false;
        if (facetDef != null) {
            for (Object k : facetDef.keySet()) {
                String kName = (String)k;
                Object v = facetDef.get(k);
                if (v == null) continue;
                if (kName.equals(MOSER_ENABLED)) {
                    String sEnabled = (String)v;
                    if ("true".equals(sEnabled)) {
                        enabled = Boolean.TRUE;
                        explicitlySetByModeler = true;
                        continue;
                    }
                    if (MOSER_AUTOMATIC.equals(sEnabled)) {
                        enabled = MoserModuleUtil.resolveEnabledByUsageAndDataType(usage, dt);
                        continue;
                    }
                    enabled = Boolean.FALSE;
                    explicitlySetByModeler = true;
                    continue;
                }
                if (!kName.equals(MOSER_SORTLIST)) continue;
                sortList = (JSONObject)v;
            }
            if (enabled == null) {
                enabled = MoserModuleUtil.resolveEnabledByUsageAndDataType(usage, dt);
            }
        } else {
            enabled = MoserModuleUtil.resolveEnabledByUsageAndDataType(usage, dt);
        }
        if (enabled == Boolean.FALSE) {
            facet = new MoserFacet(false, Collections.emptyList());
        } else {
            ArrayList<MoserSortItem> sItems = new ArrayList<MoserSortItem>();
            if (sortList != null && !sortList.isEmpty()) {
                explicitlySetByModeler = true;
                for (Object k : sortList.keySet()) {
                    String kName = (String)k;
                    Object v = sortList.get(k);
                    if (v == null || !kName.equals(MOSER_SORTITEM)) continue;
                    JSONArray lst = (JSONArray)v;
                    for (int i = 0; i < lst.size(); ++i) {
                        JSONObject jS = (JSONObject)lst.get(i);
                        MoserSortItem sortItem = MoserModuleUtil.processSortItem(jS, qi, qs, module, c);
                        sItems.add(sortItem);
                    }
                }
            } else {
                MoserSortItem defaultSort = new MoserSortItem(qi.getUniqueID(), ISortItem.SortType.ASCENDING, ISortItem.NullPlacementType.NULL_LAST);
                sItems.add(defaultSort);
            }
            facet = new MoserFacet(true, sItems);
        }
        if (explicitlySetByModeler) {
            facet.setExplicitlySetByModeler(true);
        }
        qi.setFacet(facet);
    }

    public static Boolean resolveEnabled(IQueryItem qi) {
        String usage = qi.getUsage();
        return MoserModuleUtil.isFacetEnabled(qi, usage);
    }

    protected static Boolean resolveEnabledByUsageAndDataType(String usage, IDataType dt) {
        if (!MoserModuleUtil.resolveEnabledByUsage(usage)) {
            return Boolean.FALSE;
        }
        return MoserModuleUtil.resolveEnabledByDataType(dt);
    }

    protected static boolean resolveEnabledByUsage(String usage) {
        boolean b = MOSER_ATTRIBUTE.equals(usage) || MOSER_ID.equals(usage);
        return b;
    }

    protected static boolean resolveEnabledByDataType(IDataType dt) {
        if (dt == null) {
            return false;
        }
        String dtName = dt.getTypeName();
        return FACET_DT.contains(dtName);
    }

    public static Boolean isFacetEnabled(IMetadata mdObj, String usage) {
        if (!MoserModuleUtil.resolveEnabledByUsage(usage)) {
            return Boolean.FALSE;
        }
        return MoserModuleUtil.resolveEnabledByDataType(mdObj.getDataType());
    }

    protected static MoserSortItem processSortItem(JSONObject jS, MoserQueryItem qi, MoserQuerySubject qs, IMoserModule module, List<ExpressionResolveContext> c) {
        boolean bNeedResolve = true;
        String ref = null;
        String order = null;
        String nullPlace = null;
        for (Object k : jS.keySet()) {
            String kName = (String)k;
            Object v = jS.get(k);
            if (v == null) continue;
            if (kName.equals(MOSER_REF)) {
                ref = (String)v;
                if (!qi.getName().equals(ref)) continue;
                ref = qi.getUniqueID();
                bNeedResolve = false;
                continue;
            }
            if (kName.equals(MOSER_ORDER)) {
                order = (String)v;
                continue;
            }
            if (!kName.equals(MOSER_NULLPLACEMENT)) continue;
            nullPlace = (String)v;
        }
        ISortItem.SortType sortType = null;
        if ("ascending".equals(order)) {
            sortType = ISortItem.SortType.ASCENDING;
        } else if ("descending".equals(order)) {
            sortType = ISortItem.SortType.DESCENDING;
        }
        ISortItem.NullPlacementType nullPlacementEnum = null;
        if (MOSER_FIRST.equals(nullPlace)) {
            nullPlacementEnum = ISortItem.NullPlacementType.NULL_FIRST;
        } else if (MOSER_LAST.equals(nullPlace)) {
            nullPlacementEnum = ISortItem.NullPlacementType.NULL_LAST;
        }
        MoserSortItem rt = new MoserSortItem(ref, sortType, nullPlacementEnum);
        if (c != null && bNeedResolve && module != null && module.getModuleType() != IMoserModule.ModuleType.EMBEDDED) {
            ExpressionResolveContext o = new ExpressionResolveContext();
            o.objResolve = rt;
            o.parentChain = new ArrayList();
            o.parentChain.add(qi);
            o.parentChain.add(qs);
            o.moserModule = (MoserModule)module;
            c.add(o);
        }
        return rt;
    }

    protected static void registerUnresolvedExpression(IMoserModule module, MoserQueryItem qi, String expr, MoserQuerySubject qs, List<ExpressionResolveContext> c, DeterminantDef det) {
        if (c != null) {
            qi.setExpression(expr);
            MoserModuleUtil.registerQueryItemToResolve(c, qi, qs, module);
        }
        det.bStop = true;
    }

    protected static void resolveExpressionFromSourceObject(MoserQueryItem qi, DeterminantDef det, IMetadata srcObj) {
        qi.setExpression(srcObj.getV5UniqueName());
        MoserModuleUtil.deriveFromSource(qi, srcObj);
        if (det != null) {
            MoserModuleUtil.updateDeterminantDef(qi, srcObj, det);
        }
    }

    protected static String trimPrefix(String prefix, String str) {
        String p = prefix + MOSER_DOT;
        if (str.startsWith(p)) {
            return str.substring(p.length());
        }
        return str;
    }

    protected static void getSourceObjectFromSourceModule(IMoserModule module, String refInQS, String refInQI, HashSet<IMetadata> rt, String pass, Map<String, String> cookies, MoserEnv env) {
        String[] rtRef;
        String[] nameParts = (refInQS = refInQS.trim()).split(STR_DOT_REGX);
        MoserModule subModule = (MoserModule)MoserModuleUtil.getImportModuleByAlias(module, nameParts, pass, cookies, rtRef = new String[]{null}, env);
        if (subModule != null) {
            String id = MoserModuleUtil.trimPrefix(refInQS, refInQI);
            id = rtRef[0] != null ? subModule.getUniqueName() + MOSER_DOT + rtRef[0] + MOSER_DOT + id : subModule.getUniqueName() + MOSER_DOT + id;
            IMetadata itm = subModule.getExpressionObjectByUNameThis(id);
            if (itm != null) {
                rt.add(itm);
            }
            return;
        }
    }

    protected static boolean checkContext(String onePartnameParts, IMetadata ctx) {
        if (onePartnameParts == null) {
            return true;
        }
        if (ctx == null) {
            return true;
        }
        return onePartnameParts.equals(ctx.getName());
    }

    private static IMetadata findObjectFromSourceQuerySubjectsForBinding(MoserQuerySubject qs, String ref, IMetadata context) {
        if (qs.sourceQSforBinding == null) {
            return null;
        }
        String[] onePartnameParts = new String[]{null};
        IMetadata obj = null;
        for (MoserQuerySubject sQS : qs.sourceQSforBinding) {
            IMetadata o = MoserModuleUtil.getSourceObjectFromSourceQuerySubject(sQS, ref, onePartnameParts);
            if (o == null) continue;
            if (obj == null) {
                obj = o;
                continue;
            }
            return null;
        }
        if (obj == null) {
            return null;
        }
        if (onePartnameParts[0] == null || context == null || onePartnameParts[0].equals(context.getName())) {
            return obj;
        }
        return null;
    }

    protected static void processRefInQueryItem(IMoserModule module, MoserQueryItem qi, String ref, MoserQuerySubject qs, List<ExpressionResolveContext> c, DeterminantDef det, MoserEnv env) {
        if (qs.sourceQSforBinding != null) {
            IMetadata objProjectItem = MoserModuleUtil.findObjectFromSourceQuerySubjectsForBinding(qs, ref, qi);
            if (objProjectItem != null) {
                MoserModuleUtil.resolveExpressionFromSourceObject(qi, det, objProjectItem);
            } else {
                MoserModuleUtil.registerUnresolvedExpression(module, qi, ref, qs, c, det);
            }
            return;
        }
        Set<String> refs = qs.getRefs();
        if (refs == null || refs.isEmpty()) {
            String[] qiNameParts = ref.split(STR_DOT_REGX);
            String[] rtRef = new String[]{null};
            MoserModule subModule = (MoserModule)MoserModuleUtil.getImportModuleByAlias(module, qiNameParts, det.userPassport, det.cookiesToMoser, rtRef, env);
            if (subModule != null) {
                IMetadata srcObj = subModule.getExpressionObjectByUNameThis(ref);
                if (srcObj != null) {
                    MoserModuleUtil.resolveExpressionFromSourceObject(qi, det, srcObj);
                } else {
                    det.bStop = true;
                    qi.setValid(false);
                }
            } else {
                MoserModuleUtil.registerUnresolvedExpression(module, qi, ref, qs, c, det);
            }
            return;
        }
        HashSet<IMetadata> srcObjs = new HashSet<IMetadata>();
        if (refs.size() == 1) {
            String rf = refs.iterator().next();
            MoserModuleUtil.getSourceObjectFromSourceModule(module, rf, ref, srcObjs, det.userPassport, det.cookiesToMoser, env);
            if (srcObjs.isEmpty()) {
                MoserModuleUtil.registerUnresolvedExpression(module, qi, ref, qs, c, det);
            } else if (srcObjs.size() == 1) {
                MoserModuleUtil.resolveExpressionFromSourceObject(qi, det, srcObjs.iterator().next());
            } else {
                det.bStop = true;
                qi.setValid(false);
            }
            return;
        }
        for (String r : refs) {
            MoserModuleUtil.getSourceObjectFromSourceModule(module, r, ref, srcObjs, det.userPassport, det.cookiesToMoser, env);
        }
        if (srcObjs.isEmpty()) {
            MoserModuleUtil.registerUnresolvedExpression(module, qi, ref, qs, c, det);
        } else if (srcObjs.size() == 1) {
            MoserModuleUtil.resolveExpressionFromSourceObject(qi, det, srcObjs.iterator().next());
        } else {
            det.bStop = true;
            qi.setValid(false);
        }
    }

    public static boolean isValidIdentifier(String identifier) {
        if (identifier == null || identifier.isEmpty()) {
            return false;
        }
        IntStream characters = identifier.codePoints();
        PrimitiveIterator.OfInt it = characters.iterator();
        int c = it.nextInt();
        if (!Character.isLetter(c) && c != 95) {
            return false;
        }
        while (it.hasNext()) {
            c = it.nextInt();
            if (Character.isLetterOrDigit(c) || c == 95) continue;
            return false;
        }
        return true;
    }

    protected static boolean isSimpleReferenceString(String expr) {
        String[] nameParts;
        for (String str : nameParts = expr.split(STR_DOT_REGX)) {
            if (MoserModuleUtil.isValidIdentifier(str)) continue;
            return false;
        }
        return true;
    }

    public static boolean isMoserCalculation(MoserQueryItem moserQueryItem) {
        return !MoserModuleUtil.isSimpleReferenceString(moserQueryItem.getOriginalExpression()) && moserQueryItem.getOriginalExpression().equals(moserQueryItem.getExpression());
    }

    protected static void processRefOrExpressionInQueryItem(IMoserModule module, MoserQueryItem qi, String ref, String expr, MoserQuerySubject qs, List<ExpressionResolveContext> c, DeterminantDef det, MoserEnv env) {
        String str;
        if (MoserModuleUtil.isBaseModule(module, det.userPassport, det.cookiesToMoser, env)) {
            String quot = "'";
            if (expr != null && expr.startsWith(quot) && expr.endsWith(quot)) {
                qi.setExpression(expr);
                return;
            }
            MoserModuleUtil.resolveToPhysical(module, qi, expr, qs, det, c, ref, env);
            return;
        }
        boolean bIsRef = false;
        if (ref != null && !ref.trim().isEmpty()) {
            str = ref.trim();
            bIsRef = true;
        } else {
            str = expr.trim();
        }
        List<ModuleIdPair> imports = ((MoserModule)module).getImports();
        if (imports.isEmpty() && qs.sourceQSforBinding == null) {
            MoserModuleUtil.registerUnresolvedExpression(module, qi, str, qs, c, det);
            return;
        }
        if (bIsRef || MoserModuleUtil.isSimpleReferenceString(str)) {
            MoserModuleUtil.processRefInQueryItem(module, qi, str, qs, c, det, env);
            return;
        }
        MoserModuleUtil.registerUnresolvedExpression(module, qi, expr, qs, c, det);
    }

    private static void deriveFromSource(MoserQueryItem qi, IMetadata src) {
        String srcAgg;
        String agg;
        Boolean srcIsN;
        Boolean isN;
        String srcUsage;
        IDataType srcDT;
        if (qi.getDataType() == null && (srcDT = src.getDataType()) != null) {
            qi.setDataType(srcDT);
        }
        if (qi.getUsage() == null && src instanceof MoserQueryItem && (srcUsage = ((MoserQueryItem)src).getUsage()) != null) {
            qi.setUsage(srcUsage);
        }
        if ((isN = qi.getIsNullable()) == null && src instanceof MoserQueryItem && (srcIsN = ((MoserQueryItem)src).getIsNullable()) != null) {
            qi.setIsNullable(srcIsN);
        }
        if ((agg = qi.getRegularAggregate()) == null && src instanceof MoserQueryItem && (srcAgg = ((MoserQueryItem)src).getRegularAggregate()) != null) {
            qi.setRegularAggregate(srcAgg);
        }
    }

    private static void resolveToPhysical(IMoserModule module, MoserQueryItem qi, String expr, MoserQuerySubject qs, DeterminantDef det, List<ExpressionResolveContext> c, String ref, MoserEnv env) {
        Set<String> refs = qs.getRefs();
        if (refs != null && refs.size() == 1) {
            String refToSrc = ref;
            if (refToSrc == null) {
                refToSrc = expr;
            }
            String rf = refs.iterator().next();
            List<ModuleIdPair> imports = ((MoserModule)module).getImports();
            for (ModuleIdPair md : imports) {
                MoserModule subModule = (MoserModule)module.getMetadataConnection().getModule(md, det.userPassport, det.cookiesToMoser, env);
                List<MoserDataSource> dss = subModule.getDataSourcesInThis();
                if (dss.isEmpty()) continue;
                for (MoserDataSource ds : dss) {
                    String id = subModule.getUniqueName() + MOSER_DOT + ds.getName() + MOSER_DOT + rf + MOSER_DOT + refToSrc;
                    IMetadata src = subModule.getExpressionObjectByUNameThis(id);
                    if (src == null) continue;
                    qi.setExpression(src.getV5UniqueName());
                    MoserModuleUtil.deriveFromSource(qi, src);
                    MoserModuleUtil.updateDeterminantDef(qi, src, det);
                    return;
                }
            }
        }
        if (ref != null) {
            throw new XQERuntimeException(XQEMessageKeys.MSR_ReferenceMissing, expr);
        }
        if (expr != null) {
            MoserModuleUtil.registerUnresolvedExpression(module, qi, expr, qs, c, det);
        }
    }

    private static void updateDeterminantDef(MoserQueryItem qi, IMetadata src, DeterminantDef det) {
        if (det.bStop) {
            return;
        }
        if (!(src instanceof MoserQueryItem)) {
            det.bStop = true;
            return;
        }
        MoserQueryItem srcQI = (MoserQueryItem)src;
        IQuerySubject parentQS = srcQI.getQuerySubject();
        if (parentQS == null || parentQS.getDeterminants().size() != 1) {
            det.bStop = true;
            return;
        }
        if (det.srcQS != null && det.srcQS != parentQS) {
            det.bStop = true;
            return;
        }
        det.srcQS = parentQS;
        IDeterminant srcDet = parentQS.getDeterminants().get(0);
        det.detName = srcDet.getName();
        if (det.srcKeys == null) {
            det.srcKeys = new HashSet();
            det.srcAttrs = new HashSet();
            for (IQueryItem srcKeyQI : srcDet.getKeys()) {
                det.srcKeys.add(srcKeyQI.getName());
            }
            for (IQueryItem srcAttrQI : srcDet.getAttributes()) {
                det.srcAttrs.add(srcAttrQI.getName());
            }
        }
        String srcName = src.getName();
        if (det.srcKeys.contains(srcName)) {
            if (det.primaryKeyQIs == null) {
                det.primaryKeyQIs = new TreeSet();
            }
            det.primaryKeyQIs.add(qi);
        } else if (det.srcAttrs.contains(srcName)) {
            if (det.attributeQIs == null) {
                det.attributeQIs = new TreeSet();
            }
            det.attributeQIs.add(qi);
        } else {
            det.bStop = true;
        }
    }

    private static ExpressionResolveContext registerQueryItemToResolve(List<ExpressionResolveContext> c, MoserQueryItem qi, MoserQuerySubject qs, IMoserModule module) {
        ExpressionResolveContext o = new ExpressionResolveContext();
        o.objResolve = qi;
        o.parentChain = new ArrayList();
        o.parentChain.add(qs);
        o.moserModule = (MoserModule)module;
        c.add(o);
        return o;
    }

    protected static void processParameterMaps(MoserModule module, JSONArray parameterMaps) {
        if (MoserModuleManager.loggingEnabled()) {
            MoserModuleManager.log(LogLevel.TRACE, "processParameterMaps of moduleId=" + module.getIdentifier());
        }
        module.getParameterMaps().loadFromModule(parameterMaps);
    }

    protected static void processRelationship(MoserModule module, JSONArray relationships) {
        if (MoserModuleManager.loggingEnabled()) {
            MoserModuleManager.log(LogLevel.TRACE, "processRelationship of moduleId=" + module.getIdentifier());
        }
        for (int i = 0; i < relationships.size(); ++i) {
            String name;
            JSONObject jR = (JSONObject)relationships.get(i);
            MoserRelationship r = MoserModuleUtil.createRelationshipWithCheck(module, jR, name = (String)jR.get((Object)MOSER_ID));
            if (r == null) continue;
            r.setParentModule(module);
            module.addRelationship(r);
        }
    }

    protected static MoserRelationship createRelationshipWithCheck(MoserModule module, JSONObject jR, String name) {
        JSONObject jLeft = (JSONObject)jR.get((Object)MOSER_LEFT);
        JSONObject jRight = (JSONObject)jR.get((Object)MOSER_RIGHT);
        if (jLeft == null || jRight == null) {
            return null;
        }
        IMetadata leftQS = module.getQuerySubjectByUName((String)jLeft.get((Object)MOSER_REF));
        IMetadata rightQS = module.getQuerySubjectByUName((String)jRight.get((Object)MOSER_REF));
        if (leftQS == null || rightQS == null) {
            return null;
        }
        MoserRelationship r = MoserModuleUtil.createRelationship(module, jR);
        r.setUniqueID(module.getUniqueName() + MOSER_DOT + name);
        r.setDefaultLocale(module.getExpressionLocale());
        if (leftQS instanceof MoserQuerySubject) {
            ((IQuerySubject)leftQS).setInvolvedInJoins(true);
        }
        if (rightQS instanceof MoserQuerySubject) {
            ((IQuerySubject)rightQS).setInvolvedInJoins(true);
        }
        return r;
    }

    public static MoserRelationship createRelationship(MoserModule module, JSONObject jR) {
        JSONObject jLeft = (JSONObject)jR.get((Object)MOSER_LEFT);
        String leftId = (String)jLeft.get((Object)MOSER_REF);
        IMetadata leftQS = MetadataUtil.isIdForPackage(leftId) ? module.getMetadataConnection().bindMetadataFromPackages(leftId, null) : module.getQuerySubjectByUName(leftId);
        JSONObject jRight = (JSONObject)jR.get((Object)MOSER_RIGHT);
        String rightId = (String)jRight.get((Object)MOSER_REF);
        IMetadata rightQS = MetadataUtil.isIdForPackage(rightId) ? module.getMetadataConnection().bindMetadataFromPackages(rightId, null) : module.getQuerySubjectByUName(rightId);
        String name = (String)jR.get((Object)MOSER_ID);
        MoserRelationship r = new MoserRelationship(module.getMetadataConnection().getNextId(), name);
        MoserModuleUtil.initializeRelationship(module, r, jR, leftQS, rightQS);
        r.leftOrgId = leftId;
        r.rightOrgId = rightId;
        return r;
    }

    protected static void initializeRelationship(MoserModule module, MoserRelationship r, JSONObject jR, IMetadata leftQS, IMetadata rightQS) {
        String joinFilterType;
        JSONObject jLeft = (JSONObject)jR.get((Object)MOSER_LEFT);
        r.setLeftRefObject(leftQS);
        r.setLeftRefObjectId(leftQS.getID());
        r.setLeftCardinality(MoserModuleUtil.convertToCardinalityEnum((String)jLeft.get((Object)MOSER_MINCARD), (String)jLeft.get((Object)MOSER_MAXCARD)));
        JSONObject jRight = (JSONObject)jR.get((Object)MOSER_RIGHT);
        r.setRightRefObject(rightQS);
        r.setRightRefObjectId(rightQS.getID());
        r.setRightCardinality(MoserModuleUtil.convertToCardinalityEnum((String)jRight.get((Object)MOSER_MINCARD), (String)jRight.get((Object)MOSER_MAXCARD)));
        JSONArray link = (JSONArray)jR.get((Object)MOSER_LINK);
        if (link != null && link.size() > 0) {
            MoserModuleUtil.createJoinExpressionForLink(module, r, leftQS, rightQS, link);
        }
        if ((joinFilterType = (String)jR.get((Object)MOSER_JOIN_FILTER_TYPE)) != null) {
            r.setJoinFilterType(IRelationship.JoinFilterType.toJoinFilterType(joinFilterType));
        }
    }

    protected static void createJoinExpressionForLink(MoserModule module, MoserRelationship r, IMetadata leftQS, IMetadata rightQS, JSONArray link) {
        StringBuilder sb = new StringBuilder();
        boolean bLeftMoser = leftQS instanceof MoserBaseMetadata;
        boolean bRightMoser = rightQS instanceof MoserBaseMetadata;
        for (int i = 0; i < link.size(); ++i) {
            String rightId;
            String leftId;
            if (i > 0) {
                sb.append(MOSER_V5_AND);
            }
            JSONObject jn = (JSONObject)link.get(i);
            String leftItem = (String)jn.get((Object)MOSER_LEFTREF);
            if (bLeftMoser) {
                leftId = UniqueNameGenerator.appendUniqueName(leftQS.getV5UniqueName(), leftItem);
            } else {
                String alias = module.getMetadataConnection().getAliasMFWMetadataConnection(leftQS.getConnection());
                leftId = alias + MOSER_DOT + leftQS.getV5UniqueName() + MOSER_DOT + leftItem;
            }
            String rightItem = (String)jn.get((Object)MOSER_RIGHTREF);
            if (bRightMoser) {
                rightId = UniqueNameGenerator.appendUniqueName(rightQS.getV5UniqueName(), rightItem);
            } else {
                String alias = module.getMetadataConnection().getAliasMFWMetadataConnection(rightQS.getConnection());
                rightId = alias + MOSER_DOT + rightQS.getV5UniqueName() + MOSER_DOT + rightItem;
            }
            sb.append(MoserModuleUtil.generateComparisonExpression(jn, leftId, rightId));
            if (r.links == null) {
                r.links = new ArrayList<MoserRelationship.MoserLink>();
            }
            r.links.add(new MoserRelationship.MoserLink(leftItem, rightItem, (String)jn.get((Object)MOSER_COMPARISON_OPERATOR)));
        }
        r.setExpression(sb.toString());
    }

    protected static String generateComparisonExpression(JSONObject link, String leftId, String rightId) {
        String sOp = (String)link.get((Object)MOSER_COMPARISON_OPERATOR);
        if (sOp == null || sOp.isEmpty() || sOp.equalsIgnoreCase(MOSER_EQUALTO)) {
            return leftId + MOSER_V5_EQUAL + rightId;
        }
        if (sOp.equalsIgnoreCase(MOSER_GREATERTHAN)) {
            return leftId + MOSER_V5_GREATERTHAN + rightId;
        }
        if (sOp.equalsIgnoreCase(MOSER_LESSTHAN)) {
            return leftId + MOSER_V5_LESSTHAN + rightId;
        }
        if (sOp.equalsIgnoreCase(MOSER_GREATERTHAN_EQUALTO)) {
            return leftId + MOSER_V5_GREATERTHAN_EQUALTO + rightId;
        }
        if (sOp.equalsIgnoreCase(MOSER_LESSTHAN_EQUALTO)) {
            return leftId + MOSER_V5_LESSTHAN_EQUALTO + rightId;
        }
        if (sOp.equalsIgnoreCase(MOSER_NOTEQUALTO)) {
            return leftId + MOSER_V5_NOTEQUALTO + rightId;
        }
        if (sOp.equalsIgnoreCase(MOSER_EQUALTO_BOTHNULL)) {
            return MOSER_V5_OPEN_PARENTHESIS + leftId + MOSER_V5_EQUAL + rightId + MOSER_V5_OR + MOSER_V5_OPEN_PARENTHESIS + leftId + MOSER_V5_ISNULL + MOSER_V5_AND + rightId + MOSER_V5_ISNULL + MOSER_V5_CLOSE_PARENTHESIS + MOSER_V5_CLOSE_PARENTHESIS;
        }
        if (sOp.equalsIgnoreCase(MOSER_NOTEQUALTO_ONENULL)) {
            return MOSER_V5_OPEN_PARENTHESIS + leftId + MOSER_V5_NOTEQUALTO + rightId + MOSER_V5_OR + MOSER_V5_OPEN_PARENTHESIS + leftId + MOSER_V5_ISNULL + MOSER_V5_AND + rightId + MOSER_V5_ISNOTNULL + MOSER_V5_CLOSE_PARENTHESIS + MOSER_V5_OR + MOSER_V5_OPEN_PARENTHESIS + leftId + MOSER_V5_ISNOTNULL + MOSER_V5_AND + rightId + MOSER_V5_ISNULL + MOSER_V5_CLOSE_PARENTHESIS + MOSER_V5_CLOSE_PARENTHESIS;
        }
        return leftId + MOSER_V5_EQUAL + rightId;
    }

    protected static Enum<IRelationship.Cardinality> convertToCardinalityEnum(String minCard, String maxCard) {
        if (minCard.equals("zero")) {
            if (maxCard.equals("one")) {
                return IRelationship.Cardinality.ZERO_ONE;
            }
            if (maxCard.equals("many")) {
                return IRelationship.Cardinality.ZERO_MANY;
            }
        }
        if (minCard.equals("one")) {
            if (maxCard.equals("one")) {
                return IRelationship.Cardinality.ONE_ONE;
            }
            if (maxCard.equals("many")) {
                return IRelationship.Cardinality.ONE_MANY;
            }
        }
        throw new XQERuntimeException(XQEMessageKeys.GEN_FoundInternalErrorParam_INTERNAL, "getCardinality():  Unexpected cardinality.");
    }

    public static String buildFullQualifiedIdentifier(MoserModule module, String originalName) {
        StringBuilder sb = new StringBuilder();
        sb.append(module.getUniqueName());
        sb.append(MOSER_DOT);
        sb.append(originalName);
        return sb.toString();
    }

    protected static void postResolve(MoserMetadataConnection metadataConnection, List<ExpressionResolveContext> objectToResolve, boolean bTop, MoserEnv env) {
        MoserQuerySubject qs;
        HashSet<IQuerySubject> joinedQSs = new HashSet<IQuerySubject>();
        for (ExpressionResolveContext c : objectToResolve) {
            if (c.objResolve instanceof MoserSortItem) {
                MoserModuleUtil.resolveSortItemReference(c, env);
                continue;
            }
            if (!(c.objResolve instanceof MoserQuerySubject)) continue;
            MoserModuleUtil.resolveQuerySubjectSourceRefs(c, env);
            if (((MoserQuerySubject)c.objResolve).getClassifier() != QsClassifierType.JOIN_QUERY_SUBJECT) continue;
            joinedQSs.add((IQuerySubject)c.objResolve);
        }
        for (ExpressionResolveContext c : objectToResolve) {
            if (!(c.objResolve instanceof MoserQueryItem)) continue;
            MoserQueryItem qi = (MoserQueryItem)c.objResolve;
            qs = (MoserQuerySubject)c.parentChain.get(0);
            if (MOSER_SPLIT_DEFINITION.equals(c.jsonType)) {
                if (c.jsonDef != null) {
                    MoserTimeUtil.initializeSplitDefinition(c.moserModule, qs, qi, (JSONArray)c.jsonDef.get((Object)MOSER_SPLIT_DEFINITION));
                    continue;
                }
                MoserTimeUtil.createQSforSplitDefinition(c.moserModule, qs, qi);
                continue;
            }
            String expr = qi.getExpression();
            if (!joinedQSs.contains(qs) || !MoserModuleUtil.isSimpleReferenceString(expr)) continue;
            HashSet<IMetadata> srcObjs = new HashSet<IMetadata>();
            for (IQuerySubject srcQS : qs.getSourceQuerySubject()) {
                IMetadata srcObj = MoserModuleUtil.getSourceObjectFromSourceQuerySubject((MoserQuerySubject)srcQS, expr, null);
                if (srcObj == null) continue;
                srcObjs.add(srcObj);
            }
            if (srcObjs.size() == 1) {
                MoserModuleUtil.resolveExpressionFromSourceObject(qi, null, (IMetadata)srcObjs.iterator().next());
                continue;
            }
            if (srcObjs.size() <= 1) continue;
            qi.setValid(false);
        }
        if (bTop) {
            for (ExpressionResolveContext c : objectToResolve) {
                String refQI;
                if (!(c.objResolve instanceof MoserDimension)) continue;
                MoserDimension dim = (MoserDimension)c.objResolve;
                qs = (MoserQuerySubject)c.parentChain.get(0);
                String hierId = (String)c.jsonDef.get((Object)MOSER_ID);
                MoserHierarchy hier = MoserModuleUtil.createMoserHierarchy(metadataConnection, dim, hierId, qs, c.moserModule);
                if (MOSER_ITEMHIERARCHY.equals(c.jsonType)) {
                    boolean bLocalRefs = true;
                    JSONArray objs = (JSONArray)c.jsonDef.get((Object)MOSER_LOCALREF);
                    if (objs == null) {
                        bLocalRefs = false;
                        objs = (JSONArray)c.jsonDef.get((Object)MOSER_REF);
                    }
                    MoserLevel qiLvl = null;
                    int[] index = new int[]{1};
                    for (Object o : objs) {
                        String lvlId;
                        if (bLocalRefs) {
                            JSONObject jObj = (JSONObject)o;
                            refQI = (String)jObj.get((Object)MOSER_REF);
                            lvlId = (String)jObj.get((Object)MOSER_ID);
                            if (lvlId == null) {
                                lvlId = refQI;
                            }
                        } else {
                            lvlId = refQI = (String)o;
                        }
                        MoserQueryItem refQIObj = (MoserQueryItem)MoserModuleUtil.getQueryItemByName(qs, refQI);
                        if (refQIObj == null) {
                            throw new XQERuntimeException(XQEMessageKeys.MSR_ReferenceMissing, refQI);
                        }
                        qiLvl = MoserModuleUtil.createMoserLevel(metadataConnection, hier, lvlId, index, refQIObj, qs, c.moserModule);
                    }
                    qiLvl.bLeaf = true;
                    JSONArray calcMembers = (JSONArray)c.jsonDef.get((Object)MOSER_CALCULATED_MEMBER);
                    if (calcMembers == null || calcMembers.size() <= 0) continue;
                    for (int i = 0; i < calcMembers.size(); ++i) {
                        JSONObject calc = (JSONObject)calcMembers.get(i);
                        String calcId = (String)calc.get((Object)MOSER_ID);
                        MoserMember cMember = new MoserMember(metadataConnection.getNextId(), calcId);
                        cMember.expr = (String)calc.get((Object)MOSER_EXPRESSION);
                        hier.calculatedMembers.add(cMember);
                        cMember.v5UniqueName = hier.getV5UniqueName() + MOSER_DOT + calcId;
                        cMember.uniqueId = hier.getUniqueID() + MOSER_DOT + calcId;
                        c.moserModule.registerExpressionObject(cMember.getUniqueID(), cMember);
                        String label = (String)calc.get((Object)MOSER_LABEL);
                        if (label != null) {
                            cMember.caption = label;
                        }
                        cMember.hier = hier;
                    }
                    continue;
                }
                JSONArray refs = (JSONArray)c.jsonDef.get((Object)MOSER_SEGMENT);
                MoserLevel qiLvl = null;
                int[] index = new int[]{1};
                for (Object o : refs) {
                    JSONObject ref = (JSONObject)o;
                    refQI = (String)ref.get((Object)MOSER_REF);
                    MoserQueryItem refQIObj = (MoserQueryItem)MoserModuleUtil.getQueryItemByName(qs, refQI);
                    if (refQIObj == null) {
                        throw new XQERuntimeException(XQEMessageKeys.MSR_ReferenceMissing, refQI);
                    }
                    String lvlId = (String)ref.get((Object)MOSER_ID);
                    qiLvl = MoserModuleUtil.createMoserLevel(metadataConnection, hier, lvlId, index, refQIObj, qs, c.moserModule);
                }
                qiLvl.bLeaf = true;
            }
        }
    }

    protected static MoserHierarchy createMoserHierarchy(MoserMetadataConnection metadataConnection, MoserDimension dim, String hierId, MoserQuerySubject qs, MoserModule module) {
        MoserMember allMUN;
        if (metadataConnection.cube == null) {
            metadataConnection.cube = new MoserCube(metadataConnection);
        }
        metadataConnection.cube.addDimension(dim);
        MoserHierarchy hier = new MoserHierarchy(metadataConnection.getNextId(), hierId);
        hier.setUniqueID(qs.getUniqueID() + MOSER_DOT + hier.getName());
        dim.defaultHierarchy = hier;
        hier.parentDimension = dim;
        hier.simpleV5UniqueName = qs.getName() + MOSER_DOT + hier.getName();
        if (module != null) {
            module.registerExpressionObject(hier.getUniqueID(), hier);
        }
        MoserLevel allLvl = new MoserLevel(metadataConnection.getNextId(), MOSER_ALL);
        allLvl.properties.put("isManual", "true");
        allLvl.setUniqueID(hier.getUniqueID() + MOSER_DOT + allLvl.getName());
        if (module != null) {
            module.registerExpressionObject(allLvl.getUniqueID(), allLvl);
        }
        hier.levels.add(allLvl);
        allLvl.parentHierarchy = hier;
        allLvl.bRoot = true;
        hier.defaultMember = allMUN = new MoserMember(metadataConnection.getNextId(), MOSER_ALL);
        allMUN.level = allLvl;
        return hier;
    }

    protected static MoserLevel createMoserLevel(MoserMetadataConnection metadataConnection, MoserHierarchy hier, String lvlId, int[] index, MoserQueryItem refQIObj, MoserQuerySubject qs, MoserModule module) {
        MoserLevel qiLvl = new MoserLevel(metadataConnection.getNextId(), lvlId);
        qiLvl.setUniqueID(hier.getUniqueID() + MOSER_DOT + qiLvl.getName());
        if (module != null) {
            module.registerExpressionObject(qiLvl.getUniqueID(), qiLvl);
        }
        hier.levels.add(qiLvl);
        qiLvl.parentHierarchy = hier;
        qiLvl.levelIndex = index[0];
        index[0] = index[0] + 1;
        MoserQueryItemOfLevel lvlQI = new MoserQueryItemOfLevel(metadataConnection.getNextId(), refQIObj.getName());
        lvlQI.nullable = refQIObj.isNullable();
        qiLvl.queryItems.add(lvlQI);
        lvlQI.level = qiLvl;
        lvlQI.dataType = refQIObj.getDataType();
        lvlQI.roles.add(RoleTypeEnum.BUSINESS_KEY.toV5Keyword());
        lvlQI.roles.add(RoleTypeEnum.MEMBER_CAPTION.toV5Keyword());
        lvlQI.expression = refQIObj.getV5UniqueName();
        IFacet facet = refQIObj.getFacet();
        if (facet != null && facet.isEnabled() && facet.isExplicitlySetByModeler() && facet.getSortItems().length > 0) {
            HashMap<String, MoserQueryItemOfLevel> seen = new HashMap<String, MoserQueryItemOfLevel>();
            seen.put(refQIObj.getUniqueID(), lvlQI);
            for (ISortItem s : facet.getSortItems()) {
                String refSortQI = s.getRefObject();
                MoserQueryItemOfLevel lvlQISort = (MoserQueryItemOfLevel)seen.get(refSortQI);
                if (lvlQISort == null) {
                    MoserQueryItem refQIObjSort = (MoserQueryItem)MoserModuleUtil.getQueryItemByUniqueID(qs, refSortQI);
                    if (refQIObjSort == null) {
                        throw new XQERuntimeException(XQEMessageKeys.MSR_ReferenceMissing, refSortQI);
                    }
                    lvlQISort = new MoserQueryItemOfLevel(metadataConnection.getNextId(), refQIObjSort.getName());
                    lvlQISort.nullable = refQIObjSort.isNullable();
                    seen.put(refSortQI, lvlQISort);
                    qiLvl.queryItems.add(lvlQISort);
                    lvlQISort.level = qiLvl;
                    lvlQISort.dataType = refQIObjSort.getDataType();
                    lvlQISort.expression = refQIObjSort.getV5UniqueName();
                }
                MoserSortItem lvlSortItem = new MoserSortItem(UniqueNameGenerator.createUniqueName(lvlQISort.getName()), s.getSort(), s.getNullPlacement());
                lvlSortItem.refQueryItemOfLevel = lvlQISort;
                qiLvl.sortItems.add(lvlSortItem);
            }
        }
        return qiLvl;
    }

    protected static IMetadata getQueryItemByName(MoserQuerySubject qs, String name) {
        for (IMetadata qi : qs.getQueryItemsAndMeasures()) {
            if (!qi.getName().equals(name)) continue;
            return qi;
        }
        return null;
    }

    protected static IMetadata getQueryItemByUniqueID(MoserQuerySubject qs, String uId) {
        for (IMetadata qi : qs.getQueryItemsAndMeasures()) {
            if (!qi.getUniqueID().equals(uId)) continue;
            return qi;
        }
        return null;
    }

    protected static IMetadata getSourceObjectFromSourceQuerySubject(MoserQuerySubject srcQS, String expr, String[] onePartName) {
        String[] nameParts = (expr = expr.trim()).split(STR_DOT_REGX);
        if (nameParts.length > 2) {
            return null;
        }
        if (nameParts.length == 2) {
            if (srcQS.getName().equals(nameParts[0])) {
                for (IMetadata srcQI : MoserModuleUtil.getIdentifiableItems(srcQS)) {
                    if (!srcQI.getName().equals(nameParts[1])) continue;
                    return srcQI;
                }
            }
            return null;
        }
        for (IMetadata srcQI : MoserModuleUtil.getIdentifiableItems(srcQS)) {
            if (!srcQI.getName().equals(nameParts[0])) continue;
            if (onePartName != null) {
                onePartName[0] = nameParts[0];
            }
            return srcQI;
        }
        return null;
    }

    private static List<IMetadata> getIdentifiableItems(MoserQuerySubject srcQS) {
        List<IMetadata> items = srcQS.getQueryItemsAndMeasures();
        items.addAll(srcQS.getCalculations());
        return items;
    }

    protected static void resolveQuerySubjectSourceRefs(ExpressionResolveContext c, MoserEnv env) {
        JSONArray joins;
        MoserQuerySubject qs = (MoserQuerySubject)c.objResolve;
        JSONObject jQS = c.jsonDef;
        JSONObject operation = null;
        QsClassifierType classifier = qs.getClassifier();
        if (classifier == QsClassifierType.OPERATION_QUERY_SUBJECT) {
            operation = (JSONObject)jQS.get((Object)MOSER_QUERYOPERATION);
        } else if (classifier == QsClassifierType.JOIN_QUERY_SUBJECT) {
            operation = (JSONObject)jQS.get((Object)MOSER_JOINOPERATION);
        } else {
            return;
        }
        JSONArray queryRef = (JSONArray)operation.get((Object)MOSER_QUERYREF);
        if (MoserModuleUtil.notEmptyArray(queryRef)) {
            for (int i = 0; i < queryRef.size(); ++i) {
                String r = (String)queryRef.get(i);
                IMetadata srcObj = MoserModuleUtil.getSourceQuerySubjectRelationshipFromSourceModule(c.moserModule, c.userPassport, c.cookiesToMoser, r, env);
                if (srcObj == null) {
                    srcObj = c.moserModule.getQuerySubjectOrRelationshipThis(r);
                }
                if (!(srcObj instanceof IQuerySubject)) continue;
                qs.addSourceQuerySubject(srcObj);
            }
        }
        if (classifier == QsClassifierType.JOIN_QUERY_SUBJECT && MoserModuleUtil.notEmptyArray(joins = (JSONArray)operation.get((Object)MOSER_RELATIONSHIP))) {
            for (int i = 0; i < joins.size(); ++i) {
                JSONObject jR = (JSONObject)joins.get(i);
                String name = qs.getName() + MOSER_UNDERSCORE + (String)jR.get((Object)MOSER_ID);
                MoserRelationship r = MoserModuleUtil.createRelationshipWithCheck(c.moserModule, jR, name);
                r.setJoinWeight(RQPJoinPathFinder.Weight.BothEndsInFolder);
                qs.addPreferredJoin(r);
            }
        }
    }

    protected static void resolveItemNormalization(MoserQuerySubject qs, JSONObject itemNorm) {
        JSONArray jGroups = (JSONArray)itemNorm.get((Object)MOSER_ITEM_NORMALIZATION_GROUP);
        if (jGroups == null) {
            return;
        }
        ArrayList<MoserItemNormalizationGroup> groups = new ArrayList<MoserItemNormalizationGroup>();
        if (MoserModuleUtil.notEmptyArray(jGroups)) {
            String id;
            JSONObject jGP;
            int i;
            HashMap<String, MoserItemNormalizationGroup> idToGroups = new HashMap<String, MoserItemNormalizationGroup>();
            for (i = 0; i < jGroups.size(); ++i) {
                jGP = (JSONObject)jGroups.get(i);
                id = (String)jGP.get((Object)MOSER_ID);
                if (id == null) continue;
                idToGroups.put(id, new MoserItemNormalizationGroup(id));
            }
            for (i = 0; i < jGroups.size(); ++i) {
                JSONArray jParentRef;
                String ref;
                JSONArray jAttrs;
                jGP = (JSONObject)jGroups.get(i);
                id = (String)jGP.get((Object)MOSER_ID);
                MoserItemNormalizationGroup grp = id != null ? (MoserItemNormalizationGroup)idToGroups.get(id) : new MoserItemNormalizationGroup(id);
                MoserQueryItem kItem = null;
                boolean keyUnique = false;
                boolean keyUseParent = true;
                JSONObject jKey = (JSONObject)jGP.get((Object)MOSER_KEY);
                if (jKey != null) {
                    String ref2 = (String)jKey.get((Object)MOSER_ITEMREF);
                    IMetadata md = MoserModuleUtil.getQueryItemByName(qs, ref2);
                    if (md == null) {
                        throw new XQERuntimeException(XQEMessageKeys.GEN_FoundInternalErrorParam_INTERNAL, "referenced item in key is missing: " + ref2);
                    }
                    kItem = (MoserQueryItem)md;
                    String sKeyConstraint = (String)jKey.get((Object)MOSER_KEYCONSTRAINT);
                    String sKeyComposition = (String)jKey.get((Object)MOSER_KEYCOMPOSITION);
                    if (MOSER_KEYUNIQUE.equals(sKeyConstraint)) {
                        keyUnique = true;
                    }
                    if (MOSER_KEYINDEPENDENT.equals(sKeyComposition)) {
                        keyUseParent = false;
                    }
                }
                ArrayList<MoserQueryItem> itemRef = new ArrayList<MoserQueryItem>();
                ArrayList<MoserItemNormalizationGroup> parentRef = new ArrayList<MoserItemNormalizationGroup>();
                HashMap<MoserQueryItem, String> sqlOP = null;
                if (kItem != null) {
                    itemRef.add(kItem);
                    sqlOP = new HashMap<MoserQueryItem, String>();
                }
                if (((jAttrs = (JSONArray)jGP.get((Object)MOSER_ATTRIBUTE)) == null || jAttrs.size() == 0) && kItem == null) {
                    throw new XQERuntimeException(XQEMessageKeys.GEN_FoundInternalErrorParam_INTERNAL, "empty itemNormalizationGroup.");
                }
                if (jAttrs != null) {
                    for (int j = 0; j < jAttrs.size(); ++j) {
                        JSONObject jItemRef = (JSONObject)jAttrs.get(j);
                        ref = (String)jItemRef.get((Object)MOSER_ITEMREF);
                        IMetadata md = MoserModuleUtil.getQueryItemByName(qs, ref);
                        if (md == null) continue;
                        itemRef.add((MoserQueryItem)md);
                        if (sqlOP == null) continue;
                        String strSQLOp = (String)jItemRef.get((Object)MOSER_SQLOPERATOR);
                        if (strSQLOp == null) {
                            strSQLOp = MOSER_AUTOMATIC;
                        }
                        sqlOP.put((MoserQueryItem)md, strSQLOp);
                    }
                }
                if ((jParentRef = (JSONArray)jGP.get((Object)MOSER_PARENTGROUPREF)) != null) {
                    for (int j = 0; j < jParentRef.size(); ++j) {
                        ref = (String)jParentRef.get(j);
                        MoserItemNormalizationGroup parentgrp = (MoserItemNormalizationGroup)idToGroups.get(ref);
                        if (parentgrp == null) {
                            throw new XQERuntimeException(XQEMessageKeys.GEN_FoundInternalErrorParam_INTERNAL, "referenced group in parentGroupRef is missing: " + ref);
                        }
                        parentRef.add(parentgrp);
                        parentgrp.bLeaf = false;
                    }
                }
                grp.setMoserItemNormalizationGroup(kItem, keyUseParent, itemRef, parentRef, keyUnique, sqlOP);
                groups.add(grp);
            }
        }
        if (!groups.isEmpty()) {
            qs.itemNormalization = new MoserItemNormalization(groups, qs.getQueryItemsAndMeasures());
        }
    }

    protected static IMetadata getSourceQuerySubjectRelationshipFromSourceModule(IMoserModule module, String userPassport, Map<String, String> cookies, String ref, MoserEnv env) {
        String[] rtRef;
        String refInQS = ref.trim();
        String[] nameParts = refInQS.split(STR_DOT_REGX);
        MoserModule subModule = (MoserModule)MoserModuleUtil.getImportModuleByAlias(module, nameParts, userPassport, cookies, rtRef = new String[]{null}, env);
        if (subModule != null && rtRef[0] != null) {
            return subModule.getQuerySubjectOrRelationshipThis(rtRef[0]);
        }
        return null;
    }

    private static void resolveSortItemReference(ExpressionResolveContext c, MoserEnv env) {
        MoserQuerySubject qs;
        IMetadata qi;
        MoserSortItem sort = (MoserSortItem)c.objResolve;
        sort.bRefResolved = true;
        String ref = sort.getRefObject();
        String idForSearch = c.moserModule.getUniqueName() + MOSER_DOT + ((IMetadata)c.parentChain.get(1)).getName() + MOSER_DOT + ref;
        if (c.moserModule.getExpressionObjectByUNameThis(idForSearch) != null) {
            sort.setRefObject(idForSearch);
            return;
        }
        if (c.parentChain.get(1) instanceof MoserQuerySubject && (qi = MoserModuleUtil.getSourceObjectFromSourceQuerySubject(qs = (MoserQuerySubject)c.parentChain.get(1), ref, null)) != null) {
            sort.setRefObject(qi.getUniqueID());
            return;
        }
        idForSearch = c.moserModule.getUniqueName() + MOSER_DOT + ref;
        if (c.moserModule.getExpressionObjectByUNameThis(idForSearch) != null) {
            sort.setRefObject(idForSearch);
            return;
        }
        sort.bRefResolved = false;
        String opName = env.getExecutionEnvironment().getRequestEnvironment().getOperationName();
        if (!"validateAll".equals(opName)) {
            throw new XQERuntimeException(XQEMessageKeys.MSR_ReferenceMissing, ref);
        }
    }

    protected static boolean isBaseModule(IMoserModule module, String userPassport, Map<String, String> cookiesToMoser, MoserEnv env) {
        List<ModuleIdPair> imports = ((MoserModule)module).getImports();
        if (imports == null || imports.size() != 1) {
            return false;
        }
        for (ModuleIdPair md : imports) {
            MoserModule subModule = (MoserModule)module.getMetadataConnection().getModule(md, userPassport, cookiesToMoser, env);
            if (subModule == null) {
                return false;
            }
            List<MoserDataSource> dss = subModule.getDataSourcesInThis();
            if (dss.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public static IMoserModule getImportModuleByAlias(IMoserModule module, String[] nameParts, String userPassport, Map<String, String> cookiesToMoser, String[] rtRef, MoserEnv env) {
        IMoserModule src;
        IMoserModule rt = null;
        IMoserModule current = module;
        int i = 0;
        if ("SKIP_SELF".equals(nameParts[0])) {
            i = 1;
        }
        while (i < nameParts.length && (src = MoserModuleUtil.getImportByAlias(current, nameParts[i], userPassport, cookiesToMoser, env)) != null) {
            rt = src;
            current = src;
            ++i;
        }
        if (rtRef != null && rt != null && i < nameParts.length) {
            StringBuilder sb = new StringBuilder();
            for (int j = i; j < nameParts.length; ++j) {
                if (j > i) {
                    sb.append(MOSER_DOT);
                }
                sb.append(nameParts[j]);
            }
            rtRef[0] = sb.toString();
        }
        return rt;
    }

    private static IMoserModule getImportByAlias(IMoserModule module, String alias, String userPassport, Map<String, String> cookiesToMoser, MoserEnv env) {
        List<ModuleIdPair> allImports = ((MoserModule)module).getImports();
        ModuleIdPair found = null;
        for (ModuleIdPair m : allImports) {
            if (!alias.equals(m.getAlias())) continue;
            found = m;
            break;
        }
        if (found == null) {
            return null;
        }
        return module.getMetadataConnection().getModule(found, userPassport, cookiesToMoser, env);
    }

    public static void addModuleSource(MoserModule module, String storeId, String type, String searchPath) {
        if (module.getSource() != null) {
            return;
        }
        String label = module.getLabel();
        AbstractSource src = TYPE_DATABASE.equals(type) || TYPE_FILE.equals(type) || TYPE_DATASET.equals(type) || TYPE_LWOLAP.equals(type) ? new BaseModuleSource(label, storeId, searchPath, MoserModuleUtil.getModuleLastModified(module)) : new ModuleSource(label, storeId, searchPath, MoserModuleUtil.getModuleLastModified(module));
        module.setSource(src);
    }

    protected static String getDataSourceName(MoserModule module) {
        List<MoserDataSource> srcs = module.getDataSources();
        if (srcs == null || srcs.size() != 1) {
            return MOSER_DATASOURCE;
        }
        MoserDataSource src = srcs.get(0);
        StringBuilder sb = new StringBuilder();
        sb.append(src.getCMDataSourceName());
        sb.append(COLON);
        sb.append(src.getInterface());
        sb.append(COLON);
        sb.append(src.getName());
        sb.append(MOSER_DOT);
        sb.append(src.getCatalog());
        sb.append(MOSER_DOT);
        sb.append(src.getSchema());
        return sb.toString();
    }

    protected static void setDynamicDSProperty(MoserModule module, Map<String, Object> useSpec) {
        JSONArray dynProps = (JSONArray)useSpec.get(MOSER_PROPERTY);
        if (!MoserModuleUtil.notEmptyArray(dynProps)) {
            return;
        }
        String dynCat = null;
        String dynSchema = null;
        for (Object o : dynProps) {
            JSONObject jObj = (JSONObject)o;
            String nm = (String)jObj.get((Object)MOSER_NAME);
            if (DYNAMIC_DS_XQE_CATALOG.equals(nm)) {
                dynCat = (String)jObj.get((Object)MOSER_VALUE);
                continue;
            }
            if (!DYNAMIC_DS_XQE_SCHEMA.equals(nm)) continue;
            dynSchema = (String)jObj.get((Object)MOSER_VALUE);
        }
        if (dynCat == null && dynSchema == null) {
            return;
        }
        for (MoserDataSource ds : module.datasources) {
            if (dynSchema != null) {
                if (!dynSchema.isEmpty()) {
                    ds.setSchema(dynSchema);
                } else {
                    ds.setSchema(null);
                }
            }
            if (dynCat == null) continue;
            if (!dynCat.isEmpty()) {
                ds.setCatalog(new MoserCatalog(module.getMetadataConnection().getNextId(), dynCat));
                continue;
            }
            ds.setCatalog(null);
        }
    }

    public static void addPhysicalModuleSource(MoserModule module, String storeId, Map<String, Object> useSpec, MoserEnv env) {
        String dataCacheExpiry;
        MoserModuleUtil.setDynamicDSProperty(module, useSpec);
        String type = (String)useSpec.get(USESPEC_TYPE);
        AbstractSource src = null;
        String dsName = MoserModuleUtil.getDataSourceName(module);
        if (TYPE_DATABASE.equals(type) || TYPE_LWOLAP.equals(type)) {
            long lastModified = 0L;
            if (env.getModuleReader() instanceof MoserModuleReader) {
                lastModified = System.currentTimeMillis();
            }
            src = new DatasourceSource(dsName, storeId, (String)useSpec.get(SEARCHPATH), lastModified, true);
        } else if (TYPE_DATASET.equals(type)) {
            src = new DataSet2Source(dsName, storeId, (String)useSpec.get(SEARCHPATH), MoserModuleUtil.getModuleLastModified(module));
        } else if (TYPE_FILE.equals(type)) {
            src = new UploadedFileSource(dsName, storeId, (String)useSpec.get(SEARCHPATH), MoserModuleUtil.getModuleLastModified(module));
        }
        if (src != null) {
            module.setSource(src);
        }
        if ((dataCacheExpiry = (String)useSpec.get(MOSER_DATA_CACHE_EXPIRY)) != null) {
            module.setDataCacheExpiry(dataCacheExpiry);
        }
    }

    protected static long getModuleLastModified(MoserModule module) {
        String lastModified = module.getModificationTime();
        if (lastModified == null) {
            return System.currentTimeMillis();
        }
        try {
            SimpleDateFormat format = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss z", Locale.US);
            Date dt = format.parse(lastModified);
            return dt.getTime();
        }
        catch (java.text.ParseException e) {
            return System.currentTimeMillis();
        }
    }

    public static XMLGregorianCalendar getTimeGregorian(String xsdDateTime) {
        if (xsdDateTime == null || xsdDateTime.isEmpty() || !XSD_DATE_TIME_PATTERN.matcher(xsdDateTime).matches()) {
            return null;
        }
        return datatypeFactory.newXMLGregorianCalendar(xsdDateTime);
    }

    public static long getTimeInMillis(String xsdDateTime) {
        XMLGregorianCalendar cal = MoserModuleUtil.getTimeGregorian(xsdDateTime);
        if (cal == null) {
            return 0L;
        }
        return cal.toGregorianCalendar().getTimeInMillis();
    }

    protected static IMetadata getReferencedMetadataInQuerySubject(MoserQuerySubject qs, String ref, IMetadata context, MoserQuerySubject.SearchScope[] scope, MoserEnv env) {
        IMetadata md;
        if (scope == null || scope.length == 0) {
            return null;
        }
        HashSet<MoserQuerySubject.SearchScope> s = new HashSet<MoserQuerySubject.SearchScope>(Arrays.asList(scope));
        if (s.contains((Object)MoserQuerySubject.SearchScope.QUERYSUBJECT)) {
            md = MoserModuleUtil.getSourceObjectFromSourceQuerySubject(qs, ref, null);
            if (md != null && !md.equals(context)) {
                return md;
            }
            if (scope.length == 1) {
                return md;
            }
        }
        if (s.contains((Object)MoserQuerySubject.SearchScope.SOURCE_QUERYSUBJECT) && (md = MoserModuleUtil.getReferencedMetadataInSourceQuerySubject(qs, ref, context, env)) != null) {
            return md;
        }
        if (s.contains((Object)MoserQuerySubject.SearchScope.MODULE)) {
            IMetadata md2;
            String[] parts = ref.split(STR_DOT_REGX);
            String newRef = ref;
            if (!qs.getName().equals(parts[0])) {
                newRef = qs.getName() + MOSER_DOT + ref;
            }
            if ((md2 = qs.getReferencedMetadataInModule(newRef)) != null) {
                return md2;
            }
        }
        return null;
    }

    protected static IMetadata getReferencedMetadataInSourceQuerySubject(MoserQuerySubject qs, String ref, IMetadata context, MoserEnv env) {
        IMetadata obj = MoserModuleUtil.findObjectFromSourceQuerySubjectsForBinding(qs, ref, context);
        if (obj != null) {
            return obj;
        }
        if (context != null && !ref.equals(context.getName())) {
            return null;
        }
        Set<String> refs = qs.getRefs();
        if (refs == null) {
            return null;
        }
        HashSet<IMetadata> srcObjs = new HashSet<IMetadata>();
        MoserMetadataConnection mc = qs.parentModule.getMetadataConnection();
        for (String r : refs) {
            MoserModuleUtil.getSourceObjectFromSourceModule(qs.parentModule, r, ref, srcObjs, mc.theConnectionPassport, mc.cookies, env);
        }
        if (srcObjs.size() == 1) {
            return (IMetadata)srcObjs.iterator().next();
        }
        return null;
    }

    protected static List<MoserQueryItem> getHierarchyQueryItems(MoserQuerySubject qs, String hierName, int length) {
        String[] nameParts;
        String[] parts = hierName.split(STR_DOT_REGX);
        if (parts.length > 1 && parts[0].equals(qs.getName())) {
            nameParts = new String[parts.length - 1];
            System.arraycopy(parts, 1, nameParts, 0, parts.length - 1);
        } else {
            nameParts = parts;
        }
        if (nameParts.length < 1 || nameParts.length > 2) {
            return null;
        }
        String uName = qs.getUniqueID() + MOSER_DOT + nameParts[0];
        IMetadata meta = qs.parentModule.getExpressionObjectByUNameThis(uName);
        if (meta != null) {
            return MoserModuleUtil.getQueryItemsFromHierarchy(qs, meta, nameParts, length);
        }
        if (nameParts.length > 1) {
            return null;
        }
        meta = MoserModuleUtil.getQueryItemByName(qs, nameParts[0]);
        if (meta instanceof MoserQueryItem) {
            ArrayList<MoserQueryItem> rt = new ArrayList<MoserQueryItem>();
            rt.add((MoserQueryItem)meta);
            return rt;
        }
        return null;
    }

    protected static List<MoserQueryItem> getQueryItemsFromHierarchy(MoserQuerySubject qs, IMetadata meta, String[] nameParts, int length) {
        if (!(meta instanceof MoserHierarchy)) {
            return null;
        }
        MoserHierarchy hier = (MoserHierarchy)meta;
        int end = -1;
        if (nameParts.length == 2) {
            for (int i = 1; i < hier.levels.size(); ++i) {
                if (!nameParts[1].equals(hier.levels.get(i).getName())) continue;
                end = i;
                break;
            }
        } else {
            end = hier.levels.size() - 1;
        }
        if (end < 1 || length > end) {
            return null;
        }
        ArrayList<MoserQueryItem> rt = new ArrayList<MoserQueryItem>();
        for (int i = 1; i <= length; ++i) {
            MoserLevel lvl = hier.levels.get(i);
            IMetadata qi = MoserModuleUtil.getQueryItemByName(qs, lvl.getName());
            if (!(qi instanceof MoserQueryItem)) {
                return null;
            }
            rt.add((MoserQueryItem)qi);
        }
        return rt;
    }

    public static boolean isLWOLAP(MetadataConnection metadataConnection) {
        return metadataConnection instanceof MoserMetadataConnection && ((MoserMetadataConnection)metadataConnection).getModule().isLWOLAP();
    }

    public static MetadataConnection getLWOLAPModulePackageConnection(MetadataConnection metadataConnection) {
        return ((MoserMetadataConnection)metadataConnection).getLWOLAPModulePackageConnection();
    }

    protected static String getSQLDataTypeFromJMDDataType(String dt) {
        if (JMD_DT_INTERVAL_YEAR.equalsIgnoreCase(dt) || JMD_DT_INTERVAL_YEAR_TO_MONTH.equalsIgnoreCase(dt) || JMD_DT_INTERVAL_MONTH.equalsIgnoreCase(dt) || JMD_DT_INTERVAL_DAY.equalsIgnoreCase(dt) || JMD_DT_INTERVAL_DAY_TO_HOUR.equalsIgnoreCase(dt) || JMD_DT_INTERVAL_DAY_TO_MINUTE.equalsIgnoreCase(dt) || JMD_DT_INTERVAL_DAY_TO_SECOND.equalsIgnoreCase(dt) || JMD_DT_INTERVAL_HOUR.equalsIgnoreCase(dt) || JMD_DT_INTERVAL_HOUR_TO_MINUTE.equalsIgnoreCase(dt) || JMD_DT_INTERVAL_HOUR_TO_SECOND.equalsIgnoreCase(dt) || JMD_DT_INTERVAL_MINUTE.equalsIgnoreCase(dt) || JMD_DT_INTERVAL_MINUTE_TO_SECOND.equalsIgnoreCase(dt) || JMD_DT_INTERVAL_SECOND.equalsIgnoreCase(dt)) {
            return dt.replaceAll(MOSER_UNDERSCORE, MOSER_SPACE);
        }
        if (JMD_DT_TIMESTAMP_TZ.equalsIgnoreCase(dt)) {
            return "TIMESTAMP WITH TIME ZONE";
        }
        if (JMD_DT_TIME_TZ.equalsIgnoreCase(dt)) {
            return "TIME WITH TIME ZONE";
        }
        return dt;
    }

    public static JSONObject processConnectionInfo(JSONArray connectionInfo) {
        if (!MoserModuleUtil.notEmptyArray(connectionInfo)) {
            return null;
        }
        JSONObject rt = new JSONObject();
        for (Object o : connectionInfo) {
            JSONObject cInfo = (JSONObject)o;
            for (Object k : cInfo.keySet()) {
                String kName = (String)k;
                Object v = cInfo.get(k);
                MoserModuleUtil.processConnectionInfoEntry(rt, kName, v);
            }
        }
        return rt;
    }

    private static void processConnectionInfoEntry(JSONObject dataSource, String key, Object value) {
        if ("providerType".equals(key)) {
            dataSource.put((Object)MOSER_DBTYPE, (Object)"D2");
        } else if ("jdbcConnectionString".equals(key)) {
            StringBuilder connectionString = new StringBuilder(";LOCAL;JD-D2;URL=");
            connectionString.append(((String)value).replace(BACK_SLASH, MOSER_EMPTY_STRING));
            connectionString.append(";DRIVER_NAME=com.ibm.db2.jcc.DB2Driver");
            dataSource.put((Object)"connectionString", (Object)connectionString.toString());
        } else if (MOSER_DB_UID.equals(key)) {
            dataSource.put((Object)MOSER_DB_UID, value);
        } else if ("password".equals(key)) {
            dataSource.put((Object)"password", value);
        }
    }

    public static String convertToJMDDataType(IDataType columnDt) {
        String typeName = columnDt.getTypeName();
        if ("string".equals(typeName)) {
            return JMD_DT_NVARCHAR_MAX;
        }
        if ("time with time zone".equals(typeName)) {
            return JMD_DT_TIME_TZ;
        }
        if ("timestamp with time zone".equals(typeName)) {
            return JMD_DT_TIMESTAMP_TZ;
        }
        String jmdDT = columnDt.toString();
        if (columnDt instanceof IntervalType) {
            jmdDT = jmdDT.replaceAll(MOSER_SPACE, MOSER_UNDERSCORE);
        }
        return jmdDT.toUpperCase(Locale.ENGLISH);
    }

    public static boolean stringEquals(String s1, String s2) {
        if (s1 != null && s2 != null) {
            return s1.equals(s2);
        }
        return s1 == null && s2 == null;
    }

    protected static void initializeOperationQuerySubject(IMoserModule module, MoserQuerySubject qs, JSONObject jQS, String userPassport, List<ExpressionResolveContext> c, Map<String, String> cookiesToMoser, boolean bTop, MoserEnv env, FormatConverter fc) {
        qs.setClassifier(QsClassifierType.OPERATION_QUERY_SUBJECT);
        qs.setDefinitionType(STR_MODEL_QUERY);
        qs.setQuerySubjectType(IQuerySubject.QuerySubjectTypeEnum.QUERYOPERATION);
        JSONObject operation = (JSONObject)jQS.get((Object)MOSER_QUERYOPERATION);
        qs.setProperty(SET_OPERATION_PROP, operation.get((Object)SET_OPERATION_PROP));
        qs.setProperty(DUPLICATES_PROP, operation.get((Object)DUPLICATES_PROP));
        qs.setUniqueID(((MoserModule)module).getUniqueName() + MOSER_DOT + qs.getName());
        qs.setV5UniqueName(UniqueNameGenerator.createEscapedUniqueName(((MoserModule)module).getUniqueName(), qs.getName()));
        MoserModuleUtil.initializeQuerySubjectDef(module, qs, jQS, userPassport, c, cookiesToMoser, bTop, env, fc);
    }

    public static String getNormalizedIdentifier(String identifier) {
        String[] nameParts = UniqueNameParser.parseNoThrow(identifier);
        if (nameParts != null) {
            return identifier;
        }
        nameParts = identifier.split(STR_DOT_REGX);
        if (nameParts == null || nameParts.length < 1) {
            return identifier;
        }
        StringBuffer newExpr = new StringBuffer();
        int i = 0;
        for (String part : nameParts) {
            if (i > 0) {
                newExpr.append(MOSER_DOT);
            }
            newExpr.append("[").append(part).append("]");
            ++i;
        }
        return newExpr.toString();
    }

    public static String getNormalizedUniqueId(String uniqueId) {
        String[] nameParts = uniqueId.split(STR_DOT_REGX);
        if (nameParts.length < 2 || !MoserModuleUtil.isSessionTempID(nameParts[0])) {
            return uniqueId;
        }
        return MoserModuleUtil.buildNameFromParts(Arrays.copyOfRange(nameParts, 1, nameParts.length));
    }

    static {
        block2: {
            DATEFORMAT = new SimpleDateFormat(DATE_FORMAT_PATTERN);
            DATETIMEFORMATTER = DateTimeFormatter.ofPattern(DATE_FORMAT_PATTERN);
            MOSER_CUBE = "cube";
            MOSER_CUBE_DESCRIPTION = "cubeDescription";
            MOSER_CUBE_IS_OPTIMIZED = "cubeIsOptimized";
            MOSER_DEFAULT_MEASURE = "cubeDefaultMeasure";
            MOSER_SCHEMA_UPDATED_DATE = "cubeSchemaUpdatedOn";
            MOSER_UPDATED_DATE = "cubeDataUpdatedOn";
            MOSER_CREATED_DATE = "cubeCreatedOn";
            MOSER_CURRENT_PERIOD = "cubeCurrentPeriod";
            PROMPT_INFO = "promptInfo";
            PROMPT_TYPE = "promptType";
            PROMPT_CASCADE_ON_REF = "promptCascadeOnRef";
            PROMPT_FILTER_ITEM_REF = "promptFilterItemRef";
            PROMPT_DISPLAY_ITEM_REF = "promptDisplayItemRef";
            PROMPT_USE_ITEM_REF = "promptUseItemRef";
            FACET_DT = new HashSet();
            DEFAULT_MAX_TMP_AGE = (int)TimeUnit.MINUTES.toSeconds(10L);
            DEFAULT_FLINT_DATASET_IDLE_SECONDS_VALUE = (int)TimeUnit.HOURS.toSeconds(12L);
            MAX_FLINT_DATASET_IDLE_SECONDS_VALUE = (int)TimeUnit.HOURS.toSeconds(12L);
            MIN_FLINT_DATASET_IDLE_SECONDS_VALUE = (int)TimeUnit.HOURS.toSeconds(1L);
            scheduledCacheCleanup = null;
            cleanupLock = new Object();
            XSD_DATE_TIME_PATTERN = Pattern.compile("[0-9]{4}-[0-9]{2}-[0-9]{2}T[^.]+([.][0-9]{3}|)(Z|[+-][0-9]{2}:[0-9]{2})");
            CONFIG = XQEConfigurationManager.getInstance().getConfiguration(ServiceEnumeration.XQE);
            FACET_DT.add("char");
            FACET_DT.add("nvarchar");
            FACET_DT.add("varchar");
            FACET_DT.add("nchar");
            FACET_DT.add("long");
            FACET_DT.add("integer");
            FACET_DT.add("smallint");
            FACET_DT.add("tinyint");
            FACET_DT.add("decimal");
            FACET_DT.add("date");
            FACET_DT.add(MOSER_QS_USAGE_TIME);
            FACET_DT.add("timestamp");
            FACET_DT.add("timestamp with time zone");
            FACET_DT.add("time with time zone");
            FACET_DT.add("interval year to month");
            FACET_DT.add("interval day to time");
            sidLOCK = new ConcurrentSimpleDLinkLRUMap(CONFIG.getIntegerProperty("metadataService.moserLoadDataFileLockSize", 500));
            maxTmpAge = CONFIG.getIntegerProperty("metadataService.moserTemporaryFileMaxAge", DEFAULT_MAX_TMP_AGE);
            datatypeFactory = null;
            try {
                datatypeFactory = DatatypeFactory.newInstance();
            }
            catch (DatatypeConfigurationException e) {
                if (!MoserModuleManager.loggingEnabled()) break block2;
                MoserModuleManager.log(LogLevel.TRACE, e.getLocalizedMessage());
            }
        }
    }

    private static final class DeterminantDef {
        private boolean bStop;
        private IQuerySubject srcQS;
        private Set<String> srcKeys;
        private Set<String> srcAttrs;
        private TreeSet<IQueryItem> primaryKeyQIs;
        private TreeSet<IQueryItem> attributeQIs;
        private String detName;
        private String userPassport;
        private Map<String, String> cookiesToMoser;
        private Set<String> calcUniqueIds = null;

        private DeterminantDef() {
        }
    }

    public static final class ExpressionResolveContext {
        private IMetadata objResolve;
        private ArrayList<IMetadata> parentChain;
        private MoserModule moserModule;
        private String userPassport;
        private Map<String, String> cookiesToMoser;
        private JSONObject jsonDef;
        private String jsonType;
    }
}

