/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqemoser;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.sql.parser.ParseException;
import com.cognos.xqe.data.model.IDataSource;
import com.cognos.xqe.data.types.IDataType;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.metadata.IColumnDependency;
import com.cognos.xqe.metadata.IDeterminant;
import com.cognos.xqe.metadata.IEmbeddedFilter;
import com.cognos.xqe.metadata.IMetadata;
import com.cognos.xqe.metadata.IModelDataSource;
import com.cognos.xqe.metadata.IMultiRequestHandle;
import com.cognos.xqe.metadata.IProcParameter;
import com.cognos.xqe.metadata.IQueryItem;
import com.cognos.xqe.metadata.IQuerySubject;
import com.cognos.xqe.metadata.IRelationship;
import com.cognos.xqe.metadata.MetadataBindingException;
import com.cognos.xqe.metadata.MetadataType;
import com.cognos.xqe.metadata.MetadataUtil;
import com.cognos.xqe.metadata.provider.MetadataConnection;
import com.cognos.xqe.query.engine.IContextable;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.source.DatasourceSource;
import com.cognos.xqe.source.ISource;
import com.cognos.xqe.transformation.relational.binding.SQLBinderUtil;
import com.cognos.xqe.util.Pair;
import com.cognos.xqe.util.UniqueNameGenerator;
import com.cognos.xqe.util.UniqueNameParser;
import com.cognos.xqe.util.bean.BeanPropertySupport;
import com.cognos.xqemoser.MoserBaseMetadata;
import com.cognos.xqemoser.MoserCalculation;
import com.cognos.xqemoser.MoserDataSource;
import com.cognos.xqemoser.MoserEmbeddedFilter;
import com.cognos.xqemoser.MoserEnv;
import com.cognos.xqemoser.MoserItemNormalization;
import com.cognos.xqemoser.MoserModule;
import com.cognos.xqemoser.MoserModuleUtil;
import com.cognos.xqemoser.MoserQueryItem;
import com.cognos.xqemoser.MoserQueryItemFolder;
import com.cognos.xqemoser.MoserSQLASTGenerator;
import com.cognos.xqemoser.QsClassifierType;
import com.ibm.json.java.JSONArray;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

public class MoserQuerySubject
extends MoserBaseMetadata
implements IQuerySubject,
IContextable {
    public static final SearchScope[] ONLY_IN_QUERYSUBJECT = new SearchScope[]{SearchScope.QUERYSUBJECT};
    public static final SearchScope[] QUERYSUBJECT_AND_SOURCE_QUERYSUBJECT = new SearchScope[]{SearchScope.QUERYSUBJECT, SearchScope.SOURCE_QUERYSUBJECT};
    public static final SearchScope[] QUERYSUBJECT_AND_MODULE = new SearchScope[]{SearchScope.QUERYSUBJECT, SearchScope.MODULE};
    protected MoserModule parentModule;
    protected MoserDataSource parentDataSource;
    protected String uniqueId;
    protected String v5UniqueName;
    protected IQuerySubject.QuerySubjectUsageEnum usage = IQuerySubject.QuerySubjectUsageEnum.AUTOMATIC;
    protected String generateSQL = "asView";
    protected String definitionType;
    protected Boolean involvedInJoins;
    protected IQuerySubject.QuerySubjectTypeEnum querySubjectType;
    protected ArrayList<MoserQueryItem> queryItems = new ArrayList();
    protected ArrayList<IEmbeddedFilter> embeddedFilters = new ArrayList();
    protected ArrayList<IEmbeddedFilter> securityFilters = new ArrayList();
    protected ArrayList<IDeterminant> determinants = new ArrayList();
    protected String sqlText;
    protected TreeSet<String> refs;
    protected TreeSet<String> originalRefs;
    protected XQERuntimeException error = null;
    protected String label;
    protected List<IQuerySubject> sourceQuerySubjects = new ArrayList<IQuerySubject>();
    protected Set<IRelationship> preferredJoins = new HashSet<IRelationship>();
    protected MoserItemNormalization itemNormalization = null;
    protected Map<String, Object> properties = new HashMap<String, Object>();
    protected QsClassifierType type = QsClassifierType.QUERY_SUBJECT;
    protected String dataCacheExpiry = "automatic";
    protected List<MoserQuerySubject> sourceQSforBinding = null;
    protected String cmDataSourceName;
    protected ArrayList<MoserQueryItemFolder> queryItemFolders = new ArrayList();
    protected ArrayList<MoserCalculation> calculations = new ArrayList();
    protected IQuerySubject.SelectListControl selectListControl = IQuerySubject.SelectListControl.AUTOMATIC;
    private boolean isDynamicMiniQS;
    private boolean isDynamicSQS = false;

    public MoserQuerySubject(long id, String n, int location) {
        super(id, n, location);
        this.objectType = MetadataType.QUERY_SUBJECT;
    }

    public MoserQuerySubject(long id, IQuerySubject.QuerySubjectUsageEnum qsUsage, String n) {
        this(id, n, -1);
        this.usage = qsUsage;
    }

    public void setParentModule(MoserModule m) {
        this.parentModule = m;
    }

    public MoserModule getParentModule() {
        return this.parentModule;
    }

    public MoserDataSource getParentDataSource() {
        return this.parentDataSource;
    }

    public void setParentDataSource(MoserDataSource ds) {
        this.parentDataSource = ds;
    }

    @Override
    public String getUniqueName() {
        if (this.refs != null && !this.refs.isEmpty()) {
            return this.refs.first();
        }
        return null;
    }

    @Override
    public Set<String> getAvailableProperties() {
        return null;
    }

    @Override
    public Object getProperty(String propertyName) {
        return this.properties.get(propertyName);
    }

    @Override
    public IDataType getDataType() {
        return null;
    }

    @Override
    public MetadataConnection getConnection() {
        return this.parentModule.getMetadataConnection();
    }

    @Override
    public IMetadata getParentObject() {
        return null;
    }

    @Override
    public List<IMetadata> getDescendantMetadataObjectsSkipFolders() {
        return null;
    }

    @Override
    public List<IMetadata> getChildMetadataObjects() {
        return null;
    }

    @Override
    public String getV5UniqueName() {
        return this.v5UniqueName;
    }

    public void setV5UniqueName(String v5Uname) {
        this.v5UniqueName = v5Uname;
    }

    @Override
    public String getID() {
        return this.uniqueId;
    }

    @Override
    public boolean hasChildMetadataObjects() {
        return false;
    }

    @Override
    public String getDescription() {
        return null;
    }

    @Override
    public String getUniqueID() {
        return this.uniqueId;
    }

    public void setUniqueID(String uid) {
        this.uniqueId = uid;
    }

    @Override
    public BeanPropertySupport getBeanPropertySupport() {
        return null;
    }

    @Override
    public boolean isDMR() {
        return false;
    }

    @Override
    public boolean isMFW() {
        return false;
    }

    @Override
    public IMetadata getParentObjectSkipFolders() {
        return null;
    }

    @Override
    public boolean isAccessible() {
        return true;
    }

    @Override
    public void setParentMetadataObject(IMetadata parent) {
    }

    @Override
    public IMultiRequestHandle[] getHandles() {
        return null;
    }

    @Override
    public int compareTo(Object arg0) {
        return this.doCompareTo(arg0);
    }

    @Override
    public String getDefinitionType() {
        return this.definitionType;
    }

    public void setDefinitionType(String t) {
        this.definitionType = t;
    }

    @Override
    public String getGeneratedSQLOption() {
        return this.generateSQL;
    }

    public void setGeneratedSQLOption(String g) {
        this.generateSQL = g;
    }

    @Override
    public List<IModelDataSource> getDataSources() {
        return null;
    }

    @Override
    public List<IEmbeddedFilter> getFilters() {
        ArrayList<IEmbeddedFilter> rt = new ArrayList<IEmbeddedFilter>(this.embeddedFilters);
        if (this.parentModule != null) {
            this.parentModule.getMetadataConnection().appendEmbeddedFilter(this, rt);
        }
        return rt;
    }

    public void setFilters(ArrayList<IEmbeddedFilter> filters) {
        this.embeddedFilters = filters;
    }

    @Override
    public List<IEmbeddedFilter> getPreviewFilters() {
        return Collections.emptyList();
    }

    @Override
    public List<IEmbeddedFilter> getSecurityFilters() {
        return this.securityFilters;
    }

    @Override
    public List<IDeterminant> getDeterminants() {
        return new ArrayList<IDeterminant>(this.determinants);
    }

    public void addDeterminant(IDeterminant det) {
        this.determinants.add(det);
    }

    @Override
    public List<IColumnDependency> getColumnDependencies() {
        return null;
    }

    @Override
    public List<IMetadata> getQueryItemsAndMeasures() {
        List<IMetadata> rt = this.getQueryItemsAndMeasuresThis();
        if (this.parentModule != null) {
            this.parentModule.getMetadataConnection().appendQueryItem(this, rt);
        }
        return rt;
    }

    public List<IMetadata> getQueryItemsAndMeasuresThis() {
        return new ArrayList<IMetadata>(this.queryItems);
    }

    public void addQueryItem(MoserQueryItem qi) {
        this.queryItems.add(qi);
    }

    public void addEmbeddedFilter(MoserEmbeddedFilter eFilter) {
        this.embeddedFilters.add(eFilter);
    }

    public void addSecurityFilter(MoserEmbeddedFilter eFilter) {
        this.securityFilters.add(eFilter);
    }

    @Override
    public boolean hasUniqueIndex() {
        return false;
    }

    @Override
    public String getSql() {
        return this.sqlText;
    }

    public void setSql(String s) {
        this.sqlText = s;
    }

    @Override
    public IQuerySubject[] getQuerySubjectRefs() {
        return this.getSourceQuerySubject().toArray(new IQuerySubject[this.getSourceQuerySubject().size()]);
    }

    @Override
    public IXQEQueryNode generateSQLAST(PlanningEnvironment environment, IXQEQueryNode ownerNode, IQuerySubject querySubject) throws ParseException {
        MoserSQLASTGenerator generator = new MoserSQLASTGenerator(this);
        IXQEQueryNode sqlNode = generator.generateSQLAST(environment, ownerNode);
        this.bindCMDataSourceNativeSQL(environment, sqlNode);
        return sqlNode;
    }

    @Override
    public IQuerySubject.QuerySubjectTypeEnum getQuerySubjectType() {
        return this.querySubjectType;
    }

    public void setQuerySubjectType(IQuerySubject.QuerySubjectTypeEnum qsType) {
        this.querySubjectType = qsType;
    }

    @Override
    public IQuerySubject.QuerySubjectUsageEnum getQuerySubjectUsage() {
        return this.usage;
    }

    public void setQuerySubjectUsage(IQuerySubject.QuerySubjectUsageEnum u) {
        this.usage = u;
    }

    @Override
    public IQuerySubject.QuerySubjectUseLocalCacheEnum getQuerySubjectUseLocalCache() {
        return null;
    }

    @Override
    public String getQuerySubjectDataCacheExpiry() {
        return this.dataCacheExpiry;
    }

    public void setQuerySubjectDataCacheExpiry(String theDataCacheExpiry) {
        this.dataCacheExpiry = theDataCacheExpiry;
    }

    @Override
    public Boolean getInvolvedInJoins() {
        return this.involvedInJoins;
    }

    @Override
    public void setInvolvedInJoins(boolean b) {
        this.involvedInJoins = b;
    }

    @Override
    public List<IProcParameter> getStoredProcArgs() {
        return null;
    }

    @Override
    public boolean getUseInJoinPath() {
        return false;
    }

    @Override
    public double getOrderOfMagnitude() {
        return 0.0;
    }

    public void setRefs(JSONArray r) {
        this.setRefsOrOriginalRefs(r, true);
    }

    protected void setRefsOrOriginalRefs(JSONArray r, boolean b) {
        if (r == null) {
            if (b) {
                this.refs = null;
            } else {
                this.originalRefs = null;
            }
            return;
        }
        for (int i = 0; i < r.size(); ++i) {
            String rf = (String)r.get(i);
            if (rf == null) continue;
            if (b) {
                if (this.refs == null) {
                    this.refs = new TreeSet();
                }
                this.refs.add(rf);
                continue;
            }
            if (this.originalRefs == null) {
                this.originalRefs = new TreeSet();
            }
            this.originalRefs.add(rf);
        }
    }

    public void setOriginalRefs(JSONArray r) {
        this.setRefsOrOriginalRefs(r, false);
    }

    public Set<String> getRefs() {
        return this.refs;
    }

    public XQERuntimeException getError() {
        return this.error;
    }

    public void setError(XQERuntimeException e) {
        this.error = e;
    }

    public void throwIfError() {
        if (this.error != null) {
            throw this.error;
        }
    }

    @Override
    public String getLabel() {
        return this.label;
    }

    @Override
    public void setLabel(String aLabel) {
        this.label = aLabel;
    }

    public ISource getSource() {
        if (this.cmDataSourceName != null) {
            return new DatasourceSource(this.cmDataSourceName, this.cmDataSourceName, null, System.currentTimeMillis(), true);
        }
        if (this.parentModule == null) {
            return null;
        }
        return this.parentModule.getSource();
    }

    public IQueryItem getOrCreateQueryItem(String aggregate, String theUsage, String expression, Object binaryExpression, String suggestedName) {
        List<IMetadata> qItems = this.getQueryItemsAndMeasures();
        for (IMetadata q : qItems) {
            MoserQueryItem currQI = (MoserQueryItem)q;
            if (!aggregate.equals(currQI.getRegularAggregate()) || !theUsage.equals(currQI.getUsage()) || !expression.equals(currQI.getExpression())) continue;
            return currQI;
        }
        MoserQueryItem qi = null;
        String name = MetadataUtil.generateUniqueName(suggestedName, qItems);
        qi = new MoserQueryItem(this.parentModule.getMetadataConnection().getNextId(), name, -1);
        qi.setUniqueID(this.getUniqueID() + "." + qi.getName());
        qi.setV5UniqueName(UniqueNameGenerator.appendUniqueName(this.getV5UniqueName(), qi.getName()));
        qi.setQuerySubject(this);
        qi.setRegularAggregate(aggregate);
        qi.setUsage(theUsage);
        qi.setExpression(expression);
        qi.setUniqueID(this.getUniqueID() + "." + qi.getName());
        qi.setBinaryExpression(binaryExpression);
        this.addQueryItem(qi);
        MoserModule module = this.getParentModule();
        module.registerExpressionObject(qi.getUniqueID(), qi);
        return qi;
    }

    @Override
    public void release() {
        MoserModule module = this.getParentModule();
        module.removeQuerySubject(this);
    }

    @Override
    public boolean isSessionScope() {
        return false;
    }

    public List<IQuerySubject> getSourceQuerySubject() {
        ArrayList<IQuerySubject> rt = new ArrayList<IQuerySubject>(this.sourceQuerySubjects);
        return rt;
    }

    protected void addSourceQuerySubject(IMetadata srcObj) {
        this.sourceQuerySubjects.add((IQuerySubject)srcObj);
    }

    protected void addPreferredJoin(IMetadata srcObj) {
        this.preferredJoins.add((IRelationship)srcObj);
    }

    public List<IRelationship> getPreferredJoins() {
        ArrayList<IRelationship> rt = new ArrayList<IRelationship>(this.preferredJoins);
        return rt;
    }

    public IMetadata getReferencedMetadata(String ref, IMetadata context, SearchScope[] scope) {
        String[] parts = UniqueNameParser.parseNoThrow(ref);
        IMetadata mdObj = null;
        if (parts == null) {
            mdObj = MoserModuleUtil.getReferencedMetadataInQuerySubject(this, ref, context, scope, new MoserEnv());
        }
        if (mdObj == null) {
            mdObj = this.getReferencedMetadataInModule(ref);
        }
        return mdObj;
    }

    protected IMetadata getReferencedMetadataInModule(String ref) {
        try {
            return this.parentModule.getMetadataConnection().bindMetadataReference(ref);
        }
        catch (MetadataBindingException e) {
            return null;
        }
    }

    public List<MoserQueryItem> getHierarchyQueryItems(String hierName, int length) {
        return MoserModuleUtil.getHierarchyQueryItems(this, hierName, length);
    }

    public MoserItemNormalization getItemNormalization() {
        return this.itemNormalization;
    }

    public void setProperty(String propertyName, Object value) {
        this.properties.put(propertyName, value);
    }

    public QsClassifierType getClassifier() {
        return this.type;
    }

    public void setClassifier(QsClassifierType classifier) {
        this.type = classifier;
    }

    public Pair getDummyJoinForItemNormalization(IRelationship jn, PlanningEnvironment environment) {
        if (this.itemNormalization == null) {
            return null;
        }
        return this.itemNormalization.getDummyJoinForItemNormalization(this, jn, environment);
    }

    public List<IMetadata> getRelationshipsParentModule() {
        ArrayList<IMetadata> rt = new ArrayList<IMetadata>();
        if (this.parentModule != null) {
            rt.addAll(this.parentModule.getRelationships());
        }
        return rt;
    }

    protected void addSourceQuerySubjectsForBinding(MoserQuerySubject src) {
        if (this.sourceQSforBinding == null) {
            this.sourceQSforBinding = new ArrayList<MoserQuerySubject>();
        }
        this.sourceQSforBinding.add(src);
    }

    protected void bindCMDataSourceNativeSQL(PlanningEnvironment environment, IXQEQueryNode sqlNode) {
        if (this.cmDataSourceName == null) {
            return;
        }
        IXQEQueryNode[] natives = sqlNode.getDescendantsOfType(301012, true);
        if (natives.length == 0) {
            return;
        }
        IDataSource dataSource = SQLBinderUtil.findOrCreateDataSource(environment, null, this.cmDataSourceName, null, null);
        if (dataSource == null) {
            throw new XQERuntimeException(XQEMessageKeys.PLN_DataSourceNotFound, this.cmDataSourceName);
        }
        for (IXQEQueryNode nativeSQL : natives) {
            nativeSQL.setPropertyValue("dataSource", dataSource);
        }
    }

    public Set<IRelationship> getInternalDummyJoins(Set<IMetadata> wrappers, Set<IMetadata> usedQIs) {
        if (this.itemNormalization == null) {
            return new HashSet<IRelationship>();
        }
        return this.itemNormalization.getInternalDummyJoins(this, wrappers, usedQIs);
    }

    public void addQueryItemFolder(MoserQueryItemFolder fld) {
        this.queryItemFolders.add(fld);
    }

    public List<MoserCalculation> getCalculations() {
        return new ArrayList<MoserCalculation>(this.calculations);
    }

    @Override
    public IQuerySubject.SelectListControl getSelectListControl() {
        return this.selectListControl;
    }

    public String getTypeInSQLSource() {
        if (this.sourceQSforBinding == null || this.sourceQSforBinding.size() != 1) {
            return null;
        }
        if (QsClassifierType.SQL_QUERY_SUBJECT.equals((Object)this.sourceQSforBinding.get(0).getClassifier())) {
            return this.sourceQSforBinding.get((int)0).cmDataSourceName;
        }
        return null;
    }

    public void setSelectControlList(IQuerySubject.SelectListControl scList) {
        this.selectListControl = scList;
    }

    public void setIsDynamicMini(boolean b) {
        this.isDynamicMiniQS = b;
    }

    public boolean getIsDynamicMini() {
        return this.isDynamicMiniQS;
    }

    public boolean getIsDynamicSQS() {
        return this.isDynamicSQS;
    }

    public void setDynamicSQS(boolean b) {
        this.isDynamicSQS = b;
    }

    public static enum SearchScope {
        MODULE,
        QUERYSUBJECT,
        SOURCE_QUERYSUBJECT;

    }
}

