/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqemoser;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.sql.parser.ParseException;
import com.cognos.xqe.data.types.IDataType;
import com.cognos.xqe.metadata.IColumnDependency;
import com.cognos.xqe.metadata.IDeterminant;
import com.cognos.xqe.metadata.IEmbeddedFilter;
import com.cognos.xqe.metadata.IMetadata;
import com.cognos.xqe.metadata.IModelDataSource;
import com.cognos.xqe.metadata.IMultiRequestHandle;
import com.cognos.xqe.metadata.IProcParameter;
import com.cognos.xqe.metadata.IQuerySubject;
import com.cognos.xqe.metadata.MetadataType;
import com.cognos.xqe.metadata.provider.MetadataConnection;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.util.UniqueNameGenerator;
import com.cognos.xqe.util.UniqueNameParser;
import com.cognos.xqe.util.bean.BeanPropertySupport;
import com.cognos.xqemoser.MoserBaseMetadata;
import com.cognos.xqemoser.MoserItemNormalization;
import com.cognos.xqemoser.MoserItemNormalizationGroup;
import com.cognos.xqemoser.MoserQueryItem;
import com.cognos.xqemoser.MoserQuerySubject;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

public class MoserQuerySubjectWrapper
extends MoserBaseMetadata
implements IQuerySubject {
    public static final String ITEM_NORMALIZATION = "_itemNormalGenerated";
    public static final String CLOSE_SQUARE_BRACKET = "]";
    protected final MoserQuerySubject srcQuerySubject;
    protected String v5UniqueName;
    protected String uniqueId;
    protected Set<IMetadata> wrappedQueryItems = new HashSet<IMetadata>();
    protected Set<MoserItemNormalizationGroup> uniqueGroups = new HashSet<MoserItemNormalizationGroup>();
    protected Set<MoserItemNormalizationGroup> coveredGroups = new HashSet<MoserItemNormalizationGroup>();

    public MoserQuerySubjectWrapper(MoserQuerySubject qs, long id, String nm) {
        super(id, nm, -1);
        this.srcQuerySubject = qs;
        this.objectType = MetadataType.QUERY_SUBJECT;
        String[] parts = UniqueNameParser.parseNoThrow(qs.getV5UniqueName());
        parts[parts.length - 1] = this.name;
        this.v5UniqueName = UniqueNameGenerator.createEscapedUniqueName(parts);
        this.uniqueId = qs.getParentModule().getUniqueName() + "." + this.name;
    }

    @Override
    public String getUniqueName() {
        return this.srcQuerySubject.getUniqueName();
    }

    @Override
    public List<IMetadata> getQueryItemsAndMeasures() {
        return new ArrayList<IMetadata>(this.wrappedQueryItems);
    }

    public void setWrappedQueryItems(Set<IMetadata> lst) {
        this.wrappedQueryItems.addAll(lst);
    }

    @Override
    public String getID() {
        return this.uniqueId;
    }

    @Override
    public String getUniqueID() {
        return this.uniqueId;
    }

    @Override
    public int compareTo(Object o) {
        return this.doCompareTo(o);
    }

    @Override
    public Set<String> getAvailableProperties() {
        return this.srcQuerySubject.getAvailableProperties();
    }

    @Override
    public Object getProperty(String propertyName) {
        return this.srcQuerySubject.getProperty(propertyName);
    }

    @Override
    public IDataType getDataType() {
        return this.srcQuerySubject.getDataType();
    }

    @Override
    public MetadataConnection getConnection() {
        return this.srcQuerySubject.getConnection();
    }

    @Override
    public IMetadata getParentObject() {
        return this.srcQuerySubject.getParentObject();
    }

    @Override
    public List<IMetadata> getDescendantMetadataObjectsSkipFolders() {
        return this.srcQuerySubject.getDescendantMetadataObjectsSkipFolders();
    }

    @Override
    public List<IMetadata> getChildMetadataObjects() {
        return this.srcQuerySubject.getChildMetadataObjects();
    }

    @Override
    public String getV5UniqueName() {
        return this.v5UniqueName;
    }

    @Override
    public boolean hasChildMetadataObjects() {
        return this.srcQuerySubject.hasChildMetadataObjects();
    }

    @Override
    public String getDescription() {
        return this.srcQuerySubject.getDescription();
    }

    @Override
    public BeanPropertySupport getBeanPropertySupport() {
        return this.srcQuerySubject.getBeanPropertySupport();
    }

    @Override
    public boolean isDMR() {
        return this.srcQuerySubject.isDMR();
    }

    @Override
    public boolean isMFW() {
        return this.srcQuerySubject.isMFW();
    }

    @Override
    public IMetadata getParentObjectSkipFolders() {
        return this.srcQuerySubject.getParentObjectSkipFolders();
    }

    @Override
    public boolean isAccessible() {
        return this.srcQuerySubject.isAccessible();
    }

    @Override
    public void setParentMetadataObject(IMetadata parent) {
    }

    @Override
    public IMultiRequestHandle[] getHandles() {
        return this.srcQuerySubject.getHandles();
    }

    @Override
    public String getDefinitionType() {
        return this.srcQuerySubject.getDefinitionType();
    }

    @Override
    public String getGeneratedSQLOption() {
        return this.srcQuerySubject.getGeneratedSQLOption();
    }

    @Override
    public List<IModelDataSource> getDataSources() {
        return this.srcQuerySubject.getDataSources();
    }

    @Override
    public List<IEmbeddedFilter> getFilters() {
        return this.srcQuerySubject.getFilters();
    }

    @Override
    public List<IEmbeddedFilter> getPreviewFilters() {
        return this.srcQuerySubject.getPreviewFilters();
    }

    @Override
    public List<IEmbeddedFilter> getSecurityFilters() {
        return this.srcQuerySubject.getSecurityFilters();
    }

    @Override
    public List<IDeterminant> getDeterminants() {
        return this.srcQuerySubject.getDeterminants();
    }

    @Override
    public List<IColumnDependency> getColumnDependencies() {
        return this.srcQuerySubject.getColumnDependencies();
    }

    @Override
    public boolean hasUniqueIndex() {
        return this.srcQuerySubject.hasUniqueIndex();
    }

    @Override
    public String getSql() {
        return this.srcQuerySubject.getSql();
    }

    @Override
    public IQuerySubject[] getQuerySubjectRefs() {
        return this.srcQuerySubject.getQuerySubjectRefs();
    }

    @Override
    public IXQEQueryNode generateSQLAST(PlanningEnvironment environment, IXQEQueryNode ownerNode, IQuerySubject querySubject) throws ParseException {
        return this.srcQuerySubject.generateSQLAST(environment, ownerNode, querySubject);
    }

    @Override
    public IQuerySubject.QuerySubjectTypeEnum getQuerySubjectType() {
        return this.srcQuerySubject.getQuerySubjectType();
    }

    @Override
    public IQuerySubject.QuerySubjectUsageEnum getQuerySubjectUsage() {
        return this.srcQuerySubject.getQuerySubjectUsage();
    }

    @Override
    public IQuerySubject.QuerySubjectUseLocalCacheEnum getQuerySubjectUseLocalCache() {
        return this.srcQuerySubject.getQuerySubjectUseLocalCache();
    }

    @Override
    public String getQuerySubjectDataCacheExpiry() {
        return this.srcQuerySubject.getQuerySubjectDataCacheExpiry();
    }

    @Override
    public Boolean getInvolvedInJoins() {
        return this.srcQuerySubject.getInvolvedInJoins();
    }

    @Override
    public void setInvolvedInJoins(boolean b) {
    }

    @Override
    public List<IProcParameter> getStoredProcArgs() {
        return this.srcQuerySubject.getStoredProcArgs();
    }

    @Override
    public boolean getUseInJoinPath() {
        return this.srcQuerySubject.getUseInJoinPath();
    }

    @Override
    public double getOrderOfMagnitude() {
        return this.srcQuerySubject.getOrderOfMagnitude();
    }

    public IQuerySubject getSourceQS() {
        return this.srcQuerySubject;
    }

    public boolean isGroupKey(IMetadata queryItem) {
        if (queryItem == null) {
            return false;
        }
        for (MoserItemNormalizationGroup g : this.uniqueGroups) {
            if (!queryItem.equals(g.getKeyItem())) continue;
            return true;
        }
        return false;
    }

    public boolean isWrappedQueryItem(IMetadata queryItem) {
        if (queryItem == null) {
            return false;
        }
        return this.wrappedQueryItems.contains(queryItem);
    }

    public String getSQLOperator(IMetadata qi) {
        MoserItemNormalizationGroup g = null;
        for (MoserItemNormalizationGroup grp : this.coveredGroups) {
            if (!grp.containsQueryItem((MoserQueryItem)qi)) continue;
            g = grp;
            break;
        }
        if (g == null) {
            return null;
        }
        return g.sqlOperator.get(qi);
    }

    public boolean getSQLOperatorScope(IMetadata queryItem, Set<IMetadata> scope) {
        MoserItemNormalizationGroup grp = null;
        for (MoserItemNormalizationGroup g : this.uniqueGroups) {
            if (!g.containsQueryItem((MoserQueryItem)queryItem)) continue;
            grp = g;
            break;
        }
        if (grp == null) {
            return false;
        }
        HashSet<MoserItemNormalizationGroup> groups = new HashSet<MoserItemNormalizationGroup>();
        ArrayList<List<MoserItemNormalizationGroup>> allPaths = new ArrayList<List<MoserItemNormalizationGroup>>();
        LinkedList<MoserItemNormalizationGroup> stack = new LinkedList<MoserItemNormalizationGroup>();
        MoserItemNormalization.generatePaths(grp, stack, allPaths, true);
        for (List<MoserItemNormalizationGroup> path : allPaths) {
            groups.addAll(path);
        }
        groups.retainAll(this.uniqueGroups);
        if (groups.size() == this.uniqueGroups.size()) {
            return false;
        }
        for (MoserItemNormalizationGroup g : groups) {
            scope.add(g.getKeyItem());
        }
        return true;
    }

    @Override
    public IQuerySubject.SelectListControl getSelectListControl() {
        return this.srcQuerySubject.getSelectListControl();
    }

    public MoserQuerySubject getWrapped() {
        return this.srcQuerySubject;
    }
}

