/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqemoser;

import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.metadata.provider.MetadataService;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.trace.OperationEnum;
import com.cognos.xqemoser.BaseHTTPClient;
import com.cognos.xqemoser.HTTPClientResponse;
import java.util.Map;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpMethodBase;
import org.apache.commons.httpclient.methods.PostMethod;

public class MoserServiceClient
extends BaseHTTPClient {
    private static final String DATASETS_VERSIONS = "datasets/versions/";
    private static final String STATUS = " status: ";
    private final String moserBaseModulesPath = MetadataService.getInstance().getMoserBaseModulesPath();

    public MoserServiceClient(String passp, Map<String, String> c) {
        super(passp, c);
    }

    public HTTPClientResponse postBaseModule(String reportVersionStoreId) {
        StringBuilder url = new StringBuilder(this.moserBaseModulesPath);
        url.append(DATASETS_VERSIONS);
        url.append(MoserServiceClient.encodeURIComponent(reportVersionStoreId));
        PostMethod httpPost = null;
        try {
            if (MoserServiceClient.loggingEnabled()) {
                MoserServiceClient.log(LogLevel.INFO, OperationEnum.START, "start dataset's base_module creation: " + url);
            }
            httpPost = new PostMethod();
            httpPost.setPath(url.toString());
            httpPost.setRequestHeader("Accept", "application/json");
            MoserServiceClient.setAcceptEncoding((HttpMethodBase)httpPost, this.useHttpCompression);
            MoserServiceClient.setCookies((HttpMethodBase)httpPost, this.camPassport, this.cookies);
            this.makeTrusted((HttpMethodBase)httpPost);
            int code = this.client.executeMethod((HttpMethod)httpPost);
            HTTPClientResponse resp = new HTTPClientResponse(code, (HttpMethodBase)httpPost);
            if (MoserServiceClient.loggingEnabled()) {
                MoserServiceClient.log(LogLevel.INFO, OperationEnum.END, "end dataset's base_module creation: " + url + STATUS + code);
            }
            HTTPClientResponse hTTPClientResponse = resp;
            return hTTPClientResponse;
        }
        catch (Exception e) {
            throw new XQERuntimeException(XQEMessageKeys.CM_FailContentService, (Throwable)e, (Object)url);
        }
        finally {
            if (httpPost != null) {
                httpPost.releaseConnection();
            }
        }
    }
}

