/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqemoser;

import com.cognos.xqe.config.ServiceEnumeration;
import com.cognos.xqe.config.XQEConfiguration;
import com.cognos.xqe.config.XQEConfigurationManager;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.trace.OperationEnum;
import com.cognos.xqe.trace.XQELog;
import com.cognos.xqe.trace.XQELogger;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HostConfiguration;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.commons.httpclient.HttpMethodBase;
import org.apache.commons.httpclient.MultiThreadedHttpConnectionManager;
import org.apache.commons.httpclient.params.HttpConnectionManagerParams;

public abstract class WABaseHTTPClient {
    protected static final String ACCEPT = "Accept";
    protected static final String ACCEPT_ENCODING = "Accept-Encoding";
    protected static final String APPLICATION_JSON = "application/json";
    protected static final String APPLICATION_OCTET_STREAM = "application/octet-stream";
    protected static final String APPLICATION_PARQUET = "application/vnd.ibm.bi.pq";
    protected static final String CONTENT_ENCODING = "Content-Encoding";
    protected static final String GZIP = "gzip";
    private static final String MOSER_COOKIE = "Cookie";
    private static final XQELogger TRACE_LOGGER = XQELog.getLogger(ServiceEnumeration.XQE, "XQE", "HTTPClient", LogLevel.INFO);
    protected Map<String, String> cookies;
    protected HttpClient client;
    protected boolean useHttpCompression;

    public WABaseHTTPClient(Map<String, String> c) {
        this.cookies = c;
        MultiThreadedHttpConnectionManager conMgr = new MultiThreadedHttpConnectionManager();
        HttpConnectionManagerParams params = conMgr.getParams();
        params.setDefaultMaxConnectionsPerHost(Integer.MAX_VALUE);
        params.setMaxTotalConnections(Integer.MAX_VALUE);
        conMgr.setParams(params);
        this.client = new HttpClient((HttpConnectionManager)conMgr);
        HostConfiguration hc = new HostConfiguration();
        this.client.setHostConfiguration(hc);
        XQEConfiguration configuration = XQEConfigurationManager.getInstance().getConfiguration(ServiceEnumeration.XQE);
        this.useHttpCompression = configuration.getBooleanProperty("general.useRestHttpCompression[@enabled]", true);
    }

    protected void setAcceptEncoding(HttpMethodBase method) {
        if (this.useHttpCompression) {
            method.setRequestHeader(ACCEPT_ENCODING, GZIP);
        }
    }

    protected static void log(LogLevel aLogLevel, String text) {
        TRACE_LOGGER.log(aLogLevel, text);
    }

    protected static void log(LogLevel aLogLevel, OperationEnum anOp, String text) {
        TRACE_LOGGER.log(aLogLevel, anOp, text);
    }

    protected static boolean loggingEnabled() {
        return TRACE_LOGGER.isOn();
    }

    protected static String encodeURIComponent(String input) {
        String result;
        try {
            result = URLEncoder.encode(input, "UTF-8").replaceAll("\\+", "%20").replaceAll("\\%21", "!").replaceAll("\\%27", "'").replaceAll("\\%28", "(").replaceAll("\\%29", ")").replaceAll("\\%7E", "~");
        }
        catch (UnsupportedEncodingException e) {
            result = input;
        }
        return result;
    }

    protected static InputStream getResponseBodyAsStream(HttpMethodBase method) throws IOException {
        Header h = method.getResponseHeader(CONTENT_ENCODING);
        if (h != null && GZIP.equals(h.getValue())) {
            return new GZIPInputStream(method.getResponseBodyAsStream());
        }
        return method.getResponseBodyAsStream();
    }
}

