/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqemoser;

import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.metadata.provider.MetadataService;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.trace.OperationEnum;
import com.cognos.xqemoser.BaseHTTPClient;
import com.cognos.xqemoser.HTTPClientResponse;
import com.cognos.xqemoser.IMoserModuleReader;
import com.cognos.xqemoser.MoserModuleManager;
import com.cognos.xqemoser.MoserModuleUtil;
import com.cognos.xqemoser.WABaseHTTPClient;
import com.ibm.bi.rest.RESTClient;
import com.ibm.bi.rest.RESTClientFactory;
import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import com.ibm.json.java.OrderedJSONObject;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpMethodBase;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.io.IOUtils;

public class WAMoserModuleReader
extends WABaseHTTPClient
implements IMoserModuleReader {
    private static final String STR_SPACES = "   ";
    protected static final String STR_STATUS = " status=";
    protected static final String STR_UTF8 = "UTF8";
    private static final String XQEMOSER_WHOLE = "xqemoser=whole";
    private static final String XQEMOSER_TRUE = "xqemoser=true";
    protected static final String QUESTIONMARK_STR = "?";
    protected String moserBasePath = MetadataService.getInstance().getMoserBasePath();
    private String neoDsDriverBasePath = MetadataService.getInstance().getDsDriverBasePath();

    public WAMoserModuleReader() {
        super(null);
    }

    public String getURL(String modulePath, String xqeMoser) {
        return this.moserBasePath + WAMoserModuleReader.encodeURIComponent(modulePath) + QUESTIONMARK_STR + xqeMoser;
    }

    public String getDecodedURL(String modulePath, String xqeMoser) {
        return this.moserBasePath + modulePath + QUESTIONMARK_STR + xqeMoser;
    }

    public void setRequestHeader(RESTClient client) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public JSONObject read(String modulePath, String camPassport, Map<String, String> cookiesToMoser, String queryParam, String cacheKey, HttpServletRequest httpServletRequest) {
        this.cookies = cookiesToMoser;
        JSONObject response = new JSONObject();
        boolean bGetAllModules = MetadataService.getInstance().getMoserAllModules();
        String xqeMoser = XQEMOSER_WHOLE;
        if (!bGetAllModules) {
            xqeMoser = XQEMOSER_TRUE;
        }
        String decodedUrl = null;
        RESTClient client = null;
        try {
            client = RESTClientFactory.getInstance().getClient(httpServletRequest);
            this.setRequestHeader(client);
            decodedUrl = this.getDecodedURL(modulePath, xqeMoser);
            String urlStr = this.getURL(modulePath, xqeMoser);
            if (WAMoserModuleReader.loggingEnabled()) {
                WAMoserModuleReader.log(LogLevel.INFO, OperationEnum.START, "start reading module " + urlStr);
            }
            int statusCode = client.getResource(urlStr);
            response.put((Object)"responseStatus", (Object)Integer.toString(statusCode));
            if (statusCode == 200) {
                String lastModified;
                response.put((Object)"moduleDef", (Object)new String(IOUtils.toByteArray((InputStream)client.getResponseStream()), STR_UTF8));
                String etag = client.getResponseHeader("ETag");
                if (etag != null) {
                    response.put((Object)"cacheKey", (Object)etag);
                }
                if ((lastModified = client.getResponseHeader("Last-Modified")) != null) {
                    response.put((Object)"lastModified", (Object)lastModified);
                }
            }
            if (WAMoserModuleReader.loggingEnabled()) {
                WAMoserModuleReader.log(LogLevel.INFO, OperationEnum.END, "end reading module " + urlStr + STR_STATUS + statusCode);
            }
            if (statusCode == 200 || statusCode == 304) {
                JSONObject jSONObject = response;
                return jSONObject;
            }
        }
        catch (IOException e) {
            throw new XQERuntimeException(XQEMessageKeys.MD_MetadataConnectionFailed, (Throwable)e, decodedUrl);
        }
        finally {
            if (client != null) {
                try {
                    client.close();
                }
                catch (IOException iOException) {
                }
                finally {
                    client = null;
                }
            }
        }
        throw new XQERuntimeException(XQEMessageKeys.MD_MetadataConnectionFailed, decodedUrl);
    }

    @Override
    public String getModificationTime(String modulePath, String pass, Map<String, String> cookiesToMoser) {
        GetMethod httpGet;
        block13: {
            this.cookies = cookiesToMoser;
            httpGet = null;
            try {
                JSONObject jObj;
                String urlStr = this.moserBasePath + WAMoserModuleReader.encodeURIComponent(modulePath);
                urlStr = urlStr + "/info?attributes=lastModified&attributes=xqemoser";
                if (WAMoserModuleReader.loggingEnabled()) {
                    WAMoserModuleReader.log(LogLevel.INFO, OperationEnum.START, "start modification time " + urlStr);
                }
                httpGet = new GetMethod();
                httpGet.setPath(urlStr);
                httpGet.setRequestHeader("Accept", "application/json");
                this.setAcceptEncoding((HttpMethodBase)httpGet);
                int code = this.client.executeMethod((HttpMethod)httpGet);
                if (code != 200) break block13;
                HTTPClientResponse response = new HTTPClientResponse(code, (HttpMethodBase)httpGet);
                if (WAMoserModuleReader.loggingEnabled()) {
                    WAMoserModuleReader.log(LogLevel.INFO, OperationEnum.END, "end modification time " + urlStr + STR_STATUS + code);
                }
                if ((jObj = response.getJSONObjectResponse()).isEmpty()) break block13;
                for (Object k : jObj.keySet()) {
                    String kName = (String)k;
                    Object v = jObj.get(k);
                    if (!"lastModified".equals(kName)) continue;
                    if (v != null) {
                        if (v instanceof String) {
                            String string = (String)v;
                            return string;
                        }
                        String string = v.toString();
                        return string;
                    }
                    break;
                }
            }
            catch (Exception e) {
                throw new XQERuntimeException(XQEMessageKeys.MD_MetadataConnectionFailed, (Throwable)e, modulePath);
            }
            finally {
                if (httpGet != null) {
                    httpGet.releaseConnection();
                }
            }
        }
        throw new XQERuntimeException(XQEMessageKeys.MD_MetadataConnectionFailed, modulePath + STR_SPACES + httpGet.getStatusLine().toString());
    }

    protected static void log(LogLevel aLogLevel, String text) {
        if (BaseHTTPClient.loggingEnabled()) {
            BaseHTTPClient.log(aLogLevel, text);
        } else {
            MoserModuleManager.log(aLogLevel, text);
        }
    }

    protected static void log(LogLevel aLogLevel, OperationEnum anOp, String text) {
        if (BaseHTTPClient.loggingEnabled()) {
            BaseHTTPClient.log(aLogLevel, anOp, text);
        } else {
            MoserModuleManager.log(aLogLevel, anOp, text);
        }
    }

    protected static boolean loggingEnabled() {
        return BaseHTTPClient.loggingEnabled() || MoserModuleManager.loggingEnabled();
    }

    @Override
    public boolean isXQEMoserWhole() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public JSONObject getDataSourceConnectionInfo(String assetId, Map<String, String> cookiesToMoser, HttpServletRequest httpServletRequest) {
        JSONObject rtDBConn = null;
        this.cookies = cookiesToMoser;
        RESTClient client = null;
        try {
            int statusCode;
            client = RESTClientFactory.getInstance().getClient(httpServletRequest);
            String urlStr = this.neoDsDriverBasePath + WAMoserModuleReader.encodeURIComponent(assetId);
            if (WAMoserModuleReader.loggingEnabled()) {
                WAMoserModuleReader.log(LogLevel.INFO, OperationEnum.START, "start reading DB connection " + urlStr);
            }
            if ((statusCode = client.getResource(urlStr)) == 200) {
                String rt = new String(IOUtils.toByteArray((InputStream)client.getResponseStream()), STR_UTF8);
                JSONObject jObj = OrderedJSONObject.parse((String)rt);
                JSONArray conn = (JSONArray)jObj.get((Object)"connectionInfo");
                if (WAMoserModuleReader.loggingEnabled()) {
                    WAMoserModuleReader.log(LogLevel.INFO, OperationEnum.END, "OK. end reading DB connection " + urlStr + STR_STATUS + statusCode);
                }
                rtDBConn = MoserModuleUtil.processConnectionInfo(conn);
            } else if (WAMoserModuleReader.loggingEnabled()) {
                WAMoserModuleReader.log(LogLevel.INFO, OperationEnum.END, "failed. end reading module " + urlStr + STR_STATUS + statusCode);
            }
        }
        catch (Exception e) {
            JSONObject jSONObject = null;
            return jSONObject;
        }
        finally {
            if (client != null) {
                try {
                    client.close();
                }
                catch (IOException iOException) {
                }
                finally {
                    client = null;
                }
            }
        }
        return rtDBConn;
    }

    @Override
    public String getCSVToParquet(String moduleName, String module, Map<String, String> cookiesToMoser, HttpServletRequest httpServletRequest) {
        return null;
    }

    @Override
    public boolean is304Capable() {
        return false;
    }
}

