/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqeqte;

import com.cognos.xqeqte.QTEAbstractTransformation;
import com.cognos.xqeqte.QTENodeIndex;
import com.cognos.xqeqte.QTEPlanningEnvironment;
import com.cognos.xqeqte.QTEQueryNode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class QTEPassTransformations<N extends QTEQueryNode, P extends QTEPlanningEnvironment<N>> {
    private boolean mContainsTopDownTransformations = false;
    private boolean mContainsTopDownFastTransformations = false;
    private boolean mContainsBottomUpTransformations = false;
    private boolean mContainsIndexedTransformations = false;
    private Map<Integer, List<QTEAbstractTransformation<N, P>>> mTransformationMap = new HashMap<Integer, List<QTEAbstractTransformation<N, P>>>();
    private Map<Integer, List<QTEAbstractTransformation<N, P>>> mTransformationsForNodeType = new HashMap<Integer, List<QTEAbstractTransformation<N, P>>>();
    private boolean mContainsUnlimitedTopDownTransformations = false;
    private boolean mContainsUnlimitedTopDownFastTransformations = false;
    private boolean mContainsUnlimitedBottomUpTransformations = false;
    private boolean mContainsUnlimitedIndexedTransformations = false;
    private int[] nodeTypesArray;

    QTEPassTransformations() {
    }

    void setContainsTopDownTransformations(boolean value) {
        this.mContainsTopDownTransformations = value;
    }

    void setContainsTopDownFastTransformations(boolean value) {
        this.mContainsTopDownFastTransformations = value;
    }

    void setContainsBottomUpTransformations(boolean value) {
        this.mContainsBottomUpTransformations = value;
    }

    void setContainsIndexedTransformations(boolean value) {
        this.mContainsIndexedTransformations = value;
    }

    boolean getContainsTopDownTransformations() {
        return this.mContainsTopDownTransformations;
    }

    boolean getContainsTopDownFastTransformations() {
        return this.mContainsTopDownFastTransformations;
    }

    boolean getContainsBottomUpTransformations() {
        return this.mContainsBottomUpTransformations;
    }

    boolean getContainsIndexedTransformations() {
        return this.mContainsIndexedTransformations;
    }

    public Map<Integer, List<QTEAbstractTransformation<N, P>>> getTransformationMap() {
        return this.mTransformationMap;
    }

    protected List<QTEAbstractTransformation<N, P>> getTransformationsForNodeType(int nodeType) {
        Integer nodeTypeInteger = nodeType;
        List<QTEAbstractTransformation<N, P>> transformsStoredInMap = this.mTransformationsForNodeType.get(nodeTypeInteger);
        if (transformsStoredInMap == null) {
            return Collections.emptyList();
        }
        return transformsStoredInMap;
    }

    protected void createTransformationListForNodeType(Integer nodeTypeInteger) {
        List<QTEAbstractTransformation<N, P>> transformsForNode = this.mTransformationMap.get(nodeTypeInteger);
        if (transformsForNode == null) {
            return;
        }
        int listSize = 0;
        listSize = transformsForNode.size();
        if (listSize == 0) {
            return;
        }
        ArrayList<QTEAbstractTransformation<N, P>> transformsStoredInMap = new ArrayList<QTEAbstractTransformation<N, P>>(listSize);
        transformsStoredInMap.addAll(transformsForNode);
        this.mTransformationsForNodeType.put(nodeTypeInteger, transformsStoredInMap);
    }

    public boolean targetNodeExists(QTENodeIndex<N> nodeIndex) {
        for (Integer aType : this.getTransformationMap().keySet()) {
            if (!nodeIndex.hasNodeOfType(aType)) continue;
            return true;
        }
        return false;
    }

    public Set<Integer> getNodeTypes() {
        return this.getTransformationMap().keySet();
    }

    public boolean getContainsUnlimitedTransformations() {
        return this.mContainsUnlimitedIndexedTransformations || this.mContainsUnlimitedTopDownTransformations || this.mContainsUnlimitedTopDownFastTransformations || this.mContainsUnlimitedBottomUpTransformations;
    }

    public boolean getContainsUnlimitedIndexedTransformations() {
        return this.mContainsUnlimitedIndexedTransformations;
    }

    public void setContainsUnlimitedIndexedTransformations(boolean b) {
        this.mContainsUnlimitedIndexedTransformations = b;
    }

    public boolean getContainsUnlimitedTopDownTransformations() {
        return this.mContainsUnlimitedTopDownTransformations;
    }

    public void setContainsUnlimitedTopDownTransformations(boolean b) {
        this.mContainsUnlimitedTopDownTransformations = b;
    }

    public boolean getContainsUnlimitedTopDownFastTransformations() {
        return this.mContainsUnlimitedTopDownFastTransformations;
    }

    public void setContainsUnlimitedTopDownFastTransformations(boolean b) {
        this.mContainsUnlimitedTopDownFastTransformations = b;
    }

    public boolean getContainsUnlimitedBottomUpTransformations() {
        return this.mContainsUnlimitedBottomUpTransformations;
    }

    public void setContainsUnlimitedBottomUpTransformations(boolean b) {
        this.mContainsUnlimitedBottomUpTransformations = b;
    }

    public void setNodeTypes() {
        Set<Integer> nodeTypes = this.getNodeTypes();
        this.nodeTypesArray = new int[nodeTypes.size()];
        int i = 0;
        for (Integer v : nodeTypes) {
            this.nodeTypesArray[i++] = v;
        }
    }

    public int[] getNodeTypesArray() {
        return this.nodeTypesArray;
    }
}

