/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqeqte;

import com.cognos.xqeqte.QTEAbstractTransformation;
import com.cognos.xqeqte.QTEEventListener;
import com.cognos.xqeqte.QTENodeIndex;
import com.cognos.xqeqte.QTEPassTransformations;
import com.cognos.xqeqte.QTEPlanningEnvironment;
import com.cognos.xqeqte.QTEQueryNode;
import com.cognos.xqeqte.QTETransformationLibrary;
import com.cognos.xqeqte.QTETransformationLibraryManager;
import com.cognos.xqeqte.exceptions.QTEEmptyQueryTreeException;
import com.cognos.xqeqte.exceptions.QTEMaximumNodesExceededException;
import com.cognos.xqeqte.exceptions.QTENoApplicableTransformationsForLockedNodeException;
import com.cognos.xqeqte.exceptions.QTENoPlanningEnvironmentException;
import com.cognos.xqeqte.exceptions.QTENodeNotAddedToTreeException;
import com.cognos.xqeqte.exceptions.QTEPlanningTimeoutException;
import com.cognos.xqeqte.exceptions.QTERuntimeException;
import com.cognos.xqeqte.exceptions.QTETransformationAppliedTwiceToSameNodeException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public abstract class QTETransformationEngine<N extends QTEQueryNode, P extends QTEPlanningEnvironment<N>> {
    public static final Integer DUMMY_NODEID = -1;
    private Map<Integer, List<QTEAbstractTransformation<N, P>>> mNodesTransformedInCurrentPass;
    protected QTETransformationLibraryManager<N, P> libraryManager;
    private QTEEventListener<N, P> eventListener;

    protected QTETransformationEngine() {
    }

    protected QTETransformationEngine(QTETransformationLibraryManager<N, P> libraryMgr) {
        this.libraryManager = libraryMgr;
    }

    protected QTETransformationEngine(QTETransformationLibraryManager<N, P> libraryMgr, QTEEventListener<N, P> listener) {
        this.libraryManager = libraryMgr;
        this.eventListener = listener;
    }

    public QTETransformationLibraryManager<N, P> getTransformationLibraryManager() {
        return this.libraryManager;
    }

    public void setTransformationLibraryManager(QTETransformationLibraryManager<N, P> theLibraryManager) {
        this.libraryManager = theLibraryManager;
    }

    public QTEEventListener<N, P> getEventListener() {
        return this.eventListener;
    }

    public void setEventListener(QTEEventListener<N, P> listener) {
        this.eventListener = listener;
    }

    protected abstract void loadConfigurationInformation(P var1);

    protected abstract void checkIfRequestCancelled(P var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean applyTransformations(N root, P environment) throws QTERuntimeException {
        this.initializeTransformationEnvironment(root, environment);
        environment.resetTreeHasBeenModified();
        boolean status = true;
        this.eventListener.beginQueryTransformations(environment, root);
        this.eventListener.beginTransformationPasses(environment, root);
        try {
            int maxPassNumber = this.libraryManager.getMaximumPassNumber();
            boolean calculatedMaximumNumberOfNodes = false;
            QTEPassTransformations passTransformations = null;
            long startTime = 0L;
            if (environment.getQueryPlanningTimeLimit() > 0L) {
                startTime = System.currentTimeMillis();
            }
            for (int passNumber = 0; passNumber <= maxPassNumber; ++passNumber) {
                int numTransformsAppliedPerPass = 0;
                this.eventListener.beginPassNumber(environment, root, passNumber);
                try {
                    passTransformations = this.libraryManager.getTransformations(passNumber);
                    if (environment.getNodeIndex().getNumberOfNodesInIndex() == 0) {
                        throw new IllegalStateException("environment.getNodeIndex().getNumberOfNodesInIndex() == 0");
                    }
                    if (passTransformations == null || !passTransformations.targetNodeExists(environment.getNodeIndex())) continue;
                    this.initializeListOfTransformedNodesInCurrentPass(environment);
                    int numTransformsAppliedPerIteration = -1;
                    boolean done = false;
                    int iteration = 0;
                    while (!done) {
                        if (calculatedMaximumNumberOfNodes) {
                            this.checkThatMaximumNumberOfNodesNotExceeded(environment);
                        } else if (this.treeActuallyContainsNodes(environment)) {
                            calculatedMaximumNumberOfNodes = true;
                            environment.setMaximumNumberOfNodesInQueryTree(this.calculateMaximumNumberOfNodesInQueryTree(environment));
                        }
                        this.checkIfQueryPlanningLimitExceeded(environment, startTime);
                        this.eventListener.beginPassIteration(environment, root, passNumber, iteration);
                        try {
                            numTransformsAppliedPerIteration = this.transformationIteration(passNumber, iteration, environment);
                            numTransformsAppliedPerPass += numTransformsAppliedPerIteration;
                        }
                        finally {
                            this.eventListener.endPassIteration(environment, root, passNumber, iteration, numTransformsAppliedPerIteration);
                        }
                        if (0 == numTransformsAppliedPerIteration) {
                            done = true;
                        } else if (!passTransformations.getContainsUnlimitedTransformations()) {
                            done = true;
                        }
                        ++iteration;
                    }
                    continue;
                }
                finally {
                    this.eventListener.endPassNumber(environment, root, passNumber, numTransformsAppliedPerPass, passTransformations);
                }
            }
        }
        finally {
            this.eventListener.endTransformationPasses(environment, root);
            this.eventListener.endQueryTransformations(environment, root);
        }
        environment.releaseQueryLineage();
        return status;
    }

    private int transformationIteration(int passNumber, int iterationNumber, P environment) {
        QTEPassTransformations<N, P> passTransformations = this.libraryManager.getTransformations(passNumber);
        if (passTransformations.getTransformationMap() == null) {
            return 0;
        }
        int numTransformsApplied = 0;
        if (passTransformations.getContainsTopDownTransformations() && (iterationNumber == 0 || passTransformations.getContainsUnlimitedTopDownTransformations())) {
            numTransformsApplied += this.applyTopDownTransformations(passTransformations, environment, iterationNumber);
        }
        if (passTransformations.getContainsTopDownFastTransformations() && (iterationNumber == 0 || passTransformations.getContainsUnlimitedTopDownFastTransformations())) {
            numTransformsApplied += this.applyTopDownFastTransformations(passTransformations, environment, iterationNumber);
        }
        if (passTransformations.getContainsBottomUpTransformations() && (iterationNumber == 0 || passTransformations.getContainsUnlimitedBottomUpTransformations())) {
            numTransformsApplied += this.applyBottomUpTransformations(passTransformations, environment, iterationNumber);
        }
        if (passTransformations.getContainsIndexedTransformations() && (iterationNumber == 0 || passTransformations.getContainsUnlimitedIndexedTransformations())) {
            numTransformsApplied += this.applyIndexedTransformations(passTransformations, environment, iterationNumber);
        }
        this.checkIfRequestCancelled(environment);
        return numTransformsApplied;
    }

    private int applyIndexedTransformations(QTEPassTransformations<N, P> passTransformations, P environment, int iterationNumber) {
        int numTransformsApplied = 0;
        QTENodeIndex nodeIndex = environment.getNodeIndex();
        Iterator<Map.Entry<Integer, List<QTEAbstractTransformation<N, P>>>> transformIterator = null;
        transformIterator = environment.getRandomizeTransformations() ? this.randomizeTransformations(passTransformations.getTransformationMap(), environment) : passTransformations.getTransformationMap().entrySet().iterator();
        while (transformIterator.hasNext()) {
            Map.Entry<Integer, List<QTEAbstractTransformation<N, P>>> transformEntry = transformIterator.next();
            int key = transformEntry.getKey();
            Collection nodes = null;
            boolean keepNulls = true;
            nodes = environment.getRandomizeTransformations() ? this.randomizeNodes(nodeIndex.getNodesByType(keepNulls, key), environment) : nodeIndex.getNodesByType(keepNulls, key);
            if (nodes == null) continue;
            QTEQueryNode[] nodeArray = new QTEQueryNode[nodes.size()];
            for (QTEQueryNode node : nodeArray = nodes.toArray(nodeArray)) {
                if (node == null || nodeIndex.getNodeByID(node.getId()) == null || !this.applyApplicableTransformation(passTransformations, node, iterationNumber, QTEAbstractTransformation.Mode.INDEXED, environment)) continue;
                ++numTransformsApplied;
                numTransformsApplied += this.applyLockedNodeTransformations(passTransformations, iterationNumber, environment);
                this.checkIfRequestCancelled(environment);
            }
        }
        return numTransformsApplied;
    }

    private Iterator<Map.Entry<Integer, List<QTEAbstractTransformation<N, P>>>> randomizeTransformations(Map<Integer, List<QTEAbstractTransformation<N, P>>> map, P environment) {
        ArrayList<Map.Entry<Integer, List<QTEAbstractTransformation<N, P>>>> transformList = new ArrayList<Map.Entry<Integer, List<QTEAbstractTransformation<N, P>>>>(map.size());
        Iterator<Map.Entry<Integer, List<QTEAbstractTransformation<N, P>>>> transformIterator = map.entrySet().iterator();
        for (int i = 0; i < map.size(); ++i) {
            transformList.add(null);
        }
        while (transformIterator.hasNext()) {
            int index;
            do {
                if ((index = environment.getRandom().nextInt()) >= 0) continue;
                index = -index;
            } while (transformList.get(index %= map.size()) != null);
            transformList.set(index, transformIterator.next());
        }
        return transformList.iterator();
    }

    private Collection<N> randomizeNodes(Collection<N> nodes, P environment) {
        if (nodes == null || nodes.size() == 0) {
            return null;
        }
        ArrayList<QTEQueryNode> newNodes = new ArrayList<QTEQueryNode>(nodes.size());
        for (QTEQueryNode node : nodes) {
            int index;
            do {
                if ((index = environment.getRandom().nextInt()) >= 0) continue;
                index = -index;
            } while (newNodes.get(index %= nodes.size()) != null);
            newNodes.add(index, node);
        }
        return newNodes;
    }

    private int applyTopDownFastTransformations(QTEPassTransformations<N, P> passTransformations, P environment, int iterationNumber) {
        return this.applyTopDownFastOrBottomUpTransformations((QTEQueryNode)environment.getRoot(), passTransformations, iterationNumber, QTEAbstractTransformation.Mode.TOP_DOWN_FAST, environment);
    }

    private int applyTopDownTransformations(QTEPassTransformations<N, P> passTransformations, P environment, int iterationNumber) {
        return this.applyTopDownTransformations(environment.getRoot(), passTransformations, iterationNumber, QTEAbstractTransformation.Mode.TOP_DOWN, environment);
    }

    private int applyBottomUpTransformations(QTEPassTransformations<N, P> passTransformations, P environment, int iterationNumber) {
        return this.applyTopDownFastOrBottomUpTransformations((QTEQueryNode)environment.getRoot(), passTransformations, iterationNumber, QTEAbstractTransformation.Mode.BOTTOM_UP, environment);
    }

    private void getNodeListForTopDownFastTransformation(TreeVisitor visitor) {
        visitor.addIfApplicable();
        QTEQueryNode node = visitor.getNode();
        int numChildren = node.getNumberChildren();
        for (int i = 0; i < numChildren; ++i) {
            visitor.setNode(node.getChild(i));
            this.getNodeListForTopDownFastTransformation(visitor);
        }
    }

    private void getNodeListForBottomUpTransformation(TreeVisitor visitor) {
        QTEQueryNode node = visitor.getNode();
        int numChildren = node.getNumberChildren();
        for (int i = 0; i < numChildren; ++i) {
            visitor.setNode(node.getChild(i));
            this.getNodeListForBottomUpTransformation(visitor);
        }
        visitor.addIfApplicable(node);
    }

    private int applyTopDownFastOrBottomUpTransformations(QTEQueryNode node, QTEPassTransformations<N, P> passTransformations, int iterationNumber, QTEAbstractTransformation.Mode mode, P environment) {
        if (node == null) {
            return 0;
        }
        TreeVisitor visitor = new TreeVisitor(node, passTransformations);
        if (mode == QTEAbstractTransformation.Mode.TOP_DOWN_FAST) {
            this.getNodeListForTopDownFastTransformation(visitor);
        } else if (mode == QTEAbstractTransformation.Mode.BOTTOM_UP) {
            this.getNodeListForBottomUpTransformation(visitor);
        } else {
            return 0;
        }
        List<QTEQueryNode> listOfNodes = visitor.getList();
        int numTransformsApplied = 0;
        QTENodeIndex nodeIndex = environment.getNodeIndex();
        for (QTEQueryNode nodeToApply : listOfNodes) {
            if (nodeIndex.getNodeByID(nodeToApply.getId()) == null || !this.applyApplicableTransformation(passTransformations, nodeToApply, iterationNumber, mode, environment)) continue;
            ++numTransformsApplied;
            numTransformsApplied += this.applyLockedNodeTransformations(passTransformations, iterationNumber, environment);
            this.checkIfRequestCancelled(environment);
        }
        return numTransformsApplied;
    }

    private int applyTopDownTransformations(N node, QTEPassTransformations<N, P> passTransformations, int iterationNumber, QTEAbstractTransformation.Mode mode, P environment) {
        ArrayStack plannedAscendants = new ArrayStack();
        QTEQueryNode currentAscendant = null;
        QTEQueryNode currentParent = null;
        QTEQueryNode nextSibling = null;
        Object nodeToPlan = node;
        QTEQueryNode plannedNode = null;
        QTENodeIndex nodeIndex = environment.getNodeIndex();
        int rootType = environment.getRoot().getType();
        int numTransformsApplied = 0;
        do {
            if ((currentAscendant = plannedAscendants.peekFirst()) != null) {
                if (nodeIndex.getNodeByID(currentAscendant.getId()) == null && currentAscendant.getType() != rootType) {
                    plannedAscendants.pop();
                    continue;
                }
                int pendingChildIndex = plannedAscendants.peekSecond();
                if (pendingChildIndex < currentAscendant.getNumberChildren()) {
                    nodeToPlan = currentAscendant.getChild(pendingChildIndex);
                }
                if (nodeToPlan == null) {
                    plannedAscendants.pop();
                    continue;
                }
                plannedAscendants.setSecond(++pendingChildIndex);
            }
            while (nodeToPlan != null) {
                block14: {
                    int nodeToPlanPosition = 0;
                    int numChildren = 0;
                    currentParent = nodeToPlan.getParent();
                    if (currentParent != null && (numChildren = currentParent.getNumberChildren()) > 1) {
                        nodeToPlanPosition = currentParent.getPositionOfChild((QTEQueryNode)nodeToPlan);
                    }
                    while (true) {
                        nextSibling = null;
                        int nextChildPosition = nodeToPlanPosition + 1;
                        if (currentParent != null && nextChildPosition < currentParent.getNumberChildren()) {
                            nextSibling = currentParent.getChild(nextChildPosition);
                        }
                        if (!this.applyApplicableTransformation(passTransformations, nodeToPlan, iterationNumber, mode, environment)) break block14;
                        ++numTransformsApplied;
                        numTransformsApplied += this.applyLockedNodeTransformations(passTransformations, iterationNumber, environment);
                        this.checkIfRequestCancelled(environment);
                        if (nodeIndex.getNodeByID(nodeToPlan.getId()) != null && currentParent != null && currentParent.getNumberChildren() == numChildren) {
                            plannedNode = currentParent.getChild(nodeToPlanPosition);
                            if (plannedNode != nodeToPlan) {
                                nodeToPlan = plannedNode;
                                continue;
                            }
                            break block14;
                        }
                        if (nextSibling == null || currentParent == null || nodeIndex.getNodeByID(currentParent.getId()) == null || nodeToPlanPosition >= currentParent.getNumberChildren() || !nextSibling.equals(currentParent.getChild(nodeToPlanPosition))) break;
                        nodeToPlan = nextSibling;
                    }
                    if (currentParent != null) {
                        nodeToPlan = null;
                    }
                }
                if (nodeToPlan == null) continue;
                int numChild = nodeToPlan.getNumberChildren();
                if (numChild == 0) {
                    nodeToPlan = null;
                    continue;
                }
                if (numChild > 1) {
                    plannedAscendants.push((QTEQueryNode)nodeToPlan, 1);
                }
                nodeToPlan = nodeToPlan.getChild(0);
            }
        } while (!plannedAscendants.isEmpty());
        return numTransformsApplied;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int applyLockedNodeTransformations(QTEPassTransformations<N, P> passTransformations, int iterationNumber, P environment) throws QTERuntimeException {
        int numTransformsApplied = 0;
        if (!environment.getLockNodeQueryPlanningEnabled()) {
            return numTransformsApplied;
        }
        int lockNodeType = environment.getLockNodeType();
        this.eventListener.beginTransformationGroup(environment, lockNodeType);
        try {
            QTEQueryNode[] nodes = environment.getRoot().getDescendantsOfType(lockNodeType, true);
            if (nodes.length == 0) {
                int n = numTransformsApplied;
                return n;
            }
            Integer key = lockNodeType;
            List<QTEAbstractTransformation<N, P>> transformList = this.constructTransformationList(passTransformations, key);
            if (transformList.isEmpty()) {
                throw new QTENoApplicableTransformationsForLockedNodeException(environment.getNodeTypeName(lockNodeType));
            }
            while (true) {
                int numTransformsAppliedInSubIterations = 0;
                for (QTEAbstractTransformation<N, P> transformation : transformList) {
                    if (transformation.getMode() == QTEAbstractTransformation.Mode.BOTTOM_UP || transformation.getMode() == QTEAbstractTransformation.Mode.TOP_DOWN || transformation.getMode() == QTEAbstractTransformation.Mode.TOP_DOWN_FAST) continue;
                    for (int i = 0; i < nodes.length; ++i) {
                        if (!this.applyTransformation(transformation, nodes[i], environment)) continue;
                        ++numTransformsAppliedInSubIterations;
                    }
                }
                if (numTransformsAppliedInSubIterations == 0) {
                    break;
                }
                numTransformsApplied += numTransformsAppliedInSubIterations;
                nodes = environment.getRoot().getDescendantsOfType(lockNodeType, true);
            }
        }
        finally {
            environment.disableLockNodeQueryPlanning();
            this.eventListener.endTransformationGroup(environment);
        }
        return numTransformsApplied;
    }

    private boolean applyApplicableTransformation(QTEPassTransformations<N, P> passTransformations, N node, int iterationNumber, QTEAbstractTransformation.Mode mode, P environment) {
        List<QTEAbstractTransformation<N, P>> transformList = this.constructTransformationList(passTransformations, node.getType());
        for (QTEAbstractTransformation<N, P> transformation : transformList) {
            if (transformation.getMode() != mode || iterationNumber > 0 && transformation.getApplicableIterations() == QTEAbstractTransformation.ApplicableIterations.INITIAL || !this.applyTransformation(transformation, node, environment)) continue;
            return true;
        }
        return false;
    }

    private List<QTEAbstractTransformation<N, P>> constructTransformationList(QTEPassTransformations<N, P> passTransformations, int nodeType) {
        return passTransformations.getTransformationsForNodeType(nodeType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean applyTransformation(QTEAbstractTransformation<N, P> transformation, N node, P environment) {
        this.eventListener.beginApplyTransformation(environment, transformation, node);
        QTETransformationLibrary<N, P> transformationLibrary = transformation.getTransformationLibrary();
        boolean passes = false;
        try {
            transformationLibrary.beginPassesConditionUsage();
            passes = transformationLibrary.passesCondition(node, environment, transformation);
        }
        finally {
            transformationLibrary.endPassesConditionUsage(passes);
        }
        if (passes) {
            try {
                transformation.beginPassesNodeConditionUsage();
                passes = transformation.passesQueryCondition(node, environment);
            }
            finally {
                transformation.endPassesNodeConditionUsage(passes);
            }
            if (passes) {
                try {
                    transformation.beginPassesNodeConditionUsage();
                    passes = transformation.passesNodeCondition(node, environment);
                }
                finally {
                    transformation.endPassesNodeConditionUsage(passes);
                }
                if (passes) {
                    this.eventListener.beginTreeOperations(environment, transformation, node);
                    try {
                        transformation.beginApplyUsage();
                        transformation.apply(node, environment);
                    }
                    finally {
                        transformation.endApplyUsage();
                        transformation.incrementUsage();
                    }
                    this.eventListener.endTreeOperations(environment, transformation, node);
                    if (!environment.getTreeHasBeenModified()) {
                        transformation.handleNoOpTransformation();
                    }
                    environment.resetTreeHasBeenModified();
                    this.addNodeToListOfTransformedNodesInCurrentPass(environment, (QTEQueryNode)node, transformation);
                }
            }
        }
        this.eventListener.endApplyTransformation(environment, node, passes);
        return passes;
    }

    public void validateTreeAfterTransformationApplied(P environment, QTEAbstractTransformation<N, P> transformation) throws QTERuntimeException {
        environment.getNodeIndex();
        Object node = environment.getRoot();
        int nbrNodes = this.validateChildrenNodes((QTEQueryNode)node, transformation);
        QTENodeIndex nodeIndex = environment.getNodeIndex();
        if (nbrNodes - 1 != nodeIndex.getNumberOfNodesInIndex()) {
            throw new QTENodeNotAddedToTreeException(transformation.getClass().toString());
        }
    }

    private int validateChildrenNodes(QTEQueryNode node, QTEAbstractTransformation<N, P> transformation) throws QTERuntimeException {
        int nbrNodes = 1;
        for (QTEQueryNode childNode : node.getChildren()) {
            if (childNode.getParent() != node) {
                throw new QTENodeNotAddedToTreeException(transformation.getClass().toString());
            }
            nbrNodes += this.validateChildrenNodes(childNode, transformation);
        }
        return nbrNodes;
    }

    private int calculateMaximumNumberOfNodesInQueryTree(P environment) {
        return environment.getNodeIndex().getNumberOfNodesInIndex() * environment.getQueryNodeMultiplerLimit();
    }

    private void checkThatMaximumNumberOfNodesNotExceeded(P environment) throws QTERuntimeException {
        int maximumNumberOfNodes = environment.getMaximumNumberOfNodesInQueryTree();
        if (maximumNumberOfNodes <= 0) {
            return;
        }
        if (environment.getNodeIndex().getNumberOfNodesInIndex() > maximumNumberOfNodes) {
            throw new QTEMaximumNodesExceededException(Integer.valueOf(maximumNumberOfNodes).toString());
        }
    }

    private boolean treeActuallyContainsNodes(P environment) {
        return environment.getNodeIndex().getNumberOfNodesInIndex() > 0;
    }

    private void checkIfQueryPlanningLimitExceeded(P environment, long startTime) throws QTERuntimeException {
        long currentTime;
        if (environment.getQueryPlanningTimeLimit() > 0L && (currentTime = System.currentTimeMillis()) - startTime > environment.getQueryPlanningTimeLimit()) {
            throw new QTEPlanningTimeoutException(Long.valueOf(environment.getQueryPlanningTimeLimit()).toString());
        }
    }

    private void initializeTransformationEnvironment(N root, P environment) throws QTERuntimeException {
        if (root == null) {
            throw new QTEEmptyQueryTreeException();
        }
        if (environment == null) {
            throw new QTENoPlanningEnvironmentException();
        }
        environment.setRoot(root);
        environment.constructQueryLineage();
        this.loadConfigurationInformation(environment);
    }

    private void initializeListOfTransformedNodesInCurrentPass(P environment) {
        if (environment.getCheckTransformationAppliedTwiceToNodeInSamePass() != 0) {
            return;
        }
        if (this.mNodesTransformedInCurrentPass == null) {
            this.mNodesTransformedInCurrentPass = new HashMap<Integer, List<QTEAbstractTransformation<N, P>>>();
            return;
        }
        this.mNodesTransformedInCurrentPass.clear();
    }

    private void addNodeToListOfTransformedNodesInCurrentPass(P environment, QTEQueryNode node, QTEAbstractTransformation<N, P> transformation) {
        if (environment.getCheckTransformationAppliedTwiceToNodeInSamePass() != 0) {
            return;
        }
        List<QTEAbstractTransformation<N, P>> list = this.mNodesTransformedInCurrentPass.get(node.getId());
        if (list == null) {
            list = new ArrayList<QTEAbstractTransformation<N, P>>();
            list.add(transformation);
            this.mNodesTransformedInCurrentPass.put(node.getId(), list);
            return;
        }
        for (QTEAbstractTransformation<N, P> aTransformation : list) {
            if (aTransformation != transformation) continue;
            throw new QTETransformationAppliedTwiceToSameNodeException(transformation.getName(), node.getId().toString());
        }
        list.add(transformation);
    }

    private class ArrayStack {
        private static final int INITIAL_SIZE = 32;
        private int index = -1;
        private QTEQueryNode[] nodeArray = new QTEQueryNode[32];
        private int[] intArray = new int[32];

        ArrayStack() {
        }

        public boolean isEmpty() {
            return this.index == -1;
        }

        public void pop() {
            this.nodeArray[this.index] = null;
            --this.index;
        }

        public void push(QTEQueryNode node, int number) {
            ++this.index;
            if (this.index == this.intArray.length) {
                QTEQueryNode[] newNodeArray = new QTEQueryNode[this.nodeArray.length * 2];
                int[] newIntArray = new int[this.intArray.length * 2];
                System.arraycopy(this.nodeArray, 0, newNodeArray, 0, this.nodeArray.length);
                this.nodeArray = newNodeArray;
                System.arraycopy(this.intArray, 0, newIntArray, 0, this.intArray.length);
                this.intArray = newIntArray;
            }
            this.nodeArray[this.index] = node;
            this.intArray[this.index] = number;
        }

        public QTEQueryNode peekFirst() {
            if (this.index < 0) {
                return null;
            }
            return this.nodeArray[this.index];
        }

        public int peekSecond() {
            return this.intArray[this.index];
        }

        public void setSecond(int number) {
            this.intArray[this.index] = number;
        }
    }

    private class TreeVisitor {
        private QTEQueryNode node;
        private List<QTEQueryNode> list;
        private int[] nodeTypes;

        TreeVisitor(QTEQueryNode n, QTEPassTransformations<N, P> t) {
            this.node = n;
            this.nodeTypes = t.getNodeTypesArray();
            this.list = new ArrayList<QTEQueryNode>();
        }

        public QTEQueryNode getNode() {
            return this.node;
        }

        public void setNode(QTEQueryNode n) {
            this.node = n;
        }

        public List<QTEQueryNode> getList() {
            return this.list;
        }

        public void addIfApplicable() {
            if (this.isOfTypes(this.node.getType())) {
                this.list.add(this.node);
            }
        }

        public void addIfApplicable(QTEQueryNode n) {
            if (this.isOfTypes(n.getType())) {
                this.list.add(n);
            }
        }

        private boolean isOfTypes(int nodeType) {
            for (int type : this.nodeTypes) {
                if (type != nodeType) continue;
                return true;
            }
            return false;
        }
    }
}

