/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqerdp.flint;

import com.cognos.xqe.util.datasets.FlintUtils;
import com.cognos.xqerdp.flint.CryptoProviderAdapter;
import com.cognos.xqerdp.flint.FlintApiFacade;
import com.cognos.xqerdp.flint.result.CursorBackedRowReader;
import com.cognos.xqerdp.flint.result.QueryResultReader;
import com.cognos.xqerdp.flint.result.ResultDeserializer;
import com.ibm.ba.flint.thrift.query.CursorInfo;
import com.ibm.ba.flint.thrift.query.CursorOptions;
import com.ibm.ba.flint.thrift.query.SamplingOptions;
import com.ibm.ba.flint.thrift.query.SerializationFormat;
import com.ibm.ba.flint.thrift.query.SerializedResultInfo;
import com.ibm.ba.flint.thrift.types.ResultSet;
import com.ibm.ba.flint.thrift.types.Schema;
import com.ibm.ba.flint.thrift.util.ThriftIterableRowReader;
import com.ibm.ba.flint.util.RowReader;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import shaded.org.apache.hadoop.fs.Path;

public class FlintQueryExecutor {
    private static final int CURSOR_IDLE_SEC = (int)TimeUnit.MINUTES.toSeconds(30L);
    private static final boolean CURSOR_USES_AVRO = true;
    private static final int CURSOR_BATCH_SIZE = 5000;
    private final FlintApiFacade apiFacade;

    public FlintQueryExecutor(FlintApiFacade apiFacade) {
        this.apiFacade = apiFacade;
    }

    public QueryResultReader executeSqlToResultSetCacheOFF(String sql, SamplingOptions samplingOpts) {
        ResultSet rs = this.apiFacade.executeSqlToResultSetCacheOFF(sql, FlintUtils.getQueryTimeoutInterval(), samplingOpts);
        return new QueryResultReader(rs.getSchema(), (RowReader)new ThriftIterableRowReader(rs.getSchema(), (Iterable)rs.getRows()));
    }

    public QueryResultReader executeSqlToCursor(String sql, SamplingOptions samplingOpts) {
        CursorOptions cursorOpts = new CursorOptions().setIdleSeconds(CURSOR_IDLE_SEC);
        CursorInfo cursorInfo = this.apiFacade.executeSqlToCursor(sql, FlintUtils.getQueryTimeoutInterval(), cursorOpts, samplingOpts);
        return new QueryResultReader(cursorInfo.getSchema(), new CursorBackedRowReader(this.apiFacade, cursorInfo, true, 5000));
    }

    public QueryResultReader executeSqlToSerializedFile(String sql, SamplingOptions samplingOpts) throws IOException {
        SerializedResultInfo serializedResult = this.apiFacade.executeSqlToSerializedFile(sql, FlintUtils.getQueryTimeoutInterval(), samplingOpts);
        Schema schema = serializedResult.getSchema();
        Path path = new Path(serializedResult.getPath());
        SerializationFormat format = serializedResult.getFormat();
        ResultDeserializer deserializer = new ResultDeserializer(FlintUtils.getHadoopConfiguration(), serializedResult.isEncrypted() ? new CryptoProviderAdapter() : null);
        return new QueryResultReader(serializedResult.getSchema(), deserializer.deserialize(schema, path, format));
    }
}

