/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqerdp.flint.result;

import com.cognos.xqerdp.flint.FlintApiFacade;
import com.ibm.ba.flint.avro.AvroRowReader;
import com.ibm.ba.flint.thrift.query.CursorInfo;
import com.ibm.ba.flint.thrift.query.NoSuchCursorException;
import com.ibm.ba.flint.thrift.types.Row;
import com.ibm.ba.flint.thrift.types.Schema;
import com.ibm.ba.flint.thrift.util.ThriftIterableRowReader;
import com.ibm.ba.flint.util.ReadableRow;
import com.ibm.ba.flint.util.RowReader;
import com.ibm.ba.flint.util.WritableRow;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.List;

public class CursorBackedRowReader
implements RowReader {
    private final FlintApiFacade apiFacade;
    private final String cursorId;
    private final Schema schema;
    private final boolean useAvro;
    private final int batchSize;
    private RowReader currentBatch;
    private boolean endOfStream = false;
    private boolean closed = false;

    public CursorBackedRowReader(FlintApiFacade apiFacade, CursorInfo cursorInfo, boolean fetchWithAvro, int maxBatchSize) {
        this.apiFacade = apiFacade;
        this.cursorId = cursorInfo.getCursorId();
        this.schema = cursorInfo.getSchema();
        this.useAvro = fetchWithAvro;
        this.batchSize = maxBatchSize;
    }

    public boolean hasMore() throws IOException {
        if (this.endOfStream) {
            return false;
        }
        while (null == this.currentBatch || !this.currentBatch.hasMore()) {
            if (this.fetchNextBatch()) continue;
            this.endOfStream = true;
            return false;
        }
        return true;
    }

    public ReadableRow readRow() throws IOException {
        return this.currentBatch.readRow();
    }

    public Object[] readArray(Object[] target) throws IOException {
        return this.currentBatch.readArray(target);
    }

    public void readRow(WritableRow target) throws IOException {
        this.currentBatch.readRow(target);
    }

    private boolean fetchNextBatch() throws IOException {
        if (null != this.currentBatch) {
            this.currentBatch.close();
            this.currentBatch = null;
        }
        if (this.useAvro) {
            return this.fetchNextBatchAsAvroFileData();
        }
        return this.fetchNextBatchRowsList();
    }

    private boolean fetchNextBatchAsAvroFileData() throws IOException {
        try {
            List<ByteBuffer> buffers = this.apiFacade.fetchCursorRowsAvro(this.cursorId, this.batchSize);
            if (buffers.isEmpty()) {
                return false;
            }
            this.currentBatch = new AvroRowReader(this.schema, buffers);
            return true;
        }
        catch (NoSuchCursorException ex) {
            throw new IOException(ex);
        }
    }

    private boolean fetchNextBatchRowsList() throws IOException {
        try {
            List<Row> rows = this.apiFacade.fetchCursorRowsList(this.cursorId, this.batchSize);
            if (rows.isEmpty()) {
                return false;
            }
            this.currentBatch = new ThriftIterableRowReader(this.schema, rows);
            return true;
        }
        catch (NoSuchCursorException ex) {
            throw new IOException(ex);
        }
    }

    public void close() throws IOException {
        if (this.closed) {
            return;
        }
        this.closed = true;
        if (null != this.currentBatch) {
            this.currentBatch.close();
            this.currentBatch = null;
        }
        try {
            this.apiFacade.closeCursor(this.cursorId);
        }
        catch (NoSuchCursorException noSuchCursorException) {
            // empty catch block
        }
    }
}

