/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqerdp.flint.result;

import com.cognos.xqe.data.values.IntervalDayTimeValue;
import com.cognos.xqe.data.values.IntervalYearMonthValue;
import com.cognos.xqe.data.values.ValueConversionException;
import com.cognos.xqe.exception.XQEMessageKeys;
import java.util.StringTokenizer;
import java.util.concurrent.TimeUnit;

public class RSVPLegacyIntervalFormat {
    private static final String SPACE = " ";
    private static final String YEAR = "year";
    private static final String MONTH = "month";
    private static final String DAY = "day";
    private static final String HOUR = "hour";
    private static final String MINUTE = "minute";
    private static final String SECOND = "second";
    private static final String MILLISECOND = "millisecond";

    public static void parseIntervalYM(IntervalYearMonthValue target, String sValue) {
        StringTokenizer tokenizer = new StringTokenizer(sValue, SPACE, false);
        boolean hasResolvedSign = false;
        boolean isNegative = false;
        int years = 0;
        int months = 0;
        while (tokenizer.hasMoreTokens()) {
            String strTok = tokenizer.nextToken();
            int intTok = 0;
            try {
                intTok = Integer.parseInt(strTok);
            }
            catch (NumberFormatException ex) {
                throw new ValueConversionException(XQEMessageKeys.DAT_GeneralConversionError, "string", sValue, target.getDataType().toString());
            }
            if (!tokenizer.hasMoreTokens()) {
                throw new ValueConversionException(XQEMessageKeys.DAT_GeneralConversionError, "string", sValue, target.getDataType().toString());
            }
            strTok = tokenizer.nextToken();
            if (intTok < 0 && !hasResolvedSign) {
                isNegative = true;
                intTok = Math.abs(intTok);
            } else if (intTok < 0 && hasResolvedSign) {
                throw new ValueConversionException(XQEMessageKeys.DAT_GeneralConversionError, "string", sValue, target.getDataType().toString());
            }
            if (!hasResolvedSign && intTok != 0) {
                hasResolvedSign = true;
            }
            if (strTok.startsWith(YEAR)) {
                years = intTok;
                continue;
            }
            if (strTok.startsWith(MONTH)) {
                months = intTok;
                continue;
            }
            throw new ValueConversionException(XQEMessageKeys.DAT_GeneralConversionError, "string", sValue, target.getDataType().toString());
        }
        try {
            target.set(isNegative, years, months);
        }
        catch (IllegalArgumentException ex) {
            throw new ValueConversionException(XQEMessageKeys.DAT_GeneralConversionError, (Throwable)ex, "string", sValue, target.getDataType().toString());
        }
    }

    public static void parseIntervalDT(IntervalDayTimeValue target, String sValue) {
        StringTokenizer tokenizer = new StringTokenizer(sValue, SPACE, false);
        boolean hasResolvedSign = false;
        boolean isNegative = false;
        int days = 0;
        int hours = 0;
        int minutes = 0;
        int seconds = 0;
        int nanos = 0;
        while (tokenizer.hasMoreTokens()) {
            String strTok = tokenizer.nextToken();
            int intTok = 0;
            try {
                intTok = Integer.parseInt(strTok);
            }
            catch (NumberFormatException ex) {
                throw new ValueConversionException(XQEMessageKeys.DAT_GeneralConversionError, (Throwable)ex, "string", sValue, target.getDataType().toString());
            }
            if (!tokenizer.hasMoreTokens()) {
                throw new ValueConversionException(XQEMessageKeys.DAT_GeneralConversionError, "string", sValue, target.getDataType().toString());
            }
            strTok = tokenizer.nextToken();
            if (intTok < 0 && !hasResolvedSign) {
                isNegative = true;
                intTok = Math.abs(intTok);
            } else if (intTok < 0 && hasResolvedSign) {
                throw new ValueConversionException(XQEMessageKeys.DAT_GeneralConversionError, "string", sValue, target.getDataType().toString());
            }
            if (!hasResolvedSign && intTok != 0) {
                hasResolvedSign = true;
            }
            if (strTok.startsWith(DAY)) {
                days = intTok;
                continue;
            }
            if (strTok.startsWith(HOUR)) {
                hours = intTok;
                continue;
            }
            if (strTok.startsWith(MINUTE)) {
                minutes = intTok;
                continue;
            }
            if (strTok.startsWith(SECOND)) {
                seconds = intTok;
                continue;
            }
            if (strTok.startsWith(MILLISECOND)) {
                nanos = Math.toIntExact(TimeUnit.MILLISECONDS.toNanos(intTok));
                continue;
            }
            throw new ValueConversionException(XQEMessageKeys.DAT_GeneralConversionError, "string", sValue, target.getDataType().toString());
        }
        try {
            target.set(isNegative, days, hours, minutes, seconds, nanos);
        }
        catch (IllegalArgumentException ex) {
            throw new ValueConversionException(XQEMessageKeys.DAT_GeneralConversionError, (Throwable)ex, "string", sValue, target.getDataType().toString());
        }
    }
}

