/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqerdp.flint.result;

import com.cognos.xqe.data.types.IDataType;
import com.cognos.xqe.data.types.IntervalDayTimeType;
import com.cognos.xqe.data.types.IntervalYearMonthType;
import com.cognos.xqe.data.values.DateTimeValue;
import com.cognos.xqe.data.values.IntervalDayTimeValue;
import com.cognos.xqe.data.values.IntervalYearMonthValue;
import com.cognos.xqe.data.values.RowValue;
import com.cognos.xqe.data.values.Value;
import com.cognos.xqerdp.flint.result.RSVPLegacyIntervalFormat;
import com.ibm.ba.flint.util.WritableRow;
import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.sql.Date;
import java.sql.Timestamp;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.util.BitSet;
import org.apache.commons.lang.StringUtils;

public class WritableRowValueAdapter
implements WritableRow {
    private final RowValue row;
    private final ZoneId normalizedZoneId;
    private final ZoneId denormalizedZoneId;
    private final BitSet columnsNeedingTZShift;
    private final BitSet columnsWithIntervalYM;
    private final BitSet columnsWithIntervalDT;

    public WritableRowValueAdapter(RowValue rowValue, ZoneId normalizedZone, ZoneId denormalizedZone) {
        this.row = rowValue;
        this.columnsNeedingTZShift = new BitSet(rowValue.getNumColumns());
        this.columnsWithIntervalYM = new BitSet(rowValue.getNumColumns());
        this.columnsWithIntervalDT = new BitSet(rowValue.getNumColumns());
        this.normalizedZoneId = normalizedZone;
        this.denormalizedZoneId = denormalizedZone;
        for (int i = 0; i < rowValue.getNumColumns(); ++i) {
            Value value = (Value)rowValue.getColumn(i);
            IDataType dataType = value.getDataType();
            if ((dataType.isTime() || dataType.isTimestamp()) && !dataType.isTimeZoneBearing()) {
                this.columnsNeedingTZShift.set(i);
                continue;
            }
            if (dataType instanceof IntervalDayTimeType) {
                this.columnsWithIntervalDT.set(i);
                continue;
            }
            if (!(dataType instanceof IntervalYearMonthType)) continue;
            this.columnsWithIntervalYM.set(i);
        }
    }

    private Value getColumnValue(int index) {
        return (Value)this.row.getColumn(index);
    }

    public void set(int index, Object value) {
        this.getColumnValue(index).set(value);
    }

    public void setBinary(int index, byte[] value) {
        this.getColumnValue(index).set(value);
    }

    public void setBinary(int index, ByteBuffer value) {
        byte[] buf = new byte[value.remaining()];
        value.get(buf);
        this.getColumnValue(index).set(buf);
    }

    public void setBoolean(int index, boolean value) {
        this.getColumnValue(index).set(value);
    }

    public void setByte(int index, byte value) {
        this.getColumnValue(index).set(value);
    }

    public void setDate(int index, Date value) {
        this.getColumnValue(index).set(value);
    }

    public void setDecimal(int index, BigDecimal value) {
        this.getColumnValue(index).set(value);
    }

    public void setDouble(int index, double value) {
        this.getColumnValue(index).set(value);
    }

    public void setFloat(int index, float value) {
        this.getColumnValue(index).set(value);
    }

    public void setInt(int index, int value) {
        Value v = this.getColumnValue(index);
        if (this.columnsWithIntervalDT.get(index)) {
            WritableRowValueAdapter.setIntervalDTFromInteger((IntervalDayTimeValue)v, value);
        } else {
            v.set(value);
        }
    }

    public void setLong(int index, long value) {
        this.getColumnValue(index).set(value);
    }

    public void setNull(int index) {
        this.getColumnValue(index).setNull();
    }

    public void setShort(int index, short value) {
        this.getColumnValue(index).set(value);
    }

    public void setString(int index, String value) {
        Value v = this.getColumnValue(index);
        if (this.columnsWithIntervalYM.get(index)) {
            WritableRowValueAdapter.setIntervalYMFromString((IntervalYearMonthValue)v, value);
        } else if (this.columnsWithIntervalDT.get(index)) {
            WritableRowValueAdapter.setIntervalDTFromString((IntervalDayTimeValue)v, value);
        } else {
            v.set(value);
        }
    }

    private static void setIntervalYMFromString(IntervalYearMonthValue target, String sValue) {
        if (StringUtils.isEmpty((String)sValue)) {
            target.setNull();
            return;
        }
        if (WritableRowValueAdapter.hasPeriodPrefix(sValue)) {
            target.setXSDLiteral(sValue);
        } else {
            RSVPLegacyIntervalFormat.parseIntervalYM(target, sValue);
        }
    }

    private static void setIntervalDTFromString(IntervalDayTimeValue target, String sValue) {
        if (StringUtils.isEmpty((String)sValue)) {
            target.setNull();
            return;
        }
        if (WritableRowValueAdapter.hasPeriodPrefix(sValue)) {
            target.setXSDLiteral(sValue);
        } else {
            RSVPLegacyIntervalFormat.parseIntervalDT(target, sValue);
        }
    }

    private static void setIntervalDTFromInteger(IntervalDayTimeValue target, int intVal) {
        target.setInteger(intVal);
    }

    private static boolean hasPeriodPrefix(String sValue) {
        return sValue.startsWith("P") || sValue.startsWith("-P");
    }

    public void setTimestamp(int index, Timestamp value) {
        DateTimeValue dateTime = (DateTimeValue)this.getColumnValue(index);
        if (this.columnsNeedingTZShift.get(index)) {
            dateTime.set(value.toLocalDateTime().atZone(this.denormalizedZoneId).withZoneSameInstant(this.normalizedZoneId).toLocalDateTime());
        } else {
            dateTime.set(value.toInstant().atOffset(ZoneOffset.UTC));
        }
    }

    public int size() {
        return this.row.getNumColumns();
    }
}

