/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqerdp.json.cloudant;

import com.cognos.xqe.ast.QueryFormatter;
import com.cognos.xqe.ast.sql.SQLBetween;
import com.cognos.xqe.ast.sql.SQLComparison;
import com.cognos.xqe.ast.sql.SQLFid;
import com.cognos.xqe.ast.sql.SQLFilter;
import com.cognos.xqe.ast.sql.SQLLike;
import com.cognos.xqe.ast.sql.SQLLiteral;
import com.cognos.xqe.ast.sql.SQLLogical;
import com.cognos.xqe.ast.sql.SQLProject;
import com.cognos.xqe.ast.sql.SQLQueryBlock;
import com.cognos.xqe.ast.sql.SQLQueryNode;
import com.cognos.xqe.ast.sql.SQLRangeVar;
import com.cognos.xqe.ast.sql.SQLRelation;
import com.cognos.xqe.data.model.IDataSourceCapabilities;
import com.cognos.xqe.util.ArrayUtil;

public class LuceneQueryBuilder
extends QueryFormatter {
    private static final char SQL_PERCENT = '%';
    private static final char SQL_UNDERSCORE = '_';
    private static final char[] LUCENE_SPECIAL_CHARS = new char[]{'+', '-', '!', '(', ')', '{', '}', '[', ']', '^', '\"', '~', '*', '?', ':', '\\'};
    private static final char LUCENE_ESCAPE_CHAR = '\\';
    private static final char LUCENE_SINGLE_CHAR = '?';
    private static final char LUCENE_MULTIPLE_CHARS = '*';

    @Override
    public String bufferToString() {
        return this.buffer.toString();
    }

    private Object[] dumpChildren(SQLQueryNode node, IDataSourceCapabilities capabilities) {
        LuceneQueryBuilder formatter = new LuceneQueryBuilder();
        int nArgs = node.getNumberChildren();
        Object[] argValues = new Object[nArgs];
        for (int i = 0; i < nArgs; ++i) {
            ((SQLQueryNode)node.getChild(i)).accept(formatter, capabilities);
            argValues[i] = ((QueryFormatter)formatter).bufferToString();
            formatter.clear();
        }
        return argValues;
    }

    @Override
    public void visit(SQLBetween node, IDataSourceCapabilities capabilities) {
        this.addText(String.format(node.getPattern(capabilities), this.dumpChildren(node, capabilities)));
    }

    @Override
    public void visit(SQLComparison node, IDataSourceCapabilities capabilities) {
        this.addText(String.format(node.getPattern(capabilities), this.dumpChildren(node, capabilities)));
    }

    @Override
    public void visit(SQLFid node, IDataSourceCapabilities capabilities) {
        this.addText(node.getName());
    }

    @Override
    public void visit(SQLFilter node, IDataSourceCapabilities capabilities) {
        ((SQLQueryNode)node.getChild(0)).accept(this, capabilities);
        ((SQLQueryNode)node.getChild(1)).accept(this, capabilities);
    }

    @Override
    public void visit(SQLLike node, IDataSourceCapabilities capabilities) {
        Object[] args = this.dumpChildren(node, capabilities);
        String pattern = (String)args[1];
        String escape = null;
        if (args.length > 2) {
            escape = (String)args[2];
        }
        char e = escape != null ? (char)escape.charAt(0) : (char)' ';
        StringBuilder b = new StringBuilder();
        for (int i = pattern.length() - 1; i >= 0; --i) {
            char c = pattern.charAt(i);
            if (escape == null) {
                if (c == '%') {
                    b.insert(0, '*');
                    continue;
                }
                if (c == '_') {
                    b.insert(0, '?');
                    continue;
                }
                b.insert(0, c);
                if (!this.isSpecial(c)) continue;
                b.insert(0, '\\');
                continue;
            }
            if (c == '%' || c == '_') {
                if (this.isPreceedingEscape(pattern, i - 1, e)) {
                    b.insert(0, c);
                    continue;
                }
                if (c == '%') {
                    b.insert(0, '*');
                    continue;
                }
                b.insert(0, '?');
                continue;
            }
            if (c == e) {
                if (i == 0 || !this.isPreceedingEscape(pattern, i - 1, e)) continue;
                b.insert(0, e);
                continue;
            }
            b.insert(0, c);
            if (!this.isSpecial(c)) continue;
            b.insert(0, '\\');
        }
        this.addText(String.format(node.getPattern(capabilities), args[0], b.toString()));
    }

    private boolean isPreceedingEscape(String s, int index, char escape) {
        if (index < 0) {
            return false;
        }
        char c = s.charAt(index);
        if (c == escape) {
            if (index == 0) {
                return true;
            }
            return !this.isPreceedingEscape(s, index - 1, escape);
        }
        return false;
    }

    private boolean isSpecial(char c) {
        return ArrayUtil.contains(LUCENE_SPECIAL_CHARS, c);
    }

    @Override
    public void visit(SQLLiteral node, IDataSourceCapabilities capabilities) {
        this.addText(node.getValue().getJSONLiteral());
    }

    @Override
    public void visit(SQLLogical node, IDataSourceCapabilities capabilities) {
        this.addText(String.format(node.getPattern(capabilities), this.dumpChildren(node, capabilities)));
    }

    @Override
    public void visit(SQLProject node, IDataSourceCapabilities capabilities) {
        ((SQLQueryNode)node.getChild(0)).accept(this, capabilities);
    }

    @Override
    public void visit(SQLQueryBlock node, IDataSourceCapabilities capabilities) {
        ((SQLQueryNode)node.getChild(0)).accept(this, capabilities);
    }

    @Override
    public void visit(SQLRangeVar node, IDataSourceCapabilities capabilities) {
        ((SQLQueryNode)node.getChild(0)).accept(this, capabilities);
    }

    @Override
    public void visit(SQLRelation node, IDataSourceCapabilities capabilities) {
    }
}

