/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqerdp.odata;

import com.cognos.xqe.authentication.AuthenticationHelper;
import com.cognos.xqe.bibushandler.OperationCanceledException;
import com.cognos.xqe.config.ServiceEnumeration;
import com.cognos.xqe.config.XQEConfiguration;
import com.cognos.xqe.config.XQEConfigurationManager;
import com.cognos.xqe.data.json.JSONUtil;
import com.cognos.xqe.data.model.IDataSourceCapabilities;
import com.cognos.xqe.data.providers.ProviderResultSetBase;
import com.cognos.xqe.data.providers.relational.SQLQueryArguments;
import com.cognos.xqe.data.types.IDataType;
import com.cognos.xqe.data.types.MultisetType;
import com.cognos.xqe.data.types.RowType;
import com.cognos.xqe.data.types.StructType;
import com.cognos.xqe.data.values.DataValueFactory;
import com.cognos.xqe.data.values.IRow;
import com.cognos.xqe.data.values.MultisetValue;
import com.cognos.xqe.data.values.RowValue;
import com.cognos.xqe.data.values.StructValue;
import com.cognos.xqe.data.values.Value;
import com.cognos.xqe.data.values.ValueState;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.pool.connection.IPooledConnection;
import com.cognos.xqe.query.engine.ExecutionEnvironment;
import com.cognos.xqe.resultset.interfaces.IColumnInfo;
import com.cognos.xqe.resultset.interfaces.IScrollableIterator;
import com.cognos.xqe.resultset.interfaces.ITabularIterator;
import com.cognos.xqe.resultset.interfaces.ITabularResultSet;
import com.cognos.xqe.runtree.XDataContext;
import com.cognos.xqe.runtree.XTabularIterator;
import com.cognos.xqe.runtree.relational.vectorization.ColumnVector;
import com.cognos.xqe.runtree.relational.vectorization.XVectorContext;
import com.cognos.xqe.runtree.relational.vectorization.XVectorRowBatch;
import com.cognos.xqe.runtree.relational.vectorization.XVectorRowBatchUtil;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.trace.XQELog;
import com.cognos.xqe.trace.XQELogger;
import com.cognos.xqe.util.io.TempFileUtil;
import com.cognos.xqe.util.resource.ReleasableResourceTracker;
import com.cognos.xqerdp.odata.ODataCancelHandler;
import com.cognos.xqerdp.odata.ODataConnection;
import com.cognos.xqerdp.odata.ODataDataProvider;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import net.minidev.json.JSONArray;
import net.minidev.json.JSONObject;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.URIException;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.util.URIUtil;

public class ODataTabularResult
extends ProviderResultSetBase
implements ITabularResultSet {
    private static final String UTF_8 = "UTF-8";
    public static final int ONE_KB = 1024;
    public static final int ONE_MB = 0x100000;
    private static final int BUFFER_SIZE = 65536;
    private static final String REQUEST_FORMAT = "ODATA URI: %s - ";
    private static final String REMAINING_MEM_FORMAT = "Remaining Available Memory: %d bytes.";
    private static final String OUT_OF_MEM_FORMAT = "NOT ENOUGH MEMORY TO SUSTAIN THE %dKB BUFFER";
    private static final String TRY_TO_SHRINK = "TRYING TO SHRINK THE RESPONSE BUFFER";
    private static final String SHRINK_SUCCESS = "SHRINKING RESPONSE BUFFER SUCCEED";
    private static final String MEM_ALLOCATED_FORMAT = "Memory allocated so far: %d bytes.";
    private static final String RELEASING_MEM = "Releasing memory.";
    private static final String RESPONSE_TOO_BIG = "HTTP Response is bigger than the Response Limit Size [%dMB].";
    private static final char NEWLINE = '\n';
    private IPooledConnection pooledConnection;
    protected ODataConnection connection;
    protected String request;
    private ExecutionEnvironment execEnv;
    private ODataCancelHandler cancelHandler;
    private boolean bCanceled;
    private InputStream iStream;
    private JsonParser parser;
    private boolean noData;
    private int responseLimit;
    private byte[] responseBuffer;
    private File responseFileBuffer;
    private int actualResponseLength;
    private int totalMemoryAllocated;
    private XVectorContext vContext;
    private XQELogger xqeMemoryTraceLogger;
    private XQELogger odataInfoLogger;

    public ODataTabularResult(XDataContext context, IPooledConnection thePooledConnection, SQLQueryArguments queryArgs, Integer nodeId, ODataDataProvider dataProvider) {
        block5: {
            super(dataProvider, context, queryArgs.getRunLocale(), nodeId);
            this.execEnv = null;
            this.cancelHandler = null;
            this.bCanceled = false;
            this.noData = false;
            this.responseLimit = -1;
            this.responseBuffer = null;
            this.responseFileBuffer = null;
            this.actualResponseLength = 0;
            this.totalMemoryAllocated = 0;
            this.xqeMemoryTraceLogger = XQELog.getLogger(ServiceEnumeration.XQE, "XQE", "Memory", LogLevel.TRACE);
            this.odataInfoLogger = XQELog.getLogger(ServiceEnumeration.XQE, "XQE", "ODATA", LogLevel.INFO);
            this.execEnv = (ExecutionEnvironment)context.getEnvironment();
            try {
                this.pooledConnection = thePooledConnection;
                this.pooledConnection.setNotReusable();
                this.connection = (ODataConnection)this.pooledConnection.getConnection();
                this.responseLimit = this.connection.getAvailableResponseLimit();
                String query = queryArgs.getSQLQuery();
                String host = this.connection.getURI();
                StringBuilder url = new StringBuilder();
                if (!query.startsWith("http")) {
                    url.append(host);
                }
                url.append(query);
                this.request = URIUtil.encodeQuery((String)url.toString(), (String)UTF_8);
                this.rowsetInfo = queryArgs.getCalculatedRowsetInfo();
                this.cancelHandler = new ODataCancelHandler(this);
                this.execEnv.getCancelManager().addCancelHandler(this.cancelHandler);
                this.odataInfoLogger.log(String.format(REQUEST_FORMAT, this.request) + "BEGIN HTTP RESPONSE CONSUMPTION");
                this.odataInfoLogger.log(String.format(REQUEST_FORMAT, this.request) + String.format("HTTP Response Limit: %d bytes.", this.responseLimit));
                this.xqeMemoryTraceLogger.log(String.format(REQUEST_FORMAT, this.request) + String.format(REMAINING_MEM_FORMAT, this.responseLimit));
                this.iStream = this.issueHTTPRequest();
                this.iStream = this.consumeHTTPResponse(this.iStream, this.responseLimit);
                this.connection.decreaseAvailableResponseLimit(this.actualResponseLength);
                this.odataInfoLogger.log(String.format(REQUEST_FORMAT, this.request) + "HTTP RESPONSE CONSUMED SUCCESSFULLY");
                this.xqeMemoryTraceLogger.log(String.format(REQUEST_FORMAT, this.request) + String.format(REMAINING_MEM_FORMAT, this.connection.getAvailableResponseLimit()));
                this.xqeMemoryTraceLogger.log(String.format(REQUEST_FORMAT, this.request) + String.format("HTTP Response length: %d bytes.", this.actualResponseLength));
                if (!this.noData) {
                    this.odataInfoLogger.log(String.format(REQUEST_FORMAT, this.request) + "INITIALIZING JSON PARSER.");
                    this.initializeJSONParser(this.iStream);
                    this.odataInfoLogger.log(String.format(REQUEST_FORMAT, this.request) + "JSON PARSER INITIALIZED.");
                }
                if (this.bCanceled) {
                    this.release();
                }
                this.vContext = queryArgs.getVectorizationContext();
            }
            catch (Exception e) {
                this.release();
                if (this.bCanceled) break block5;
                throw new XQERuntimeException(XQEMessageKeys.DAT_DataSourceAdapterError, (Throwable)e, e.toString());
            }
        }
    }

    private InputStream issueHTTPRequest() throws HttpException, IOException {
        GetMethod httpGet;
        InputStream inputStream = null;
        HttpClient client = new HttpClient();
        try {
            httpGet = AuthenticationHelper.createGetMethod(this.connection.getDataSource(), this.request);
        }
        catch (URIException e) {
            throw new XQERuntimeException(e);
        }
        int response = client.executeMethod((HttpMethod)httpGet);
        if (response == 404) {
            this.noData = true;
        } else {
            if (response != 200) {
                throw new RuntimeException(httpGet.getResponseBodyAsString());
            }
            long contentLength = httpGet.getResponseContentLength();
            if (this.responseLimit == 0) {
                inputStream = httpGet.getResponseBodyAsStream();
            } else if (contentLength <= (long)this.responseLimit) {
                if (contentLength > 0L) {
                    this.responseLimit = (int)contentLength;
                }
                inputStream = httpGet.getResponseBodyAsStream();
            } else {
                throw new XQERuntimeException(XQEMessageKeys.EXE_HTTPResponseBiggerThanLimit, contentLength / 0x100000L, (Object)(this.responseLimit / 0x100000));
            }
        }
        return inputStream;
    }

    private InputStream consumeHTTPResponse(InputStream httpResponseStream, int httpResponseLimit) throws IOException {
        if (httpResponseStream == null || httpResponseLimit == 0) {
            return httpResponseStream;
        }
        this.odataInfoLogger.log(String.format(REQUEST_FORMAT, this.request) + "CHECKING IF HTTP RESPONSE CAN BE CONSUMED LOCALLY.");
        this.xqeMemoryTraceLogger.log(String.format("ODATATabularResult == BUFFER_SIZE is set to %d KB", 64));
        if (this.getDataContext().getMemoryManager().allocateMemory(httpResponseLimit + 65536, false)) {
            this.totalMemoryAllocated += httpResponseLimit + 65536;
            this.odataInfoLogger.log(String.format(REQUEST_FORMAT, this.request) + "HTTP RESPONSE WILL BE STORED IN RAM.");
            this.xqeMemoryTraceLogger.log(String.format(REQUEST_FORMAT, this.request) + String.format(MEM_ALLOCATED_FORMAT, this.totalMemoryAllocated));
            this.consumeHTTPResponseToRAM(httpResponseStream, httpResponseLimit);
            return null;
        }
        if (this.getDataContext().getMemoryManager().allocateMemory(65536L, false)) {
            this.totalMemoryAllocated += 65536;
            this.xqeMemoryTraceLogger.log(String.format(REQUEST_FORMAT, this.request) + "HTTP RESPONSE WILL BE STORED TO DISK");
            this.xqeMemoryTraceLogger.log(String.format(REQUEST_FORMAT, this.request) + String.format(MEM_ALLOCATED_FORMAT, this.totalMemoryAllocated));
            return this.consumeHTTPResponseToDISK(httpResponseStream, httpResponseLimit);
        }
        this.odataInfoLogger.log(String.format(REQUEST_FORMAT, this.request) + "HTTP RESPONSE CANNOT BE CONSUMED LOCALLY.");
        this.odataInfoLogger.log(String.format(REQUEST_FORMAT, this.request) + String.format(OUT_OF_MEM_FORMAT, 65536));
        OutOfMemoryError e = new OutOfMemoryError(String.format(OUT_OF_MEM_FORMAT, 65536));
        throw new XQERuntimeException(e);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private InputStream consumeHTTPResponseToDISK(InputStream httpResponseStream, int httpResponseLimit) throws IOException {
        this.responseFileBuffer = TempFileUtil.createTempFile(this.getClass().getSimpleName());
        this.responseFileBuffer.setWritable(true);
        FileOutputStream outStream = new FileOutputStream(this.responseFileBuffer);
        byte[] buffer = new byte[65536];
        int bytesRead = 0;
        try {
            while ((bytesRead = httpResponseStream.read(buffer)) >= 0) {
                this.actualResponseLength += bytesRead;
                if (this.actualResponseLength <= httpResponseLimit) {
                    outStream.write(buffer, 0, bytesRead);
                    outStream.flush();
                    continue;
                }
                this.odataInfoLogger.log(String.format(REQUEST_FORMAT, this.request) + String.format(RESPONSE_TOO_BIG, httpResponseLimit / 0x100000));
                outStream.close();
                outStream = null;
                this.releaseResponseFileBuffer();
                throw new XQERuntimeException(XQEMessageKeys.EXE_HTTPResponseBig, httpResponseLimit / 0x100000);
            }
            this.getDataContext().getMemoryManager().releaseMemory(65536L);
            this.totalMemoryAllocated -= 65536;
        }
        catch (Throwable throwable) {
            this.getDataContext().getMemoryManager().releaseMemory(65536L);
            this.totalMemoryAllocated -= 65536;
            this.xqeMemoryTraceLogger.log(String.format(REQUEST_FORMAT, this.request) + RELEASING_MEM + '\n' + String.format(REQUEST_FORMAT, this.request) + String.format(MEM_ALLOCATED_FORMAT, this.totalMemoryAllocated));
            httpResponseStream.close();
            httpResponseStream = null;
            throw throwable;
        }
        this.xqeMemoryTraceLogger.log(String.format(REQUEST_FORMAT, this.request) + RELEASING_MEM + '\n' + String.format(REQUEST_FORMAT, this.request) + String.format(MEM_ALLOCATED_FORMAT, this.totalMemoryAllocated));
        httpResponseStream.close();
        httpResponseStream = null;
        outStream.close();
        outStream = null;
        this.responseFileBuffer.setWritable(false);
        this.responseFileBuffer.setReadOnly();
        return new FileInputStream(this.responseFileBuffer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void consumeHTTPResponseToRAM(InputStream httpResponseStream, int httpResponseLimit) throws IOException {
        byte[] buffer = new byte[65536];
        int offset = 0;
        int bytesRead = 0;
        try {
            this.responseBuffer = new byte[httpResponseLimit];
            while ((bytesRead = httpResponseStream.read(buffer)) >= 0) {
                this.actualResponseLength += bytesRead;
                if (this.actualResponseLength > httpResponseLimit) {
                    this.odataInfoLogger.log(String.format(REQUEST_FORMAT, this.request) + String.format(RESPONSE_TOO_BIG, httpResponseLimit / 0x100000));
                    this.releaseResponseBuffer();
                    throw new XQERuntimeException(XQEMessageKeys.EXE_HTTPResponseBig, httpResponseLimit / 0x100000);
                }
                System.arraycopy(buffer, 0, this.responseBuffer, offset, bytesRead);
                offset += bytesRead;
            }
            this.getDataContext().getMemoryManager().releaseMemory(65536L);
            this.totalMemoryAllocated -= 65536;
        }
        catch (Throwable throwable) {
            this.getDataContext().getMemoryManager().releaseMemory(65536L);
            this.totalMemoryAllocated -= 65536;
            this.xqeMemoryTraceLogger.log(String.format(REQUEST_FORMAT, this.request) + RELEASING_MEM + '\n' + String.format(REQUEST_FORMAT, this.request) + String.format(MEM_ALLOCATED_FORMAT, this.totalMemoryAllocated));
            httpResponseStream.close();
            httpResponseStream = null;
            throw throwable;
        }
        this.xqeMemoryTraceLogger.log(String.format(REQUEST_FORMAT, this.request) + RELEASING_MEM + '\n' + String.format(REQUEST_FORMAT, this.request) + String.format(MEM_ALLOCATED_FORMAT, this.totalMemoryAllocated));
        httpResponseStream.close();
        httpResponseStream = null;
        this.tryToShrinkResponseBuffer();
    }

    private void tryToShrinkResponseBuffer() {
        if (this.actualResponseLength < this.responseLimit && this.getDataContext().getMemoryManager().allocateMemory(this.actualResponseLength, false)) {
            this.totalMemoryAllocated += this.actualResponseLength;
            this.odataInfoLogger.log(String.format(REQUEST_FORMAT, this.request) + TRY_TO_SHRINK);
            this.xqeMemoryTraceLogger.log(String.format(REQUEST_FORMAT, this.request) + TRY_TO_SHRINK + '\n' + String.format(REQUEST_FORMAT, this.request) + String.format(MEM_ALLOCATED_FORMAT, this.totalMemoryAllocated));
            byte[] bufferToBeReleased = this.responseBuffer;
            this.responseBuffer = new byte[this.actualResponseLength];
            System.arraycopy(bufferToBeReleased, 0, this.responseBuffer, 0, this.actualResponseLength);
            bufferToBeReleased = null;
            this.getDataContext().getMemoryManager().releaseMemory(this.responseLimit);
            this.totalMemoryAllocated -= this.responseLimit;
            this.odataInfoLogger.log(String.format(REQUEST_FORMAT, this.request) + SHRINK_SUCCESS);
            this.xqeMemoryTraceLogger.log(String.format(REQUEST_FORMAT, this.request) + SHRINK_SUCCESS + '\n' + String.format(REQUEST_FORMAT, this.request) + String.format(MEM_ALLOCATED_FORMAT, this.totalMemoryAllocated));
        }
    }

    private void initializeJSONParser(InputStream httpResponseStream) throws JsonParseException, IOException {
        this.parser = this.responseBuffer != null ? new JsonFactory().createParser(this.responseBuffer) : new JsonFactory().createParser(httpResponseStream);
        this.parser.nextToken();
        this.parser.nextToken();
        if (this.parser.nextToken() == JsonToken.START_ARRAY) {
            this.parser.nextToken();
        }
    }

    @Override
    public long getRowCount() {
        return -1L;
    }

    @Override
    public ITabularIterator getTabularIterator() {
        return new ODataTabularResultIterator(this.getDataContext(), this.nodeId);
    }

    @Override
    public IScrollableIterator getScrollableTabularIterator() {
        throw new UnsupportedOperationException();
    }

    @Override
    protected void releaseImpl() {
        try {
            if (this.connection != null) {
                this.connection.increaseAvailableResponseLimit(this.actualResponseLength);
            }
            if (this.iStream != null) {
                this.iStream.close();
            }
            if (this.parser != null) {
                this.parser.close();
            }
            this.releaseResponseBuffer();
            this.releaseResponseFileBuffer();
            if (this.totalMemoryAllocated != 0) {
                this.xqeMemoryTraceLogger.log(String.format(REQUEST_FORMAT, this.request) + "MEMORY NOT RELEASED PROPERLY!");
                throw new AssertionError((Object)"Memory was not released properly!");
            }
            this.returnConnection();
            if (this.cancelHandler != null) {
                this.execEnv.getCancelManager().removeCancelHandler(this.cancelHandler);
                if (this.isCanceled()) {
                    throw new OperationCanceledException();
                }
            }
        }
        catch (IOException iOException) {
        }
        finally {
            super.releaseImpl();
        }
    }

    private void releaseResponseBuffer() {
        if (this.responseBuffer != null) {
            this.totalMemoryAllocated -= this.responseBuffer.length;
            this.getDataContext().getMemoryManager().releaseMemory(this.responseBuffer.length);
            this.responseBuffer = null;
            this.actualResponseLength = 0;
            this.responseLimit = 0;
            this.xqeMemoryTraceLogger.log(String.format(REQUEST_FORMAT, this.request) + String.format(REMAINING_MEM_FORMAT, this.totalMemoryAllocated));
        }
    }

    private void releaseResponseFileBuffer() {
        if (this.responseFileBuffer != null) {
            TempFileUtil.deleteTempFile(this.responseFileBuffer);
            this.responseFileBuffer = null;
        }
    }

    public IDataSourceCapabilities getCapabilities() {
        return this.connection.getCapabilities();
    }

    public boolean isCanceled() {
        return this.bCanceled;
    }

    public void setCanceled(boolean cancelled) {
        this.bCanceled = cancelled;
    }

    public boolean cancelImpl() {
        boolean canceled = true;
        return canceled;
    }

    public void returnConnection() {
        if (this.pooledConnection != null) {
            this.pooledConnection.returnConnection();
            this.pooledConnection = null;
        }
    }

    public ODataConnection getConnection() {
        return this.connection;
    }

    public IPooledConnection getPooledConnection() {
        return this.pooledConnection;
    }

    public void setPooledConnection(IPooledConnection aConnection) {
        this.pooledConnection = aConnection;
    }

    protected class ODataTabularResultIterator
    extends XTabularIterator {
        private static final String URI = "uri";
        private static final String DEFERRED = "__deferred";
        private static final String RESULTS = "results";
        private static final String QUERY_EXECUTION_O_DATA_LAZY_LOADING_VALUE = "queryExecution.OData.lazyLoading[@value]";
        private static final boolean DEFAULT_LAZY_LOADING = false;
        private RowValue row;
        private XVectorRowBatch batch;
        private boolean eod;
        private final AtomicBoolean mReleased;
        private JSONObject jObject;
        private boolean lazyLoading;

        protected ODataTabularResultIterator(XDataContext context, Integer id) {
            super(context, id);
            this.mReleased = new AtomicBoolean(false);
            this.lazyLoading = true;
            XQEConfiguration configuration = XQEConfigurationManager.getInstance().getConfiguration(ServiceEnumeration.XQE);
            this.lazyLoading = configuration.getBooleanProperty(QUERY_EXECUTION_O_DATA_LAZY_LOADING_VALUE, false);
            this.row = DataValueFactory.createRowValue(context.getLocalCollator(), ODataTabularResult.this.rowsetInfo);
            if (ODataTabularResult.this.vContext != null) {
                this.batch = XVectorRowBatchUtil.createRowBatch(ODataTabularResult.this.vContext, ODataTabularResult.this.rowsetInfo, context.getLocalCollator());
            }
            ReleasableResourceTracker parentTracker = ODataTabularResult.this.getResourceTracker();
            parentTracker.addInstance(this, Thread.currentThread().getStackTrace());
        }

        @Override
        public Object nextImpl() {
            try {
                if (ODataTabularResult.this.isCanceled()) {
                    throw new OperationCanceledException();
                }
                if (ODataTabularResult.this.noData) {
                    return null;
                }
                ++this.nRows;
                this.jObject = this.getNextObject();
                if (this.jObject == null) {
                    return null;
                }
                int i = 0;
                for (IColumnInfo columnInfo : ODataTabularResult.this.rowsetInfo.getColumnInfos()) {
                    Value value = (Value)this.row.getColumn(i++);
                    Object jValue = this.jObject.get((Object)columnInfo.getName());
                    value.setState(ValueState.NULL);
                    if (null == jValue) continue;
                    this.getValue(jValue, columnInfo.getDataType(), value);
                }
                ODataTabularResult.this.parser.nextToken();
            }
            catch (Exception e) {
                throw new XQERuntimeException(XQEMessageKeys.DAT_DataSourceAdapterError, (Throwable)e, e.toString());
            }
            ++this.nRows;
            this.jObject = null;
            return this.row;
        }

        @Override
        public Object nextBatch() {
            if (this.context.isCanceled()) {
                throw new OperationCanceledException(this.context.getCancelSource());
            }
            if (this.eod) {
                this.batch.eod = true;
                return this.batch;
            }
            this.batch.reset();
            ColumnVector[] columns = this.batch.columns;
            int size = 0;
            for (int i = 0; i < this.batch.maxBatchSize; ++i) {
                IRow nextRow = (IRow)this.nextImpl();
                if (nextRow == null) {
                    this.eod = true;
                    break;
                }
                for (int j = 0; j < ODataTabularResult.this.rowsetInfo.getNumColumns(); ++j) {
                    Value value = (Value)nextRow.getColumn(j);
                    ColumnVector vector = columns[j];
                    if (value.isNull()) {
                        vector.isNull[i] = true;
                        vector.noNulls = false;
                        continue;
                    }
                    vector.assign(i, value);
                }
                ++size;
            }
            this.batch.size = size;
            if (this.batch.size == 0) {
                this.batch.eod = true;
            } else {
                this.batch.complete(size);
            }
            return this.batch;
        }

        private JSONObject getNextObject() throws IOException {
            if (ODataTabularResult.this.parser.getCurrentToken() == JsonToken.END_ARRAY) {
                return null;
            }
            JSONObject jsonObject = JSONUtil.parseObject(ODataTabularResult.this.parser);
            return jsonObject;
        }

        private void getValue(Object jObj, IDataType dType, Value value) {
            if (jObj == null) {
                value.setNull();
                return;
            }
            switch (dType.getCCLTypeCode()) {
                case 102: {
                    value.set(((JSONArray)jObj).toArray());
                    break;
                }
                case 104: {
                    this.getStructValue((Map<String, Object>)((JSONObject)jObj), (StructType)value.getDataType(), (StructValue)value);
                    break;
                }
                case 103: {
                    if (this.lazyLoading) {
                        Map jMap = (Map)jObj;
                        jMap = (Map)jMap.get(DEFERRED);
                        ((MultisetValue)value).setDeferredURI((String)jMap.get(URI));
                        break;
                    }
                    this.getMultisetValue(jObj, (MultisetType)value.getDataType(), (MultisetValue)value);
                    break;
                }
                case 59: {
                    value.set(this.getMilliseconds(jObj));
                    break;
                }
                default: {
                    value.set(jObj);
                }
            }
        }

        private void getStructValue(Map<String, Object> jMap, StructType dType, StructValue sValue) {
            sValue.setNotNull();
            for (int j = 0; j < dType.getNumberColumns(); ++j) {
                Value value = (Value)sValue.getColumn(j);
                Object jObj = jMap.get(dType.getFieldName(j));
                this.getValue(jObj, dType.getFieldDataType(j), value);
            }
        }

        private void getMultisetValue(Object jObj, MultisetType dType, MultisetValue multisetValue) {
            Object results;
            multisetValue.clear();
            RowType elementType = (RowType)dType.getElementType();
            if (jObj instanceof JSONObject && (results = ((JSONObject)jObj).get((Object)RESULTS)) != null) {
                jObj = results;
            }
            if (jObj instanceof JSONArray) {
                JSONArray jArray = (JSONArray)jObj;
                for (int i = 0; i < jArray.size(); ++i) {
                    this.getMultisetObject((JSONObject)jArray.get(i), elementType, multisetValue);
                }
            } else {
                this.getMultisetObject((JSONObject)jObj, elementType, multisetValue);
            }
        }

        private void getMultisetObject(JSONObject jMap, RowType elementType, MultisetValue multisetValue) {
            RowValue rowValue = (RowValue)elementType.createValue();
            for (int j = 0; j < elementType.getNumberColumns(); ++j) {
                Value value = (Value)rowValue.getColumn(j);
                Object jObj = jMap.get((Object)elementType.getFieldName(j));
                this.getValue(jObj, elementType.getFieldDataType(j), value);
            }
            multisetValue.add(rowValue);
        }

        private long getMilliseconds(Object jValue) {
            String str = jValue.toString();
            String arg = str.substring(str.indexOf("(") + 1, str.indexOf(")"));
            return Long.valueOf(arg);
        }

        @Override
        public long getIndex() {
            return -1L;
        }

        public IDataType getDataType() {
            return ODataTabularResult.this.rowsetInfo.getDataType();
        }

        @Override
        public void release() {
            try {
                if (this.mReleased.compareAndSet(false, true)) {
                    ReleasableResourceTracker parentTracker = ODataTabularResult.this.getResourceTracker();
                    parentTracker.removeInstance(this);
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }
}

