/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.xqe.resultsdk.util;

import com.cognos.xqe.config.ServiceEnumeration;
import com.cognos.xqe.config.XQEConfiguration;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.trace.XQELog;
import com.cognos.xqe.trace.XQELogger;
import com.ibm.cognos.xqe.resultsdk.IPostProcessingFilter;
import com.ibm.cognos.xqe.resultsdk.wrapper.XQELoggerWrapper;

public class PostProcessingFilterLoader {
    private static XQELogger sLogger = XQELog.getLogger(ServiceEnumeration.XQE, "XQE", "ResultSDK", LogLevel.TRACE);
    private static IPostProcessingFilter sPostProcessingFilter = null;
    private static String sCustomTraceDirName = null;

    public static IPostProcessingFilter getPostProcessingFilter() {
        return sPostProcessingFilter;
    }

    public static void setPostProcessingFilter(IPostProcessingFilter filter) {
        sPostProcessingFilter = filter;
        if (filter != null) {
            XQELoggerWrapper loggerWrapper = new XQELoggerWrapper(sLogger);
            sPostProcessingFilter.initialize(loggerWrapper);
        }
    }

    public static void setupPostProcessingFilter(String postProcessingFilter) throws ClassNotFoundException, IllegalAccessException, InstantiationException {
        Class<?> postProcessingFilterClass = null;
        if (!postProcessingFilter.equals("")) {
            postProcessingFilterClass = Class.forName(postProcessingFilter);
        }
        if (postProcessingFilterClass != null) {
            PostProcessingFilterLoader.setPostProcessingFilter((IPostProcessingFilter)postProcessingFilterClass.newInstance());
        }
    }

    public static void preloadClassesToImproveFirstRunPerformance(XQEConfiguration config, XQELogger initLogger) {
        String postProcessingFilter = config.getStringProperty("general.PostProcessingFilter[@className]", "");
        if (!postProcessingFilter.equals("")) {
            try {
                PostProcessingFilterLoader.setupPostProcessingFilter(postProcessingFilter);
                initLogger.log(LogLevel.INFO, "Post processing filter " + postProcessingFilter + " loaded successfully at startup.");
            }
            catch (ClassNotFoundException e) {
                initLogger.log(LogLevel.ERROR, "Exception caught loading post processing filter " + postProcessingFilter + " at startup.This is an expected exception if any post processing filter is defined but not installed.");
            }
            catch (IllegalAccessException e) {
                initLogger.log(LogLevel.ERROR, "IllegalAccessException caught instanciating post processing filter " + postProcessingFilter);
            }
            catch (InstantiationException e) {
                initLogger.log(LogLevel.ERROR, "InstantiationException caught instanciating post processing filter " + postProcessingFilter);
            }
        }
    }

    public static void clearPostProcessingFilterInfo() {
        PostProcessingFilterLoader.setPostProcessingFilter(null);
    }

    public static void setCustomTraceDirName(String traceDirName) {
        sCustomTraceDirName = traceDirName;
    }

    public static String getCustomTraceDirName() {
        return sCustomTraceDirName;
    }
}

