/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.xqe.resultsdk.wrapper;

import com.cognos.xqe.resultsets.md.XCellIterator;
import com.cognos.xqe.runtree.XScrollableCellIterator;
import com.cognos.xqe.trace.XQETrace;
import com.ibm.cognos.xqe.resultsdk.ICell;
import com.ibm.cognos.xqe.resultsdk.ICellIterator;
import com.ibm.cognos.xqe.resultsdk.wrapper.V5CellWrapper;
import com.ibm.cognos.xqe.resultsdk.wrapper.V5ResultSetWrapper;
import java.util.Iterator;

class V5CellIteratorWrapper
implements ICellIterator {
    private V5ResultSetWrapper mResultSetWrapper;
    private XScrollableCellIterator mScrollableCellIterator;

    V5CellIteratorWrapper(V5ResultSetWrapper resultSetWrapper) {
        this.mResultSetWrapper = resultSetWrapper;
        if (resultSetWrapper.hasTracingStarted()) {
            XQETrace trace = resultSetWrapper.getTrace();
            resultSetWrapper.startTraceElement();
            trace.beginElement("CellIterator");
        }
    }

    @Override
    public Iterator<ICell> iterator() {
        return new IteratorWrapper();
    }

    @Override
    public ICell byOrdinal(long ordinal) {
        com.cognos.xqe.resultset.interfaces.ICell realCell;
        if (this.mScrollableCellIterator == null) {
            this.mScrollableCellIterator = this.mResultSetWrapper.getV5ResultSet().getScrollableV5CellIterator();
        }
        if ((realCell = this.mScrollableCellIterator.byOrdinal(ordinal)) != null) {
            return new V5CellWrapper(this.mResultSetWrapper, realCell);
        }
        return null;
    }

    private class IteratorWrapper
    implements Iterator<ICell> {
        private XCellIterator mCellIterator;

        IteratorWrapper() {
            this.mCellIterator = V5CellIteratorWrapper.this.mResultSetWrapper.getV5ResultSet().getV5CellIterator();
        }

        @Override
        public boolean hasNext() {
            return this.mCellIterator.hasNext();
        }

        @Override
        public ICell next() {
            com.cognos.xqe.resultset.interfaces.ICell realCell = this.mCellIterator.next();
            if (realCell != null) {
                return new V5CellWrapper(V5CellIteratorWrapper.this.mResultSetWrapper, realCell);
            }
            return null;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

