/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.data.providers.olap.tm1;

import com.cognos.xqe.data.providers.olap.tm1.TM1Connection;
import com.cognos.xqe.data.providers.olap.tm1.TM1DataProvider;
import com.cognos.xqe.data.providers.olap.tm1.TM1Log;
import com.cognos.xqe.exception.XQEMessage;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.pool.connection.ConnectionParameters;
import com.cognos.xqe.pool.connection.IConnectionFactory;
import com.cognos.xqe.pool.connection.IPooledConnection;
import com.cognos.xqe.trace.LogLevel;
import java.util.List;

public class TM1ConnectionFactory
implements IConnectionFactory {
    private TM1DataProvider dataProvider;

    public TM1ConnectionFactory(TM1DataProvider provider) {
        this.dataProvider = provider;
        TM1Log.TM1LogWrapper.log(TM1Log.CONN_FACTORY, LogLevel.TRACE, "TM1ConnectionFactory(): constructed", new Object[0]);
    }

    public void destroyConnection(IPooledConnection pooledConnection) {
        this.destroyConnection((TM1Connection)((Object)pooledConnection.getConnection()));
    }

    public void destroyConnection(TM1Connection connection) {
        if (null == connection) {
            TM1Log.TM1LogWrapper.log(TM1Log.CONN_FACTORY, LogLevel.TRACE, "TM1ConnectionFactory.destroyConnection(): There is no connection to destroy.", new Object[0]);
        } else {
            TM1Log.TM1LogWrapper.log(TM1Log.CONN_FACTORY, LogLevel.TRACE, "TM1ConnectionFactory.destroyConnection(): %s.", connection.toString());
            connection.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object createConnection(ConnectionParameters connectionParameters) {
        TM1Connection connection;
        block11: {
            block10: {
                connection = null;
                try {
                    TM1Log.TM1LogWrapper.log(TM1Log.CONN_FACTORY, LogLevel.TRACE, "TM1ConnectionFactory.createConnection(): attempting to create a connection.", new Object[0]);
                    connection = new TM1Connection(this.dataProvider, connectionParameters);
                    if (null != connection) break block10;
                }
                catch (Throwable throwable) {
                    if (null == connection) {
                        TM1Log.TM1LogWrapper.log(TM1Log.CONN_FACTORY, LogLevel.TRACE, "TM1ConnectionFactory.createConnection(): failed.", new Object[0]);
                    } else {
                        TM1Log.TM1LogWrapper.log(TM1Log.CONN_FACTORY, LogLevel.TRACE, "TM1ConnectionFactory.createConnection(): passed %s.", connection.toString());
                        List<XQEMessage> blackList = connection.getConnectionBlackListDetails();
                        if (!blackList.isEmpty()) {
                            this.destroyConnection(connection);
                            connection = null;
                            XQEMessage message = blackList.get(0);
                            if (XQEMessageKeys.DS_DriverBlacklistedTestConnectionUI == message.getMessageKey()) {
                                TM1Log.TM1LogWrapper.log(TM1Log.CONN_FACTORY, LogLevel.ERROR, "TM1ConnectionFactory.createConnection(): The driver version %s is black listed.", message.getParams()[0]);
                                throw new XQERuntimeException(XQEMessageKeys.DS_DriverBlacklistedTestConnectionUI, message.getParams()[0], message.getParams()[1]);
                            }
                            if (XQEMessageKeys.DS_ServerBlacklistedTestConnectionUI2 == message.getMessageKey()) {
                                TM1Log.TM1LogWrapper.log(TM1Log.CONN_FACTORY, LogLevel.ERROR, "TM1ConnectionFactory.createConnection(): The server version %s is black listed.", message.getParams()[1]);
                                throw new XQERuntimeException(XQEMessageKeys.DS_ServerBlacklistedTestConnectionUI2, message.getParams()[0], message.getParams()[1]);
                            }
                            throw new XQERuntimeException(XQEMessageKeys.GEN_FoundInternalError_INTERNAL);
                        }
                    }
                    throw throwable;
                }
                TM1Log.TM1LogWrapper.log(TM1Log.CONN_FACTORY, LogLevel.TRACE, "TM1ConnectionFactory.createConnection(): failed.", new Object[0]);
                break block11;
            }
            TM1Log.TM1LogWrapper.log(TM1Log.CONN_FACTORY, LogLevel.TRACE, "TM1ConnectionFactory.createConnection(): passed %s.", connection.toString());
            List<XQEMessage> blackList = connection.getConnectionBlackListDetails();
            if (!blackList.isEmpty()) {
                this.destroyConnection(connection);
                connection = null;
                XQEMessage message = blackList.get(0);
                if (XQEMessageKeys.DS_DriverBlacklistedTestConnectionUI == message.getMessageKey()) {
                    TM1Log.TM1LogWrapper.log(TM1Log.CONN_FACTORY, LogLevel.ERROR, "TM1ConnectionFactory.createConnection(): The driver version %s is black listed.", message.getParams()[0]);
                    throw new XQERuntimeException(XQEMessageKeys.DS_DriverBlacklistedTestConnectionUI, message.getParams()[0], message.getParams()[1]);
                }
                if (XQEMessageKeys.DS_ServerBlacklistedTestConnectionUI2 == message.getMessageKey()) {
                    TM1Log.TM1LogWrapper.log(TM1Log.CONN_FACTORY, LogLevel.ERROR, "TM1ConnectionFactory.createConnection(): The server version %s is black listed.", message.getParams()[1]);
                    throw new XQERuntimeException(XQEMessageKeys.DS_ServerBlacklistedTestConnectionUI2, message.getParams()[0], message.getParams()[1]);
                }
                throw new XQERuntimeException(XQEMessageKeys.GEN_FoundInternalError_INTERNAL);
            }
        }
        return connection;
    }
}

