/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.data.providers.olap.tm1.connection;

import com.cognos.xqe.data.providers.connection.parameters.CubeParameter;
import com.cognos.xqe.data.providers.connection.parameters.UserClassIDsParameter;
import com.cognos.xqe.data.providers.olap.DefaultConnection;
import com.cognos.xqe.data.providers.olap.tm1.TM1Connection;
import com.cognos.xqe.data.providers.olap.tm1.TM1Log;
import com.cognos.xqe.data.providers.olap.tm1.connection.MetadataCacheContext;
import com.cognos.xqe.data.providers.olap.tm1.connection.TM1PasswordParameter;
import com.cognos.xqe.data.providers.olap.tm1.connection.TM1UserNameParameter;
import com.cognos.xqe.data.providers.olap.tm1.metadata.TM1CubeCache;
import com.cognos.xqe.pool.connection.ConnectionParameters;
import com.cognos.xqe.pool.connection.IConnectionParameter;
import com.cognos.xqe.pool.connection.IConnectionSelector;
import com.cognos.xqe.pool.connection.IPooledConnection;
import com.cognos.xqe.pool.connection.ISelectorContext;
import com.cognos.xqe.query.engine.ExecutionEnvironment;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.util.context.ExecutionEnvironmentContext;

public class TM1ConnectionSelector
implements IConnectionSelector {
    private static final long VALIDATION_PERIOD = 10000L;

    public TM1ConnectionSelector() {
    }

    public TM1ConnectionSelector(Object securityContext) {
    }

    public IConnectionSelector.ReturnCode selectConnection(ConnectionParameters connectionParameters, ISelectorContext context, IPooledConnection pooledConnection) {
        String cubeName;
        DefaultConnection connection = (DefaultConnection)pooledConnection.getConnection();
        Integer connectionId = System.identityHashCode(connection);
        ConnectionParameters poolParameters = connection.getConnectionParameters();
        TM1Log.TM1LogWrapper.log(TM1Log.CONN_SELECTOR, LogLevel.TRACE, "[CONNECTION_ID=%d] Selecting connection parameters are connection [%s] and selection [%s].", connectionId, poolParameters, connectionParameters);
        int pass = -1;
        if (null != context) {
            pass = context.getSelectionPass();
        }
        if (!poolParameters.matches(connectionParameters)) {
            TM1Log.TM1LogWrapper.log(TM1Log.CONN_SELECTOR, LogLevel.TRACE, "[CONNECTION_ID=%d] Connection initial match pass=%d failed.", connectionId, pass);
            return IConnectionSelector.ReturnCode.NOT_MATCH;
        }
        TM1Log.TM1LogWrapper.log(TM1Log.CONN_SELECTOR, LogLevel.TRACE, "[CONNECTION_ID=%d] Connection initial match pass=%d passed.", connectionId, pass);
        if (null != context && 1 == context.getSelectionPass() && null != (cubeName = (String)connectionParameters.valueOf(CubeParameter.class, String.class))) {
            Object[] ctx = connection.getContext();
            boolean isCubeLoaded = false;
            if (ctx != null) {
                for (Object c : ctx) {
                    if (!(c instanceof MetadataCacheContext)) continue;
                    isCubeLoaded = ((MetadataCacheContext)c).isCubeLoaded(cubeName);
                }
            }
            if (!isCubeLoaded) {
                TM1Log.TM1LogWrapper.log(TM1Log.CONN_SELECTOR, LogLevel.TRACE, "[CONNECTION_ID=%d] Skipping this connection on the first pass, metadata for cube [%s] is not loaded.", connectionId, cubeName);
                return IConnectionSelector.ReturnCode.NEXT_PASS;
            }
        }
        boolean matches = false;
        UserClassIDsParameter paramUserGroups = (UserClassIDsParameter)connectionParameters.get(UserClassIDsParameter.class);
        UserClassIDsParameter pooledConnUserGroups = (UserClassIDsParameter)poolParameters.get(UserClassIDsParameter.class);
        if (paramUserGroups != null) {
            if (null != pooledConnUserGroups) {
                TM1Log.TM1LogWrapper.log(TM1Log.CONN_SELECTOR, LogLevel.TRACE, "[CONNECTION_ID=%d] Matching user groups: connection=[%s] and request=[%s].", connectionId, pooledConnUserGroups, paramUserGroups);
                matches = paramUserGroups.matches((IConnectionParameter)pooledConnUserGroups);
            }
        } else if (pooledConnUserGroups != null) {
            TM1Log.TM1LogWrapper.log(TM1Log.CONN_SELECTOR, LogLevel.WARN, "[CONNECTION_ID=%d] Incoming request has no user groups.  Need to retrieve them first.", connectionId);
            UserClassIDsParameter ucids = TM1Connection.addStaticUserGroups(connectionParameters);
            matches = pooledConnUserGroups.matches((IConnectionParameter)ucids);
        } else {
            TM1UserNameParameter luid = (TM1UserNameParameter)connectionParameters.get(TM1UserNameParameter.class);
            TM1UserNameParameter ruid = (TM1UserNameParameter)poolParameters.get(TM1UserNameParameter.class);
            TM1Log.TM1LogWrapper.log(TM1Log.CONN_SELECTOR, LogLevel.TRACE, "[CONNECTION_ID=%d] Matching user names [%s] and [%s].", new Object[]{connectionId, luid, ruid});
            if (luid == null && ruid == null) {
                matches = true;
            } else if (luid != null && ruid != null && luid.matches((IConnectionParameter)ruid)) {
                TM1PasswordParameter lpwd = (TM1PasswordParameter)connectionParameters.get(TM1PasswordParameter.class);
                TM1PasswordParameter rpwd = (TM1PasswordParameter)poolParameters.get(TM1PasswordParameter.class);
                if (null == lpwd && null == rpwd) {
                    matches = true;
                } else if (null != lpwd && null != rpwd && lpwd.matches((IConnectionParameter)rpwd)) {
                    matches = true;
                }
            }
        }
        boolean isValid = true;
        if (connection instanceof TM1Connection) {
            TM1CubeCache cubeCache;
            TM1Connection tm1Connection = (TM1Connection)connection;
            long connRtnTime = pooledConnection.getLastReturnedTimeMillis();
            long current = System.currentTimeMillis();
            if (current - connRtnTime >= 10000L) {
                tm1Connection.setValidationOn();
            }
            if (matches && null != (cubeCache = tm1Connection.getCubeCache())) {
                ExecutionEnvironment execEnv = (ExecutionEnvironment)ExecutionEnvironmentContext.getExecutionEnvironment();
                cubeCache.checkStaleCubes(execEnv);
            }
        } else {
            isValid = connection.isValid();
        }
        if (matches && !isValid) {
            connection.invalidate();
            matches = false;
            TM1Log.TM1LogWrapper.log(TM1Log.CONN_SELECTOR, LogLevel.TRACE, "[CONNECTION_ID=%d] Detected an invalid connection and marked it as non-reusable.", connectionId);
        }
        if (matches) {
            TM1Log.TM1LogWrapper.log(TM1Log.CONN_SELECTOR, LogLevel.TRACE, "[CONNECTION_ID=%d] Matched connection.", connectionId);
            return IConnectionSelector.ReturnCode.MATCH;
        }
        TM1Log.TM1LogWrapper.log(TM1Log.CONN_SELECTOR, LogLevel.TRACE, "[CONNECTION_ID=%d] Rejected connection.", connectionId);
        return IConnectionSelector.ReturnCode.NOT_MATCH;
    }
}

