/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.data.providers.olap.tm1.data;

import com.cognos.xqe.data.providers.olap.tm1.data.TM1CellFormatParser;
import com.cognos.xqe.data.providers.olap.tm1.data.TM1FormatInfo;
import com.cognos.xqe.format.FormatPropertyDefinition;
import com.cognos.xqe.format.FormatPropertySet;
import com.cognos.xqe.format.FormatService;
import com.cognos.xqe.format.string.IFormatInfo;
import com.ibm.cognos.aurora.api.format.ICurrencyValueFormat;
import com.ibm.cognos.aurora.api.format.INumberValueFormat;
import com.ibm.cognos.aurora.api.format.INumericValueFormat;
import com.ibm.cognos.aurora.api.format.IPercentValueFormat;
import com.ibm.cognos.aurora.api.format.IValueFormat;
import com.ibm.cognos.aurora.api.model.datatype.DoubleType;
import com.ibm.cognos.aurora.api.model.datatype.IDataType;
import com.ibm.cognos.qls.format.QLSFormatService;
import com.ibm.cognos.qls.format.exception.InvalidFormatPatternException;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class EnhancedTM1CellFormatParser
extends TM1CellFormatParser {
    private static final Pattern TRAILING_HASH_DECIMAL = Pattern.compile("(\\.)?(.*)#$");
    private static final char GROUPING_DELIMITER_DEFAULT = ',';
    private static final char DECIMAL_DELIMITER_DEFAULT = '.';
    private static final String EXPONENT_SYMBOL_DEFAULT = "E";
    private static final String PERCENT_SYMBOL_DEFAULT = "%";
    private static final int PERCENT_SCALE_DEFAULT = 100;
    private static final String ZERO_SYMBOL_DEFAULT = "0";
    private static final String NULL_SYMBOL_DEFAULT = "";
    private static final String SIGN_DEFAULT = "-";
    private static final IDataType DOUBLE_TYPE = new DoubleType();

    public EnhancedTM1CellFormatParser(FormatService service) {
        super(service);
    }

    @Override
    public FormatPropertySet parseFormat(IFormatInfo info, Locale locale) throws Exception {
        byte decimalSize;
        TM1FormatInfo tm1Info = (TM1FormatInfo)info;
        String tm1FormatString = tm1Info.getFormatString();
        if (this.useDeprecatedFormatParser(tm1FormatString)) {
            return super.parseFormat(tm1Info, locale);
        }
        IValueFormat formatter = null;
        try {
            formatter = this.getFormatter(tm1FormatString, locale);
        }
        catch (InvalidFormatPatternException e) {
            return super.parseFormat(tm1Info, locale);
        }
        if (formatter == null || !(formatter instanceof INumericValueFormat)) {
            return super.parseFormat(tm1Info, locale);
        }
        FormatPropertySet set = new FormatPropertySet(this.mService);
        INumericValueFormat numericValueFormat = (INumericValueFormat)formatter;
        set.addPropertyValue(FormatPropertyDefinition.createPropertyValue((FormatService)this.mService, (String)"useGrouping", (Object)numericValueFormat.isUseGrouping()));
        if (numericValueFormat.isUseGrouping() && numericValueFormat.getGroupDelimiter() != ',') {
            set.addPropertyValue(FormatPropertyDefinition.createPropertyValue((FormatService)this.mService, (String)"groupDelimiter", (Object)Character.valueOf(numericValueFormat.getGroupDelimiter())));
        }
        if ((decimalSize = this.getDecimalSize(numericValueFormat)) > -1) {
            set.addPropertyValue(FormatPropertyDefinition.createPropertyValue((FormatService)this.mService, (String)"decimalSize", (Object)decimalSize));
        }
        if (numericValueFormat.getDecimalDelimiter() != '.') {
            set.addPropertyValue(FormatPropertyDefinition.createPropertyValue((FormatService)this.mService, (String)"decimalDelimiter", (Object)Character.valueOf(numericValueFormat.getDecimalDelimiter())));
        }
        if (numericValueFormat.getWhenZero() != null && !numericValueFormat.getWhenZero().equals(ZERO_SYMBOL_DEFAULT)) {
            set.addPropertyValue(FormatPropertyDefinition.createPropertyValue((FormatService)this.mService, (String)"whenZero", (Object)numericValueFormat.getWhenZero()));
        }
        if (numericValueFormat.getWhenNull() != null && !numericValueFormat.getWhenNull().equals(NULL_SYMBOL_DEFAULT)) {
            set.addPropertyValue(FormatPropertyDefinition.createPropertyValue((FormatService)this.mService, (String)"whenMissing", (Object)numericValueFormat.getWhenNull()));
        }
        this.setLocale(set, locale);
        switch (formatter.getValueFormatCategory()) {
            case ICurrencyValueFormat: {
                set.setFormatType("currencyFormat");
                ICurrencyValueFormat currencyValueFormat = (ICurrencyValueFormat)formatter;
                if (this.isBuildInFormat(formatter.getDsFormatString())) {
                    set.addPropertyValue(FormatPropertyDefinition.createPropertyValue((FormatService)this.mService, (String)"currencySymbol", (Object)currencyValueFormat.getCurrencySymbol()));
                } else if (currencyValueFormat.getUseTrailingSymbol().equals("Y")) {
                    set.addPropertyValue(FormatPropertyDefinition.createPropertyValue((FormatService)this.mService, (String)"useTrailingSymbol", (Object)true));
                    set.addPropertyValue(FormatPropertyDefinition.createPropertyValue((FormatService)this.mService, (String)"currencySymbol", (Object)currencyValueFormat.getPositiveSuffix()));
                } else {
                    set.addPropertyValue(FormatPropertyDefinition.createPropertyValue((FormatService)this.mService, (String)"currencySymbol", (Object)currencyValueFormat.getPositivePrefix()));
                }
                this.setSign(numericValueFormat, set, currencyValueFormat.getPositivePrefix(), currencyValueFormat.getPositiveSuffix());
                break;
            }
            case IPercentValueFormat: {
                set.setFormatType("percentFormat");
                IPercentValueFormat percentValueFormat = (IPercentValueFormat)formatter;
                String percentSymbol = percentValueFormat.getPercentSymbol();
                if (this.isBuildInFormat(formatter.getDsFormatString())) {
                    if (!percentSymbol.equals(PERCENT_SYMBOL_DEFAULT)) {
                        set.addPropertyValue(FormatPropertyDefinition.createPropertyValue((FormatService)this.mService, (String)"percentSymbol", (Object)percentSymbol));
                    }
                } else if (percentValueFormat.getPositiveSuffix() != null && !percentValueFormat.getPositiveSuffix().isEmpty() && percentValueFormat.getPositiveSuffix().contains(percentSymbol)) {
                    if (!percentValueFormat.getPositiveSuffix().equals(PERCENT_SYMBOL_DEFAULT)) {
                        set.addPropertyValue(FormatPropertyDefinition.createPropertyValue((FormatService)this.mService, (String)"percentSymbol", (Object)percentValueFormat.getPositiveSuffix()));
                    }
                } else if (percentValueFormat.getPositivePrefix().contains(percentSymbol) && !percentValueFormat.getPositivePrefix().equals(PERCENT_SYMBOL_DEFAULT)) {
                    set.addPropertyValue(FormatPropertyDefinition.createPropertyValue((FormatService)this.mService, (String)"percentSymbol", (Object)percentValueFormat.getPositivePrefix()));
                }
                if (percentValueFormat.getPercentScale() != 100) {
                    set.addPropertyValue(FormatPropertyDefinition.createPropertyValue((FormatService)this.mService, (String)"percentScale", (Object)percentValueFormat.getPercentScale()));
                }
                this.setSign(numericValueFormat, set, percentValueFormat.getPositivePrefix(), percentValueFormat.getPositiveSuffix());
                break;
            }
            case INumberValueFormat: {
                String unitOfMeasure;
                set.setFormatType("numberFormat");
                INumberValueFormat numberValueFormat = (INumberValueFormat)formatter;
                if (numberValueFormat.isUseScientific()) {
                    set.addPropertyValue(FormatPropertyDefinition.createPropertyValue((FormatService)this.mService, (String)"useScientific", (Object)numberValueFormat.isUseScientific()));
                    if (!numberValueFormat.getExponentSymbol().equals(EXPONENT_SYMBOL_DEFAULT)) {
                        set.addPropertyValue(FormatPropertyDefinition.createPropertyValue((FormatService)this.mService, (String)"exponentSymbol", (Object)((INumberValueFormat)formatter).getExponentSymbol()));
                    }
                }
                if (!(unitOfMeasure = this.getUnitOfMeasure(numericValueFormat)).isEmpty()) {
                    set.addPropertyValue(FormatPropertyDefinition.createPropertyValue((FormatService)this.mService, (String)"unitOfMeasure", (Object)unitOfMeasure));
                }
                this.setSign(numericValueFormat, set, this.getPrefix((INumericValueFormat)numberValueFormat), unitOfMeasure);
                break;
            }
            default: {
                set.setFormatType("numberFormat");
            }
        }
        return set;
    }

    private void setSign(INumericValueFormat numericValueFormat, FormatPropertySet set, String leadingSymbol, String trailingSymbol) {
        if (numericValueFormat.getUseParentheses().equals("Y")) {
            set.addPropertyValue(FormatPropertyDefinition.createPropertyValue((FormatService)this.mService, (String)"sign", (Object)"()"));
            return;
        }
        if (this.isBuildInFormat(numericValueFormat.getDsFormatString())) {
            return;
        }
        String negativePrefix = numericValueFormat.getNegativePrefix();
        String negativeSuffix = numericValueFormat.getNegativeSuffix();
        Pattern leadingSymbolPattern = Pattern.compile(leadingSymbol, 16);
        if (negativePrefix != null) {
            negativePrefix = leadingSymbolPattern.matcher(negativePrefix).replaceAll(NULL_SYMBOL_DEFAULT);
        }
        if (negativePrefix != null && !negativePrefix.isEmpty() && !negativePrefix.equals(numericValueFormat.getPositivePrefix())) {
            if (!negativePrefix.equals(SIGN_DEFAULT)) {
                set.addPropertyValue(FormatPropertyDefinition.createPropertyValue((FormatService)this.mService, (String)"sign", (Object)negativePrefix));
            }
            return;
        }
        Pattern trailingSymbolPattern = Pattern.compile(trailingSymbol, 16);
        if (negativeSuffix != null) {
            negativeSuffix = trailingSymbolPattern.matcher(negativeSuffix).replaceAll(NULL_SYMBOL_DEFAULT);
        }
        if (negativeSuffix != null && !negativeSuffix.isEmpty() && !negativeSuffix.equals(numericValueFormat.getPositiveSuffix())) {
            if (!negativeSuffix.equals(SIGN_DEFAULT)) {
                set.addPropertyValue(FormatPropertyDefinition.createPropertyValue((FormatService)this.mService, (String)"sign", (Object)negativeSuffix));
            }
            set.addPropertyValue(FormatPropertyDefinition.createPropertyValue((FormatService)this.mService, (String)"useTrailingSign", (Object)true));
        }
    }

    private String getUnitOfMeasure(INumericValueFormat numericValueFormat) {
        if (this.isBuildInFormat(numericValueFormat.getDsFormatString())) {
            return NULL_SYMBOL_DEFAULT;
        }
        String positiveSuffix = numericValueFormat.getPositiveSuffix();
        String negativeSuffix = numericValueFormat.getNegativeSuffix();
        if (positiveSuffix == null || positiveSuffix.isEmpty()) {
            return NULL_SYMBOL_DEFAULT;
        }
        if (negativeSuffix == null || negativeSuffix.isEmpty()) {
            return NULL_SYMBOL_DEFAULT;
        }
        if (!negativeSuffix.endsWith(positiveSuffix)) {
            return NULL_SYMBOL_DEFAULT;
        }
        return numericValueFormat.getPositiveSuffix();
    }

    private String getPrefix(INumericValueFormat numericValueFormat) {
        if (this.isBuildInFormat(numericValueFormat.getDsFormatString())) {
            return NULL_SYMBOL_DEFAULT;
        }
        String positivePrefix = numericValueFormat.getPositivePrefix();
        String negativePrefix = numericValueFormat.getNegativePrefix();
        if (positivePrefix == null || positivePrefix.isEmpty()) {
            return NULL_SYMBOL_DEFAULT;
        }
        if (negativePrefix == null || negativePrefix.isEmpty()) {
            return NULL_SYMBOL_DEFAULT;
        }
        if (!negativePrefix.endsWith(positivePrefix)) {
            return NULL_SYMBOL_DEFAULT;
        }
        return positivePrefix;
    }

    private void setLocale(FormatPropertySet set, Locale locale) {
        String localeStr = null;
        localeStr = locale.getCountry().length() > 0 ? String.format("%s-%s", locale.getLanguage(), locale.getCountry().toLowerCase()) : locale.getLanguage();
        set.addPropertyValue(FormatPropertyDefinition.createPropertyValue((FormatService)this.mService, (String)"xml:lang", (Object)localeStr));
    }

    private byte getDecimalSize(INumericValueFormat formatter) {
        Matcher m;
        if (formatter.getDecimalSize() == 0) {
            return 0;
        }
        String pattern = formatter.getICUFormatPattern();
        String[] sections = formatter.getICUFormatPattern().split(Pattern.quote(";"));
        if (sections.length > 1) {
            pattern = sections[0];
        }
        if ((m = TRAILING_HASH_DECIMAL.matcher(pattern)).matches()) {
            return -1;
        }
        return formatter.getDecimalSize();
    }

    private boolean isBuildInFormat(String pattern) {
        return pattern.contains("\f");
    }

    private boolean useDeprecatedFormatParser(String formatString) {
        return formatString.startsWith("dddd, mmmm dd, yyyy") || formatString.startsWith("mmmm dd, yyyy") || formatString.startsWith("dddd, dd mmmm, yyyy") || formatString.startsWith("dd mmmm, yyyy") || formatString.startsWith("h:nn:ss AMPM") || formatString.startsWith("hh:nn:ss AMPM") || formatString.startsWith("h:nn:ss") || formatString.startsWith("hh:nn:ss") || formatString.contains(";()") || formatString.equals("const");
    }

    public IValueFormat getFormatter(String tm1FormatString, Locale locale) throws InvalidFormatPatternException {
        return QLSFormatService.getInstance().buildFormatInstance(tm1FormatString, DOUBLE_TYPE, locale);
    }
}

