/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.data.providers.olap.tm1.data;

import com.cognos.xqe.data.providers.ProviderIteratorBase;
import com.cognos.xqe.data.providers.ProviderResultSetBase;
import com.cognos.xqe.data.providers.olap.tm1.TM1MessageKeys;
import com.cognos.xqe.data.providers.olap.tm1.TM1ODPException;
import com.cognos.xqe.data.providers.olap.tm1.data.TM1CubeResultSet;
import com.cognos.xqe.data.providers.olap.tm1.metadata.TM1Member;
import com.cognos.xqe.data.providers.olap.tm1.util.ITM1RowsetView;
import com.cognos.xqe.data.providers.olap.tm1.util.TM1ExceptionConverter;
import com.cognos.xqe.data.providers.olap.tm1.util.TM1RowsetAccessor;
import com.cognos.xqe.data.providers.olap.tm1.util.TM1Utils;
import com.cognos.xqe.data.types.BooleanType;
import com.cognos.xqe.data.types.DataTypeFactory;
import com.cognos.xqe.data.values.DataValueFactory;
import com.cognos.xqe.data.values.StringValue;
import com.cognos.xqe.data.values.Value;
import com.cognos.xqe.data.values.ValueState;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.metadata.ICube;
import com.cognos.xqe.metadata.IDimension;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.metadata.ILevel;
import com.cognos.xqe.metadata.IMember;
import com.cognos.xqe.metadata.IProperty;
import com.cognos.xqe.metadata.RoleTypeEnum;
import com.cognos.xqe.metadata.provider.Member;
import com.cognos.xqe.resultset.interfaces.ITuple;
import com.cognos.xqe.resultsets.md.Tuple;
import com.cognos.xqe.runtree.XDataContext;
import com.cognos.xqe.util.ArrayCast;
import com.cognos.xqe.util.UniqueNameGenerator;
import com.ibm.cognos.tm1.Axis;
import com.ibm.cognos.tm1.FieldType;
import com.ibm.cognos.tm1.Rowset;
import com.ibm.cognos.tm1.TM1Exception;

public class TM1AxisIterator
extends ProviderIteratorBase {
    private final Axis mAxis;
    private final Rowset mRowset;
    private final IDimension[] mDimensions;
    private final String[] mCommonMUNPrefixes;
    private final TM1RowsetAccessor<TM1Member.TM1MemberFields> mRowsetAccessor;
    private final ITM1RowsetView<TM1Member.TM1MemberFields>[] mRowsetViews;
    private static final String EMPTY_STRING = "";

    public TM1AxisIterator(TM1CubeResultSet rs, Axis axis, XDataContext xDataContext, Integer nodeId) throws TM1Exception {
        super((ProviderResultSetBase)rs, xDataContext, nodeId);
        this.mAxis = axis;
        this.mRowset = this.mAxis.getTupleRowset();
        ICube cube = rs.getCube();
        String[] dimNames = this.mAxis.getDimensionNames();
        this.mDimensions = new IDimension[dimNames.length];
        this.mCommonMUNPrefixes = new String[dimNames.length];
        this.mRowsetViews = (ITM1RowsetView[])ArrayCast.uncheckedCast((Object[])new ITM1RowsetView[dimNames.length]);
        this.mRowsetAccessor = TM1RowsetAccessor.create(this.mRowset, TM1Member.TM1MemberFields.class);
        for (int i = 0; i < dimNames.length; ++i) {
            String dun = UniqueNameGenerator.createSingleNamePart((String)dimNames[i]);
            this.mDimensions[i] = cube.getDimension(dun);
            if (null == this.mDimensions[i]) {
                throw new XQERuntimeException(TM1MessageKeys.MET_NONEXISTANT_DIMENSION, dun);
            }
            this.mCommonMUNPrefixes[i] = TM1Utils.createCommonMUNPrefix(this.mDimensions[i]);
            this.mRowsetViews[i] = this.mRowsetAccessor.createQualifiedView(dimNames[i]);
        }
    }

    public Object nextImpl() {
        if (this.mDimensions.length == 0) {
            return null;
        }
        try {
            if (!this.mRowset.getNext()) {
                return null;
            }
            ++this.currentIndex;
            return this.readTuple();
        }
        catch (TM1Exception ex) {
            throw TM1ExceptionConverter.convert(ex);
        }
    }

    private ITuple readTuple() throws TM1Exception {
        IMember[] members = new IMember[this.mDimensions.length];
        for (int i = 0; i < this.mDimensions.length; ++i) {
            members[i] = this.readMember(i);
        }
        return new Tuple(members);
    }

    private IMember readMember(int tupleIndex) throws TM1Exception {
        int levelNumber;
        ILevel level;
        IDimension dimension = this.mDimensions[tupleIndex];
        IHierarchy hierarchy = dimension.getDefaultHierarchy();
        String commonMUNPrefix = this.mCommonMUNPrefixes[tupleIndex];
        ITM1RowsetView<TM1Member.TM1MemberFields> view = this.mRowsetViews[tupleIndex];
        String providerMUN = view.getStringField(TM1Member.TM1MemberFields.MEMBER_UNIQUE_NAME);
        Member member = this.getCachedMember(providerMUN);
        if (null != member) {
            return member;
        }
        member = new Member();
        member.setConnection(dimension.getConnection());
        member.setUniqueName(TM1Utils.convertProviderMUNToMDDSMUN(commonMUNPrefix, providerMUN));
        if (view.containsField(TM1Member.TM1MemberFields.MEMBER_NAME)) {
            member.setName(view.getStringField(TM1Member.TM1MemberFields.MEMBER_NAME));
        }
        if (view.containsField(TM1Member.TM1MemberFields.DESCRIPTION.getFieldName())) {
            member.setDescription(view.getStringField(TM1Member.TM1MemberFields.DESCRIPTION.getFieldName()));
        }
        if (view.containsField(TM1Member.TM1MemberFields.LABEL)) {
            member.setCaption(view.getStringField(TM1Member.TM1MemberFields.LABEL));
        }
        if (null == member.getName()) {
            member.setName(member.getCaption());
        }
        member.setUniqueID(member.getName());
        if (view.containsField(TM1Member.TM1MemberFields.CHILDREN_CARDINALITY)) {
            member.setChildrenCardinality((int)view.getIntegerField(TM1Member.TM1MemberFields.CHILDREN_CARDINALITY));
        }
        String memberKey = null;
        if (view.containsField("MEMBER_KEY")) {
            String value = view.getStringField("MEMBER_KEY");
            member.setProperty("MEMBER_KEY", (Object)value);
            member.setProperty(view.getQualifiedFieldName("MEMBER_KEY"), (Object)value);
            memberKey = value;
        }
        if (null == (level = hierarchy.getLevel(levelNumber = (int)view.getIntegerField(TM1Member.TM1MemberFields.LEVEL_NUMBER)))) {
            throw new TM1ODPException(TM1MessageKeys.MET_LEVEL_NUMBER_NOT_FOUND, Integer.toString(levelNumber), hierarchy.getUniqueName());
        }
        member.setLevel(level);
        StringValue strValue = DataValueFactory.createStringValue();
        strValue.set(EMPTY_STRING);
        member.setBusinessKey((Value)strValue);
        if (null != memberKey) {
            strValue.set(memberKey);
            member.setBusinessKey((Value)strValue);
        } else if (null != member.getName()) {
            strValue.set(member.getName());
            member.setBusinessKey((Value)strValue);
        }
        if (view.containsField(TM1Member.TM1MemberFields.PARENT_UNIQUE_NAME)) {
            member.setParentUniqueName(TM1Utils.convertProviderMUNToMDDSMUN(commonMUNPrefix, view.getStringField(TM1Member.TM1MemberFields.PARENT_UNIQUE_NAME)));
        } else if (view.containsField(TM1Member.TM1MemberFields.PARENT_KEY) && !view.getStringField(TM1Member.TM1MemberFields.PARENT_KEY).isEmpty()) {
            member.setParentUniqueName(TM1Utils.createMDDSMUN(commonMUNPrefix, view.getStringField(TM1Member.TM1MemberFields.PARENT_KEY)));
        }
        if (view.containsField(TM1Member.TM1MemberFields.PARENT_LEVEL.getFieldName()) && view.getFieldType(TM1Member.TM1MemberFields.PARENT_LEVEL.getFieldName()).equals((Object)FieldType.Integer)) {
            member.setParentLevelNumber((int)view.getIntegerField(TM1Member.TM1MemberFields.PARENT_LEVEL.getFieldName()));
        } else {
            member.setParentLevelNumber(member.getLevel().getIndex() - 1);
        }
        block8: for (IProperty prop : level.getMemberProperties()) {
            String propUN = prop.getUniqueName();
            if (!this.mRowsetAccessor.containsField(propUN)) continue;
            Value value = null;
            BooleanType dataType = null;
            FieldType fieldType = this.mRowsetAccessor.getFieldType(propUN);
            switch (fieldType) {
                case Boolean: {
                    dataType = DataTypeFactory.getBooleanType();
                    value = (Value)dataType.createValue();
                    boolean booleanValue = this.mRowsetAccessor.getBooleanField(propUN);
                    value.set(booleanValue);
                    break;
                }
                case Double: {
                    dataType = DataTypeFactory.getDoubleType();
                    value = (Value)dataType.createValue();
                    double doubleValue = this.mRowsetAccessor.getDoubleField(propUN);
                    value.set(doubleValue);
                    break;
                }
                case Integer: {
                    dataType = DataTypeFactory.getIntegerType();
                    value = (Value)dataType.createValue();
                    long integerValue = this.mRowsetAccessor.getIntegerField(propUN);
                    value.set(integerValue);
                    break;
                }
                case String: {
                    String stringValue = this.mRowsetAccessor.getStringField(propUN);
                    if (TM1Utils.isNullString(stringValue)) continue block8;
                    if (TM1Utils.isErrorString(stringValue)) {
                        dataType = DataTypeFactory.getStringType();
                        value = (Value)dataType.createValue();
                        value.setState(ValueState.ERROR);
                        break;
                    }
                    if (TM1Utils.isDivZeroString(stringValue)) {
                        dataType = DataTypeFactory.getDoubleType();
                        value = (Value)dataType.createValue();
                        value.setState(ValueState.DIV_BY_ZERO);
                        break;
                    }
                    dataType = DataTypeFactory.getStringType();
                    value = (Value)dataType.createValue();
                    value.set(stringValue);
                    break;
                }
                case Error: {
                    dataType = DataTypeFactory.getStringType();
                    value = (Value)dataType.createValue();
                    value.setState(ValueState.ERROR);
                    break;
                }
                case Unknown: {
                    dataType = DataTypeFactory.getStringType();
                    value = (Value)dataType.createValue();
                    value.setState(ValueState.UNKNOWN);
                    break;
                }
                default: {
                    continue block8;
                }
            }
            member.setProperty(propUN, (Object)value);
            if (!prop.getRoles().contains(RoleTypeEnum.BUSINESS_KEY)) continue;
            member.setBusinessKey(value);
        }
        this.putCachedMember(member);
        return member;
    }

    private Member getCachedMember(String mun) {
        TM1CubeResultSet rs = (TM1CubeResultSet)this.getResultSet();
        return rs.getCachedMember(mun);
    }

    private void putCachedMember(Member member) {
        TM1CubeResultSet rs = (TM1CubeResultSet)this.getResultSet();
        rs.putCachedMember(member);
    }

    public void releaseImpl() {
        this.mRowset.dispose();
    }
}

