/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.data.providers.olap.tm1.data;

import com.cognos.xqe.data.providers.ProviderCellBase;
import com.cognos.xqe.data.providers.olap.tm1.data.TM1CellFormatParser;
import com.cognos.xqe.data.providers.olap.tm1.data.TM1CellsetFields;
import com.cognos.xqe.data.providers.olap.tm1.data.TM1FormatInfo;
import com.cognos.xqe.data.providers.olap.tm1.util.ITM1RowsetView;
import com.cognos.xqe.data.providers.olap.tm1.util.TM1ExceptionConverter;
import com.cognos.xqe.data.providers.olap.tm1.util.TM1RowsetAccessor;
import com.cognos.xqe.data.providers.olap.tm1.util.TM1Utils;
import com.cognos.xqe.data.types.BooleanType;
import com.cognos.xqe.data.types.DataTypeFactory;
import com.cognos.xqe.data.types.DoubleType;
import com.cognos.xqe.data.types.IntegerType;
import com.cognos.xqe.data.types.LongType;
import com.cognos.xqe.data.types.StringType;
import com.cognos.xqe.data.values.IValue;
import com.cognos.xqe.data.values.Value;
import com.cognos.xqe.data.values.ValueState;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.format.FormatId;
import com.cognos.xqe.format.FormatService;
import com.cognos.xqe.format.string.IFormatInfo;
import com.cognos.xqe.resultset.interfaces.ICell;
import com.ibm.cognos.tm1.CellStatus;
import com.ibm.cognos.tm1.Cellset;
import com.ibm.cognos.tm1.FieldType;
import com.ibm.cognos.tm1.Rowset;
import com.ibm.cognos.tm1.TM1Exception;
import java.util.Locale;

public class TM1ScrollableCellIteratorHelper {
    private final Cellset mCellset;
    private final Locale mLocale;
    private final ITM1RowsetView<TM1CellsetFields> mAccessor;
    private long mCellsetOrdinal = -1L;
    private long mLogicalOrdinal = -1L;
    private ICell mCurrentCell = null;
    private final long mCellsetRowCount;

    public TM1ScrollableCellIteratorHelper(Cellset cellset, Locale locale) throws TM1Exception {
        this.mCellset = cellset;
        this.mCellsetRowCount = this.mCellset.getCount();
        this.mLocale = locale;
        this.mCellset.reset();
        this.mAccessor = TM1RowsetAccessor.create((Rowset)this.mCellset, TM1CellsetFields.class);
    }

    public ICell nextImpl() {
        this.mCurrentCell = null;
        if (this.mCellsetOrdinal == this.mCellsetRowCount) {
            this.updateOrdinals(this.mCellsetRowCount);
            return null;
        }
        if (this.mCellsetOrdinal == this.mLogicalOrdinal && !this.moveToNext()) {
            this.updateOrdinals(this.mCellsetRowCount);
            return null;
        }
        try {
            this.mCurrentCell = this.readCell();
        }
        catch (TM1Exception ex) {
            throw TM1ExceptionConverter.convert(ex);
        }
        this.updateOrdinals(this.mCurrentCell.getOrdinal());
        return this.mCurrentCell;
    }

    public boolean absolute(long index) {
        if (this.mCellset.isForwardOnly()) {
            throw new XQERuntimeException(XQEMessageKeys.GEN_MethodNotImplemented_INTERNAL, "com.cognos.xqe.data.providers.olap.tm1.data.TM1ScrollableCellIterator.absolute(long)");
        }
        if (index == -1L) {
            return this.reset();
        }
        try {
            if (!this.mCellset.seek(index)) {
                return false;
            }
            this.updateOrdinals(index);
            this.mCurrentCell = null;
        }
        catch (TM1Exception ex) {
            throw TM1ExceptionConverter.convert(ex);
        }
        return true;
    }

    public ICell current() {
        if (this.mCurrentCell != null) {
            return this.mCurrentCell;
        }
        if (this.mLogicalOrdinal == -1L || this.mLogicalOrdinal >= this.mCellsetRowCount) {
            return null;
        }
        if (this.mCellsetOrdinal > this.mLogicalOrdinal) {
            return null;
        }
        try {
            this.mCurrentCell = this.readCell();
        }
        catch (TM1Exception ex) {
            throw TM1ExceptionConverter.convert(ex);
        }
        return this.mCurrentCell;
    }

    public boolean reset() {
        if (this.mCellset.isForwardOnly()) {
            throw new XQERuntimeException(XQEMessageKeys.GEN_MethodNotImplemented_INTERNAL, "com.cognos.xqe.data.providers.olap.tm1.data.TM1ScrollableCellIterator.reset()");
        }
        try {
            this.mCellset.reset();
        }
        catch (TM1Exception ex) {
            throw TM1ExceptionConverter.convert(ex);
        }
        this.updateOrdinals(-1L);
        this.mCurrentCell = null;
        return true;
    }

    public boolean hasNext() {
        if (this.mLogicalOrdinal == -1L) {
            return this.moveToNext();
        }
        if (this.mCellsetOrdinal == this.mCellsetRowCount) {
            return false;
        }
        if (this.mCellsetOrdinal > this.mLogicalOrdinal) {
            return true;
        }
        return this.moveToNext();
    }

    public void releaseImpl() {
    }

    long getIndex() {
        return this.mLogicalOrdinal;
    }

    private ICell readCell() throws TM1Exception {
        long rule;
        CellStatus status = this.mCellset.getCellStatus();
        Value value = null;
        if (CellStatus.Null == status) {
            return null;
        }
        FormatId formatId = FormatId.INVALID_FORMAT_FID;
        String formatString = this.mAccessor.getStringField(TM1CellsetFields.FORMAT_STRING);
        FieldType fieldType = this.mAccessor.getFieldType(TM1CellsetFields.VALUE);
        long cellOrdinal = this.mAccessor.getIntegerField(TM1CellsetFields.CELL_ORDINAL);
        FormatService service = FormatService.getInstance();
        if (null != service) {
            TM1FormatInfo info = new TM1FormatInfo(formatString);
            formatId = service.registerTM1CellFormat((IFormatInfo)info, this.mLocale);
        }
        if (CellStatus.Data == status) {
            switch (fieldType) {
                case Boolean: {
                    BooleanType dataType = DataTypeFactory.getBooleanType();
                    value = (Value)dataType.createValue();
                    value.set(this.mAccessor.getBooleanField(TM1CellsetFields.VALUE));
                    break;
                }
                case Double: {
                    double tempValue = this.mAccessor.getDoubleField(TM1CellsetFields.VALUE);
                    String formatTypeName = service.getFormatTypeName(formatId);
                    if (formatId != null && formatTypeName.compareTo("dateFormat") == 0) {
                        int date = TM1CellFormatParser.convertTM1DateTimeToNumericDate(this.mLocale, tempValue);
                        IntegerType dataType = DataTypeFactory.getIntegerType();
                        value = (Value)dataType.createValue();
                        value.set(date);
                        break;
                    }
                    if (formatId != null && formatTypeName.compareTo("timeFormat") == 0) {
                        int time = TM1CellFormatParser.convertTM1DateTimeToNumericTime(tempValue);
                        IntegerType dataType = DataTypeFactory.getIntegerType();
                        value = (Value)dataType.createValue();
                        value.set(time);
                        break;
                    }
                    DoubleType dataType = DataTypeFactory.getDoubleType();
                    value = (Value)dataType.createValue();
                    value.set(tempValue);
                    break;
                }
                case Integer: {
                    LongType dataType = DataTypeFactory.getLongType();
                    value = (Value)dataType.createValue();
                    value.set(this.mAccessor.getIntegerField(TM1CellsetFields.VALUE));
                    break;
                }
                case String: {
                    String strValue = this.mAccessor.getStringField(TM1CellsetFields.VALUE);
                    if (TM1Utils.isNullString(strValue) || TM1Utils.isEmptyString(strValue)) {
                        return null;
                    }
                    if (TM1Utils.isErrorString(strValue)) {
                        StringType dataType = DataTypeFactory.getStringType();
                        value = (Value)dataType.createValue();
                        value.setState(ValueState.ERROR);
                        break;
                    }
                    if (TM1Utils.isDivZeroString(strValue)) {
                        DoubleType dataType = DataTypeFactory.getDoubleType();
                        value = (Value)dataType.createValue();
                        value.setState(ValueState.DIV_BY_ZERO);
                        break;
                    }
                    if (TM1Utils.isZeroNumberString(strValue)) {
                        DoubleType dataType = DataTypeFactory.getDoubleType();
                        value = (Value)dataType.createValue();
                        value.set(0.0);
                        value.setState(ValueState.OK);
                        break;
                    }
                    StringType dataType = DataTypeFactory.getStringType();
                    value = (Value)dataType.createValue();
                    value.set(strValue);
                    break;
                }
                default: {
                    StringType dataType = DataTypeFactory.getStringType();
                    value = (Value)dataType.createValue();
                    value.setState(ValueState.ERROR);
                    break;
                }
            }
        } else {
            StringType dataType = DataTypeFactory.getStringType();
            value = (Value)dataType.createValue();
            value.setState(ValueState.ERROR);
        }
        value.setFormatId(formatId);
        ProviderCellBase cell = new ProviderCellBase(cellOrdinal, (IValue)value);
        if (this.mAccessor.containsField(TM1CellsetFields.TM1RULEDERIVED) && (rule = this.mAccessor.getIntegerField(TM1CellsetFields.TM1RULEDERIVED)) != 0L) {
            cell.setCellProperty(TM1CellsetFields.TM1RULEDERIVED.getFieldName(), (Object)rule);
            if (value.isOK()) {
                value.setState(ValueState.CALC);
            }
        }
        return cell;
    }

    private boolean moveToNext() {
        try {
            while (this.mCellset.getNext()) {
                String strValue;
                CellStatus status = this.mCellset.getCellStatus();
                if (status == CellStatus.Null || status == CellStatus.Data && this.mAccessor.getFieldType(TM1CellsetFields.VALUE) == FieldType.String && (TM1Utils.isNullString(strValue = this.mAccessor.getStringField(TM1CellsetFields.VALUE)) || TM1Utils.isEmptyString(strValue))) continue;
                this.mCellsetOrdinal = this.mAccessor.getIntegerField(TM1CellsetFields.CELL_ORDINAL);
                return true;
            }
        }
        catch (TM1Exception ex) {
            throw TM1ExceptionConverter.convert(ex);
        }
        this.mCellsetOrdinal = this.mCellsetRowCount;
        return false;
    }

    private void updateOrdinals(long ordinal) {
        this.mCellsetOrdinal = ordinal;
        this.mLogicalOrdinal = ordinal;
    }
}

