/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.data.providers.olap.tm1.metadata;

import com.cognos.xqe.config.ServiceEnumeration;
import com.cognos.xqe.config.XQEConfiguration;
import com.cognos.xqe.config.XQEConfigurationManager;
import com.cognos.xqe.data.providers.olap.tm1.TM1Connection;
import com.cognos.xqe.data.providers.olap.tm1.TM1Log;
import com.cognos.xqe.data.providers.olap.tm1.metadata.TM1CubeTimestamps;
import com.cognos.xqe.data.providers.olap.tm1.metadata.TM1Dimension;
import com.cognos.xqe.data.providers.olap.tm1.metadata.TM1Metadata;
import com.cognos.xqe.data.providers.olap.tm1.metadata.TM1MetadataType;
import com.cognos.xqe.data.providers.olap.tm1.util.ITM1Field;
import com.cognos.xqe.trace.LogLevel;
import com.ibm.cognos.tm1.AttributeDefinition;
import com.ibm.cognos.tm1.AttributeType;
import com.ibm.cognos.tm1.Cube;
import com.ibm.cognos.tm1.TM1Exception;
import java.io.PrintWriter;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;

public final class TM1Cube
extends TM1Metadata {
    private String mMeasureDUN;
    private String mTimeDUN;
    private final TM1CubeTimestamps mTimestamps;
    private double mUndefVal = 0.0;
    private final Map<String, TM1Dimension> mDimensionsByDUN = new LinkedHashMap<String, TM1Dimension>();
    private boolean mIsUnderFed;
    private boolean alternateHierarchySupport;

    public TM1Cube() {
        super(null);
        Calendar cal = Calendar.getInstance();
        this.mTimestamps = new TM1CubeTimestamps(cal.getTime(), cal.getTime());
        this.mIsUnderFed = false;
    }

    @Override
    public TM1MetadataType getType() {
        return TM1MetadataType.CUBE;
    }

    @Override
    public String getUniqueName() {
        return this.getProviderUniqueName();
    }

    public String getMeasureDUN() {
        return this.mMeasureDUN;
    }

    public String getTimeDUN() {
        return this.mTimeDUN;
    }

    public TM1CubeTimestamps getTimestamps() {
        return this.mTimestamps;
    }

    public Date getLastSchemaUpdate() {
        if (null != this.mTimestamps) {
            return this.mTimestamps.getLastSchemaUpdate();
        }
        return null;
    }

    public Date getLastDataUpdate() {
        if (null != this.mTimestamps) {
            return this.mTimestamps.getLastDataUpdate();
        }
        return null;
    }

    public double getUndefVal() {
        return this.mUndefVal;
    }

    public Collection<TM1Dimension> getDimensions() {
        return Collections.unmodifiableCollection(this.mDimensionsByDUN.values());
    }

    public TM1Dimension getMeasureDimension() {
        return this.findDimension(this.mMeasureDUN);
    }

    public TM1Dimension getTimeDimension() {
        return this.findDimension(this.mTimeDUN);
    }

    public boolean isUnderFed() {
        return this.mIsUnderFed;
    }

    public TM1Dimension findDimension(String dun) {
        return this.mDimensionsByDUN.get(dun);
    }

    public void populate(Cube cubeAPI) throws TM1Exception {
        this.mProviderUniqueName = this.mName = cubeAPI.getName();
        this.mProviderCaption = this.mName;
        this.mMeasureDUN = cubeAPI.getMeasuresDimension();
        this.mTimeDUN = cubeAPI.getTimeDimension();
        this.mUndefVal = cubeAPI.getUndefVal();
        this.mTimestamps.setLastSchemaUpdate(cubeAPI.getLastSchemaUpdate());
        this.mTimestamps.setLastDataUpdate(cubeAPI.getLastDataUpdate());
        this.setUnderFedState(cubeAPI);
        this.setAlternateHierarchySupport();
    }

    private void setAlternateHierarchySupport() {
        XQEConfiguration config = XQEConfigurationManager.getInstance().getConfiguration(ServiceEnumeration.XQE);
        this.alternateHierarchySupport = config.getBooleanProperty("queryExecution.tm1AlternateHierarchySupport[@value]", false);
    }

    public boolean getAlternateHierarchySupport() {
        return this.alternateHierarchySupport;
    }

    private void setUnderFedState(Cube cubeAPI) throws TM1Exception {
        AttributeDefinition definition = TM1Connection.getCubeAttributeDefinition(cubeAPI.getServer(), "IsUnderFed");
        String underFedCubeAttribute = null;
        if (definition != null && definition.getType().equals((Object)AttributeType.String)) {
            underFedCubeAttribute = cubeAPI.getAttributeStringValue("IsUnderFed");
            if (underFedCubeAttribute.equalsIgnoreCase("T")) {
                this.mIsUnderFed = true;
                TM1Log.TM1LogWrapper.log(TM1Log.META_CUBE, LogLevel.INFO, "The cube attribute %s is set to \"%s\" for [CUBE_NAME=%s]. The cube is under-fed.", "IsUnderFed", underFedCubeAttribute, this.mName);
            } else {
                TM1Log.TM1LogWrapper.log(TM1Log.META_CUBE, LogLevel.TRACE, "The cube attribute %s is set to \"%s\" for [CUBE_NAME=%s]. The cube is properly fed.", "IsUnderFed", underFedCubeAttribute, this.mName);
            }
        }
        if (underFedCubeAttribute == null) {
            TM1Log.TM1LogWrapper.log(TM1Log.META_CUBE, LogLevel.TRACE, "The cube attribute %s%s%s%s", "IsUnderFed", " is either undefined or is not a text attribute. The cube ", this.mName, " is considered to be properly fed.");
        }
    }

    @Override
    public void dump(PrintWriter writer, int indent) {
        TM1Cube.printHeader(writer, indent, "TM1Cube");
        TM1Cube.printField(writer, indent, "name", this.getName());
        TM1Cube.printField(writer, indent, "caption", this.getCaption());
        TM1Cube.printField(writer, indent, "measureDUN", this.getMeasureDUN());
        TM1Cube.printField(writer, indent, "timeDUN", this.getTimeDUN());
        TM1Cube.printField(writer, indent, "lastSchemaUpdate", this.getLastSchemaUpdate().toString());
        TM1Cube.printField(writer, indent, "lastDataUpdate", this.getLastDataUpdate().toString());
        TM1Cube.printField(writer, indent, "undefVal", Double.toString(this.getUndefVal()));
        for (TM1Dimension dimension : this.getDimensions()) {
            dimension.dump(writer, indent + 2);
        }
    }

    void addDimension(TM1Dimension dimension) {
        this.mDimensionsByDUN.put(dimension.getUniqueName(), dimension);
    }

    public static enum TM1CubeFields implements ITM1Field
    {
        CUBE_NAME,
        CUBE_CAPTION,
        MEASURES_DIMENSION,
        TIME_DIMENSION,
        LAST_SCHEMA_UPDATE,
        LAST_DATA_UPDATE,
        UNDEF_VAL;

        private final String mFieldName;

        private TM1CubeFields() {
            this.mFieldName = this.name();
        }

        private TM1CubeFields(String fieldName) {
            this.mFieldName = fieldName;
        }

        @Override
        public String getFieldName() {
            return this.mFieldName;
        }
    }
}

