/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.data.providers.olap.tm1.metadata;

import com.cognos.xqe.data.providers.olap.tm1.metadata.TM1Attribute;
import com.cognos.xqe.data.providers.olap.tm1.metadata.TM1Hierarchy;
import com.cognos.xqe.data.providers.olap.tm1.metadata.TM1Metadata;
import com.cognos.xqe.data.providers.olap.tm1.metadata.TM1MetadataType;
import com.cognos.xqe.data.providers.olap.tm1.util.ITM1Field;
import com.cognos.xqe.data.providers.olap.tm1.util.ITM1RowsetView;
import com.cognos.xqe.data.providers.olap.tm1.util.TM1Constants;
import com.cognos.xqe.data.providers.olap.tm1.util.TM1Utils;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.ibm.cognos.tm1.TM1Exception;
import java.io.PrintWriter;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.regex.Matcher;

public final class TM1Level
extends TM1Metadata
implements Comparable<TM1Level> {
    private int mLevelNumber;
    private long mCardinality;
    private final Map<String, TM1Attribute> mAttributesByName = new LinkedHashMap<String, TM1Attribute>();

    public TM1Level(TM1Hierarchy hierarchy) {
        super(hierarchy);
    }

    @Override
    public TM1MetadataType getType() {
        return TM1MetadataType.LEVEL;
    }

    @Override
    public String getUniqueName() {
        if (null == this.mUniqueName) {
            if (this.getHierarchy().isParentChild()) {
                Matcher defaultLUNMatcher = TM1Constants.DEFAULT_LEVEL_NAME_PATTERN.matcher(this.getProviderUniqueName());
                if (!defaultLUNMatcher.find()) {
                    throw new XQERuntimeException(XQEMessageKeys.GEN_FoundInternalErrorParam_INTERNAL, "Unexpected provider LUN format: " + this.getProviderUniqueName());
                }
                String providerLUN = defaultLUNMatcher.replaceFirst('[' + this.getName() + ']');
                this.mUniqueName = TM1Utils.convertProviderLUNToMDDSLUN(providerLUN, this.getHierarchy().getUniqueName());
            } else {
                this.mUniqueName = TM1Utils.convertProviderLUNToMDDSLUN(this.getProviderUniqueName(), this.getHierarchy().getUniqueName());
            }
        }
        return this.mUniqueName;
    }

    @Override
    public String getName() {
        if (this.getHierarchy().isParentChild()) {
            return String.format("ParentChildHierarchyLevel_%d", this.getLevelNumber());
        }
        return super.getName();
    }

    @Override
    public String getCaption() {
        if (this.getHierarchy().isParentChild()) {
            return String.format("ParentChildHierarchyLevel_%d", this.getLevelNumber());
        }
        return this.getProviderCaption();
    }

    public TM1Hierarchy getHierarchy() {
        return (TM1Hierarchy)this.getParent();
    }

    public int getLevelNumber() {
        return this.mLevelNumber;
    }

    public long getCardinality() {
        return this.mCardinality;
    }

    public Collection<TM1Attribute> getAttributes() {
        return Collections.unmodifiableCollection(this.mAttributesByName.values());
    }

    @Override
    public int compareTo(TM1Level level) {
        return this.mLevelNumber - level.mLevelNumber;
    }

    public TM1Attribute findAttribute(String name) {
        return this.mAttributesByName.get(name);
    }

    public void populate(ITM1RowsetView<TM1LevelFields> view) throws TM1Exception {
        this.mName = view.getStringField(TM1LevelFields.LEVEL_NAME);
        this.mProviderUniqueName = view.getStringField(TM1LevelFields.LEVEL_UNIQUE_NAME);
        this.mProviderCaption = view.getStringField(TM1LevelFields.LEVEL_CAPTION);
        this.mLevelNumber = (int)view.getIntegerField(TM1LevelFields.LEVEL_NUMBER);
        this.mCardinality = view.getIntegerField(TM1LevelFields.LEVEL_CARDINALITY);
    }

    @Override
    public void dump(PrintWriter writer, int indent) {
        TM1Level.printHeader(writer, indent, "TM1Level");
        TM1Level.printField(writer, indent, "name", this.getName());
        TM1Level.printField(writer, indent, "caption", this.getCaption());
        TM1Level.printField(writer, indent, "uniqueName", this.getProviderUniqueName());
        TM1Level.printField(writer, indent, "levelNumber", Integer.toString(this.getLevelNumber()));
        TM1Level.printField(writer, indent, "cardinality", Long.toString(this.getCardinality()));
        for (TM1Attribute attribute : this.getAttributes()) {
            attribute.dump(writer, indent + 2);
        }
    }

    void addAttribute(TM1Attribute attribute) {
        this.mAttributesByName.put(attribute.getName(), attribute);
    }

    public static enum TM1LevelFields implements ITM1Field
    {
        CUBE_NAME,
        DIMENSION_UNIQUE_NAME,
        HIERARCHY_UNIQUE_NAME,
        LEVEL_NAME,
        LEVEL_UNIQUE_NAME,
        LEVEL_CAPTION,
        DIMENSION_TYPE,
        LEVEL_NUMBER,
        LEVEL_CARDINALITY,
        LEVEL_TYPE;

        private final String mFieldName;

        private TM1LevelFields() {
            this.mFieldName = this.name();
        }

        private TM1LevelFields(String fieldName) {
            this.mFieldName = fieldName;
        }

        @Override
        public String getFieldName() {
            return this.mFieldName;
        }
    }
}

