/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.data.providers.olap.tm1.metadata;

import com.cognos.xqe.ast.ma.MARequestedPropertiesEnum;
import com.cognos.xqe.ast.maExp.MABlockConstraint;
import com.cognos.xqe.data.providers.olap.tm1.metadata.TM1Cube;
import com.cognos.xqe.data.providers.olap.tm1.metadata.TM1Dimension;
import com.cognos.xqe.data.providers.olap.tm1.metadata.TM1Hierarchy;
import com.cognos.xqe.data.providers.olap.tm1.metadata.TM1Level;
import com.cognos.xqe.data.providers.olap.tm1.metadata.TM1Member;
import com.cognos.xqe.data.providers.olap.tm1.metadata.TM1MemberMDXQuery;
import com.cognos.xqe.data.providers.olap.tm1.metadata.TM1MetadataSession;
import com.cognos.xqe.data.providers.olap.tm1.metadata.TM1MetadataType;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.transformation.ma.provider.MASearchCriteria;
import com.ibm.cognos.tm1.TreeOperator;
import java.util.EnumSet;
import java.util.List;

public final class TM1MemberSearch
extends TM1MemberMDXQuery {
    private EnumSet<TreeOperator> mTreeOps = null;
    private MASearchCriteria mSearchCriteria = null;
    private Integer mLevelNumber = null;

    public TM1MemberSearch(TM1MetadataSession session) {
        super(session);
    }

    public void setTreeOps(EnumSet<TreeOperator> treeOps) {
        this.mTreeOps = treeOps;
    }

    public void setSearchCriteria(MASearchCriteria searchCriteria) {
        this.mSearchCriteria = searchCriteria;
    }

    public void setLevelNumber(Integer levelNumber) {
        this.mLevelNumber = levelNumber;
    }

    @Override
    protected String generateMDX() {
        String setExpr;
        TM1Member member;
        TM1Cube cube;
        TM1Dimension dimension;
        TM1Hierarchy hierarchy;
        if (null == this.mSearchCriteria) {
            throw new XQERuntimeException(XQEMessageKeys.GEN_FoundInternalErrorParam_INTERNAL, "Member search criteria was not specified.");
        }
        switch (this.mSearchContext.getType()) {
            case HIERARCHY: {
                hierarchy = (TM1Hierarchy)this.mSearchContext;
                dimension = hierarchy.getDimension();
                cube = dimension.getCube();
                TM1Level level = null;
                member = null;
                int dep = 0;
                if (this.mSearchCriteria.getDepth() != -1) {
                    dep = this.mSearchCriteria.getDepth();
                }
                if (hierarchy.isParentChild() && this.mLevelNumber != null) {
                    setExpr = hierarchy.getProviderUniqueName() + ".LEVELS(" + this.mLevelNumber + ").MEMBERS, ";
                    break;
                }
                if (dep > 0) {
                    List<TM1Member> rootMuns = hierarchy.getAccessibleRoots();
                    setExpr = this.createSetExpression(rootMuns);
                    break;
                }
                setExpr = hierarchy.getProviderUniqueName() + ".MEMBERS, ";
                break;
            }
            case LEVEL: {
                TM1Level level = (TM1Level)this.mSearchContext;
                hierarchy = level.getHierarchy();
                dimension = hierarchy.getDimension();
                cube = dimension.getCube();
                member = null;
                setExpr = level.getProviderUniqueName() + ".MEMBERS, ";
                break;
            }
            case MEMBER: {
                member = (TM1Member)this.mSearchContext;
                TM1Level level = member.getLevel();
                hierarchy = level.getHierarchy();
                dimension = hierarchy.getDimension();
                cube = dimension.getCube();
                setExpr = this.createMemberSetExpression(member);
                break;
            }
            default: {
                throw new XQERuntimeException(XQEMessageKeys.GEN_FoundInternalError_INTERNAL);
            }
        }
        StringBuilder mdxBuffer = new StringBuilder();
        mdxBuffer.append("SELECT { ");
        if (TM1MetadataType.MEMBER == this.mSearchContext.getType()) {
            mdxBuffer.append(" UNION({").append(member.getProviderUniqueName()).append("}, ");
        }
        mdxBuffer.append("FILTER( ").append(setExpr);
        int numValues = 0;
        StringBuilder propExprBuffer = new StringBuilder();
        StringBuilder propExprBuffer1 = new StringBuilder();
        if (this.mSearchCriteria.getCaseInsensitive()) {
            propExprBuffer.append("UCase(");
        }
        propExprBuffer.append(hierarchy.getProviderUniqueName()).append(".CURRENTMEMBER.PROPERTIES(\"");
        if (MARequestedPropertiesEnum.CAPTION != this.mSearchCriteria.getProperty()) {
            throw new XQERuntimeException(XQEMessageKeys.GEN_FoundInternalErrorParam_INTERNAL, "An unsupported property was requested: " + this.mSearchCriteria.getProperty().toString());
        }
        String aliasName = this.getAliasName(dimension);
        if (aliasName != null) {
            propExprBuffer1.append((CharSequence)propExprBuffer);
            propExprBuffer1.append(aliasName);
            propExprBuffer1.append("\")");
            if (this.mSearchCriteria.getCaseInsensitive()) {
                propExprBuffer1.append(')');
            }
        }
        propExprBuffer.append("MEMBER_CAPTION");
        propExprBuffer.append("\")");
        if (this.mSearchCriteria.getCaseInsensitive()) {
            propExprBuffer.append(')');
        }
        String propExpr = propExprBuffer.toString();
        String propExpr1 = propExprBuffer1.toString();
        StringBuilder pBuffer = new StringBuilder();
        StringBuilder pBuffer1 = new StringBuilder();
        for (String sv : this.mSearchCriteria.getSearchValues()) {
            if (numValues > 0) {
                if (MABlockConstraint.Operation.NOT_DEFINED == this.mSearchCriteria.getOperator()) {
                    throw new XQERuntimeException(XQEMessageKeys.GEN_FoundInternalErrorParam_INTERNAL, "Member search operation was not defined.");
                }
                pBuffer.append(' ').append(this.mSearchCriteria.getOperator().name()).append(' ');
                if (aliasName != null) {
                    pBuffer1.append(' ').append(this.mSearchCriteria.getOperator().name()).append(' ');
                }
            }
            String valueExpr = this.mSearchCriteria.getCaseInsensitive() ? "UCase(\"" + sv + "\")" : '\"' + sv + '\"';
            this.appendInStrExp(pBuffer, propExpr, valueExpr);
            if (aliasName != null) {
                this.appendInStrExp(pBuffer1, propExpr1, valueExpr);
            }
            ++numValues;
        }
        mdxBuffer.append((CharSequence)pBuffer);
        if (aliasName != null) {
            mdxBuffer.append("OR");
            mdxBuffer.append((CharSequence)pBuffer1);
        }
        if (TM1MetadataType.MEMBER == this.mSearchContext.getType()) {
            mdxBuffer.append(" )");
        }
        mdxBuffer.append(" ) } PROPERTIES MEMBER_NAME, MEMBER_ORDINAL, CHILDREN_CARDINALITY, PARENT_UNIQUE_NAME, LEVEL_NUMBER");
        String qualifiedAliasName = this.getQualifiedAliasName(dimension);
        if (qualifiedAliasName != null) {
            mdxBuffer.append(", ").append(qualifiedAliasName);
        }
        mdxBuffer.append(" ON AXIS(0), {} ON AXIS(1) FROM [").append(cube.getName()).append(']');
        return mdxBuffer.toString();
    }

    private String createSetExpression(List<TM1Member> rootMuns) {
        StringBuilder exprBuffer = new StringBuilder();
        exprBuffer.append("{");
        if (!rootMuns.isEmpty()) {
            for (int i = 0; i < rootMuns.size() - 1; ++i) {
                exprBuffer.append(rootMuns.get(i).getProviderUniqueName());
                exprBuffer.append(",");
            }
            exprBuffer.append(rootMuns.get(rootMuns.size() - 1).getProviderUniqueName());
        }
        exprBuffer.append("},");
        return exprBuffer.toString();
    }

    private String createMemberSetExpression(TM1Member member) {
        StringBuilder exprBuffer = new StringBuilder();
        exprBuffer.append("DESCENDANTS( ").append(member.getProviderUniqueName());
        if (this.mTreeOps.contains(TreeOperator.Children)) {
            exprBuffer.append(", 1");
            if (this.mTreeOps.contains(TreeOperator.Self)) {
                exprBuffer.append(", SELF_AND_BEFORE");
            }
        } else if (this.mTreeOps.contains(TreeOperator.Descendants)) {
            exprBuffer.append(", 1");
            if (this.mTreeOps.contains(TreeOperator.Self)) {
                exprBuffer.append(", SELF_BEFORE_AFTER");
            } else {
                exprBuffer.append(", SELF_AND_AFTER");
            }
        } else if (this.mTreeOps.contains(TreeOperator.Self) || this.mTreeOps.isEmpty()) {
            exprBuffer.append(", 0");
        }
        exprBuffer.append(" ), ");
        return exprBuffer.toString();
    }

    private void appendInStrExp(StringBuilder mdxBuffer, String propExpr, String valueExpr) {
        switch (this.mSearchCriteria.getSearchCondition()) {
            case CONTAINS: {
                mdxBuffer.append("(INSTR(").append(propExpr).append(", ").append(valueExpr).append(") > 0)");
                break;
            }
            case ENDS_WITH: {
                mdxBuffer.append("(LEN(").append(propExpr).append(") - LEN(").append(valueExpr).append(")) >= 0 AND INSTR(").append(propExpr).append(", ").append(valueExpr).append(") = (LEN(").append(propExpr).append(") - LEN(").append(valueExpr).append(") + 1)");
                break;
            }
            case EQUALS: {
                mdxBuffer.append("(INSTR(").append(propExpr).append(", ").append(valueExpr).append(") = 1  AND LEN(").append(propExpr).append(") = LEN(").append(valueExpr).append("))");
                break;
            }
            case STARTS_WITH: {
                mdxBuffer.append("(INSTR(").append(propExpr).append(", ").append(valueExpr).append(") = 1)");
                break;
            }
            default: {
                throw new XQERuntimeException(XQEMessageKeys.GEN_FoundInternalErrorParam_INTERNAL, "Unsupported search condition: " + this.mSearchCriteria.getSearchCondition());
            }
        }
    }
}

