/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.data.providers.olap.tm1.metadata;

import com.cognos.xqe.data.providers.olap.tm1.TM1Log;
import com.cognos.xqe.data.providers.olap.tm1.TM1MessageKeys;
import com.cognos.xqe.data.providers.olap.tm1.TM1ODPException;
import com.cognos.xqe.data.providers.olap.tm1.metadata.TM1Attribute;
import com.cognos.xqe.data.providers.olap.tm1.metadata.TM1Cube;
import com.cognos.xqe.data.providers.olap.tm1.metadata.TM1CubeCache;
import com.cognos.xqe.data.providers.olap.tm1.metadata.TM1Dimension;
import com.cognos.xqe.data.providers.olap.tm1.metadata.TM1Hierarchy;
import com.cognos.xqe.data.providers.olap.tm1.metadata.TM1Level;
import com.cognos.xqe.data.providers.olap.tm1.metadata.TM1Member;
import com.cognos.xqe.data.providers.olap.tm1.metadata.TM1MetadataSession;
import com.cognos.xqe.data.providers.olap.tm1.metadata.query.MetadataQuery;
import com.cognos.xqe.data.providers.olap.tm1.util.ITM1RowsetView;
import com.cognos.xqe.data.providers.olap.tm1.util.TM1RowsetAccessor;
import com.cognos.xqe.exception.IMessageKey;
import com.cognos.xqe.exception.XQEMessages;
import com.cognos.xqe.metadata.RoleTypeEnum;
import com.cognos.xqe.trace.LogLevel;
import com.ibm.cognos.tm1.Cube;
import com.ibm.cognos.tm1.DimensionOrder;
import com.ibm.cognos.tm1.Rowset;
import com.ibm.cognos.tm1.Server;
import com.ibm.cognos.tm1.TM1Exception;
import com.ibm.cognos.tm1.TreeOperator;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Locale;

public final class TM1MetadataLoader {
    private static final String[] DEFAULT_MEMBER_FIELDS = new String[]{TM1Member.TM1MemberFields.PARENT_UNIQUE_NAME.getFieldName(), TM1Member.TM1MemberFields.MEMBER_ORDINAL.getFieldName(), TM1Member.TM1MemberFields.MEMBER_NAME.getFieldName(), TM1Member.TM1MemberFields.MEMBER_UNIQUE_NAME.getFieldName(), TM1Member.TM1MemberFields.MEMBER_CAPTION.getFieldName(), TM1Member.TM1MemberFields.LEVEL_NUMBER.getFieldName(), TM1Member.TM1MemberFields.CHILDREN_CARDINALITY.getFieldName(), TM1Member.TM1MemberFields.DESCRIPTION.name()};
    private final TM1MetadataSession mSession;

    TM1MetadataLoader(TM1MetadataSession session) {
        this.mSession = session;
    }

    public TM1MetadataSession getSession() {
        return this.mSession;
    }

    public TM1Cube loadCube(String cubeName, TM1CubeCache cubeCache) throws TM1Exception {
        TM1Log.TM1LogWrapper.log(TM1Log.META_LOADER, LogLevel.INFO, "Loading a TM1 cube [CUBE_NAME=%s] from cache or data source.", cubeName);
        if (null != cubeCache) {
            TM1Cube cube = cubeCache.getCube(cubeName);
            if (null == cube) {
                cube = this.bulkLoadCube(cubeName);
                if (null != cube) {
                    TM1Log.TM1LogWrapper.log(TM1Log.META_LOADER, LogLevel.INFO, "Putting new TM1 cube [CUBE_NAME=%s] into cache.", cubeName);
                    cubeCache.putCube(cube);
                }
            } else {
                TM1Log.TM1LogWrapper.log(TM1Log.META_LOADER, LogLevel.INFO, "Found a cached TM1 cube [CUBE_NAME=%s].", cubeName);
            }
            return cube;
        }
        return this.bulkLoadCube(cubeName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TM1Cube shallowLoadCube(String cubeName) throws TM1Exception {
        TM1Log.TM1LogWrapper.log(TM1Log.META_LOADER, LogLevel.INFO, "Shallow-loading a TM1 cube [CUBE_NAME=%s] from data source.", cubeName);
        Server serverAPI = this.getSession().getServer();
        Cube cubeAPI = serverAPI.findCube(cubeName);
        TM1Cube cube = null;
        if (null != cubeAPI) {
            try {
                cube = new TM1Cube();
                cube.populate(cubeAPI);
            }
            finally {
                cubeAPI.dispose();
            }
        }
        return cube;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<TM1Cube> shallowLoadAllCubes() throws TM1Exception {
        TM1Log.TM1LogWrapper.log(TM1Log.META_LOADER, LogLevel.INFO, "Shallow-loading all TM1 cubes from data source.", new Object[0]);
        Server serverAPI = this.getSession().getServer();
        ArrayList<TM1Cube> allCubes = new ArrayList<TM1Cube>();
        Cube[] allCubeAPIs = serverAPI.listCubes();
        try {
            for (Cube cubeAPI : allCubeAPIs) {
                TM1Cube cube = new TM1Cube();
                cube.populate(cubeAPI);
                allCubes.add(cube);
            }
        }
        finally {
            for (Cube cubeAPI : allCubeAPIs) {
                cubeAPI.dispose();
            }
        }
        return allCubes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TM1Dimension shallowLoadDimension(TM1Cube cube, String dun) throws TM1Exception {
        Server serverAPI = this.getSession().getServer();
        Cube cubeAPI = serverAPI.findCube(cube.getName());
        TM1Dimension dimension = null;
        if (cubeAPI != null) {
            Rowset rs = cubeAPI.getDimensionsRowset(dun, true, DimensionOrder.Current);
            try {
                TM1RowsetAccessor<TM1Dimension.TM1DimensionFields> rsa = TM1RowsetAccessor.create(rs, TM1Dimension.TM1DimensionFields.class);
                if (rsa.next()) {
                    dimension = new TM1Dimension(cube);
                    dimension.populate(rsa);
                }
            }
            finally {
                rs.dispose();
            }
        }
        return dimension;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TM1Hierarchy shallowLoadHierarchy(TM1Dimension dimension, String hun) throws TM1Exception {
        Server serverAPI = this.getSession().getServer();
        TM1Cube cube = dimension.getCube();
        Rowset rs = serverAPI.getHierarchiesRowset(cube.getName(), dimension.getProviderUniqueName(), hun);
        TM1Hierarchy hierarchy = null;
        try {
            TM1RowsetAccessor<TM1Hierarchy.TM1HierarchyFields> rsa = TM1RowsetAccessor.create(rs, TM1Hierarchy.TM1HierarchyFields.class);
            if (rsa.next()) {
                String hn;
                if (!dimension.getCube().getAlternateHierarchySupport() && !(hn = rsa.getStringField(TM1Hierarchy.TM1HierarchyFields.HIERARCHY_NAME)).equals(dimension.getDefaultHierarchyName())) {
                    TM1Hierarchy tM1Hierarchy = null;
                    return tM1Hierarchy;
                }
                hierarchy = new TM1Hierarchy(dimension);
                hierarchy.populate(rsa);
            }
        }
        finally {
            rs.dispose();
        }
        return hierarchy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<TM1Member> loadAccessibleRootMembers(TM1Hierarchy hierarchy, String[] dimProps) throws TM1Exception {
        Server serverAPI = this.getSession().getServer();
        ArrayList<TM1Member> roots = new ArrayList<TM1Member>();
        TM1Dimension dimension = hierarchy.getDimension();
        TM1Cube cube = dimension.getCube();
        List<String> aliasNames = hierarchy.getAliasNames();
        String[] fields = aliasNames.isEmpty() && (dimProps == null || dimProps.length == 0) ? DEFAULT_MEMBER_FIELDS : this.buildMemberFields(aliasNames, dimProps);
        Rowset rs = serverAPI.getAccessibleRootsRowset(cube.getName(), dimension.getProviderUniqueName(), hierarchy.getProviderUniqueName(), fields);
        try {
            TM1RowsetAccessor<TM1Member.TM1MemberFields> rowsetAccessor = TM1RowsetAccessor.create(rs, TM1Member.TM1MemberFields.class);
            while (rowsetAccessor.next()) {
                roots.add(this.loadMemberFromRowset(hierarchy, rowsetAccessor, dimProps));
            }
        }
        finally {
            rs.dispose();
        }
        return roots;
    }

    public TM1Member loadSingleMember(TM1Hierarchy hierarchy, String mun, String[] dimProperties) throws TM1Exception {
        ArrayList<TM1Member> members = new ArrayList<TM1Member>(1);
        this.loadMembersTreeOp(hierarchy, mun, EnumSet.of(TreeOperator.Self), dimProperties, members);
        if (members.size() > 0) {
            return (TM1Member)members.get(0);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadMembersTreeOp(TM1Hierarchy hierarchy, String mun, EnumSet<TreeOperator> treeOps, String[] dimProperties, List<TM1Member> result) throws TM1Exception {
        Server serverAPI = this.getSession().getServer();
        TM1Dimension dimension = hierarchy.getDimension();
        TM1Cube cube = dimension.getCube();
        List<String> aliasNames = hierarchy.getAliasNames();
        String[] fields = aliasNames.isEmpty() && (dimProperties == null || dimProperties.length == 0) ? DEFAULT_MEMBER_FIELDS : this.buildMemberFields(aliasNames, dimProperties);
        Rowset rs = serverAPI.getMembersRowset(cube.getName(), dimension.getProviderUniqueName(), hierarchy.getProviderUniqueName(), null, mun, treeOps, fields);
        try {
            TM1RowsetAccessor<TM1Member.TM1MemberFields> rowsetAccessor = TM1RowsetAccessor.create(rs, TM1Member.TM1MemberFields.class);
            while (rowsetAccessor.next()) {
                result.add(this.loadMemberFromRowset(hierarchy, rowsetAccessor, dimProperties));
            }
        }
        finally {
            rs.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadHierarchyMembers(TM1Hierarchy hierarchy, String[] dimProperties, List<TM1Member> result) throws TM1Exception {
        Server serverAPI = this.getSession().getServer();
        TM1Dimension dimension = hierarchy.getDimension();
        TM1Cube cube = dimension.getCube();
        List<String> aliasNames = hierarchy.getAliasNames();
        String[] fields = aliasNames.isEmpty() && (dimProperties == null || dimProperties.length == 0) ? DEFAULT_MEMBER_FIELDS : this.buildMemberFields(aliasNames, dimProperties);
        Rowset rs = serverAPI.getMembersRowset(cube.getName(), dimension.getProviderUniqueName(), hierarchy.getProviderUniqueName(), null, null, EnumSet.of(TreeOperator.Self), fields);
        try {
            TM1RowsetAccessor<TM1Member.TM1MemberFields> rowsetAccessor = TM1RowsetAccessor.create(rs, TM1Member.TM1MemberFields.class);
            while (rowsetAccessor.next()) {
                result.add(this.loadMemberFromRowset(hierarchy, rowsetAccessor, dimProperties));
            }
        }
        finally {
            rs.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadLevelMembers(TM1Level level, String[] dimProperties, List<TM1Member> result) throws TM1Exception {
        Server serverAPI = this.getSession().getServer();
        TM1Hierarchy hierarchy = level.getHierarchy();
        TM1Dimension dimension = hierarchy.getDimension();
        TM1Cube cube = dimension.getCube();
        List<String> aliasNames = hierarchy.getAliasNames();
        String[] fields = aliasNames.isEmpty() && (dimProperties == null || dimProperties.length == 0) ? DEFAULT_MEMBER_FIELDS : this.buildMemberFields(aliasNames, dimProperties);
        Rowset rs = serverAPI.getMembersRowset(cube.getName(), dimension.getProviderUniqueName(), hierarchy.getProviderUniqueName(), level.getProviderUniqueName(), null, EnumSet.of(TreeOperator.Self), fields);
        try {
            TM1RowsetAccessor<TM1Member.TM1MemberFields> rowsetAccessor = TM1RowsetAccessor.create(rs, TM1Member.TM1MemberFields.class);
            while (rowsetAccessor.next()) {
                TM1Member tm1Member = this.loadMemberFromRowset(level, rowsetAccessor, dimProperties);
                boolean isAccessible = true;
                if (tm1Member.getParentLevelNumber() == 0 && hierarchy.isRagged()) {
                    isAccessible = hierarchy.getAccessibleRoots().contains(tm1Member);
                }
                if (!isAccessible) continue;
                result.add(tm1Member);
            }
        }
        finally {
            rs.dispose();
        }
    }

    private TM1Member loadMemberFromRowset(TM1Hierarchy hierarchy, ITM1RowsetView<TM1Member.TM1MemberFields> rowsetAccessor, String[] dimProperties) throws TM1Exception {
        int levelNum = (int)rowsetAccessor.getIntegerField(TM1Member.TM1MemberFields.LEVEL_NUMBER);
        TM1Level level = hierarchy.findLevel(levelNum);
        if (null == level) {
            throw new TM1ODPException(TM1MessageKeys.MET_LEVEL_NUMBER_NOT_FOUND, Integer.toString(levelNum), hierarchy.getUniqueName());
        }
        TM1Member member = new TM1Member(level);
        member.populate(rowsetAccessor, dimProperties);
        return member;
    }

    private TM1Member loadMemberFromRowset(TM1Level level, ITM1RowsetView<TM1Member.TM1MemberFields> rowsetAccessor, String[] dimProperties) throws TM1Exception {
        TM1Member member = new TM1Member(level);
        member.populate(rowsetAccessor, dimProperties);
        return member;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TM1Cube bulkLoadCube(String cubeName) throws TM1Exception {
        TM1Log.TM1LogWrapper.log(TM1Log.META_LOADER, LogLevel.INFO, "Bulk-loading a TM1 cube [CUBE_NAME=%s] from data source.", cubeName);
        Server serverAPI = this.getSession().getServer();
        Cube cubeAPI = serverAPI.findCube(cubeName);
        TM1Cube cube = null;
        if (null != cubeAPI) {
            try {
                cube = new TM1Cube();
                cube.populate(cubeAPI);
            }
            finally {
                cubeAPI.dispose();
            }
        }
        if (null != cube) {
            this.bulkLoadDimensions(cube);
            this.bulkLoadHierarchies(cube);
            this.bulkLoadLevels(cube);
            this.bulkLoadAttributes(cube);
            this.bulkLoadAccessibleRootMembers(cube);
        }
        return cube;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void bulkLoadDimensions(TM1Cube cube) throws TM1Exception {
        Server serverAPI = this.getSession().getServer();
        Cube cubeAPI = serverAPI.findCube(cube.getName());
        if (cubeAPI != null) {
            Rowset rs = cubeAPI.getDimensionsRowset(null, true, DimensionOrder.Current);
            try {
                TM1RowsetAccessor<TM1Dimension.TM1DimensionFields> rsa = TM1RowsetAccessor.create(rs, TM1Dimension.TM1DimensionFields.class);
                while (rsa.next()) {
                    TM1Dimension dimension = new TM1Dimension(cube);
                    dimension.populate(rsa);
                    cube.addDimension(dimension);
                }
            }
            finally {
                rs.dispose();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void bulkLoadHierarchies(TM1Cube cube) throws TM1Exception {
        Server serverAPI = this.getSession().getServer();
        Rowset rs = serverAPI.getHierarchiesRowset(cube.getName(), null, null);
        try {
            TM1RowsetAccessor<TM1Hierarchy.TM1HierarchyFields> rsa = TM1RowsetAccessor.create(rs, TM1Hierarchy.TM1HierarchyFields.class);
            while (rsa.next()) {
                String hn;
                String dun = rsa.getStringField(TM1Hierarchy.TM1HierarchyFields.DIMENSION_UNIQUE_NAME);
                TM1Dimension dimension = cube.findDimension(dun);
                if (null == dimension) {
                    throw new TM1ODPException(TM1MessageKeys.MET_NONEXISTANT_DIMENSION, dun);
                }
                if (!dimension.getCube().getAlternateHierarchySupport() && !(hn = rsa.getStringField(TM1Hierarchy.TM1HierarchyFields.HIERARCHY_NAME)).equals(dimension.getDefaultHierarchyName())) continue;
                TM1Hierarchy hierarchy = new TM1Hierarchy(dimension);
                hierarchy.populate(rsa);
                dimension.addHierarchy(hierarchy);
            }
        }
        finally {
            rs.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void bulkLoadLevels(TM1Cube cube) throws TM1Exception {
        Server serverAPI = this.getSession().getServer();
        Rowset rs = serverAPI.getLevelsRowset(cube.getName(), null, null, null);
        try {
            TM1RowsetAccessor<TM1Level.TM1LevelFields> rsa = TM1RowsetAccessor.create(rs, TM1Level.TM1LevelFields.class);
            while (rsa.next()) {
                String dun = rsa.getStringField(TM1Level.TM1LevelFields.DIMENSION_UNIQUE_NAME);
                TM1Dimension dimension = cube.findDimension(dun);
                if (null == dimension) {
                    throw new TM1ODPException(TM1MessageKeys.MET_NONEXISTANT_DIMENSION, dun);
                }
                String hun = rsa.getStringField(TM1Level.TM1LevelFields.HIERARCHY_UNIQUE_NAME);
                TM1Hierarchy hierarchy = dimension.findHierarchy(hun);
                if (null == hierarchy) {
                    if (!dimension.getCube().getAlternateHierarchySupport()) continue;
                    throw new TM1ODPException(TM1MessageKeys.MET_NONEXISTANT_HIERARCHY, hun);
                }
                TM1Level level = new TM1Level(hierarchy);
                level.populate(rsa);
                hierarchy.addLevel(level);
            }
        }
        finally {
            rs.dispose();
        }
    }

    private void bulkLoadAttributes(TM1Cube cube) throws TM1Exception {
        this.bulkLoadCustomAttributes(cube);
        this.bulkLoadDefaultAttributes(cube);
    }

    private void bulkLoadDefaultAttributes(TM1Cube cube) {
        Locale locale = this.getSession().getLocale();
        String dashName = XQEMessages.getMessage((IMessageKey.Param0)TM1MessageKeys.STR_DASH_NAME, (Locale)locale);
        TM1Attribute attribute = null;
        for (TM1Dimension dimension : cube.getDimensions()) {
            if (dimension.isMeasureDimension()) continue;
            for (TM1Hierarchy hierarchy : dimension.getHierarchies()) {
                attribute = TM1Attribute.createHierarchyBusinessKey(hierarchy, dashName);
                hierarchy.addAttribute(attribute);
                if (hierarchy.isParentChild()) continue;
                for (TM1Level level : hierarchy.getLevels()) {
                    attribute = TM1Attribute.createLevelBusinessKey(level, dashName);
                    level.addAttribute(attribute);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void bulkLoadCustomAttributes(TM1Cube cube) throws TM1Exception {
        Server serverAPI = this.getSession().getServer();
        Rowset rs = serverAPI.getAttributesRowset(cube.getName(), null, null, null, null);
        try {
            TM1RowsetAccessor<TM1Attribute.TM1AttributeFields> rsa = TM1RowsetAccessor.create(rs, TM1Attribute.TM1AttributeFields.class);
            while (rsa.next()) {
                String dun = rsa.getStringField(TM1Attribute.TM1AttributeFields.DIMENSION_UNIQUE_NAME);
                TM1Dimension dimension = cube.findDimension(dun);
                if (null == dimension) {
                    throw new TM1ODPException(TM1MessageKeys.MET_NONEXISTANT_DIMENSION, dun);
                }
                TM1Attribute attribute = new TM1Attribute(dimension, RoleTypeEnum.MEMBER_CUSTOM_PROPERTY);
                attribute.populate(rsa);
                if (TM1MetadataLoader.canSkipAttribute(attribute)) continue;
                dimension.addAttribute(attribute);
                for (TM1Hierarchy hierarchy : dimension.getHierarchies()) {
                    attribute = new TM1Attribute(hierarchy, RoleTypeEnum.MEMBER_CUSTOM_PROPERTY);
                    attribute.populate(rsa);
                    hierarchy.addAttribute(attribute);
                    if (hierarchy.isParentChild()) continue;
                    for (TM1Level level : hierarchy.getLevels()) {
                        attribute = new TM1Attribute(level, RoleTypeEnum.MEMBER_CUSTOM_PROPERTY);
                        attribute.populate(rsa);
                        level.addAttribute(attribute);
                    }
                }
            }
        }
        finally {
            rs.dispose();
        }
    }

    private static boolean canSkipAttribute(TM1Attribute attribute) throws TM1Exception {
        if ((null == attribute.getDescription() || 0 == attribute.getDescription().length()) && "Format".equals(attribute.getName())) {
            return true;
        }
        return "DESCRIPTION".equals(attribute.getName()) && !attribute.isAlias();
    }

    private void bulkLoadAccessibleRootMembers(TM1Cube cube) throws TM1Exception {
        for (TM1Dimension dimension : cube.getDimensions()) {
            for (TM1Hierarchy hierarchy : dimension.getHierarchies()) {
                List<TM1Member> roots = this.loadAccessibleRootMembers(hierarchy, MetadataQuery.EMPTY_PROPERTY_ARRAY);
                hierarchy.setAccessibleRoots(roots);
            }
        }
    }

    private String[] buildMemberFields(List<String> customFields, String[] dimProperties) {
        String[] result = new String[DEFAULT_MEMBER_FIELDS.length + dimProperties.length + customFields.size()];
        System.arraycopy(DEFAULT_MEMBER_FIELDS, 0, result, 0, DEFAULT_MEMBER_FIELDS.length);
        System.arraycopy(dimProperties, 0, result, DEFAULT_MEMBER_FIELDS.length, dimProperties.length);
        int i = DEFAULT_MEMBER_FIELDS.length + dimProperties.length;
        for (String fieldName : customFields) {
            result[i++] = fieldName;
        }
        return result;
    }

    public static boolean isDefaultField(String propName) {
        for (String field : DEFAULT_MEMBER_FIELDS) {
            if (!field.equals(propName)) continue;
            return true;
        }
        return false;
    }
}

