/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.data.providers.olap.tm1.metadata;

import com.cognos.xqe.data.providers.olap.IRestrictions;
import com.cognos.xqe.data.providers.olap.RestrictionType;
import com.cognos.xqe.data.providers.olap.tm1.TM1Connection;
import com.cognos.xqe.data.providers.olap.tm1.TM1MessageKeys;
import com.cognos.xqe.data.providers.olap.tm1.TM1ODPException;
import com.cognos.xqe.data.providers.olap.tm1.metadata.TM1CubeTimestamps;
import com.cognos.xqe.data.providers.olap.tm1.metadata.TM1MetadataLoader;
import com.cognos.xqe.data.providers.olap.tm1.metadata.query.AliasRecordQuery;
import com.cognos.xqe.data.providers.olap.tm1.metadata.query.CubeDefaultMeasureQuery;
import com.cognos.xqe.data.providers.olap.tm1.metadata.query.CubeRecordQuery;
import com.cognos.xqe.data.providers.olap.tm1.metadata.query.DimensionRecordQuery;
import com.cognos.xqe.data.providers.olap.tm1.metadata.query.HierarchyRecordQuery;
import com.cognos.xqe.data.providers.olap.tm1.metadata.query.HierarchyRootMembersQuery;
import com.cognos.xqe.data.providers.olap.tm1.metadata.query.LevelRecordQuery;
import com.cognos.xqe.data.providers.olap.tm1.metadata.query.MeasureRecordQuery;
import com.cognos.xqe.data.providers.olap.tm1.metadata.query.MemberRecordQuery;
import com.cognos.xqe.data.providers.olap.tm1.metadata.query.MetadataQuery;
import com.cognos.xqe.data.providers.olap.tm1.metadata.query.PropertyRecordQuery;
import com.cognos.xqe.data.providers.olap.tm1.util.TM1AliasTable;
import com.cognos.xqe.data.providers.olap.tm1.util.TM1Constants;
import com.cognos.xqe.data.providers.olap.tm1.util.TM1Utils;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.metadata.TreeOperatorEnum;
import com.cognos.xqe.metadata.record.AliasRecord;
import com.cognos.xqe.metadata.record.CatalogRecord;
import com.cognos.xqe.metadata.record.CubeRecord;
import com.cognos.xqe.metadata.record.DimensionRecord;
import com.cognos.xqe.metadata.record.HierarchyRecord;
import com.cognos.xqe.metadata.record.LevelRecord;
import com.cognos.xqe.metadata.record.MeasureRecord;
import com.cognos.xqe.metadata.record.MemberRecord;
import com.cognos.xqe.metadata.record.PropertyRecord;
import com.cognos.xqe.query.engine.ExecutionEnvironment;
import com.cognos.xqe.transformation.ma.provider.MASearchCriteria;
import com.cognos.xqe.util.ILocalizedString;
import com.cognos.xqe.util.LocalizedString;
import com.ibm.cognos.tm1.Cube;
import com.ibm.cognos.tm1.Server;
import com.ibm.cognos.tm1.TM1Exception;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;

public class TM1MetadataSession {
    private final TM1Connection mConnection;
    private final TM1MetadataLoader mLoader;
    private final Locale mLocale;
    private final ExecutionEnvironment mExecEnv;

    public TM1MetadataSession(TM1Connection connection, Locale locale, ExecutionEnvironment execEnv) {
        this.mConnection = connection;
        this.mLoader = new TM1MetadataLoader(this);
        this.mLocale = locale;
        this.mExecEnv = execEnv;
    }

    public TM1Connection getConnection() {
        return this.mConnection;
    }

    public Server getServer() {
        return this.mConnection.getServer();
    }

    public ExecutionEnvironment getExecutionEnvironment() {
        return this.mExecEnv;
    }

    public Locale getLocale() {
        return this.mLocale;
    }

    public TM1MetadataLoader getLoader() {
        return this.mLoader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<CubeRecord> getCubeRecords(IRestrictions restrictions) throws TM1Exception {
        String cubeName = (String)restrictions.getValueOf(RestrictionType.CUBE);
        CubeRecordQuery query = new CubeRecordQuery(this);
        query.setLocale(this.mLocale);
        query.setCubeName(cubeName);
        this.setRangeRestrictions(query, restrictions);
        try {
            List<CubeRecord> list = query.execute();
            return list;
        }
        finally {
            query.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<DimensionRecord> getDimensionRecords(IRestrictions restrictions) throws TM1Exception {
        String cubeName = (String)restrictions.getValueOf(RestrictionType.CUBE);
        String dun = (String)restrictions.getValueOf(RestrictionType.DIMENSION_UNIQUE_NAME);
        DimensionRecordQuery query = new DimensionRecordQuery(this);
        query.setLocale(this.mLocale);
        query.setCubeName(cubeName);
        query.setDUN(dun);
        this.setRangeRestrictions(query, restrictions);
        try {
            List<DimensionRecord> list = query.execute();
            return list;
        }
        finally {
            query.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<AliasRecord> getAliasRecords(IRestrictions restrictions) throws TM1Exception {
        String cubeName = (String)restrictions.getValueOf(RestrictionType.CUBE);
        AliasRecordQuery query = new AliasRecordQuery(this);
        query.setLocale(this.mLocale);
        query.setCubeName(cubeName);
        this.setRangeRestrictions(query, restrictions);
        try {
            List<AliasRecord> list = query.execute();
            return list;
        }
        finally {
            query.release();
        }
    }

    public List<CatalogRecord> getCatalogRecords(IRestrictions restrictions) throws TM1Exception {
        String catalogName = (String)restrictions.getValueOf(RestrictionType.CATALOG);
        if (null == catalogName || "CATALOG".equals(catalogName)) {
            CatalogRecord record = new CatalogRecord();
            record.setUniqueName("CATALOG");
            record.setName("CATALOG");
            record.setCaption((ILocalizedString)new LocalizedString(this.mLocale, "CATALOG"));
            record.setDescription("");
            return Collections.singletonList(record);
        }
        return Collections.emptyList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getCubeDefaultMeasure(IRestrictions restrictions) throws TM1Exception {
        String cubeName = (String)restrictions.getValueOf(RestrictionType.CUBE);
        CubeDefaultMeasureQuery query = new CubeDefaultMeasureQuery(this);
        query.setLocale(this.mLocale);
        query.setCubeName(cubeName);
        try {
            List<String> result = query.execute();
            if (result.isEmpty()) {
                throw new TM1ODPException(TM1MessageKeys.MET_NO_DEFAULT_MEASURE, cubeName);
            }
            String string = result.get(0);
            return string;
        }
        finally {
            query.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<HierarchyRecord> getHierarchyRecords(IRestrictions restrictions) throws TM1Exception {
        String cubeName = (String)restrictions.getValueOf(RestrictionType.CUBE);
        String dun = (String)restrictions.getValueOf(RestrictionType.DIMENSION_UNIQUE_NAME);
        String hun = (String)restrictions.getValueOf(RestrictionType.HIERARCHY_UNIQUE_NAME);
        HierarchyRecordQuery query = new HierarchyRecordQuery(this);
        query.setLocale(this.mLocale);
        query.setCubeName(cubeName);
        query.setDUN(dun);
        query.setHUN(hun);
        this.setRangeRestrictions(query, restrictions);
        try {
            List<HierarchyRecord> list = query.execute();
            return list;
        }
        finally {
            query.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<MemberRecord> getHierarchyRootMemberRecords(IRestrictions restrictions) throws TM1Exception {
        String cubeName = (String)restrictions.getValueOf(RestrictionType.CUBE);
        String hun = (String)restrictions.getValueOf(RestrictionType.HIERARCHY_UNIQUE_NAME);
        Map aliases = (Map)restrictions.getValueOf(RestrictionType.ALIASES);
        HierarchyRootMembersQuery query = new HierarchyRootMembersQuery(this);
        query.setLocale(this.mLocale);
        query.setCubeName(cubeName);
        query.setHUN(hun);
        query.setAliasTable(TM1AliasTable.parse(aliases));
        this.setRangeRestrictions(query, restrictions);
        try {
            List<MemberRecord> list = query.execute();
            return list;
        }
        finally {
            query.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<LevelRecord> getLevelRecords(IRestrictions restrictions) throws TM1Exception {
        String cubeName = (String)restrictions.getValueOf(RestrictionType.CUBE);
        String dun = (String)restrictions.getValueOf(RestrictionType.DIMENSION_UNIQUE_NAME);
        String hun = (String)restrictions.getValueOf(RestrictionType.HIERARCHY_UNIQUE_NAME);
        String lun = (String)restrictions.getValueOf(RestrictionType.LEVEL_UNIQUE_NAME);
        Integer levelNumber = (Integer)restrictions.getValueOf(RestrictionType.LEVEL_NUMBER);
        LevelRecordQuery query = new LevelRecordQuery(this);
        query.setLocale(this.mLocale);
        query.setCubeName(cubeName);
        query.setDUN(dun);
        query.setHUN(hun);
        query.setLUN(lun);
        query.setLevelNumber(levelNumber);
        this.setRangeRestrictions(query, restrictions);
        try {
            List<LevelRecord> list = query.execute();
            return list;
        }
        finally {
            query.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<MeasureRecord> getMeasureRecords(IRestrictions restrictions) throws TM1Exception {
        String cubeName = (String)restrictions.getValueOf(RestrictionType.CUBE);
        String mun = (String)restrictions.getValueOf(RestrictionType.MEASURE_UNIQUE_NAME);
        Integer levelNumber = (Integer)restrictions.getValueOf(RestrictionType.LEVEL_NUMBER);
        EnumSet treeOps = (EnumSet)restrictions.getValueOf(RestrictionType.TREEOP);
        Map aliases = (Map)restrictions.getValueOf(RestrictionType.ALIASES);
        boolean rootsOnly = false;
        if (null != levelNumber) {
            if (levelNumber == 0) {
                rootsOnly = true;
            } else {
                throw new XQERuntimeException(XQEMessageKeys.MD_RestrictionIllegalValue, "LEVEL_NUMBER", levelNumber.toString());
            }
        }
        boolean includeSelf = false;
        boolean includeChildren = false;
        if (null != treeOps) {
            block7: for (TreeOperatorEnum op : treeOps) {
                switch (op) {
                    case SELF: {
                        includeSelf = true;
                        continue block7;
                    }
                    case CHILDREN: {
                        includeChildren = true;
                        continue block7;
                    }
                }
                throw new XQERuntimeException(XQEMessageKeys.MD_RestrictionIllegalValue, "TREEOP", treeOps.toString());
            }
        } else {
            includeSelf = true;
        }
        MeasureRecordQuery query = new MeasureRecordQuery(this);
        query.setLocale(this.mLocale);
        query.setCubeName(cubeName);
        query.setMUN(mun);
        query.setRootsOnly(rootsOnly);
        query.setIncludeSelf(includeSelf);
        query.setIncludeChildren(includeChildren);
        query.setAliasTable(TM1AliasTable.parse(aliases));
        this.setRangeRestrictions(query, restrictions);
        try {
            List<MeasureRecord> list = query.execute();
            return list;
        }
        finally {
            query.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<MemberRecord> getMemberRecords(IRestrictions restrictions) throws TM1Exception {
        String cubeName = (String)restrictions.getValueOf(RestrictionType.CUBE);
        String dun = (String)restrictions.getValueOf(RestrictionType.DIMENSION_UNIQUE_NAME);
        String hun = (String)restrictions.getValueOf(RestrictionType.HIERARCHY_UNIQUE_NAME);
        String lun = (String)restrictions.getValueOf(RestrictionType.LEVEL_UNIQUE_NAME);
        Integer levelNumber = (Integer)restrictions.getValueOf(RestrictionType.LEVEL_NUMBER);
        Integer depth = (Integer)restrictions.getValueOf(RestrictionType.SCOPE);
        Integer createdLevelNumber = null;
        if (TM1MetadataSession.isCreatedLevel(lun)) {
            createdLevelNumber = TM1MetadataSession.levelUniqueNameToLevelNumber(lun);
        }
        String mun = (String)restrictions.getValueOf(RestrictionType.MEMBER_UNIQUE_NAME);
        Collection ppdsCodes = (Collection)restrictions.getValueOf(RestrictionType.PPDS_CODES);
        MASearchCriteria searchCriteria = (MASearchCriteria)restrictions.getValueOf(RestrictionType.MEMBERSEARCH);
        EnumSet treeOps = (EnumSet)restrictions.getValueOf(RestrictionType.TREEOP);
        Map aliases = (Map)restrictions.getValueOf(RestrictionType.ALIASES);
        MemberRecordQuery query = new MemberRecordQuery(this);
        query.setLocale(this.mLocale);
        query.setCubeName(cubeName);
        query.setDUN(dun);
        query.setHUN(hun);
        if (createdLevelNumber != null) {
            query.setLevelNumber(createdLevelNumber);
            if (hun == null) {
                query.setHUN(TM1Utils.extractMDDSHUNFromMDDSLUN(lun));
            }
        } else {
            query.setLUN(lun);
        }
        if (levelNumber != null) {
            query.setLevelNumber(levelNumber);
        }
        if (searchCriteria != null && depth != null) {
            searchCriteria.setDepth(depth.intValue());
        }
        query.setMUN(mun);
        query.setPPDSCodes(ppdsCodes);
        query.setTreeOps(treeOps);
        query.setSearchCriteria(searchCriteria);
        query.setAliasTable(TM1AliasTable.parse(aliases));
        query.setDynamicProperties((String)restrictions.getValueOf(RestrictionType.DIMENSION_PROPERTIES));
        this.setRangeRestrictions(query, restrictions);
        try {
            List<MemberRecord> list = query.execute();
            return list;
        }
        finally {
            query.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<PropertyRecord> getPropertyRecords(IRestrictions restrictions) throws TM1Exception {
        String cubeName = (String)restrictions.getValueOf(RestrictionType.CUBE);
        String dun = (String)restrictions.getValueOf(RestrictionType.DIMENSION_UNIQUE_NAME);
        String hun = (String)restrictions.getValueOf(RestrictionType.HIERARCHY_UNIQUE_NAME);
        String lun = (String)restrictions.getValueOf(RestrictionType.LEVEL_UNIQUE_NAME);
        String property = (String)restrictions.getValueOf(RestrictionType.PROPERTY);
        PropertyRecordQuery query = new PropertyRecordQuery(this);
        query.setLocale(this.mLocale);
        query.setCubeName(cubeName);
        query.setDUN(dun);
        query.setHUN(hun);
        query.setLUN(lun);
        query.setPUN(property);
        this.setRangeRestrictions(query, restrictions);
        try {
            List<PropertyRecord> list = query.execute();
            return list;
        }
        finally {
            query.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TM1CubeTimestamps getCubeTimestamps(String cubeName) throws TM1Exception {
        Server serverAPI = this.getServer();
        Cube cube = serverAPI.findCube(cubeName);
        if (null == cube) {
            throw new TM1ODPException(TM1MessageKeys.MET_CANNOT_FIND_CUBE, cubeName);
        }
        try {
            TM1CubeTimestamps tM1CubeTimestamps = new TM1CubeTimestamps(cube.getLastSchemaUpdate(), cube.getLastDataUpdate());
            return tM1CubeTimestamps;
        }
        finally {
            cube.dispose();
        }
    }

    private void setRangeRestrictions(MetadataQuery<?> query, IRestrictions restrictions) {
        Integer rangeFrom = (Integer)restrictions.getValueOf(RestrictionType.FROM);
        Integer rangeSize = (Integer)restrictions.getValueOf(RestrictionType.SIZE);
        if (null != rangeFrom) {
            query.setRangeFrom(rangeFrom);
        }
        if (null != rangeSize) {
            EnumSet treeOpSet = (EnumSet)restrictions.getValueOf(RestrictionType.TREEOP, null);
            if (treeOpSet != null && treeOpSet.contains(TreeOperatorEnum.SELF) && treeOpSet.size() > 1 && rangeSize != Integer.MAX_VALUE) {
                Integer n = rangeSize;
                Integer n2 = rangeSize = Integer.valueOf(rangeSize + 1);
            }
            query.setRangeSize(rangeSize);
        }
    }

    private static boolean isCreatedLevel(String lun) {
        if (lun == null) {
            return false;
        }
        Matcher matcher = TM1Constants.PC_LEVEL_NAME_PATTERN.matcher(lun);
        return matcher.find();
    }

    private static int levelUniqueNameToLevelNumber(String lun) {
        if (lun == null) {
            return -1;
        }
        Matcher matcher = TM1Constants.PC_LEVEL_NAME_PATTERN.matcher(lun);
        if (matcher.find()) {
            return Integer.valueOf(matcher.group(1));
        }
        return -1;
    }
}

