/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.data.providers.olap.tm1.metadata.query;

import com.cognos.xqe.data.providers.olap.tm1.TM1MessageKeys;
import com.cognos.xqe.data.providers.olap.tm1.TM1ODPException;
import com.cognos.xqe.data.providers.olap.tm1.metadata.TM1Cube;
import com.cognos.xqe.data.providers.olap.tm1.metadata.TM1Dimension;
import com.cognos.xqe.data.providers.olap.tm1.metadata.TM1Hierarchy;
import com.cognos.xqe.data.providers.olap.tm1.metadata.TM1Member;
import com.cognos.xqe.data.providers.olap.tm1.metadata.TM1MetadataSession;
import com.cognos.xqe.data.providers.olap.tm1.metadata.query.MetadataQuery;
import com.cognos.xqe.data.providers.olap.tm1.util.TM1Utils;
import com.ibm.cognos.tm1.TM1Exception;
import java.util.Collections;
import java.util.List;

public class CubeDefaultMeasureQuery
extends MetadataQuery<String> {
    private String mCubeName;

    public CubeDefaultMeasureQuery(TM1MetadataSession session) {
        super(session);
    }

    public void setCubeName(String cubeName) {
        this.mCubeName = cubeName;
    }

    @Override
    public List<String> execute() throws TM1Exception {
        List<TM1Member> roots;
        TM1Cube cube = this.getLoader().loadCube(this.mCubeName, this.getCubeCache());
        if (null == cube) {
            throw new TM1ODPException(TM1MessageKeys.MET_CANNOT_FIND_CUBE, this.mCubeName);
        }
        TM1Dimension measureDimension = cube.getMeasureDimension();
        if (null == measureDimension) {
            throw new TM1ODPException(TM1MessageKeys.MET_NO_MEASURE_DIMENSION, this.mCubeName);
        }
        TM1Hierarchy measureHier = measureDimension.getDefaultHierarchy();
        if (null == measureHier) {
            throw new TM1ODPException(TM1MessageKeys.MET_NONEXISTANT_HIERARCHY, measureDimension.getDefaultHierarchyName());
        }
        String measureUN = measureHier.getDefaultMemberUN();
        if (!(null != measureUN && measureUN.length() != 0 || (roots = measureHier.getAccessibleRoots()).isEmpty())) {
            measureUN = roots.get(0).getProviderUniqueName();
        }
        if (null != measureUN && measureUN.length() > 0) {
            measureUN = TM1Utils.convertProviderMUNToMDDSMUN(measureHier.getCommonMUNPrefix(), measureUN);
            return Collections.singletonList(measureUN);
        }
        return Collections.emptyList();
    }
}

