/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.data.providers.olap.tm1.metadata.query;

import com.cognos.xqe.data.providers.olap.tm1.metadata.TM1Cube;
import com.cognos.xqe.data.providers.olap.tm1.metadata.TM1MetadataSession;
import com.cognos.xqe.data.providers.olap.tm1.metadata.query.MetadataQuery;
import com.cognos.xqe.data.providers.olap.tm1.util.TM1Utils;
import com.cognos.xqe.data.values.DateTimeValue;
import com.cognos.xqe.metadata.record.CubeRecord;
import com.cognos.xqe.util.ILocalizedString;
import com.cognos.xqe.util.LocalizedString;
import com.ibm.cognos.tm1.TM1Exception;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class CubeRecordQuery
extends MetadataQuery<CubeRecord> {
    private String mCubeName = null;

    public CubeRecordQuery(TM1MetadataSession session) {
        super(session);
    }

    public void setCubeName(String cubeName) {
        this.mCubeName = cubeName;
    }

    @Override
    public List<CubeRecord> execute() throws TM1Exception {
        this.checkRangeRestrictions();
        if (this.mRangeSize < 1) {
            return Collections.emptyList();
        }
        if (null != this.mCubeName) {
            TM1Cube cube = this.getLoader().shallowLoadCube(this.mCubeName);
            if (null == cube) {
                return Collections.emptyList();
            }
            if (this.isInRange(0)) {
                return Collections.singletonList(this.buildRecord(cube));
            }
            return Collections.emptyList();
        }
        List<TM1Cube> allCubes = this.getLoader().shallowLoadAllCubes();
        int effectiveSize = Math.min(this.mRangeSize, allCubes.size() - this.mRangeFrom);
        if (effectiveSize <= 0) {
            return Collections.emptyList();
        }
        ArrayList<CubeRecord> records = new ArrayList<CubeRecord>(effectiveSize);
        for (int i = this.mRangeFrom; i < this.mRangeFrom + effectiveSize; ++i) {
            records.add(this.buildRecord(allCubes.get(i)));
        }
        return records;
    }

    private CubeRecord buildRecord(TM1Cube cube) {
        CubeRecord record = new CubeRecord();
        record.setCatalogName("CATALOG");
        record.setName(cube.getName());
        record.setUniqueName(cube.getName());
        record.setDescription(cube.getName());
        record.setCaption((ILocalizedString)new LocalizedString(this.mLocale, cube.getCaption()));
        record.setCreatedDate((DateTimeValue)TM1Utils.getTimestampValue(cube.getLastSchemaUpdate()));
        record.setDataUpdateDate((DateTimeValue)TM1Utils.getTimestampValue(cube.getLastDataUpdate()));
        record.setSchemaUpdateDate((DateTimeValue)TM1Utils.getTimestampValue(cube.getLastSchemaUpdate()));
        record.setDynamicFieldAsBoolean("IsUnderFed", Boolean.valueOf(cube.isUnderFed()));
        return record;
    }

    @Override
    public void release() {
        super.release();
    }
}

