/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.data.providers.olap.tm1.metadata.query;

import com.cognos.xqe.data.providers.olap.tm1.TM1MessageKeys;
import com.cognos.xqe.data.providers.olap.tm1.TM1ODPException;
import com.cognos.xqe.data.providers.olap.tm1.metadata.TM1Cube;
import com.cognos.xqe.data.providers.olap.tm1.metadata.TM1Dimension;
import com.cognos.xqe.data.providers.olap.tm1.metadata.TM1Hierarchy;
import com.cognos.xqe.data.providers.olap.tm1.metadata.TM1Level;
import com.cognos.xqe.data.providers.olap.tm1.metadata.TM1Member;
import com.cognos.xqe.data.providers.olap.tm1.metadata.TM1MetadataSession;
import com.cognos.xqe.data.providers.olap.tm1.metadata.query.MetadataQuery;
import com.cognos.xqe.data.providers.olap.tm1.util.TM1AliasTable;
import com.cognos.xqe.data.providers.olap.tm1.util.TM1Utils;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.metadata.RollupTypeEnum;
import com.cognos.xqe.metadata.record.MemberRecord;
import com.cognos.xqe.util.ILocalizedString;
import com.cognos.xqe.util.LocalizedString;
import com.ibm.cognos.tm1.TM1Exception;
import java.util.ArrayList;
import java.util.List;

public class HierarchyRootMembersQuery
extends MetadataQuery<MemberRecord> {
    private String mCubeName = null;
    private String mHUN = null;
    private TM1AliasTable mAliasTable = null;

    public HierarchyRootMembersQuery(TM1MetadataSession session) {
        super(session);
    }

    public void setCubeName(String cubeName) {
        this.mCubeName = cubeName;
    }

    public void setHUN(String hun) {
        this.mHUN = hun;
    }

    public void setAliasTable(TM1AliasTable aliasTable) {
        this.mAliasTable = aliasTable;
    }

    @Override
    public List<MemberRecord> execute() throws TM1Exception {
        if (null == this.mCubeName) {
            throw new XQERuntimeException(XQEMessageKeys.GEN_FoundInternalErrorParam_INTERNAL, "A cube name was not specified.");
        }
        if (null == this.mHUN) {
            throw new XQERuntimeException(XQEMessageKeys.GEN_FoundInternalErrorParam_INTERNAL, "A Hierarchy Unique Name was not specified.");
        }
        TM1Cube cube = this.getLoader().loadCube(this.mCubeName, this.getCubeCache());
        if (null == cube) {
            throw new TM1ODPException(TM1MessageKeys.MET_CANNOT_FIND_CUBE, this.mCubeName);
        }
        TM1Hierarchy hierarchy = TM1Utils.findHierarchy(cube, this.mHUN, true);
        List<TM1Member> accessibleRoots = hierarchy.getAccessibleRoots();
        ArrayList<MemberRecord> records = new ArrayList<MemberRecord>(accessibleRoots.size());
        for (TM1Member member : accessibleRoots) {
            records.add(this.buildRecord(member));
        }
        return records;
    }

    private MemberRecord buildRecord(TM1Member member) {
        TM1Level level = member.getLevel();
        TM1Hierarchy hierarchy = level.getHierarchy();
        TM1Dimension dimension = hierarchy.getDimension();
        TM1Cube cube = dimension.getCube();
        MemberRecord record = new MemberRecord();
        record.setCatalogName("CATALOG");
        record.setCubeName(cube.getName());
        record.setDimensionUniqueName(dimension.getUniqueName());
        record.setHierarchyUniqueName(hierarchy.getUniqueName());
        if (hierarchy.isParentChild() && hierarchy.isRagged()) {
            record.setLevelNumber(0);
            record.setLevelUniqueName(hierarchy.findLevel(0).getUniqueName());
        } else {
            record.setLevelNumber(member.getLevelNumber());
            record.setLevelUniqueName(level.getUniqueName());
        }
        record.setParentLevelNumber(-1);
        record.setName(member.getName());
        record.setUniqueName(member.getUniqueName());
        record.setDescription(member.getDescription());
        record.setChildCardinality((int)member.getChildrenCardinality());
        record.setRollupType(RollupTypeEnum.ROLLUP);
        record.setUniqueId(member.getName());
        record.setDynamicField("PPDS_KEY", (Object)member.getName());
        LocalizedString caption = TM1Utils.buildLocalizedCaption(this.getSession().getLocale(), member.getCaption(), this.mAliasTable, dimension.getName(), member.getAliasValues());
        record.setCaption((ILocalizedString)caption);
        return record;
    }
}

