/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.data.providers.olap.tm1.metadata.query;

import com.cognos.xqe.data.providers.olap.tm1.TM1MessageKeys;
import com.cognos.xqe.data.providers.olap.tm1.TM1ODPException;
import com.cognos.xqe.data.providers.olap.tm1.metadata.TM1Cube;
import com.cognos.xqe.data.providers.olap.tm1.metadata.TM1Dimension;
import com.cognos.xqe.data.providers.olap.tm1.metadata.TM1Hierarchy;
import com.cognos.xqe.data.providers.olap.tm1.metadata.TM1Level;
import com.cognos.xqe.data.providers.olap.tm1.metadata.TM1MetadataSession;
import com.cognos.xqe.data.providers.olap.tm1.metadata.query.MetadataQuery;
import com.cognos.xqe.data.providers.olap.tm1.util.TM1Utils;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.metadata.record.LevelRecord;
import com.cognos.xqe.util.ILocalizedString;
import com.cognos.xqe.util.LocalizedString;
import com.ibm.cognos.tm1.TM1Exception;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class LevelRecordQuery
extends MetadataQuery<LevelRecord> {
    private String mCubeName = null;
    private String mDUN = null;
    private String mHUN = null;
    private String mLUN = null;
    private Integer mLevelNumber = null;

    public LevelRecordQuery(TM1MetadataSession session) {
        super(session);
    }

    public void setCubeName(String cubeName) {
        this.mCubeName = cubeName;
    }

    public void setDUN(String dun) {
        this.mDUN = dun;
    }

    public void setHUN(String hun) {
        this.mHUN = hun;
    }

    public void setLUN(String lun) {
        this.mLUN = lun;
    }

    public void setLevelNumber(Integer levelNumber) {
        this.mLevelNumber = levelNumber;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public List<LevelRecord> execute() throws TM1Exception {
        void var5_10;
        this.checkRangeRestrictions();
        if (null == this.mCubeName) {
            throw new XQERuntimeException(XQEMessageKeys.GEN_FoundInternalErrorParam_INTERNAL, "A cube name was not specified.");
        }
        if (this.mRangeSize < 1) {
            return Collections.emptyList();
        }
        TM1Cube cube = this.getLoader().loadCube(this.mCubeName, this.getCubeCache());
        if (null == cube) {
            throw new TM1ODPException(TM1MessageKeys.MET_CANNOT_FIND_CUBE, this.mCubeName);
        }
        ArrayList<TM1Level> levelsFound = new ArrayList<TM1Level>();
        if (null != this.mLUN) {
            TM1Level level = TM1Utils.findLevel(cube, this.mLUN, false);
            if (null != level) {
                levelsFound.add(level);
            }
        } else if (null != this.mHUN) {
            TM1Hierarchy hierarchy = TM1Utils.findHierarchy(cube, this.mHUN, false);
            if (null != hierarchy) {
                this.addLevelsFromHierarchy(hierarchy, levelsFound);
            }
        } else if (null != this.mDUN) {
            TM1Dimension dimension = TM1Utils.findDimension(cube, this.mDUN, false);
            if (null != dimension) {
                for (TM1Hierarchy tM1Hierarchy : dimension.getHierarchies()) {
                    this.addLevelsFromHierarchy(tM1Hierarchy, levelsFound);
                }
            }
        } else {
            for (TM1Dimension dimension : cube.getDimensions()) {
                for (TM1Hierarchy hierarchy : dimension.getHierarchies()) {
                    this.addLevelsFromHierarchy(hierarchy, levelsFound);
                }
            }
        }
        int effectiveSize = Math.min(this.mRangeSize, levelsFound.size() - this.mRangeFrom);
        if (effectiveSize <= 0) {
            return Collections.emptyList();
        }
        ArrayList<LevelRecord> records = new ArrayList<LevelRecord>(effectiveSize);
        int n = this.mRangeFrom;
        while (var5_10 < this.mRangeFrom + effectiveSize) {
            records.add(this.buildRecord((TM1Level)levelsFound.get((int)var5_10)));
            ++var5_10;
        }
        return records;
    }

    private void addLevelsFromHierarchy(TM1Hierarchy hierarchy, List<TM1Level> result) {
        if (null != this.mLevelNumber) {
            TM1Level level = hierarchy.findLevel(this.mLevelNumber);
            if (null != level) {
                result.add(level);
            }
        } else {
            result.addAll(hierarchy.getLevels());
        }
    }

    private LevelRecord buildRecord(TM1Level level) {
        TM1Hierarchy hierarchy = level.getHierarchy();
        TM1Dimension dimension = hierarchy.getDimension();
        TM1Cube cube = dimension.getCube();
        LevelRecord record = new LevelRecord();
        record.setCatalogName("CATALOG");
        record.setCubeName(cube.getName());
        record.setDimensionUniqueName(dimension.getUniqueName());
        record.setHierarchyUniqueName(hierarchy.getUniqueName());
        record.setUniqueName(level.getUniqueName());
        record.setName(level.getName());
        record.setCaption((ILocalizedString)new LocalizedString(this.mLocale, level.getCaption()));
        record.setDescription(record.getName());
        record.setCardinality((int)level.getCardinality());
        record.setUniqueMemberNames(false);
        record.setLevelNumber(level.getLevelNumber());
        record.setHidden(Boolean.valueOf(hierarchy.isParentChild()));
        record.setUniqueId(record.getName());
        record.setDynamicField("PPDS_KEY", (Object)record.getName());
        return record;
    }

    @Override
    public void release() {
    }
}

