/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.data.providers.olap.tm1.util;

import com.cognos.xqe.data.providers.olap.tm1.TM1Connection;
import com.cognos.xqe.data.providers.olap.tm1.TM1MessageKeys;
import com.cognos.xqe.data.providers.olap.tm1.TM1ODPException;
import com.cognos.xqe.exception.IMessageKey;
import com.cognos.xqe.exception.XQEMessages;
import com.ibm.cognos.tm1.ErrorCode;
import com.ibm.cognos.tm1.TM1Exception;
import java.util.Locale;

public final class TM1ExceptionConverter {
    private static final char COLON = ':';
    private static final char DOUBLE_QUOTE = '\"';

    public static TM1ODPException convert(TM1Exception e, String context) {
        ErrorCode errCode = e.getErrorCode();
        String message = e.getMessage();
        switch (errCode) {
            case CAMDllLoadFailed: 
            case CannotInitializeAPI: 
            case JavaAPIInitializationFailed: {
                return new TM1ODPException(TM1MessageKeys.JAP_CANNOT_INITIALIZE_API, errCode.toString(), message);
            }
            case APINotFound: 
            case APIFunctionFailed: 
            case APIFunctionNotSupported: 
            case NGAPIError: {
                return new TM1ODPException(TM1MessageKeys.JAP_TM1_API_CALL_FAILED, errCode.toString(), (Object)message, (Object)context);
            }
            case ServerConfigurationNotFound: 
            case ServerNotFound: {
                return new TM1ODPException(TM1MessageKeys.CON_SERVER_NOT_RESPONDING, message, context);
            }
            case SystemServerNotFound: 
            case DatabaseConnectionFailed: {
                return new TM1ODPException(TM1MessageKeys.CON_CANNOT_LOGIN, errCode.toString(), (Object)message, (Object)context);
            }
            case Unknown: 
            case UnhandledException: {
                return new TM1ODPException(TM1MessageKeys.ERR_UNKNOWN, errCode.toString(), message);
            }
            case InvalidMDXExpression: {
                return new TM1ODPException(TM1MessageKeys.ERR_TM1ODP_DATAQUERY_FAILED_DURINGEXECUTE, errCode.toString(), message);
            }
            case UnsupportedOperation: {
                return new TM1ODPException(TM1MessageKeys.ERR_INTERNAL, errCode.toString(), message);
            }
            case DatabaseQueryExecutionFailed: 
            case CubeNotFound: {
                return new TM1ODPException(TM1MessageKeys.MET_CANNOT_FIND_CUBE, message);
            }
            case DimensionNotFound: {
                return new TM1ODPException(TM1MessageKeys.MET_NONEXISTANT_DIMENSION, message);
            }
            case HierarchyNotFound: {
                return new TM1ODPException(TM1MessageKeys.MET_NONEXISTANT_HIERARCHY, message);
            }
            case ObjectNotLoaded: 
            case ObjectNotFound: 
            case ObjectLoadFailed: {
                return new TM1ODPException(TM1MessageKeys.ERR_INTERNAL, errCode.toString(), message);
            }
        }
        return new TM1ODPException(TM1MessageKeys.JAP_GENERIC_ERROR, errCode.toString(), (Object)message, (Object)context);
    }

    public static TM1ODPException convert(TM1Exception e) {
        return TM1ExceptionConverter.convert(e, "");
    }

    private TM1ExceptionConverter() {
    }

    public static TM1ODPException convert(TM1Exception e, String adminHost, String serverName, Locale locale) {
        String context = TM1ExceptionConverter.getContextInformation(adminHost, serverName, locale);
        return TM1ExceptionConverter.convert(e, context);
    }

    public static TM1ODPException convert(TM1Exception e, TM1Connection tm1Connection) {
        String context = TM1ExceptionConverter.getContextInformation(tm1Connection);
        return TM1ExceptionConverter.convert(e, context);
    }

    public static String getContextInformation(TM1Connection tm1Connection) {
        Locale productLocale = tm1Connection.getProductLocale1();
        StringBuilder sb = new StringBuilder();
        String serverAdminHostIdentifier = XQEMessages.getMessage((IMessageKey.Param0)TM1MessageKeys.CXT_ADMIN_HOST, (Locale)productLocale);
        String serverNameIdentifier = XQEMessages.getMessage((IMessageKey.Param0)TM1MessageKeys.CXT_SERVER_NAME, (Locale)productLocale);
        TM1ExceptionConverter.appendContext(sb, serverAdminHostIdentifier, tm1Connection.getServerAdminHost());
        TM1ExceptionConverter.appendContext(sb, serverNameIdentifier, tm1Connection.getServerName());
        return sb.toString();
    }

    public static String getContextInformation(String adminHost, String serverName, Locale locale) {
        StringBuilder sb = new StringBuilder();
        String serverAdminHostIdentifier = XQEMessages.getMessage((IMessageKey.Param0)TM1MessageKeys.CXT_ADMIN_HOST, (Locale)locale);
        String serverNameIdentifier = XQEMessages.getMessage((IMessageKey.Param0)TM1MessageKeys.CXT_SERVER_NAME, (Locale)locale);
        TM1ExceptionConverter.appendContext(sb, serverAdminHostIdentifier, adminHost);
        TM1ExceptionConverter.appendContext(sb, serverNameIdentifier, serverName);
        return sb.toString();
    }

    public static String appendContext(StringBuilder sb, String name, String value) {
        sb.append("\n    ");
        sb.append(name);
        sb.append(':');
        sb.append('\"');
        sb.append(value);
        sb.append('\"');
        return sb.toString();
    }
}

