/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.data.providers.olap.tm1.util;

import com.cognos.xqe.data.providers.olap.tm1.util.ITM1Field;
import com.cognos.xqe.data.providers.olap.tm1.util.ITM1RowsetView;
import com.cognos.xqe.util.UniqueNameParser;
import com.cognos.xqe.util.UniqueNameParserException;
import com.ibm.cognos.tm1.Field;
import com.ibm.cognos.tm1.FieldType;
import com.ibm.cognos.tm1.Rowset;
import com.ibm.cognos.tm1.TM1Exception;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;

public final class TM1RowsetAccessor<T extends Enum<T>>
implements ITM1RowsetView<T> {
    private static final String ERRMSG_FIELD_NOT_FOUND = "Field not found: ";
    private final Class<T> mFieldType;
    private final Rowset mRowset;
    private final Field[] mFields;
    private final EnumMap<T, Long> mEnumToFieldIndex;
    private final Map<String, Long> mQualifiedNameToFieldIndex;

    protected TM1RowsetAccessor(Rowset rowset, Class<T> fieldType) throws TM1Exception {
        if (!ITM1Field.class.isAssignableFrom(fieldType)) {
            throw new IllegalArgumentException("Field type is not compatible: " + fieldType.getName());
        }
        this.mFieldType = fieldType;
        this.mRowset = rowset;
        this.mFields = rowset.getFields();
        this.mEnumToFieldIndex = new EnumMap(fieldType);
        this.mQualifiedNameToFieldIndex = new HashMap<String, Long>();
        for (int i = 0; i < this.mFields.length; ++i) {
            this.mQualifiedNameToFieldIndex.put(this.mFields[i].Name, Long.valueOf(i));
        }
        for (Enum t : EnumSet.allOf(fieldType)) {
            ITM1Field field = (ITM1Field)((Object)t);
            Long index = this.mQualifiedNameToFieldIndex.get(field.getFieldName());
            if (null == index) continue;
            this.mEnumToFieldIndex.put(t, index);
        }
    }

    public ITM1RowsetView<T> createQualifiedView(String dimensionName) {
        return new DimensionQualifiedView(dimensionName);
    }

    @Override
    public long getRowCount() throws TM1Exception {
        return this.mRowset.getCount();
    }

    @Override
    public boolean next() throws TM1Exception {
        return this.mRowset.getNext();
    }

    @Override
    public void reset() throws TM1Exception {
        this.mRowset.reset();
    }

    @Override
    public boolean containsField(T field) {
        return this.mEnumToFieldIndex.containsKey(field);
    }

    @Override
    public boolean containsField(String fieldName) throws TM1Exception {
        return this.mQualifiedNameToFieldIndex.containsKey(fieldName);
    }

    @Override
    public long getFieldIndex(T field) {
        Long offset = this.mEnumToFieldIndex.get(field);
        if (null == offset) {
            throw new IllegalArgumentException(ERRMSG_FIELD_NOT_FOUND + ((ITM1Field)field).getFieldName());
        }
        return offset;
    }

    @Override
    public long getFieldIndex(String fieldName) {
        Long index = this.mQualifiedNameToFieldIndex.get(fieldName);
        if (null != index) {
            return index;
        }
        throw new IllegalArgumentException(ERRMSG_FIELD_NOT_FOUND + fieldName);
    }

    @Override
    public FieldType getFieldType(T field) throws TM1Exception {
        long index = this.getFieldIndex(field);
        FieldType type = this.mFields[(int)index].Type;
        if (FieldType.Unknown == type) {
            return this.mRowset.getFieldType(index);
        }
        return type;
    }

    @Override
    public FieldType getFieldType(String fieldName) throws TM1Exception {
        long index = this.getFieldIndex(fieldName);
        FieldType type = this.mFields[(int)index].Type;
        if (FieldType.Unknown == type) {
            return this.mRowset.getFieldType(index);
        }
        return type;
    }

    @Override
    public String getQualifiedFieldName(T field) {
        return this.mFields[(int)this.getFieldIndex(field)].Name;
    }

    @Override
    public String getQualifiedFieldName(String fieldName) {
        return this.mFields[(int)this.getFieldIndex((String)fieldName)].Name;
    }

    @Override
    public String getStringField(T field) throws TM1Exception {
        return this.mRowset.getStringField(this.getFieldIndex(field));
    }

    @Override
    public String getStringField(String fieldName) throws TM1Exception {
        return this.mRowset.getStringField(this.getFieldIndex(fieldName));
    }

    @Override
    public boolean getBooleanField(T field) throws TM1Exception {
        return this.mRowset.getBooleanField(this.getFieldIndex(field));
    }

    @Override
    public boolean getBooleanField(String fieldName) throws TM1Exception {
        return this.mRowset.getBooleanField(this.getFieldIndex(fieldName));
    }

    @Override
    public double getDoubleField(T field) throws TM1Exception {
        return this.mRowset.getDoubleField(this.getFieldIndex(field));
    }

    @Override
    public double getDoubleField(String fieldName) throws TM1Exception {
        return this.mRowset.getDoubleField(this.getFieldIndex(fieldName));
    }

    @Override
    public long getIntegerField(T field) throws TM1Exception {
        return this.mRowset.getIntegerField(this.getFieldIndex(field));
    }

    @Override
    public long getIntegerField(String fieldName) throws TM1Exception {
        return this.mRowset.getIntegerField(this.getFieldIndex(fieldName));
    }

    public static <F extends Enum<F>> TM1RowsetAccessor<F> create(Rowset rowset, Class<F> fieldType) throws TM1Exception {
        return new TM1RowsetAccessor<F>(rowset, fieldType);
    }

    private final class DimensionQualifiedView
    implements ITM1RowsetView<T> {
        private final String mDimensionName;
        private final EnumMap<T, Long> mEnumToFieldIndex;
        private final Map<String, Long> mNameToFieldIndex;

        DimensionQualifiedView(String dimensionName) {
            this.mDimensionName = dimensionName;
            this.mEnumToFieldIndex = new EnumMap(TM1RowsetAccessor.this.mFieldType);
            this.mNameToFieldIndex = new HashMap<String, Long>();
            for (Map.Entry e : TM1RowsetAccessor.this.mQualifiedNameToFieldIndex.entrySet()) {
                try {
                    String[] nameParts = UniqueNameParser.parse((String)((String)e.getKey()));
                    if (nameParts.length <= 1 || !nameParts[0].equals(this.mDimensionName)) continue;
                    this.mNameToFieldIndex.put(nameParts[1], (Long)e.getValue());
                }
                catch (UniqueNameParserException nameParts) {}
            }
            for (Enum t : EnumSet.allOf(TM1RowsetAccessor.this.mFieldType)) {
                ITM1Field field = (ITM1Field)((Object)t);
                Long index = this.mNameToFieldIndex.get(field.getFieldName());
                if (null == index) continue;
                this.mEnumToFieldIndex.put(t, index);
            }
        }

        @Override
        public long getRowCount() throws TM1Exception {
            return TM1RowsetAccessor.this.mRowset.getCount();
        }

        @Override
        public boolean next() throws TM1Exception {
            return TM1RowsetAccessor.this.mRowset.getNext();
        }

        @Override
        public void reset() throws TM1Exception {
            TM1RowsetAccessor.this.mRowset.reset();
        }

        @Override
        public boolean containsField(T field) {
            return this.mEnumToFieldIndex.containsKey(field);
        }

        @Override
        public boolean containsField(String fieldName) throws TM1Exception {
            return this.mNameToFieldIndex.containsKey(fieldName);
        }

        @Override
        public long getFieldIndex(T field) {
            Long offset = this.mEnumToFieldIndex.get(field);
            if (null == offset) {
                throw new IllegalArgumentException(TM1RowsetAccessor.ERRMSG_FIELD_NOT_FOUND + ((ITM1Field)field).getFieldName());
            }
            return offset;
        }

        @Override
        public long getFieldIndex(String fieldName) {
            Long index = this.mNameToFieldIndex.get(fieldName);
            if (null != index) {
                return index;
            }
            throw new IllegalArgumentException(TM1RowsetAccessor.ERRMSG_FIELD_NOT_FOUND + fieldName);
        }

        @Override
        public FieldType getFieldType(T field) throws TM1Exception {
            long index = this.getFieldIndex(field);
            FieldType type = ((TM1RowsetAccessor)TM1RowsetAccessor.this).mFields[(int)index].Type;
            if (FieldType.Unknown == type) {
                return TM1RowsetAccessor.this.mRowset.getFieldType(index);
            }
            return type;
        }

        @Override
        public FieldType getFieldType(String fieldName) throws TM1Exception {
            long index = this.getFieldIndex(fieldName);
            FieldType type = ((TM1RowsetAccessor)TM1RowsetAccessor.this).mFields[(int)index].Type;
            if (FieldType.Unknown == type) {
                return TM1RowsetAccessor.this.mRowset.getFieldType(index);
            }
            return type;
        }

        @Override
        public String getQualifiedFieldName(T field) {
            return ((TM1RowsetAccessor)TM1RowsetAccessor.this).mFields[(int)this.getFieldIndex(field)].Name;
        }

        @Override
        public String getQualifiedFieldName(String fieldName) {
            return ((TM1RowsetAccessor)TM1RowsetAccessor.this).mFields[(int)this.getFieldIndex((String)fieldName)].Name;
        }

        @Override
        public String getStringField(T field) throws TM1Exception {
            return TM1RowsetAccessor.this.mRowset.getStringField(this.getFieldIndex(field));
        }

        @Override
        public String getStringField(String fieldName) throws TM1Exception {
            return TM1RowsetAccessor.this.mRowset.getStringField(this.getFieldIndex(fieldName));
        }

        @Override
        public boolean getBooleanField(T field) throws TM1Exception {
            return TM1RowsetAccessor.this.mRowset.getBooleanField(this.getFieldIndex(field));
        }

        @Override
        public boolean getBooleanField(String fieldName) throws TM1Exception {
            return TM1RowsetAccessor.this.mRowset.getBooleanField(this.getFieldIndex(fieldName));
        }

        @Override
        public double getDoubleField(T field) throws TM1Exception {
            return TM1RowsetAccessor.this.mRowset.getDoubleField(this.getFieldIndex(field));
        }

        @Override
        public double getDoubleField(String fieldName) throws TM1Exception {
            return TM1RowsetAccessor.this.mRowset.getDoubleField(this.getFieldIndex(fieldName));
        }

        @Override
        public long getIntegerField(T field) throws TM1Exception {
            return TM1RowsetAccessor.this.mRowset.getIntegerField(this.getFieldIndex(field));
        }

        @Override
        public long getIntegerField(String fieldName) throws TM1Exception {
            return TM1RowsetAccessor.this.mRowset.getIntegerField(this.getFieldIndex(fieldName));
        }
    }
}

