/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.data.providers.olap.tm1.util;

import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class TabularPrinter {
    private static final String NULL_PLACEHOLDER = "-";
    private static final String BORDER = "=";
    private static final String SPACE = " ";
    private final int mNumCol;
    private final int mGap;
    private final int[] mColumnWidths;
    private final List<String[]> mHeaders = new ArrayList<String[]>();
    private final List<String[]> mRows = new ArrayList<String[]>();
    private PrintWriter mPrinter = null;

    public TabularPrinter(int numCol, int gap) {
        this.mNumCol = numCol;
        this.mGap = gap;
        this.mColumnWidths = new int[numCol];
    }

    public void setOutput(PrintWriter printWriter) {
        this.mPrinter = printWriter;
    }

    public void setOutput(Writer writer) {
        this.mPrinter = new PrintWriter(writer, true);
    }

    public void setOutput(OutputStream os) {
        this.setOutput(new OutputStreamWriter(os));
    }

    public void addHeader(String[] header) {
        this.mHeaders.add(Arrays.copyOf(header, header.length));
    }

    public void addRow(String[] row) {
        this.mRows.add(Arrays.copyOf(row, row.length));
    }

    public void clearHeaders() {
        this.mHeaders.clear();
    }

    public void clearRows() {
        this.mRows.clear();
        for (int i = 0; i < this.mColumnWidths.length; ++i) {
            this.mColumnWidths[i] = 0;
        }
    }

    public void computeColumnWidths() {
        int i;
        for (String[] row : this.mHeaders) {
            for (i = 0; i < this.mNumCol; ++i) {
                int len;
                if (row[i] == null) {
                    row[i] = NULL_PLACEHOLDER;
                }
                if (this.mColumnWidths[i] >= (len = row[i].length())) continue;
                this.mColumnWidths[i] = len;
            }
        }
        for (String[] row : this.mRows) {
            for (i = 0; i < this.mNumCol; ++i) {
                if (row[i] == null) {
                    row[i] = NULL_PLACEHOLDER;
                }
                if (this.mColumnWidths[i] >= row[i].length()) continue;
                this.mColumnWidths[i] = row[i].length();
            }
        }
    }

    public int getTotalColumnWidth() {
        int total = 0;
        for (int colWidth : this.mColumnWidths) {
            total += colWidth + this.mGap;
        }
        return total;
    }

    public void printHeaders() {
        for (String[] row : this.mHeaders) {
            for (int i = 0; i < this.mNumCol; ++i) {
                int availableSpace = this.mColumnWidths[i];
                this.mPrinter.print(row[i]);
                if (i >= this.mNumCol - 1) continue;
                this.printSpaces(availableSpace - row[i].length() + this.mGap);
            }
            this.mPrinter.println();
        }
    }

    public void printRows() {
        for (String[] row : this.mRows) {
            for (int i = 0; i < this.mNumCol; ++i) {
                this.mPrinter.print(row[i]);
                if (i >= this.mNumCol - 1) continue;
                this.printSpaces(this.mColumnWidths[i] - row[i].length() + this.mGap);
            }
            this.mPrinter.println();
        }
    }

    private void printSpaces(int count) {
        for (int i = 0; i < count; ++i) {
            this.mPrinter.print(SPACE);
        }
    }

    public void printBorder() {
        int j;
        int i;
        for (i = 0; i < this.mNumCol; ++i) {
            for (j = 0; j < this.mColumnWidths[i]; ++j) {
                this.mPrinter.print(BORDER);
            }
        }
        for (i = 0; i < this.mNumCol - 1; ++i) {
            for (j = 0; j < this.mGap; ++j) {
                this.mPrinter.print(BORDER);
            }
        }
        this.mPrinter.println();
    }
}

