/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.data.providers.olap.tm1rest;

import com.cognos.xqe.data.providers.olap.tm1rest.TM1RESTLog;
import com.cognos.xqe.data.providers.olap.tm1rest.TM1RESTServerSecurity;
import com.cognos.xqe.trace.LogLevel;

class SecurityModeData {
    private static final long DUMP_SECURITY_MODE_STAT_PERIOD = 10000L;
    private static long mDumpTime = System.currentTimeMillis();
    private int mReferenced = 0;
    private TM1RESTServerSecurity.SecurityMode mSecurityMode;
    private long mCreateTime;
    private long mLastTime;

    SecurityModeData(TM1RESTServerSecurity.SecurityMode securityMode) {
        this.mSecurityMode = securityMode;
        this.mLastTime = this.mCreateTime = System.currentTimeMillis();
    }

    TM1RESTServerSecurity.SecurityMode getMode() {
        ++this.mReferenced;
        this.mLastTime = System.currentTimeMillis();
        SecurityModeData.dump(this.mLastTime);
        return this.mSecurityMode;
    }

    private static void dump(long currentTime) {
        if (TM1RESTLog.CONN_SECURITY_MODE_STATS.isOn(LogLevel.INFO) && currentTime - mDumpTime >= 10000L) {
            mDumpTime = currentTime;
            StringBuilder sb = new StringBuilder("Statistics for cached TM1 security modes...");
            for (String key : TM1RESTServerSecurity.serverToSecurityModeDataMap.keySet()) {
                SecurityModeData securityModeData = (SecurityModeData)TM1RESTServerSecurity.serverToSecurityModeDataMap.get(key);
                if (null == securityModeData) continue;
                sb.append("\n  CreateTime:");
                sb.append(currentTime - securityModeData.mCreateTime);
                sb.append("  LastTime:");
                sb.append(currentTime - securityModeData.mLastTime);
                sb.append("  Referenced:");
                sb.append(securityModeData.mReferenced);
                sb.append("  Key:");
                sb.append(key);
                sb.append("  Mode:");
                sb.append(securityModeData.mSecurityMode.toString());
            }
            TM1RESTLog.CONN_SECURITY_MODE_STATS.log(LogLevel.INFO, sb.toString());
        }
    }
}

